/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.ActionExecutorTestCase;
import org.apache.oozie.action.hadoop.DistcpActionExecutor;
import org.apache.oozie.action.hadoop.DistcpMain;
import org.apache.oozie.action.hadoop.LauncherMainTester;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;

public class TestDistCpActionExecutor
extends ActionExecutorTestCase {
    public void testSetupMethods() throws Exception {
        DistcpActionExecutor ae = new DistcpActionExecutor();
        TestDistCpActionExecutor.assertEquals(Arrays.asList(DistcpMain.class), (Object)ae.getLauncherClasses());
    }

    public void testDistCpFile() throws Exception {
        int offset;
        int numRead;
        Path inputPath = new Path(this.getFsTestCaseDir(), "input.txt");
        final Path outputPath = new Path(this.getFsTestCaseDir(), "output.txt");
        byte[] content = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes();
        FSDataOutputStream os = this.getFileSystem().create(inputPath);
        os.write(content);
        os.close();
        String actionXml = "<distcp><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><arg>" + inputPath + "</arg><arg>" + outputPath + "</arg></distcp>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml);
        String launcherId = this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(launcherId);
        this.waitFor(60000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return TestDistCpActionExecutor.this.getFileSystem().exists(outputPath);
            }
        });
        TestDistCpActionExecutor.assertTrue((boolean)this.getFileSystem().exists(outputPath));
        byte[] readContent = new byte[content.length];
        FSDataInputStream is = this.getFileSystem().open(outputPath);
        for (offset = 0; offset < readContent.length && (numRead = is.read(readContent, offset, readContent.length)) != -1; offset += numRead) {
        }
        TestDistCpActionExecutor.assertEquals((int)is.read(), (int)-1);
        is.close();
        for (offset = 0; offset < readContent.length; ++offset) {
            TestDistCpActionExecutor.assertEquals((byte)readContent[offset], (byte)content[offset]);
        }
        DistcpActionExecutor ae = new DistcpActionExecutor();
        WorkflowAction wfAction = context.getAction();
        ae.check((ActionExecutor.Context)context, wfAction);
        ae.end((ActionExecutor.Context)context, wfAction);
        TestDistCpActionExecutor.assertEquals((String)"SUCCEEDED", (String)wfAction.getExternalStatus());
        String externalIds = wfAction.getExternalChildIDs();
        TestDistCpActionExecutor.assertNotNull((Object)externalIds);
        TestDistCpActionExecutor.assertNotSame((Object)"", (Object)externalIds);
        TestDistCpActionExecutor.assertTrue((boolean)externalIds.contains("job_"));
    }

    protected ActionExecutorTestCase.Context createContext(String actionXml) throws Exception {
        DistcpActionExecutor ae = new DistcpActionExecutor();
        Path appJarPath = new Path("lib/test.jar");
        File jarFile = IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)"test.jar", (Class[])new Class[]{LauncherMainTester.class});
        FileInputStream is = new FileInputStream(jarFile);
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getAppPath(), "lib/test.jar"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        Path appSoPath = new Path("lib/test.so");
        this.getFileSystem().create(new Path(this.getAppPath(), appSoPath)).close();
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestDistCpActionExecutor.getTestUser());
        protoConf.setStrings("oozie.wf.application.lib", new String[]{appJarPath.toString(), appSoPath.toString()});
        WorkflowJobBean wf = this.createBaseWorkflow(protoConf, "action");
        WorkflowActionBean action = (WorkflowActionBean)wf.getActions().get(0);
        action.setType(ae.getType());
        action.setConf(actionXml);
        return new ActionExecutorTestCase.Context(wf, action);
    }

    protected String submitAction(ActionExecutorTestCase.Context context) throws Exception {
        DistcpActionExecutor ae = new DistcpActionExecutor();
        WorkflowAction action = context.getAction();
        ae.prepareActionDir(this.getFileSystem(), (ActionExecutor.Context)context);
        ae.submitLauncher(this.getFileSystem(), (ActionExecutor.Context)context, action);
        String jobId = action.getExternalId();
        String jobTracker = action.getTrackerUri();
        String consoleUrl = action.getConsoleUrl();
        TestDistCpActionExecutor.assertNotNull((Object)jobId);
        TestDistCpActionExecutor.assertNotNull((Object)jobTracker);
        TestDistCpActionExecutor.assertNotNull((Object)consoleUrl);
        ae.submitLauncher(this.getFileSystem(), (ActionExecutor.Context)context, context.getAction());
        return context.getAction().getExternalId();
    }
}

