/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.DistcpMain;
import org.apache.oozie.action.hadoop.LauncherAMUtils;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.MainTestCase;
import org.apache.oozie.util.XConfiguration;

public class TestDistcpMain
extends MainTestCase {
    @Override
    public Void call() throws Exception {
        XConfiguration jobConf = new XConfiguration();
        XConfiguration.copy((Configuration)this.createJobConf(), (Configuration)jobConf);
        FileSystem fs = this.getFileSystem();
        Path inputDir = new Path(this.getFsTestCaseDir(), "input");
        fs.mkdirs(inputDir);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "data.txt")));
        writer.write("hello");
        ((Writer)writer).close();
        Path outputDir = new Path(this.getFsTestCaseDir(), "output");
        jobConf.set("oozie.launcher.action.main.class", "org.apache.hadoop.tools.DistCp");
        jobConf.set("mapreduce.job.tags", "" + System.currentTimeMillis());
        this.setSystemProperty("oozie.job.launch.time", "" + System.currentTimeMillis());
        File actionXml = new File(this.getTestCaseDir(), "action.xml");
        FileOutputStream os = new FileOutputStream(actionXml);
        jobConf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        System.setProperty("oozie.action.conf.xml", actionXml.getAbsolutePath());
        File statsDataFile = new File(this.getTestCaseDir(), "statsdata.properties");
        File hadoopIdsFile = new File(this.getTestCaseDir(), "hadoopIds");
        File outputDataFile = new File(this.getTestCaseDir(), "outputdata.properties");
        this.setSystemProperty("oozie.launcher.job.id", "" + System.currentTimeMillis());
        this.setSystemProperty("oozie.action.conf.xml", actionXml.getAbsolutePath());
        this.setSystemProperty("oozie.action.stats.properties", statsDataFile.getAbsolutePath());
        this.setSystemProperty("oozie.action.externalChildIDs", hadoopIdsFile.getAbsolutePath());
        this.setSystemProperty("oozie.action.output.properties", outputDataFile.getAbsolutePath());
        DistcpMain.main((String[])new String[]{inputDir.toString(), outputDir.toString()});
        TestDistcpMain.assertTrue((boolean)this.getFileSystem().exists(outputDir));
        TestDistcpMain.assertTrue((boolean)hadoopIdsFile.exists());
        TestDistcpMain.assertNotNull((Object)LauncherAMUtils.getLocalFileContentStr((File)hadoopIdsFile, (String)"", (int)-1));
        fs.delete(outputDir, true);
        try {
            DistcpMain.main((String[])new String[0]);
        }
        catch (RuntimeException re) {
            TestDistcpMain.assertTrue((re.getMessage().indexOf("Returned value from distcp is non-zero") != -1 ? 1 : 0) != 0);
        }
        jobConf.set("mapred.job.queue.name", "non-exist");
        new File(this.getTestCaseDir(), "action.xml").delete();
        os = new FileOutputStream(actionXml);
        jobConf.writeXml((OutputStream)os);
        TestDistcpMain.assertFalse((boolean)this.getFileSystem().exists(outputDir));
        String option = "-Dmapred.job.queue.name=default";
        DistcpMain.main((String[])new String[]{option, inputDir.toString(), outputDir.toString()});
        TestDistcpMain.assertTrue((boolean)this.getFileSystem().exists(outputDir));
        new File(this.getTestCaseDir(), "action.xml").delete();
        return null;
    }

    public void testJobIDPattern() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Job complete: job_001");
        lines.add("Job job_002 completed successfully");
        lines.add("Submitted application application_003");
        lines.add("Job complete: job004");
        lines.add("Job complete: (job_005");
        lines.add("Job abc job_006 completed successfully");
        lines.add("Submitted application. application_007");
        LinkedHashSet jobIds = new LinkedHashSet();
        for (String line : lines) {
            LauncherMain.extractJobIDs((String)line, (Pattern[])DistcpMain.DISTCP_JOB_IDS_PATTERNS, jobIds);
        }
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("job_001");
        expected.add("job_002");
        expected.add("job_003");
        TestDistcpMain.assertEquals(expected, jobIds);
    }
}

