/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.action.hadoop.LauncherException;
import org.apache.oozie.action.hadoop.LauncherHelper;
import org.apache.oozie.action.hadoop.PrepareActionsDriver;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XFsTestCase;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TestFSPrepareActions
extends XFsTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Services services = new Services();
        services.getConf().set("oozie.service.HadoopAccessorService.supported.filesystems", "hdfs");
        services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    @Test
    public void testDelete() throws Exception {
        Path newDir;
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        if (fs.exists(newDir = new Path(actionDir, "newDir"))) {
            fs.delete(newDir, true);
        }
        fs.mkdirs(newDir);
        String prepareXML = "<prepare><delete path='" + newDir + "'/></prepare>";
        JobConf conf = this.createJobConf();
        LauncherHelper.setupLauncherURIHandlerConf((Configuration)conf);
        PrepareActionsDriver.doOperations((String)prepareXML, (Configuration)conf);
        TestFSPrepareActions.assertFalse((boolean)fs.exists(newDir));
    }

    @Test
    public void testDeleteWithGlob() throws Exception {
        Path newDir;
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        if (fs.exists(newDir = new Path(actionDir, "newDir"))) {
            fs.delete(newDir, true);
        }
        fs.mkdirs(newDir);
        fs.mkdirs(new Path(newDir, "2010"));
        fs.mkdirs(new Path(newDir + "/2010/10"));
        fs.mkdirs(new Path(newDir, "2011"));
        fs.mkdirs(new Path(newDir + "/2011/10"));
        fs.mkdirs(new Path(newDir, "2012"));
        fs.mkdirs(new Path(newDir + "/2012/10"));
        String prepareXML = "<prepare><delete path='" + newDir + "/201[0-1]/*'/></prepare>";
        JobConf conf = this.createJobConf();
        LauncherHelper.setupLauncherURIHandlerConf((Configuration)conf);
        PrepareActionsDriver.doOperations((String)prepareXML, (Configuration)conf);
        TestFSPrepareActions.assertFalse((boolean)fs.exists(new Path(newDir + "/2010/10")));
        TestFSPrepareActions.assertFalse((boolean)fs.exists(new Path(newDir + "/2011/10")));
        TestFSPrepareActions.assertTrue((boolean)fs.exists(new Path(newDir + "/2012/10")));
        fs.delete(newDir, true);
    }

    @Test
    public void testMkdir() throws Exception {
        Path newDir;
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        if (fs.exists(newDir = new Path(actionDir, "newDir"))) {
            fs.delete(newDir, true);
        }
        String prepareXML = "<prepare><mkdir path='" + newDir + "'/></prepare>";
        JobConf conf = this.createJobConf();
        LauncherHelper.setupLauncherURIHandlerConf((Configuration)conf);
        PrepareActionsDriver.doOperations((String)prepareXML, (Configuration)conf);
        TestFSPrepareActions.assertTrue((boolean)fs.exists(newDir));
    }

    @Test
    public void testForInvalidScheme() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        Path newDir = new Path("hftp:/" + actionDir.toString().substring(5) + "/delete");
        String prepareXML = "<prepare><delete path='" + newDir + "'/></prepare>";
        Document doc = PrepareActionsDriver.getDocumentFromXML((String)prepareXML);
        Node n = doc.getDocumentElement().getChildNodes().item(0);
        try {
            JobConf conf = this.createJobConf();
            LauncherHelper.setupLauncherURIHandlerConf((Configuration)conf);
            PrepareActionsDriver.doOperations((String)prepareXML, (Configuration)conf);
            TestFSPrepareActions.fail((String)"Expected to catch an exception but did not encounter any");
        }
        catch (LauncherException le) {
            Path path = new Path(n.getAttributes().getNamedItem("path").getNodeValue().trim());
            TestFSPrepareActions.assertEquals((String)("Scheme hftp not supported in uri " + path), (String)le.getMessage());
        }
        catch (Exception ex) {
            TestFSPrepareActions.fail((String)"Expected a LauncherException but received an Exception");
        }
    }

    @Test
    public void testForNullScheme() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        Path newDir = new Path(actionDir, "newDir");
        String noSchemePath = newDir.toUri().getPath();
        FileSystem fs = this.getFileSystem();
        if (fs.exists(newDir)) {
            fs.delete(newDir, true);
        }
        String prepareXML = "<prepare><mkdir path='" + noSchemePath + "'/></prepare>";
        JobConf conf = this.createJobConf();
        LauncherHelper.setupLauncherURIHandlerConf((Configuration)conf);
        PrepareActionsDriver.doOperations((String)prepareXML, (Configuration)conf);
        TestFSPrepareActions.assertTrue((boolean)fs.exists(new Path(noSchemePath)));
    }
}

