/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.ActionExecutorTestCase;
import org.apache.oozie.action.hadoop.FsActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.dependency.FSURIHandler;
import org.apache.oozie.dependency.HCatURIHandler;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class TestFsActionExecutor
extends ActionExecutorTestCase {
    final String db = "db1";
    final String table = "table1";
    private Services services;
    private URIHandlerService uriService;
    private JobConf conf;

    @Override
    protected void setSystemProps() throws Exception {
        super.setSystemProps();
        this.setSystemProperty("oozie.service.ActionService.executor.classes", FsActionExecutor.class.getName());
    }

    public void testSetupMethods() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        TestFsActionExecutor.assertEquals((String)"fs", (String)ae.getType());
    }

    private ActionExecutorTestCase.Context createContext(String actionXml) throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestFsActionExecutor.getTestUser());
        protoConf.setLong("fs.trash.interval", 6000L);
        WorkflowJobBean wf = this.createBaseWorkflow(protoConf, "fs-action");
        WorkflowActionBean action = (WorkflowActionBean)wf.getActions().get(0);
        action.setType(ae.getType());
        action.setConf(actionXml);
        return new ActionExecutorTestCase.Context(this, wf, action);
    }

    public void testValidatePath() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        ae.validatePath(new Path("hdfs://x/bla"), true);
        ae.validatePath(new Path("bla"), false);
        try {
            ae.validatePath(new Path("hdfs://x/bla"), false);
            TestFsActionExecutor.fail();
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertEquals((String)"FS002", (String)ex.getErrorCode());
        }
        try {
            ae.validatePath(new Path("bla"), true);
            TestFsActionExecutor.fail();
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertEquals((String)"FS001", (String)ex.getErrorCode());
        }
        Services.get().destroy();
        this.setSystemProperty("oozie.service.HadoopAccessorService.supported.filesystems", "hdfs,viewfs");
        new Services().init();
        try {
            ae.validatePath(new Path("viewfs://bla"), true);
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.fail((String)"viewfs is a supported scheme. This should not throw exception");
        }
        try {
            ae.validatePath(new Path("file://bla"), true);
            TestFsActionExecutor.fail((String)"file is not a supported scheme. This should throw exception");
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertTrue((boolean)ex.getMessage().contains("E0904"));
        }
    }

    public void testFileSchemeWildcard() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        Services.get().destroy();
        this.setSystemProperty("oozie.service.HadoopAccessorService.supported.filesystems", "*");
        new Services().init();
        try {
            ae.validatePath(new Path("anyfs://bla"), true);
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.fail((String)"Wildcard indicates ALL schemes will be allowed. This should pass");
        }
    }

    public void testResolveToFullPath() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        TestFsActionExecutor.assertEquals((Object)new Path("hdfs://x/bla"), (Object)ae.resolveToFullPath(null, new Path("hdfs://x/bla"), true));
        TestFsActionExecutor.assertEquals((Object)new Path("bla"), (Object)ae.resolveToFullPath(null, new Path("bla"), false));
        TestFsActionExecutor.assertEquals((Object)new Path("hdfs://x/bla"), (Object)ae.resolveToFullPath(new Path("hdfs://x"), new Path("/bla"), true));
        TestFsActionExecutor.assertEquals((Object)new Path("hdfs://x/bla/[0-1]*"), (Object)ae.resolveToFullPath(new Path("hdfs://x"), new Path("/bla/[0-1]*"), true));
        TestFsActionExecutor.assertEquals((Object)new Path("hdfs://x/bla"), (Object)ae.resolveToFullPath(new Path("hdfs://x/ha"), new Path("/bla"), true));
        TestFsActionExecutor.assertEquals((Object)new Path("hdfs://x/bla"), (Object)ae.resolveToFullPath(new Path("hdfs://z"), new Path("hdfs://x/bla"), true));
        TestFsActionExecutor.assertEquals((Object)new Path("hdfs://x/bla/[0-1]*"), (Object)ae.resolveToFullPath(new Path("hdfs://z"), new Path("hdfs://x/bla/[0-1]*"), true));
        TestFsActionExecutor.assertEquals((Object)new Path("hdfs://x/bla"), (Object)ae.resolveToFullPath(new Path("hdfs://x"), new Path("hdfs://x/bla"), true));
        try {
            ae.resolveToFullPath(null, new Path("hdfs://x/bla"), false);
            TestFsActionExecutor.fail();
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertEquals((String)"FS002", (String)ex.getErrorCode());
        }
        try {
            ae.resolveToFullPath(null, new Path("bla"), true);
            TestFsActionExecutor.fail();
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertEquals((String)"FS001", (String)ex.getErrorCode());
        }
        Services.get().destroy();
        this.setSystemProperty("oozie.service.HadoopAccessorService.supported.filesystems", null);
        new Services().init();
        try {
            ae.resolveToFullPath(null, new Path("file://bla"), true);
            TestFsActionExecutor.fail();
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertTrue((boolean)ex.getMessage().contains("E0904"));
        }
        try {
            ae.resolveToFullPath(new Path("hdfs://z"), new Path("hdfs://x/bla"), false);
            TestFsActionExecutor.fail();
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertEquals((String)"FS002", (String)ex.getErrorCode());
        }
        try {
            ae.resolveToFullPath(new Path("hdfs://z"), new Path("bla"), true);
            TestFsActionExecutor.fail();
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertEquals((String)"FS011", (String)ex.getErrorCode());
        }
        try {
            ae.resolveToFullPath(new Path("hdfs://z"), new Path("file://bla"), true);
            TestFsActionExecutor.fail();
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertTrue((boolean)ex.getMessage().contains("E0904"));
        }
    }

    public void testvalidateSameNN() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        ae.validateSameNN(new Path("hdfs://x/bla"), new Path("hdfs://x/foo"));
        try {
            ae.validateSameNN(new Path("hdfs://x/bla"), new Path("viefs://x/bla"));
            TestFsActionExecutor.fail();
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertEquals((String)"FS007", (String)ex.getErrorCode());
        }
        try {
            ae.validateSameNN(new Path("hdfs://x/bla"), new Path("hdfs://y/bla"));
            TestFsActionExecutor.fail();
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertEquals((String)"FS007", (String)ex.getErrorCode());
        }
    }

    public void testMkdir() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path path = new Path(this.getFsTestCaseDir(), "dir1");
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        ae.mkdir((ActionExecutor.Context)context, path);
        TestFsActionExecutor.assertTrue((boolean)fs.exists(path));
        ae.mkdir((ActionExecutor.Context)context, path);
    }

    public void testDelete() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path path = new Path(this.getFsTestCaseDir(), "dir1");
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        fs.mkdirs(path);
        ae.delete((ActionExecutor.Context)context, path);
        TestFsActionExecutor.assertTrue((!fs.exists(path) ? 1 : 0) != 0);
        ae.delete((ActionExecutor.Context)context, path);
    }

    public void testMovetoTrash() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path path = new Path(this.getFsTestCaseDir(), "dir1");
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        fs.mkdirs(path);
        ae.delete((ActionExecutor.Context)context, null, null, path, false);
        Path trashPath = new Path(fs.getHomeDirectory() + "/.Trash/Current/" + path.toUri().getPath());
        TestFsActionExecutor.assertTrue((!fs.exists(path) ? 1 : 0) != 0);
        TestFsActionExecutor.assertTrue((boolean)fs.exists(trashPath));
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.getConf().set("oozie.service.URIHandlerService.uri.handlers", FSURIHandler.class.getName() + "," + HCatURIHandler.class.getName());
        this.services.setService(HCatAccessorService.class);
        this.services.init();
        this.conf = this.createJobConf();
        this.uriService = (URIHandlerService)Services.get().get(URIHandlerService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    private void createTestTable() throws Exception {
        this.dropTable("db1", "table1", true);
        this.dropDatabase("db1", true);
        this.createDatabase("db1");
        this.createTable("db1", "table1", "year,month,dt,country");
    }

    public void testDeleteHcat() throws Exception {
        this.setSystemProperty("oozie.test.user.test", System.getProperty("user.name"));
        this.createTestTable();
        this.addPartition("db1", "table1", "year=2012;month=12;dt=02;country=us");
        URI hcatURI = this.getHCatURI("db1", "table1", "country=us;year=2012;month=12;dt=02");
        URIHandler handler = this.uriService.getURIHandler(hcatURI);
        FsActionExecutor ae = new FsActionExecutor();
        Path path = new Path(hcatURI);
        Path nameNodePath = new Path(this.getNameNodeUri());
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        XConfiguration conf = new XConfiguration();
        TestFsActionExecutor.assertTrue((boolean)handler.exists(hcatURI, (Configuration)conf, TestFsActionExecutor.getTestUser()));
        ae.delete((ActionExecutor.Context)context, conf, nameNodePath, path, true);
        TestFsActionExecutor.assertFalse((boolean)handler.exists(hcatURI, (Configuration)conf, TestFsActionExecutor.getTestUser()));
    }

    public void testDeleteHcatTable() throws Exception {
        this.createTestTable();
        URI hcatURI = this.getHCatURI("db1", "table1");
        URIHandler handler = this.uriService.getURIHandler(hcatURI);
        FsActionExecutor ae = new FsActionExecutor();
        Path path = new Path(hcatURI);
        Path nameNodePath = new Path(this.getNameNodeUri());
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        XConfiguration conf = new XConfiguration();
        TestFsActionExecutor.assertTrue((boolean)handler.exists(hcatURI, (Configuration)conf, TestFsActionExecutor.getTestUser()));
        ae.delete((ActionExecutor.Context)context, conf, nameNodePath, path, true);
        TestFsActionExecutor.assertFalse((boolean)handler.exists(hcatURI, (Configuration)conf, TestFsActionExecutor.getTestUser()));
    }

    public void testDeleteWithGlob() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        Path basePath = new Path(this.getFsTestCaseDir(), "2010");
        fs.mkdirs(basePath);
        fs.mkdirs(new Path(basePath, "10"));
        fs.createNewFile(new Path(basePath + "/10/newfile1"));
        fs.createNewFile(new Path(basePath + "/10/newfile2"));
        fs.mkdirs(new Path(basePath, "11"));
        fs.createNewFile(new Path(basePath + "/11/newfile3"));
        fs.mkdirs(new Path(basePath, "12"));
        fs.createNewFile(new Path(basePath + "/12/newfile4"));
        Path globPath = new Path(basePath + "/1{0,1}/*");
        ae.delete((ActionExecutor.Context)context, globPath);
        TestFsActionExecutor.assertFalse((boolean)fs.exists(new Path(basePath + "/10/newfile1")));
        TestFsActionExecutor.assertFalse((boolean)fs.exists(new Path(basePath + "/10/newfile2")));
        TestFsActionExecutor.assertFalse((boolean)fs.exists(new Path(basePath + "/11/newfile3")));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(new Path(basePath + "/12/newfile4")));
        fs.delete(basePath, true);
    }

    public void testMove() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path source = new Path(this.getFsTestCaseDir(), "source");
        Path target = new Path(this.getFsTestCaseDir(), "target");
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        fs.mkdirs(source);
        fs.createNewFile(new Path(source + "/newfile1"));
        fs.mkdirs(target);
        String dest = target.toUri().getPath();
        Path destPath = new Path(dest);
        ae.move((ActionExecutor.Context)context, new Path(source + "/newfile1"), destPath, false);
        TestFsActionExecutor.assertTrue((!fs.exists(new Path(source + "/newfile1")) ? 1 : 0) != 0);
        TestFsActionExecutor.assertTrue((boolean)fs.exists(target));
        try {
            ae.move((ActionExecutor.Context)context, new Path(source + "/newfile1"), destPath, false);
            TestFsActionExecutor.fail();
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertEquals((String)"FS006", (String)ex.getErrorCode());
        }
        fs.mkdirs(source);
        fs.createNewFile(new Path(source + "/newfile"));
        Path complexTarget = new Path(target + "/a/b");
        fs.mkdirs(complexTarget);
        ae.move((ActionExecutor.Context)context, source, complexTarget, false);
        TestFsActionExecutor.assertTrue((boolean)fs.exists(new Path(complexTarget + "/" + source.getName())));
        fs.mkdirs(source);
        try {
            ae.move((ActionExecutor.Context)context, source, new Path(target.toUri().getScheme() + "://foo/" + destPath), false);
            TestFsActionExecutor.fail();
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertEquals((String)"FS007", (String)ex.getErrorCode());
        }
        fs.delete(source, true);
        ae.move((ActionExecutor.Context)context, source, new Path(target.toUri().getPath()), true);
        fs.mkdirs(source);
        fs.delete(target, true);
        ae.move((ActionExecutor.Context)context, source, new Path(target.toUri().getPath()), true);
        TestFsActionExecutor.assertTrue((!fs.exists(source) ? 1 : 0) != 0);
        TestFsActionExecutor.assertTrue((boolean)fs.exists(target));
    }

    public void testMoveWithGlob() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path source = new Path(this.getFsTestCaseDir(), "source");
        Path target = new Path(this.getFsTestCaseDir(), "target");
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        fs.mkdirs(source);
        fs.mkdirs(target);
        fs.createNewFile(new Path(source, "newfile1"));
        fs.createNewFile(new Path(source, "newfile2"));
        ae.move((ActionExecutor.Context)context, new Path(source.toString() + "/*"), target, false);
        TestFsActionExecutor.assertTrue((boolean)fs.exists(new Path(target, "newfile1")));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(new Path(target, "newfile2")));
        fs.delete(target, true);
        fs.mkdirs(target);
        fs.mkdirs(new Path(source + "/2010"));
        fs.mkdirs(new Path(source + "/2011"));
        fs.mkdirs(new Path(source + "/2012"));
        fs.mkdirs(new Path(source + "/2010/10"));
        fs.mkdirs(new Path(source + "/2010/11"));
        fs.createNewFile(new Path(source + "/2010/10/newfile1"));
        fs.createNewFile(new Path(source + "/2010/11/newfile2"));
        fs.mkdirs(new Path(source + "/2011/09"));
        fs.mkdirs(new Path(source + "/2011/10"));
        fs.createNewFile(new Path(source + "/2011/09/newfile3"));
        fs.createNewFile(new Path(source + "/2011/10/newfile4"));
        ae.move((ActionExecutor.Context)context, new Path(source.toString() + "/201[0-1]/1{0,1}/*"), target, false);
        TestFsActionExecutor.assertTrue((boolean)fs.exists(new Path(target.toString() + "/newfile1")));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(new Path(target.toString() + "/newfile2")));
        TestFsActionExecutor.assertFalse((boolean)fs.exists(new Path(target.toString() + "/newfile3")));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(new Path(target.toString() + "/newfile4")));
        fs.delete(new Path(source + "/2010"), true);
        fs.delete(new Path(source + "/2011"), true);
        fs.delete(new Path(source + "/2012"), true);
        fs.delete(target, true);
        try {
            ae.move((ActionExecutor.Context)context, new Path(source.toString() + "/*"), target, true);
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertEquals((String)"FS012", (String)ex.getErrorCode());
        }
        fs.delete(target, true);
        Path targetFile = new Path(target, "newfile1");
        fs.createNewFile(targetFile);
        try {
            ae.move((ActionExecutor.Context)context, new Path(source.toString() + "/*"), targetFile, true);
        }
        catch (ActionExecutorException ex) {
            TestFsActionExecutor.assertEquals((String)"FS012", (String)ex.getErrorCode());
        }
    }

    public void testChmod() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path path = new Path(this.getFsTestCaseDir(), "dir");
        Path child = new Path(path, "child");
        Path grandchild = new Path(child, "grandchild");
        fs.mkdirs(grandchild);
        fs.setPermission(path, FsPermission.valueOf((String)"-rwx------"));
        fs.setPermission(child, FsPermission.valueOf((String)"-rwxr-----"));
        fs.setPermission(grandchild, FsPermission.valueOf((String)"-rwx---r--"));
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(path).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxr-----", (String)fs.getFileStatus(child).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx---r--", (String)fs.getFileStatus(grandchild).getPermission().toString());
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        ae.chmod((ActionExecutor.Context)context, path, "-rwx-----x", false, false);
        TestFsActionExecutor.assertEquals((String)"rwx-----x", (String)fs.getFileStatus(path).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxr-----", (String)fs.getFileStatus(child).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx---r--", (String)fs.getFileStatus(grandchild).getPermission().toString());
        ae.chmod((ActionExecutor.Context)context, path, "-rwxr----x", true, false);
        TestFsActionExecutor.assertEquals((String)"rwxr----x", (String)fs.getFileStatus(path).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxr----x", (String)fs.getFileStatus(child).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx---r--", (String)fs.getFileStatus(grandchild).getPermission().toString());
    }

    private void createTestDirForChmod(Path basePath, FileSystem fs) throws Exception {
        fs.mkdirs(basePath);
        fs.mkdirs(new Path(basePath, "10"));
        fs.mkdirs(new Path(basePath + "/10/dir1"));
        fs.createNewFile(new Path(basePath + "/10/dir1/file1"));
        fs.mkdirs(new Path(basePath + "/10/dir2"));
        fs.mkdirs(new Path(basePath, "11"));
        fs.mkdirs(new Path(basePath + "/11/dir3"));
        fs.mkdirs(new Path(basePath, "12"));
        fs.setPermission(new Path(basePath, "10"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        fs.setPermission(new Path(basePath + "/10/dir1"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        fs.setPermission(new Path(basePath + "/10/dir2"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        fs.setPermission(new Path(basePath + "/10/dir1/file1"), FsPermission.valueOf((String)"-rw-rw-rw-"));
        fs.setPermission(new Path(basePath, "11"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        fs.setPermission(new Path(basePath + "/11/dir3"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        fs.setPermission(new Path(basePath, "12"), FsPermission.valueOf((String)"-rwxrwxrwx"));
    }

    public void testChmodWithGlob() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        Path basePath = new Path(this.getFsTestCaseDir(), "2010");
        this.createTestDirForChmod(basePath, fs);
        Path globPath = new Path(basePath + "/1[0-1]");
        ae.chmod((ActionExecutor.Context)context, globPath, "-rwx------", false, false);
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath, "10")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath, "11")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(new Path(basePath, "12")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(new Path(basePath + "/10/dir1")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(new Path(basePath + "/10/dir2")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(new Path(basePath + "/11/dir3")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rw-rw-rw-", (String)fs.getFileStatus(new Path(basePath + "/10/dir1/file1")).getPermission().toString());
        ae.chmod((ActionExecutor.Context)context, globPath, "-rwx------", true, false);
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath, "10")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath, "11")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(new Path(basePath, "12")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath + "/10/dir1")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath + "/10/dir2")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath + "/11/dir3")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rw-rw-rw-", (String)fs.getFileStatus(new Path(basePath + "/10/dir1/file1")).getPermission().toString());
        ae.chmod((ActionExecutor.Context)context, globPath, "-rwx------", true, true);
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath, "10")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath, "11")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(new Path(basePath, "12")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath + "/10/dir1")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath + "/10/dir2")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath + "/11/dir3")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath + "/10/dir1/file1")).getPermission().toString());
        fs.delete(basePath, true);
    }

    public void testChmodRelativePath() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        Path basePath = new Path(this.getFsTestCaseDir(), "2010");
        this.createTestDirForChmod(basePath, fs);
        Path globPath = new Path(basePath + "/1[0-1]");
        Path relativePath = new Path(globPath.toUri().getPath());
        Path nameNode = new Path(globPath.toUri().getScheme() + "://" + globPath.toUri().getAuthority());
        ae.chmod((ActionExecutor.Context)context, null, nameNode, relativePath, "-rwx------", false, false);
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath, "10")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(new Path(basePath, "11")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(new Path(basePath, "12")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(new Path(basePath + "/10/dir1")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(new Path(basePath + "/10/dir2")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(new Path(basePath + "/11/dir3")).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rw-rw-rw-", (String)fs.getFileStatus(new Path(basePath + "/10/dir1/file1")).getPermission().toString());
        try {
            ae.chmod((ActionExecutor.Context)context, null, null, relativePath, "-rwx-----", false, false);
            TestFsActionExecutor.fail();
        }
        catch (ActionExecutorException e) {
            TestFsActionExecutor.assertEquals((String)e.getErrorCode(), (String)"FS001");
        }
        fs.delete(basePath, true);
    }

    public void testChmodRecursive() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path path = new Path(this.getFsTestCaseDir(), "dir");
        Path child = new Path(path, "child");
        Path grandchild = new Path(child, "grandchild");
        fs.mkdirs(grandchild);
        fs.setPermission(path, FsPermission.valueOf((String)"-rwx------"));
        fs.setPermission(child, FsPermission.valueOf((String)"-rwxr-----"));
        fs.setPermission(grandchild, FsPermission.valueOf((String)"-rwx---r--"));
        TestFsActionExecutor.assertEquals((String)"rwx------", (String)fs.getFileStatus(path).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxr-----", (String)fs.getFileStatus(child).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx---r--", (String)fs.getFileStatus(grandchild).getPermission().toString());
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        ae.chmod((ActionExecutor.Context)context, path, "-rwx-----x", false, false);
        TestFsActionExecutor.assertEquals((String)"rwx-----x", (String)fs.getFileStatus(path).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxr-----", (String)fs.getFileStatus(child).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx---r--", (String)fs.getFileStatus(grandchild).getPermission().toString());
        ae.chmod((ActionExecutor.Context)context, path, "-rwx-----x", false, true);
        TestFsActionExecutor.assertEquals((String)"rwx-----x", (String)fs.getFileStatus(path).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxr-----", (String)fs.getFileStatus(child).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwx---r--", (String)fs.getFileStatus(grandchild).getPermission().toString());
        ae.chmod((ActionExecutor.Context)context, path, "-rwxr----x", true, true);
        TestFsActionExecutor.assertEquals((String)"rwxr----x", (String)fs.getFileStatus(path).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxr----x", (String)fs.getFileStatus(child).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxr----x", (String)fs.getFileStatus(grandchild).getPermission().toString());
    }

    public void testTouchz() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path dir = new Path(this.getFsTestCaseDir(), "dir1");
        Path f1 = new Path(dir + "/newfile1");
        Path f2 = new Path(dir + "/newfile2");
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        fs.mkdirs(dir);
        fs.createNewFile(f1);
        TestFsActionExecutor.assertTrue((boolean)fs.exists(f1));
        TestFsActionExecutor.assertTrue((fs.getFileStatus(f1).getLen() == 0L ? 1 : 0) != 0);
        ae.touchz((ActionExecutor.Context)context, f1);
        ae.touchz((ActionExecutor.Context)context, f2);
        TestFsActionExecutor.assertTrue((boolean)fs.exists(f1));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(f2));
        FileStatus fs1 = fs.getFileStatus(f1);
        FileStatus fs2 = fs.getFileStatus(f2);
        TestFsActionExecutor.assertFalse((boolean)fs1.isDir());
        TestFsActionExecutor.assertFalse((boolean)fs2.isDir());
        TestFsActionExecutor.assertTrue((fs1.getLen() == 0L ? 1 : 0) != 0);
        TestFsActionExecutor.assertTrue((fs2.getLen() == 0L ? 1 : 0) != 0);
        try {
            ae.touchz((ActionExecutor.Context)context, dir);
            TestFsActionExecutor.fail();
        }
        catch (Exception ex) {
            TestFsActionExecutor.assertTrue((boolean)ex.getMessage().contains("is a directory"));
        }
        Path f3 = new Path(dir + "/newfile3");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(f3));
        writer.write("This is not a zero length file");
        ((Writer)writer).close();
        try {
            ae.touchz((ActionExecutor.Context)context, f3);
            TestFsActionExecutor.fail();
        }
        catch (Exception ex) {
            TestFsActionExecutor.assertTrue((boolean)ex.getMessage().contains("must be a zero-length file"));
        }
    }

    public void testDoOperations() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path mkdir = new Path(this.getFsTestCaseDir(), "mkdir");
        Path delete = new Path(this.getFsTestCaseDir(), "delete");
        fs.mkdirs(delete);
        Path source = new Path(this.getFsTestCaseDir(), "source");
        fs.mkdirs(source);
        Path target = new Path(new Path(this.getFsTestCaseDir(), "target").toUri().getPath());
        Path chmod1 = new Path(this.getFsTestCaseDir(), "chmod1");
        fs.mkdirs(chmod1);
        Path child1 = new Path(chmod1, "child1");
        fs.mkdirs(child1);
        Path chmod2 = new Path(this.getFsTestCaseDir(), "chmod2");
        fs.mkdirs(chmod2);
        Path child2 = new Path(chmod2, "child2");
        fs.mkdirs(child2);
        Path newFile1 = new Path(mkdir + "newFile1");
        Path newFile2 = new Path(mkdir + "newFile2");
        fs.createNewFile(newFile1);
        Path chmod3 = new Path(this.getFsTestCaseDir(), "chmod3");
        fs.mkdirs(chmod3);
        Path child3 = new Path(chmod3, "child3");
        fs.mkdirs(child3);
        Path grandchild3 = new Path(child3, "grandchild1");
        fs.mkdirs(grandchild3);
        String str = MessageFormat.format("<root><mkdir path=''{0}''/><delete path=''{1}''/><move source=''{2}'' target=''{3}''/><chmod path=''{4}'' permissions=''-rwxrwxrwx''/><chmod path=''{5}'' permissions=''-rwxrwx---'' dir-files=''false''/><touchz path=''{6}''/><touchz path=''{7}''/><chmod path=''{8}'' permissions=''-rwxrwx---''> <recursive/> </chmod></root>", mkdir, delete, source, target, chmod1, chmod2, newFile1, newFile2, chmod3);
        Element xml = XmlUtils.parseXml((String)str);
        ae.doOperations((ActionExecutor.Context)this.createContext("<fs/>"), xml);
        TestFsActionExecutor.assertTrue((boolean)fs.exists(mkdir));
        TestFsActionExecutor.assertFalse((boolean)fs.exists(delete));
        TestFsActionExecutor.assertFalse((boolean)fs.exists(source));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(target));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(newFile1));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(newFile2));
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(chmod1).getPermission().toString());
        TestFsActionExecutor.assertNotSame((Object)"rwxrwxrwx", (Object)fs.getFileStatus(child1).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwx---", (String)fs.getFileStatus(chmod2).getPermission().toString());
        TestFsActionExecutor.assertNotSame((Object)"rwxrwx---", (Object)fs.getFileStatus(child2).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwx---", (String)fs.getFileStatus(child3).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwx---", (String)fs.getFileStatus(grandchild3).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwx---", (String)fs.getFileStatus(child3).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwx---", (String)fs.getFileStatus(grandchild3).getPermission().toString());
    }

    public void testDoOperationsWithNameNodeElement() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path mkdir = new Path(this.getFsTestCaseDir(), "mkdir");
        Path mkdirX = new Path(mkdir.toUri().getPath());
        Path delete = new Path(this.getFsTestCaseDir(), "delete");
        Path deleteX = new Path(delete.toUri().getPath());
        fs.mkdirs(delete);
        Path source = new Path(this.getFsTestCaseDir(), "source");
        Path sourceX = new Path(source.toUri().getPath());
        fs.mkdirs(source);
        Path target = new Path(new Path(this.getFsTestCaseDir(), "target").toUri().getPath());
        Path chmod1 = new Path(this.getFsTestCaseDir(), "chmod1");
        Path chmod1X = new Path(chmod1.toUri().getPath());
        fs.mkdirs(chmod1);
        Path child1 = new Path(chmod1, "child1");
        fs.mkdirs(child1);
        Path chmod2 = new Path(this.getFsTestCaseDir(), "chmod2");
        Path chmod2X = new Path(chmod2.toUri().getPath());
        fs.mkdirs(chmod2);
        Path child2 = new Path(chmod2, "child2");
        fs.mkdirs(child2);
        Path newFile1 = new Path(mkdir + "newFile1");
        Path newFile1X = new Path(newFile1.toUri().getPath());
        Path newFile2 = new Path(mkdir + "newFile2");
        Path newFile2X = new Path(newFile2.toUri().getPath());
        fs.createNewFile(newFile1);
        Path chmod3 = new Path(this.getFsTestCaseDir(), "chmod3");
        Path chmod3X = new Path(chmod3.toUri().getPath());
        fs.mkdirs(chmod3);
        Path child3 = new Path(chmod3, "child3");
        fs.mkdirs(child3);
        Path grandchild3 = new Path(child3, "grandchild1");
        fs.mkdirs(grandchild3);
        String str = MessageFormat.format("<root><name-node>{0}</name-node><mkdir path=''{1}''/><delete path=''{2}''/><move source=''{3}'' target=''{4}''/><chmod path=''{5}'' permissions=''-rwxrwxrwx''/><chmod path=''{6}'' permissions=''-rwxrwx---'' dir-files=''false''/><touchz path=''{7}''/><touchz path=''{8}''/><chmod path=''{9}'' permissions=''-rwxrwx---''> <recursive/> </chmod></root>", this.getNameNodeUri(), mkdirX, deleteX, sourceX, target, chmod1X, chmod2X, newFile1X, newFile2X, chmod3X);
        Element xml = XmlUtils.parseXml((String)str);
        ae.doOperations((ActionExecutor.Context)this.createContext("<fs/>"), xml);
        TestFsActionExecutor.assertTrue((boolean)fs.exists(mkdir));
        TestFsActionExecutor.assertFalse((boolean)fs.exists(delete));
        TestFsActionExecutor.assertFalse((boolean)fs.exists(source));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(target));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(newFile1));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(newFile2));
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(chmod1).getPermission().toString());
        TestFsActionExecutor.assertNotSame((Object)"rwxrwxrwx", (Object)fs.getFileStatus(child1).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwx---", (String)fs.getFileStatus(chmod2).getPermission().toString());
        TestFsActionExecutor.assertNotSame((Object)"rwxrwx---", (Object)fs.getFileStatus(child2).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwx---", (String)fs.getFileStatus(child3).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwx---", (String)fs.getFileStatus(grandchild3).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwx---", (String)fs.getFileStatus(child3).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwx---", (String)fs.getFileStatus(grandchild3).getPermission().toString());
    }

    public void testSubmit() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path mkdir = new Path(this.getFsTestCaseDir(), "mkdir");
        Path delete = new Path(this.getFsTestCaseDir(), "delete");
        fs.mkdirs(delete);
        Path source = new Path(this.getFsTestCaseDir(), "source");
        fs.mkdirs(source);
        Path target = new Path(new Path(this.getFsTestCaseDir(), "target").toUri().getPath());
        Path chmod1 = new Path(this.getFsTestCaseDir(), "chmod1");
        fs.mkdirs(chmod1);
        Path child1 = new Path(chmod1, "child1");
        fs.mkdirs(child1);
        Path chmod2 = new Path(this.getFsTestCaseDir(), "chmod2");
        fs.mkdirs(chmod2);
        Path child2 = new Path(chmod2, "child2");
        fs.mkdirs(child2);
        Path newFile1 = new Path(mkdir + "newFile1");
        Path newFile2 = new Path(mkdir + "newFile2");
        fs.createNewFile(newFile1);
        String actionXml = MessageFormat.format("<fs><mkdir path=''{0}''/><delete path=''{1}''/><move source=''{2}'' target=''{3}''/><chmod path=''{4}'' permissions=''-rwxrwxrwx''/><chmod path=''{5}'' permissions=''-rwxrwx---'' dir-files=''false''/><touchz path=''{6}''/><touchz path=''{7}''/></fs>", mkdir, delete, source, target, chmod1, chmod2, newFile1, newFile2);
        ActionExecutorTestCase.Context context = this.createContext(actionXml);
        WorkflowAction action = context.getAction();
        TestFsActionExecutor.assertFalse((boolean)fs.exists(ae.getRecoveryPath((ActionExecutor.Context)context)));
        ae.start((ActionExecutor.Context)context, action);
        TestFsActionExecutor.assertTrue((boolean)fs.exists(ae.getRecoveryPath((ActionExecutor.Context)context)));
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestFsActionExecutor.assertEquals((String)"OK", (String)context.getAction().getExternalStatus());
        TestFsActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestFsActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)context.getAction().getStatus());
        TestFsActionExecutor.assertFalse((boolean)fs.exists(ae.getRecoveryPath((ActionExecutor.Context)context)));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(mkdir));
        TestFsActionExecutor.assertFalse((boolean)fs.exists(delete));
        TestFsActionExecutor.assertFalse((boolean)fs.exists(source));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(target));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(newFile1));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(newFile2));
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(chmod1).getPermission().toString());
        TestFsActionExecutor.assertNotSame((Object)"rwxrwxrwx", (Object)fs.getFileStatus(child1).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwx---", (String)fs.getFileStatus(chmod2).getPermission().toString());
        TestFsActionExecutor.assertNotSame((Object)"rwxrwx---", (Object)fs.getFileStatus(child2).getPermission().toString());
    }

    public void testSubmitWithNameNode() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path mkdir = new Path(this.getFsTestCaseDir(), "mkdir");
        Path mkdirX = new Path(mkdir.toUri().getPath());
        Path delete = new Path(this.getFsTestCaseDir(), "delete");
        Path deleteX = new Path(delete.toUri().getPath());
        fs.mkdirs(delete);
        Path source = new Path(this.getFsTestCaseDir(), "source");
        Path sourceX = new Path(source.toUri().getPath());
        fs.mkdirs(source);
        Path target = new Path(new Path(this.getFsTestCaseDir(), "target").toUri().getPath());
        Path chmod1 = new Path(this.getFsTestCaseDir(), "chmod1");
        Path chmod1X = new Path(chmod1.toUri().getPath());
        fs.mkdirs(chmod1);
        Path child1 = new Path(chmod1, "child1");
        fs.mkdirs(child1);
        Path chmod2 = new Path(this.getFsTestCaseDir(), "chmod2");
        Path chmod2X = new Path(chmod2.toUri().getPath());
        fs.mkdirs(chmod2);
        Path child2 = new Path(chmod2, "child2");
        fs.mkdirs(child2);
        Path newFile1 = new Path(mkdir + "newFile1");
        Path newFile1X = new Path(newFile1.toUri().getPath());
        Path newFile2 = new Path(mkdir + "newFile2");
        Path newFile2X = new Path(newFile2.toUri().getPath());
        fs.createNewFile(newFile1);
        String actionXml = MessageFormat.format("<fs><name-node>{0}</name-node><mkdir path=''{1}''/><delete path=''{2}''/><move source=''{3}'' target=''{4}''/><chmod path=''{5}'' permissions=''-rwxrwxrwx''/><chmod path=''{6}'' permissions=''-rwxrwx---'' dir-files=''false''/><touchz path=''{7}''/><touchz path=''{8}''/></fs>", this.getNameNodeUri(), mkdirX, deleteX, sourceX, target, chmod1X, chmod2X, newFile1X, newFile2X);
        ActionExecutorTestCase.Context context = this.createContext(actionXml);
        WorkflowAction action = context.getAction();
        TestFsActionExecutor.assertFalse((boolean)fs.exists(ae.getRecoveryPath((ActionExecutor.Context)context)));
        ae.start((ActionExecutor.Context)context, action);
        TestFsActionExecutor.assertTrue((boolean)fs.exists(ae.getRecoveryPath((ActionExecutor.Context)context)));
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestFsActionExecutor.assertEquals((String)"OK", (String)context.getAction().getExternalStatus());
        TestFsActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestFsActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)context.getAction().getStatus());
        TestFsActionExecutor.assertFalse((boolean)fs.exists(ae.getRecoveryPath((ActionExecutor.Context)context)));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(mkdir));
        TestFsActionExecutor.assertFalse((boolean)fs.exists(delete));
        TestFsActionExecutor.assertFalse((boolean)fs.exists(source));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(target));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(newFile1));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(newFile2));
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(chmod1).getPermission().toString());
        TestFsActionExecutor.assertNotSame((Object)"rwxrwxrwx", (Object)fs.getFileStatus(child1).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwx---", (String)fs.getFileStatus(chmod2).getPermission().toString());
        TestFsActionExecutor.assertNotSame((Object)"rwxrwx---", (Object)fs.getFileStatus(child2).getPermission().toString());
    }

    public void testRecovery() throws Exception {
        WorkflowAction action;
        ActionExecutorTestCase.Context context;
        String id;
        String actionXml;
        Path child2;
        Path chmod2;
        Path child1;
        Path chmod1;
        Path target;
        Path source;
        Path delete;
        Path mkdir;
        FileSystem fs;
        FsActionExecutor ae;
        block2: {
            ae = new FsActionExecutor();
            fs = this.getFileSystem();
            mkdir = new Path(this.getFsTestCaseDir(), "mkdir");
            delete = new Path(this.getFsTestCaseDir(), "delete");
            fs.mkdirs(delete);
            source = new Path(this.getFsTestCaseDir(), "source");
            fs.mkdirs(source);
            target = new Path(new Path(this.getFsTestCaseDir(), "target").toUri().getPath());
            chmod1 = new Path(this.getFsTestCaseDir(), "chmod1");
            fs.mkdirs(chmod1);
            child1 = new Path(chmod1, "child1");
            fs.mkdirs(child1);
            chmod2 = new Path(this.getFsTestCaseDir(), "chmod2");
            fs.mkdirs(chmod2);
            child2 = new Path(chmod2, "child2");
            fs.mkdirs(child2);
            actionXml = MessageFormat.format("<fs><mkdir path=''{0}''/><delete path=''{1}''/><move source=''{2}'' target=''{3}''/><chmod path=''{4}'' permissions=''111''/><chmod path=''{5}'' permissions=''222'' dir-files=''false''/></fs>", mkdir, delete, source.toUri().getPath(), target, chmod1, chmod2);
            id = "ID" + System.currentTimeMillis();
            context = this.createContext(actionXml);
            ((WorkflowJobBean)context.getWorkflow()).setId(id);
            ((WorkflowActionBean)context.getWorkflow().getActions().get(0)).setJobId(id);
            ((WorkflowActionBean)context.getWorkflow().getActions().get(0)).setId(id + "-FS");
            action = context.getAction();
            TestFsActionExecutor.assertFalse((boolean)fs.exists(ae.getRecoveryPath((ActionExecutor.Context)context)));
            try {
                ae.start((ActionExecutor.Context)context, action);
            }
            catch (ActionExecutorException ex) {
                if (ex.getErrorCode().equals("FS001")) break block2;
                throw ex;
            }
        }
        TestFsActionExecutor.assertTrue((boolean)fs.exists(mkdir));
        TestFsActionExecutor.assertFalse((boolean)fs.exists(delete));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(ae.getRecoveryPath((ActionExecutor.Context)context)));
        actionXml = MessageFormat.format("<fs><mkdir path=''{0}''/><delete path=''{1}''/><move source=''{2}'' target=''{3}''/><chmod path=''{4}'' permissions=''-rwxrwxrwx''/><chmod path=''{5}'' permissions=''-rwxrwx---'' dir-files=''false''/></fs>", mkdir, delete, source, target, chmod1, chmod2);
        context = this.createContext(actionXml);
        ((WorkflowJobBean)context.getWorkflow()).setId(id);
        ((WorkflowActionBean)context.getWorkflow().getActions().get(0)).setJobId(id);
        ((WorkflowActionBean)context.getWorkflow().getActions().get(0)).setId(id + "-FS");
        action = context.getAction();
        ae.start((ActionExecutor.Context)context, action);
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestFsActionExecutor.assertEquals((String)"OK", (String)context.getAction().getExternalStatus());
        TestFsActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestFsActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)context.getAction().getStatus());
        TestFsActionExecutor.assertFalse((boolean)fs.exists(ae.getRecoveryPath((ActionExecutor.Context)context)));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(mkdir));
        TestFsActionExecutor.assertFalse((boolean)fs.exists(delete));
        TestFsActionExecutor.assertFalse((boolean)fs.exists(source));
        TestFsActionExecutor.assertTrue((boolean)fs.exists(target));
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(chmod1).getPermission().toString());
        TestFsActionExecutor.assertNotSame((Object)"rwxrwxrwx", (Object)fs.getFileStatus(child1).getPermission().toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwx---", (String)fs.getFileStatus(chmod2).getPermission().toString());
        TestFsActionExecutor.assertNotSame((Object)"rwxrwx---", (Object)fs.getFileStatus(child2).getPermission().toString());
    }

    public void testPermissionMask() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)ae.createShortPermission("777", null).toString());
        TestFsActionExecutor.assertEquals((String)"rwxrwxrwx", (String)ae.createShortPermission("-rwxrwxrwx", null).toString());
        TestFsActionExecutor.assertEquals((String)"r--------", (String)ae.createShortPermission("400", null).toString());
        TestFsActionExecutor.assertEquals((String)"r--------", (String)ae.createShortPermission("-r--------", null).toString());
    }

    public void testChgrp() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path path = new Path(this.getFsTestCaseDir(), "dir");
        Path child = new Path(path, "child");
        Path grandchild = new Path(child, "grandchild");
        fs.mkdirs(grandchild);
        String testUser = TestFsActionExecutor.getTestUser();
        String testGroup = TestFsActionExecutor.getTestGroup();
        String testGroup2 = TestFsActionExecutor.getTestGroup2();
        fs.setOwner(path, testUser, testGroup);
        fs.setOwner(child, testUser, testGroup);
        fs.setOwner(grandchild, testUser, testGroup);
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(path).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(child).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(grandchild).getGroup().toString());
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        ae.chgrp((ActionExecutor.Context)context, null, null, path, testUser, testGroup2, false, false);
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(path).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(child).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(grandchild).getGroup().toString());
        fs.setOwner(path, testUser, testGroup);
        fs.setOwner(child, testUser, testGroup);
        fs.setOwner(grandchild, testUser, testGroup);
        ae.chgrp((ActionExecutor.Context)context, null, null, path, testUser, testGroup2, true, false);
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(path).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(child).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(grandchild).getGroup().toString());
        fs.setOwner(path, testUser, testGroup);
        fs.setOwner(child, testUser, testGroup);
        fs.setOwner(grandchild, testUser, testGroup);
        ae.chgrp((ActionExecutor.Context)context, null, null, path, testUser, testGroup2, true, true);
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(path).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(child).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(grandchild).getGroup().toString());
    }

    private void createTestDirForChgrp(Path basePath, FileSystem fs) throws Exception {
        String testUser = TestFsActionExecutor.getTestUser();
        String testGroup = TestFsActionExecutor.getTestGroup();
        fs.mkdirs(basePath);
        fs.mkdirs(new Path(basePath, "10"));
        fs.mkdirs(new Path(basePath + "/10/dir1"));
        fs.createNewFile(new Path(basePath + "/10/dir1/file1"));
        fs.mkdirs(new Path(basePath + "/10/dir2"));
        fs.mkdirs(new Path(basePath, "11"));
        fs.mkdirs(new Path(basePath + "/11/dir3"));
        fs.mkdirs(new Path(basePath, "12"));
        fs.setOwner(new Path(basePath, "10"), testUser, testGroup);
        fs.setOwner(new Path(basePath + "/10/dir1"), testUser, testGroup);
        fs.setOwner(new Path(basePath + "/10/dir1/file1"), testUser, testGroup);
        fs.setOwner(new Path(basePath + "/10/dir2"), testUser, testGroup);
        fs.setOwner(new Path(basePath, "11"), testUser, testGroup);
        fs.setOwner(new Path(basePath + "/11/dir3"), testUser, testGroup);
        fs.setOwner(new Path(basePath, "12"), testUser, testGroup);
    }

    public void testChgrpWithGlob() throws Exception {
        String testUser = TestFsActionExecutor.getTestUser();
        String testGroup = TestFsActionExecutor.getTestGroup();
        String testGroup2 = TestFsActionExecutor.getTestGroup2();
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        Path basePath = new Path(this.getFsTestCaseDir(), "2010");
        this.createTestDirForChgrp(basePath, fs);
        Path globPath = new Path(basePath + "/1[0-1]");
        ae.chgrp((ActionExecutor.Context)context, null, null, globPath, testUser, testGroup2, false, false);
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath, "10")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath, "11")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(new Path(basePath, "12")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(new Path(basePath + "/10/dir1")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(new Path(basePath + "/10/dir2")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(new Path(basePath + "/11/dir3")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(new Path(basePath + "/10/dir1/file1")).getGroup().toString());
        ae.chgrp((ActionExecutor.Context)context, null, null, globPath, testUser, testGroup2, true, false);
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath, "10")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath, "11")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(new Path(basePath, "12")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath + "/10/dir1")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath + "/10/dir2")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath + "/11/dir3")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(new Path(basePath + "/10/dir1/file1")).getGroup().toString());
        ae.chgrp((ActionExecutor.Context)context, null, null, globPath, testUser, testGroup2, true, true);
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath, "10")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath, "11")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(new Path(basePath, "12")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath + "/10/dir1")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath + "/10/dir2")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath + "/11/dir3")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath + "/10/dir1/file1")).getGroup().toString());
        fs.delete(basePath, true);
    }

    public void testChgrpRelativePath() throws Exception {
        String testUser = TestFsActionExecutor.getTestUser();
        String testGroup = TestFsActionExecutor.getTestGroup();
        String testGroup2 = TestFsActionExecutor.getTestGroup2();
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        Path basePath = new Path(this.getFsTestCaseDir(), "2010");
        this.createTestDirForChgrp(basePath, fs);
        Path globPath = new Path(basePath + "/1[0-1]");
        Path relativePath = new Path(globPath.toUri().getPath());
        Path nameNode = new Path(globPath.toUri().getScheme() + "://" + globPath.toUri().getAuthority());
        ae.chgrp((ActionExecutor.Context)context, null, nameNode, relativePath, testUser, testGroup2, false, false);
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath, "10")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup2, (String)fs.getFileStatus(new Path(basePath, "11")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(new Path(basePath, "12")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(new Path(basePath + "/10/dir1")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(new Path(basePath + "/10/dir2")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(new Path(basePath + "/11/dir3")).getGroup().toString());
        TestFsActionExecutor.assertEquals((String)testGroup, (String)fs.getFileStatus(new Path(basePath + "/10/dir1/file1")).getGroup().toString());
        try {
            ae.chgrp((ActionExecutor.Context)context, null, null, relativePath, testUser, testGroup2, false, false);
            TestFsActionExecutor.fail();
        }
        catch (ActionExecutorException e) {
            TestFsActionExecutor.assertEquals((String)e.getErrorCode(), (String)"FS001");
        }
        fs.delete(basePath, true);
    }

    private ActionExecutorTestCase.Context createContextWithUser(String actionXml, String user) throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", user);
        WorkflowJobBean wf = this.createBaseWorkflow(protoConf, "fs-action");
        wf.setUser(user);
        WorkflowActionBean action = (WorkflowActionBean)wf.getActions().get(0);
        action.setType(ae.getType());
        action.setConf(actionXml);
        return new ActionExecutorTestCase.Context(this, wf, action);
    }

    public void testRetryOnAccessControlError() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path path = new Path(this.getFsTestCaseDir(), "dir");
        fs.mkdirs(path);
        fs.setPermission(path, FsPermission.valueOf((String)"-rwx------"));
        ActionExecutorTestCase.Context context = this.createContextWithUser("<fs/>", TestFsActionExecutor.getTestUser2());
        try {
            ae.chmod((ActionExecutor.Context)context, path, "-r--------", false, false);
            TestFsActionExecutor.fail();
        }
        catch (Exception e) {
            TestFsActionExecutor.assertTrue((boolean)(e instanceof ActionExecutorException));
            TestFsActionExecutor.assertEquals((String)"FS014", (String)((ActionExecutorException)((Object)e)).getErrorCode());
            TestFsActionExecutor.assertEquals((Object)ActionExecutorException.ErrorType.ERROR, (Object)((ActionExecutorException)((Object)e)).getErrorType());
        }
    }

    public void testSetRep() throws Exception {
        FsActionExecutor ae = new FsActionExecutor();
        FileSystem fs = this.getFileSystem();
        Path path = new Path(this.getFsTestCaseDir(), "dir1");
        ActionExecutorTestCase.Context context = this.createContext("<fs/>");
        fs.mkdirs(path);
        Path file = new Path(path + "/file");
        fs.createNewFile(file);
        int replicationFactor = 2;
        ae.setrep((ActionExecutor.Context)context, path, (short)2);
        TestFsActionExecutor.assertEquals((short)2, (short)fs.getFileStatus(file).getReplication());
    }
}

