/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.Credentials;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.action.hadoop.HCatCredentialHelper;
import org.apache.oozie.action.hadoop.HCatCredentials;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={HCatCredentialHelper.class, HCatCredentials.class})
public class TestHCatCredentials {
    private Services services;
    private static File OOZIE_HOME_DIR = null;
    private static final String TEST_HIVE_METASTORE_PRINCIPAL = "hcat/test-hcat1.com@OOZIE.EXAMPLE.COM";
    private static final String TEST_HIVE_METASTORE_URI = "thrift://test-hcat1.com:9898";
    private static final String TEST_HIVE_METASTORE_PRINCIPAL2 = "hcat/test-hcat2.com@OOZIE.EXAMPLE.COM";
    private static final String TEST_HIVE_METASTORE_URI2 = "thrift://test-hcat2.com:9898";
    final String HIVE_METASTORE_PRINCIPAL = "hive.principal";
    final String HIVE_METASTORE_URI = "hive.uri";
    final String HCAT_METASTORE_PRINCIPAL = "hcat.principal";
    final String HCAT_METASTORE_URI = "hcat.uri";
    private static File hiveSiteXml = null;
    private static ClassLoader prevClassloader = null;

    @BeforeClass
    public static void initialize() throws Exception {
        OOZIE_HOME_DIR = new File(new File("").getAbsolutePath(), "test-oozie-home");
        if (!OOZIE_HOME_DIR.exists()) {
            OOZIE_HOME_DIR.mkdirs();
        }
        System.setProperty("oozie.home.dir", OOZIE_HOME_DIR.getAbsolutePath());
        Services.setOozieHome();
        File oozieConfDir = new File(OOZIE_HOME_DIR.getAbsolutePath(), "conf");
        oozieConfDir.mkdir();
        File hadoopConfDir = new File(oozieConfDir, "hadoop-conf");
        hadoopConfDir.mkdir();
        File actionConfDir = new File(oozieConfDir, "action-conf");
        actionConfDir.mkdir();
        hiveSiteXml = new File(OOZIE_HOME_DIR, "hive-site.xml");
        FileWriter fw = new FileWriter(hiveSiteXml);
        fw.write(TestHCatCredentials.getHiveConfig(TEST_HIVE_METASTORE_PRINCIPAL, TEST_HIVE_METASTORE_URI));
        fw.flush();
        fw.close();
        prevClassloader = Thread.currentThread().getContextClassLoader();
    }

    @Before
    public void setUp() throws ServiceException, MalformedURLException {
        this.services = new Services();
        Configuration conf = this.services.getConf();
        conf.set("oozie.services.ext", HCatAccessorService.class.getName());
        conf.set("oozie.services", "");
        ContextClassLoader contextClassLoader = new ContextClassLoader(HCatCredentials.class.getClassLoader());
        contextClassLoader.addURL(hiveSiteXml.toURI().toURL());
        Thread.currentThread().setContextClassLoader(contextClassLoader);
    }

    @After
    public void tearDown() {
        if (this.services != null) {
            this.services.destroy();
        }
    }

    @AfterClass
    public static void terminate() throws IOException {
        FileUtils.deleteDirectory((File)OOZIE_HOME_DIR);
        Thread.currentThread().setContextClassLoader(prevClassloader);
    }

    @Test
    public void testAddToJobConfFromHCat() throws Exception {
        File hcatConfig = new File(OOZIE_HOME_DIR, "hcatConf.xml");
        FileWriter fw = new FileWriter(hcatConfig);
        fw.write(TestHCatCredentials.getHiveConfig(TEST_HIVE_METASTORE_PRINCIPAL2, TEST_HIVE_METASTORE_URI2));
        fw.flush();
        fw.close();
        Configuration conf = this.services.getConf();
        conf.set("oozie.service.HCatAccessorService.hcat.configuration", OOZIE_HOME_DIR + "/hcatConf.xml");
        this.services.init();
        HCatCredentialHelper hcatCredHelper = (HCatCredentialHelper)Mockito.mock(HCatCredentialHelper.class);
        PowerMockito.whenNew(HCatCredentialHelper.class).withNoArguments().thenReturn((Object)hcatCredHelper);
        CredentialsProperties credProps = new CredentialsProperties("", "");
        credProps.setProperties(new HashMap());
        HCatCredentials hcatCred = new HCatCredentials();
        JobConf jobConf = new JobConf(false);
        Credentials credentials = new Credentials();
        ((HCatCredentialHelper)PowerMockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                Configuration jConf = (Configuration)args[1];
                jConf.set("hcat.principal", (String)args[2]);
                jConf.set("hcat.uri", (String)args[3]);
                return null;
            }
        }).when((Object)hcatCredHelper)).set(credentials, (Configuration)jobConf, TEST_HIVE_METASTORE_PRINCIPAL2, TEST_HIVE_METASTORE_URI2);
        hcatCred.updateCredentials(credentials, (Configuration)jobConf, credProps, null);
        Assert.assertEquals((Object)TEST_HIVE_METASTORE_PRINCIPAL2, (Object)jobConf.get("hcat.principal"));
        Assert.assertEquals((Object)TEST_HIVE_METASTORE_URI2, (Object)jobConf.get("hcat.uri"));
        Assert.assertNull((Object)jobConf.get("hive.principal"));
        Assert.assertNull((Object)jobConf.get("hive.uri"));
        hcatConfig.delete();
    }

    @Test
    public void testAddToJobConfFromHiveConf() throws Exception {
        this.services.init();
        CredentialsProperties credProps = new CredentialsProperties("", "");
        credProps.setProperties(new HashMap());
        HCatCredentials hcatCred = new HCatCredentials();
        JobConf jobConf = new JobConf(false);
        Credentials credentials = new Credentials();
        HCatCredentialHelper hcatCredHelper = (HCatCredentialHelper)Mockito.mock(HCatCredentialHelper.class);
        PowerMockito.whenNew(HCatCredentialHelper.class).withNoArguments().thenReturn((Object)hcatCredHelper);
        ((HCatCredentialHelper)PowerMockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                Configuration jConf = (Configuration)args[1];
                jConf.set("hive.principal", (String)args[2]);
                jConf.set("hive.uri", (String)args[3]);
                return null;
            }
        }).when((Object)hcatCredHelper)).set(credentials, (Configuration)jobConf, TEST_HIVE_METASTORE_PRINCIPAL, TEST_HIVE_METASTORE_URI);
        hcatCred.updateCredentials(credentials, (Configuration)jobConf, credProps, null);
        Assert.assertEquals((Object)TEST_HIVE_METASTORE_PRINCIPAL, (Object)jobConf.get("hive.principal"));
        Assert.assertEquals((Object)TEST_HIVE_METASTORE_URI, (Object)jobConf.get("hive.uri"));
        Assert.assertNull((Object)jobConf.get("hcat.principal"));
        Assert.assertNull((Object)jobConf.get("hcat.uri"));
    }

    @Test
    public void testAddToJobConfFromOozieConfig() throws Exception {
        this.services.init();
        HCatCredentialHelper hcatCredHelper = (HCatCredentialHelper)Mockito.mock(HCatCredentialHelper.class);
        PowerMockito.whenNew(HCatCredentialHelper.class).withNoArguments().thenReturn((Object)hcatCredHelper);
        CredentialsProperties credProps = new CredentialsProperties("", "");
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("hcat.metastore.principal", TEST_HIVE_METASTORE_PRINCIPAL2);
        prop.put("hcat.metastore.uri", TEST_HIVE_METASTORE_URI2);
        credProps.setProperties(prop);
        HCatCredentials hcatCred = new HCatCredentials();
        JobConf jobConf = new JobConf(false);
        Credentials credentials = new Credentials();
        ((HCatCredentialHelper)PowerMockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                JobConf jConf = (JobConf)args[1];
                jConf.set("hcat.principal", (String)args[2]);
                jConf.set("hcat.uri", (String)args[3]);
                return null;
            }
        }).when((Object)hcatCredHelper)).set(credentials, (Configuration)jobConf, TEST_HIVE_METASTORE_PRINCIPAL2, TEST_HIVE_METASTORE_URI2);
        hcatCred.updateCredentials(credentials, (Configuration)jobConf, credProps, null);
        Assert.assertEquals((Object)TEST_HIVE_METASTORE_PRINCIPAL2, (Object)jobConf.get("hcat.principal"));
        Assert.assertEquals((Object)TEST_HIVE_METASTORE_URI2, (Object)jobConf.get("hcat.uri"));
        Assert.assertNull((Object)jobConf.get("hive.principal"));
        Assert.assertNull((Object)jobConf.get("hive.uri"));
    }

    private static String getHiveConfig(String hivePrincipal, String hiveUri) {
        return "<configuration><property><name>hive.metastore.kerberos.principal</name><value>" + hivePrincipal + "</value></property><property><name>hive.metastore.uris</name><value>" + hiveUri + "</value></property></configuration>";
    }

    private static class ContextClassLoader
    extends URLClassLoader {
        private HashMap<String, URL> resources = new HashMap();

        @Override
        public URL findResource(String name) {
            if (this.resources.containsKey(name)) {
                return this.resources.get(name);
            }
            return super.findResource(name);
        }

        @Override
        public URL getResource(String name) {
            if (this.resources.containsKey(name)) {
                return this.resources.get(name);
            }
            return super.getResource(name);
        }

        public ContextClassLoader(ClassLoader classLoader) {
            this(new URL[0], classLoader);
        }

        public ContextClassLoader(URL[] urls, ClassLoader classLoader) {
            super(urls, classLoader);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
            try {
                this.resources.put(new Path(url.toURI()).getName(), url);
            }
            catch (URISyntaxException e) {
                e.printStackTrace(System.out);
            }
        }
    }
}

