/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.action.hadoop.LauncherHelper;
import org.apache.oozie.action.hadoop.PrepareActionsDriver;
import org.apache.oozie.dependency.FSURIHandler;
import org.apache.oozie.dependency.HCatURIHandler;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XHCatTestCase;
import org.junit.Test;

public class TestHCatPrepareActions
extends XHCatTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Services services = new Services();
        services.getConf().set("oozie.service.URIHandlerService.uri.handlers", FSURIHandler.class.getName() + "," + HCatURIHandler.class.getName());
        services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    @Test
    public void testDelete() throws Exception {
        this.dropTable("db1", "table1", true);
        this.dropDatabase("db1", true);
        this.createDatabase("db1");
        this.createTable("db1", "table1", "year,month,dt,country");
        String part1 = this.addPartition("db1", "table1", "year=2012;month=12;dt=02;country=us");
        String part2 = this.addPartition("db1", "table1", "year=2012;month=12;dt=03;country=us");
        String part3 = this.addPartition("db1", "table1", "year=2013;month=1;dt=01;country=us");
        String uri1 = "hcat://" + this.getMetastoreAuthority() + "/db1/table1/year=2012;month=12";
        String uri2 = "hcat://" + this.getMetastoreAuthority() + "/db1/table1/year=2013;dt=01";
        String prepareXML = "<prepare><delete path='" + uri1 + "'/><delete path='" + uri2 + "'/></prepare>";
        JobConf conf = this.createJobConf();
        LauncherHelper.setupLauncherURIHandlerConf((Configuration)conf);
        PrepareActionsDriver.doOperations((String)prepareXML, (Configuration)conf);
        FileSystem fs = this.getFileSystem();
        TestHCatPrepareActions.assertFalse((boolean)fs.exists(new Path(part1)));
        TestHCatPrepareActions.assertFalse((boolean)fs.exists(new Path(part2)));
        TestHCatPrepareActions.assertFalse((boolean)fs.exists(new Path(part3)));
        TestHCatPrepareActions.assertEquals((int)0, (int)this.getPartitions("db1", "table1", "country=us").size());
        this.dropTable("db1", "table1", true);
        this.dropDatabase("db1", true);
    }
}

