/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.ActionExecutorTestCase;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.action.hadoop.CredentialsProviderFactory;
import org.apache.oozie.action.hadoop.HiveActionExecutor;
import org.apache.oozie.action.hadoop.InsertTestToken;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.action.hadoop.JavaMain;
import org.apache.oozie.action.hadoop.LauncherAMUtils;
import org.apache.oozie.action.hadoop.LauncherHelper;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.LauncherMainTester;
import org.apache.oozie.action.hadoop.LauncherMainTester2;
import org.apache.oozie.action.hadoop.PigActionExecutor;
import org.apache.oozie.action.hadoop.TestWorkflowHelper;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.ShareLibService;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.service.UserGroupInformationService;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.WorkflowLib;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;
import org.jdom.Element;
import org.junit.Assert;
import org.junit.Test;

public class TestJavaActionExecutor
extends ActionExecutorTestCase {
    private static final String YARN_RESOURCEMANAGER_ADDRESS = "yarn.resourcemanager.address";
    private static final String MAPRED_CHILD_JAVA_OPTS = "mapred.child.java.opts";
    private static final String MAPREDUCE_MAP_JAVA_OPTS = "mapreduce.map.java.opts";
    private TestWorkflowHelper helper;

    @Override
    protected void beforeSetUp() throws Exception {
        super.beforeSetUp();
        this.setSystemProperty("oozie.test.hadoop.minicluster2", "true");
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.helper = new TestWorkflowHelper(this.getJobTrackerUri(), this.getNameNodeUri(), this.getTestCaseDir());
    }

    @Override
    protected void setSystemProps() throws Exception {
        super.setSystemProps();
        this.setSystemProperty("oozie.service.ActionService.executor.classes", JavaActionExecutor.class.getName());
        this.setSystemProperty("oozie.service.HadoopAccessorService.action.configurations", "*=hadoop-conf," + this.getJobTrackerUri() + "=action-conf");
        this.setSystemProperty("oozie.service.WorkflowAppService.system.libpath", this.getFsTestCaseDir().toUri().getPath() + "/systemlib");
        new File(this.getTestCaseConfDir(), "action-conf").mkdir();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("test-action-config.xml");
        FileOutputStream os = new FileOutputStream(new File(this.getTestCaseConfDir() + "/action-conf", "java.xml"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
    }

    public void testSetupMethods() throws Exception {
        JavaActionExecutor ae = new JavaActionExecutor();
        TestJavaActionExecutor.assertEquals(Arrays.asList(JavaMain.class), (Object)ae.getLauncherClasses());
        XConfiguration conf = new XConfiguration();
        conf.set("user.name", "a");
        try {
            JavaActionExecutor.checkForDisallowedProps((Configuration)conf, (String)"x");
            TestJavaActionExecutor.fail();
        }
        catch (ActionExecutorException actionExecutorException) {
            // empty catch block
        }
        conf = new XConfiguration();
        conf.set(YARN_RESOURCEMANAGER_ADDRESS, "a");
        try {
            JavaActionExecutor.checkForDisallowedProps((Configuration)conf, (String)"x");
            TestJavaActionExecutor.fail();
        }
        catch (ActionExecutorException actionExecutorException) {
            // empty catch block
        }
        conf = new XConfiguration();
        conf.set("fs.default.name", "a");
        try {
            JavaActionExecutor.checkForDisallowedProps((Configuration)conf, (String)"x");
            TestJavaActionExecutor.fail();
        }
        catch (ActionExecutorException actionExecutorException) {
            // empty catch block
        }
        conf = new XConfiguration();
        conf.set("a", "a");
        try {
            JavaActionExecutor.checkForDisallowedProps((Configuration)conf, (String)"x");
        }
        catch (ActionExecutorException ex) {
            TestJavaActionExecutor.fail();
        }
        Element actionXml = XmlUtils.parseXml((String)("<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><job-xml>job.xml</job-xml><job-xml>job2.xml</job-xml><configuration><property><name>oozie.launcher.a</name><value>LA</value></property><property><name>a</name><value>AA</value></property><property><name>b</name><value>BB</value></property></configuration><main-class>MAIN-CLASS</main-class><java-opts>JAVA-OPTS</java-opts><arg>A1</arg><arg>A2</arg><file>f.jar</file><archive>a.tar</archive></java>"));
        Path appPath = new Path(this.getFsTestCaseDir(), "wf");
        Path appJarPath = new Path("lib/a.jar");
        this.getFileSystem().create(new Path(appPath, appJarPath)).close();
        Path appSoPath = new Path("lib/a.so");
        this.getFileSystem().create(new Path(appPath, appSoPath)).close();
        Path appSo1Path = new Path("lib/a.so.1");
        String expectedSo1Path = "lib/a.so.1#a.so.1";
        this.getFileSystem().create(new Path(appPath, appSo1Path)).close();
        Path filePath = new Path("f.jar");
        this.getFileSystem().create(new Path(appPath, filePath)).close();
        Path archivePath = new Path("a.tar");
        this.getFileSystem().create(new Path(appPath, archivePath)).close();
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestJavaActionExecutor.getTestUser());
        protoConf.setStrings("oozie.wf.application.lib", new String[]{appJarPath.toString(), appSoPath.toString()});
        WorkflowJobBean wf = this.createBaseWorkflow(protoConf, "action");
        WorkflowActionBean action = (WorkflowActionBean)wf.getActions().get(0);
        action.setType(ae.getType());
        ActionExecutorTestCase.Context context = new ActionExecutorTestCase.Context(this, wf, action);
        conf = new XConfiguration();
        conf.set("c", "C");
        conf.set("oozie.launcher.d", "D");
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getFsTestCaseDir(), "job.xml"));
        conf.writeXml((OutputStream)os);
        os.close();
        os = this.getFileSystem().create(new Path(this.getFsTestCaseDir(), new Path("app", "job.xml")));
        conf.writeXml((OutputStream)os);
        os.close();
        conf = new XConfiguration();
        conf.set("e", "E");
        conf.set("oozie.launcher.f", "F");
        os = this.getFileSystem().create(new Path(this.getFsTestCaseDir(), "job2.xml"));
        conf.writeXml((OutputStream)os);
        os.close();
        os = this.getFileSystem().create(new Path(this.getFsTestCaseDir(), new Path("app", "job2.xml")));
        conf.writeXml((OutputStream)os);
        os.close();
        conf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXml);
        TestJavaActionExecutor.assertEquals((String)protoConf.get("user.name"), (String)conf.get("user.name"));
        TestJavaActionExecutor.assertEquals((String)this.getJobTrackerUri(), (String)conf.get(YARN_RESOURCEMANAGER_ADDRESS));
        TestJavaActionExecutor.assertEquals((String)this.getNameNodeUri(), (String)conf.get("fs.default.name"));
        conf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXml);
        ae.setupLauncherConf((Configuration)conf, actionXml, this.getFsTestCaseDir(), (ActionExecutor.Context)context);
        TestJavaActionExecutor.assertEquals((String)"LA", (String)conf.get("oozie.launcher.a"));
        TestJavaActionExecutor.assertEquals((String)"LA", (String)conf.get("a"));
        TestJavaActionExecutor.assertNull((Object)conf.get("b"));
        TestJavaActionExecutor.assertEquals((String)"D", (String)conf.get("oozie.launcher.d"));
        TestJavaActionExecutor.assertEquals((String)"D", (String)conf.get("d"));
        TestJavaActionExecutor.assertEquals((String)"F", (String)conf.get("oozie.launcher.f"));
        TestJavaActionExecutor.assertEquals((String)"F", (String)conf.get("f"));
        TestJavaActionExecutor.assertNull((Object)conf.get("action.foo"));
        TestJavaActionExecutor.assertEquals((String)"action.barbar", (String)conf.get("action.foofoo"));
        conf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXml);
        ae.setupActionConf((Configuration)conf, (ActionExecutor.Context)context, actionXml, this.getFsTestCaseDir());
        TestJavaActionExecutor.assertEquals((String)"LA", (String)conf.get("oozie.launcher.a"));
        TestJavaActionExecutor.assertEquals((String)"AA", (String)conf.get("a"));
        TestJavaActionExecutor.assertEquals((String)"BB", (String)conf.get("b"));
        TestJavaActionExecutor.assertEquals((String)"C", (String)conf.get("c"));
        TestJavaActionExecutor.assertEquals((String)"D", (String)conf.get("oozie.launcher.d"));
        TestJavaActionExecutor.assertNull((Object)conf.get("d"));
        TestJavaActionExecutor.assertEquals((String)"E", (String)conf.get("e"));
        TestJavaActionExecutor.assertEquals((String)"F", (String)conf.get("oozie.launcher.f"));
        TestJavaActionExecutor.assertNull((Object)conf.get("f"));
        TestJavaActionExecutor.assertEquals((String)"action.bar", (String)conf.get("action.foo"));
        conf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXml);
        ae.setupLauncherConf((Configuration)conf, actionXml, this.getFsTestCaseDir(), (ActionExecutor.Context)context);
        ae.addToCache((Configuration)conf, appPath, appJarPath.toString(), false);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.job.classpath.files").contains(appJarPath.toUri().getPath()));
        ae.addToCache((Configuration)conf, appPath, appSoPath.toString(), false);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.files").contains(appSoPath.toUri().getPath()));
        ae.addToCache((Configuration)conf, appPath, appSo1Path.toString(), false);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.files").contains(expectedSo1Path));
        TestJavaActionExecutor.assertFalse((boolean)this.getFileSystem().exists(context.getActionDir()));
        ae.prepareActionDir(this.getFileSystem(), (ActionExecutor.Context)context);
        TestJavaActionExecutor.assertTrue((boolean)this.getFileSystem().exists(context.getActionDir()));
        ae.cleanUpActionDir(this.getFileSystem(), (ActionExecutor.Context)context);
        TestJavaActionExecutor.assertFalse((boolean)this.getFileSystem().exists(context.getActionDir()));
        conf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXml);
        ae.setupLauncherConf((Configuration)conf, actionXml, this.getFsTestCaseDir(), (ActionExecutor.Context)context);
        ae.setLibFilesArchives((ActionExecutor.Context)context, actionXml, appPath, (Configuration)conf);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.files").contains(filePath.toUri().getPath()));
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.archives").contains(archivePath.toUri().getPath()));
        conf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXml);
        ae.setupActionConf((Configuration)conf, (ActionExecutor.Context)context, actionXml, this.getFsTestCaseDir());
        ae.setLibFilesArchives((ActionExecutor.Context)context, actionXml, appPath, (Configuration)conf);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.files").contains(filePath.toUri().getPath()));
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.archives").contains(archivePath.toUri().getPath()));
        Configuration actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXml);
        ae.setupActionConf(actionConf, (ActionExecutor.Context)context, actionXml, this.getFsTestCaseDir());
        conf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, actionXml, actionConf);
        ae.setupLauncherConf((Configuration)conf, actionXml, this.getFsTestCaseDir(), (ActionExecutor.Context)context);
        TestJavaActionExecutor.assertEquals((String)"MAIN-CLASS", (String)actionConf.get("oozie.action.java.main", "null"));
        TestJavaActionExecutor.assertEquals((String)"org.apache.oozie.action.hadoop.JavaMain", (String)ae.getLauncherMain((Configuration)conf, actionXml));
        TestJavaActionExecutor.assertTrue((boolean)conf.get(MAPRED_CHILD_JAVA_OPTS).contains("JAVA-OPTS"));
        TestJavaActionExecutor.assertTrue((boolean)conf.get(MAPREDUCE_MAP_JAVA_OPTS).contains("JAVA-OPTS"));
        TestJavaActionExecutor.assertEquals(Arrays.asList("A1", "A2"), Arrays.asList(LauncherAMUtils.getMainArguments((Configuration)conf)));
        actionXml = XmlUtils.parseXml((String)("<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node> <configuration><property><name>mapred.job.queue.name</name><value>AQ</value></property><property><name>oozie.action.sharelib.for.java</name><value>sharelib-java</value></property></configuration><main-class>MAIN-CLASS</main-class></java>"));
        actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXml);
        ae.setupActionConf(actionConf, (ActionExecutor.Context)context, actionXml, appPath);
        conf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, actionXml, actionConf);
        TestJavaActionExecutor.assertEquals((String)"AQ", (String)conf.get("mapred.job.queue.name"));
        TestJavaActionExecutor.assertEquals((String)"AQ", (String)actionConf.get("mapred.job.queue.name"));
        TestJavaActionExecutor.assertEquals((String)"sharelib-java", (String)actionConf.get("oozie.action.sharelib.for.java"));
        actionXml = XmlUtils.parseXml((String)("<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node> <configuration><property><name>oozie.launcher.mapred.job.queue.name</name><value>LQ</value></property></configuration><main-class>MAIN-CLASS</main-class></java>"));
        actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXml);
        ae.setupActionConf(actionConf, (ActionExecutor.Context)context, actionXml, appPath);
        conf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, actionXml, actionConf);
        TestJavaActionExecutor.assertEquals((String)"LQ", (String)conf.get("mapred.job.queue.name"));
        actionXml = XmlUtils.parseXml((String)("<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node> <configuration><property><name>oozie.launcher.mapred.job.queue.name</name><value>LQ</value></property><property><name>mapred.job.queue.name</name><value>AQ</value></property></configuration><main-class>MAIN-CLASS</main-class></java>"));
        actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXml);
        ae.setupActionConf(actionConf, (ActionExecutor.Context)context, actionXml, appPath);
        conf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, actionXml, actionConf);
        TestJavaActionExecutor.assertEquals((String)"LQ", (String)conf.get("mapred.job.queue.name"));
        TestJavaActionExecutor.assertEquals((String)"AQ", (String)actionConf.get("mapred.job.queue.name"));
        TestJavaActionExecutor.assertEquals((boolean)true, (boolean)conf.getBoolean("mapreduce.job.complete.cancel.delegation.tokens", false));
        TestJavaActionExecutor.assertEquals((boolean)false, (boolean)actionConf.getBoolean("mapreduce.job.complete.cancel.delegation.tokens", true));
    }

    protected ActionExecutorTestCase.Context createContext(String actionXml, String group) throws Exception {
        JavaActionExecutor ae = new JavaActionExecutor();
        Path appJarPath = new Path("lib/test.jar");
        File jarFile = IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)"test.jar", (Class[])new Class[]{LauncherMainTester.class});
        FileInputStream is = new FileInputStream(jarFile);
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getAppPath(), "lib/test.jar"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        Path appSoPath = new Path("lib/test.so");
        this.getFileSystem().create(new Path(this.getAppPath(), appSoPath)).close();
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestJavaActionExecutor.getTestUser());
        protoConf.setStrings("oozie.wf.application.lib", new String[]{appJarPath.toString(), appSoPath.toString()});
        WorkflowJobBean wf = this.createBaseWorkflow(protoConf, "action");
        if (group != null) {
            wf.setGroup(group);
        }
        WorkflowActionBean action = (WorkflowActionBean)wf.getActions().get(0);
        action.setType(ae.getType());
        action.setConf(actionXml);
        return new ActionExecutorTestCase.Context(this, wf, action);
    }

    protected String submitAction(ActionExecutorTestCase.Context context, JavaActionExecutor javaActionExecutor) throws ActionExecutorException {
        WorkflowAction action = context.getAction();
        javaActionExecutor.prepareActionDir(this.getFileSystem(), (ActionExecutor.Context)context);
        javaActionExecutor.submitLauncher(this.getFileSystem(), (ActionExecutor.Context)context, action);
        String jobId = action.getExternalId();
        String jobTracker = action.getTrackerUri();
        String consoleUrl = action.getConsoleUrl();
        TestJavaActionExecutor.assertNotNull((Object)jobId);
        TestJavaActionExecutor.assertNotNull((Object)jobTracker);
        TestJavaActionExecutor.assertNotNull((Object)consoleUrl);
        return jobId;
    }

    protected String submitAction(ActionExecutorTestCase.Context context) throws ActionExecutorException {
        return this.submitAction(context, new JavaActionExecutor());
    }

    public void testSimpestSleSubmitOK() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(context.getAction().getExternalId());
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((String)"SUCCEEDED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)context.getAction().getStatus());
    }

    public void testSimplestSubmitWithResourceManagerOK() throws Exception {
        String actionXml = "<java><resource-manager>" + this.getJobTrackerUri() + "</resource-manager><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(context.getAction().getExternalId());
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((String)"SUCCEEDED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)context.getAction().getStatus());
    }

    public void testOutputSubmitOK() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + LauncherMainTester.class.getName() + "</main-class><arg>out</arg><capture-output/></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        String runningJob = this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(runningJob);
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((String)"SUCCEEDED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertNotNull((Object)context.getAction().getData());
        StringReader sr = new StringReader(context.getAction().getData());
        Properties props = new Properties();
        props.load(sr);
        TestJavaActionExecutor.assertEquals((Object)"A", (Object)props.get("a"));
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)context.getAction().getStatus());
    }

    public void testIdSwapSubmitOK() throws Exception {
        block2: {
            String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + LauncherMainTester.class.getName() + "</main-class><arg>id</arg><capture-output/></java>";
            ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
            String runningJob = this.submitAction(context);
            this.waitUntilYarnAppDoneAndAssertSuccess(runningJob);
            JavaActionExecutor ae = new JavaActionExecutor();
            try {
                ae.check((ActionExecutor.Context)context, context.getAction());
            }
            catch (ActionExecutorException ex) {
                if (ex.getMessage().contains("IDSWAP")) break block2;
                TestJavaActionExecutor.fail();
            }
        }
    }

    public void testAdditionalJarSubmitOK() throws Exception {
        Path appJarPath = new Path("test-extra.jar");
        File jarFile = IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)appJarPath.getName(), (Class[])new Class[]{LauncherMainTester2.class});
        FileInputStream is = new FileInputStream(jarFile);
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getAppPath(), appJarPath.toString()));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + LauncherMainTester2.class.getName() + "</main-class><file>" + appJarPath.toString() + "</file></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        String runningJobId = this.submitAction(context);
        JavaActionExecutor ae = new JavaActionExecutor();
        TestJavaActionExecutor.assertFalse((boolean)ae.isCompleted(context.getAction().getExternalStatus()));
        this.waitUntilYarnAppDoneAndAssertSuccess(runningJobId);
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((String)"SUCCEEDED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)context.getAction().getStatus());
    }

    public void testExit0SubmitOK() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + LauncherMainTester.class.getName() + "</main-class><arg>exit0</arg></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        String runningJob = this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(runningJob);
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertTrue((boolean)ae.isCompleted(context.getAction().getExternalStatus()));
        TestJavaActionExecutor.assertEquals((String)"SUCCEEDED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)context.getAction().getStatus());
    }

    public void testExit1SubmitError() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + LauncherMainTester.class.getName() + "</main-class><arg>exit1</arg></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        String runningJob = this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(runningJob);
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertTrue((boolean)ae.isCompleted(context.getAction().getExternalStatus()));
        TestJavaActionExecutor.assertEquals((String)"FAILED/KILLED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertEquals((String)"1", (String)context.getAction().getErrorCode());
        TestJavaActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.ERROR, (Object)context.getAction().getStatus());
    }

    public void testExceptionSubmitException() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + LauncherMainTester.class.getName() + "</main-class><arg>exception</arg></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        String runningJob = this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(runningJob);
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertTrue((boolean)ae.isCompleted(context.getAction().getExternalStatus()));
        TestJavaActionExecutor.assertEquals((String)"FAILED/KILLED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.ERROR, (Object)context.getAction().getStatus());
    }

    public void testExceptionSubmitThrowable() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + LauncherMainTester.class.getName() + "</main-class><arg>throwable</arg></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        String runningJob = this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(runningJob);
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertTrue((boolean)ae.isCompleted(context.getAction().getExternalStatus()));
        TestJavaActionExecutor.assertEquals((String)"FAILED/KILLED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.ERROR, (Object)context.getAction().getStatus());
    }

    public void testKill() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        String runningJob = this.submitAction(context);
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.kill((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.DONE, (Object)context.getAction().getStatus());
        TestJavaActionExecutor.assertEquals((String)"KILLED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertTrue((boolean)ae.isCompleted(context.getAction().getExternalStatus()));
        this.waitUntilYarnAppKilledAndAssertSuccess(runningJob);
    }

    public void testRecovery() throws Exception {
        final String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        final ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        String launcherId = this.submitAction(context);
        this.waitFor(60000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                JavaActionExecutor ae = new JavaActionExecutor();
                Configuration conf = ae.createBaseHadoopConf((ActionExecutor.Context)context, XmlUtils.parseXml((String)actionXml));
                return LauncherHelper.getRecoveryId((Configuration)conf, (Path)context.getActionDir(), (String)context.getRecoveryId()) != null;
            }
        });
        String runningJob2 = this.submitAction(context);
        TestJavaActionExecutor.assertEquals((String)launcherId, (String)runningJob2);
        TestJavaActionExecutor.assertEquals((String)launcherId, (String)context.getAction().getExternalId());
        this.waitUntilYarnAppDoneAndAssertSuccess(launcherId);
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((String)"SUCCEEDED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)context.getAction().getStatus());
    }

    public void testLibFileArchives() throws Exception {
        boolean found;
        Path root = new Path(this.getFsTestCaseDir(), "root");
        Path jar = new Path("jar.jar");
        this.getFileSystem().create(new Path(this.getAppPath(), jar)).close();
        Path rootJar = new Path(root, "rootJar.jar");
        this.getFileSystem().create(rootJar).close();
        Path file = new Path("file");
        this.getFileSystem().create(new Path(this.getAppPath(), file)).close();
        Path rootFile = new Path(root, "rootFile");
        this.getFileSystem().create(rootFile).close();
        Path so = new Path("soFile.so");
        this.getFileSystem().create(new Path(this.getAppPath(), so)).close();
        Path rootSo = new Path(root, "rootSoFile.so");
        this.getFileSystem().create(rootSo).close();
        Path so1 = new Path("soFile.so.1");
        this.getFileSystem().create(new Path(this.getAppPath(), so1)).close();
        Path rootSo1 = new Path(root, "rootSoFile.so.1");
        this.getFileSystem().create(rootSo1).close();
        Path archive = new Path("archive.tar");
        this.getFileSystem().create(new Path(this.getAppPath(), archive)).close();
        Path rootArchive = new Path(root, "rootArchive.tar");
        this.getFileSystem().create(rootArchive).close();
        String actionXml = "<java>      <job-tracker>" + this.getJobTrackerUri() + "</job-tracker>      <name-node>" + this.getNameNodeUri() + "</name-node>      <main-class>CLASS</main-class>      <file>" + jar.toString() + "</file>\n      <file>" + rootJar.toString() + "</file>\n      <file>" + file.toString() + "</file>\n      <file>" + rootFile.toString() + "</file>\n      <file>" + so.toString() + "</file>\n      <file>" + rootSo.toString() + "</file>\n      <file>" + so1.toString() + "</file>\n      <file>" + rootSo1.toString() + "</file>\n      <archive>" + archive.toString() + "</archive>\n      <archive>" + rootArchive.toString() + "</archive>\n</java>";
        Element eActionXml = XmlUtils.parseXml((String)actionXml);
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        Path appPath = this.getAppPath();
        JavaActionExecutor ae = new JavaActionExecutor();
        Configuration jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        ae.setupActionConf(jobConf, (ActionExecutor.Context)context, eActionXml, appPath);
        ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, appPath, jobConf);
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)jobConf));
        Path[] filesInClasspath = DistributedCache.getFileClassPaths((Configuration)jobConf);
        for (Path p : new Path[]{new Path(this.getAppPath(), jar), rootJar}) {
            found = false;
            for (Path c : filesInClasspath) {
                if (found || !p.toUri().getPath().equals(c.toUri().getPath())) continue;
                found = true;
            }
            TestJavaActionExecutor.assertTrue((String)("file " + p.toUri().getPath() + " not found in classpath"), (boolean)found);
        }
        for (Path p : new Path[]{new Path(this.getAppPath(), file), rootFile, new Path(this.getAppPath(), so), rootSo, new Path(this.getAppPath(), so1), rootSo1}) {
            found = false;
            for (Path c : filesInClasspath) {
                if (found || !p.toUri().getPath().equals(c.toUri().getPath())) continue;
                found = true;
            }
            TestJavaActionExecutor.assertFalse((String)("file " + p.toUri().getPath() + " found in classpath"), (boolean)found);
        }
        URI[] filesInCache = DistributedCache.getCacheFiles((Configuration)jobConf);
        for (Path p : new Path[]{new Path(this.getAppPath(), jar), rootJar, new Path(this.getAppPath(), file), rootFile, new Path(this.getAppPath(), so), rootSo, new Path(this.getAppPath(), so1), rootSo1}) {
            boolean found2 = false;
            for (URI c : filesInCache) {
                if (found2 || !p.toUri().getPath().equals(c.getPath())) continue;
                found2 = true;
            }
            TestJavaActionExecutor.assertTrue((String)("file " + p.toUri().getPath() + " not found in cache"), (boolean)found2);
        }
        URI[] archivesInCache = DistributedCache.getCacheArchives((Configuration)jobConf);
        for (Path p : new Path[]{new Path(this.getAppPath(), archive), rootArchive}) {
            boolean found3 = false;
            for (URI c : archivesInCache) {
                if (found3 || !p.toUri().getPath().equals(c.getPath())) continue;
                found3 = true;
            }
            TestJavaActionExecutor.assertTrue((String)("archive " + p.toUri().getPath() + " not found in cache"), (boolean)found3);
        }
    }

    public void testCommaSeparatedFilesAndArchives() throws Exception {
        boolean found;
        Path root = new Path(this.getFsTestCaseDir(), "root");
        Path jar = new Path("jar.jar");
        this.getFileSystem().create(new Path(this.getAppPath(), jar)).close();
        Path rootJar = new Path(root, "rootJar.jar");
        this.getFileSystem().create(rootJar).close();
        Path file = new Path("file");
        this.getFileSystem().create(new Path(this.getAppPath(), file)).close();
        Path rootFile = new Path(root, "rootFile");
        this.getFileSystem().create(rootFile).close();
        Path so = new Path("soFile.so");
        this.getFileSystem().create(new Path(this.getAppPath(), so)).close();
        Path rootSo = new Path(root, "rootSoFile.so");
        this.getFileSystem().create(rootSo).close();
        Path so1 = new Path("soFile.so.1");
        this.getFileSystem().create(new Path(this.getAppPath(), so1)).close();
        Path rootSo1 = new Path(root, "rootSoFile.so.1");
        this.getFileSystem().create(rootSo1).close();
        Path archive = new Path("archive.tar");
        this.getFileSystem().create(new Path(this.getAppPath(), archive)).close();
        Path rootArchive = new Path(root, "rootArchive.tar");
        this.getFileSystem().create(rootArchive).close();
        String actionXml = "<java>      <job-tracker>" + this.getJobTrackerUri() + "</job-tracker>      <name-node>" + this.getNameNodeUri() + "</name-node>      <main-class>CLASS</main-class>      <file>" + jar.toString() + "," + rootJar.toString() + "," + file.toString() + ", " + rootFile.toString() + "  ," + so.toString() + "," + rootSo.toString() + "," + so1.toString() + "," + rootSo1.toString() + "</file>\n      <archive>" + archive.toString() + ", " + rootArchive.toString() + " </archive>\n</java>";
        Element eActionXml = XmlUtils.parseXml((String)actionXml);
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        Path appPath = this.getAppPath();
        JavaActionExecutor ae = new JavaActionExecutor();
        Configuration jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        ae.setupActionConf(jobConf, (ActionExecutor.Context)context, eActionXml, appPath);
        ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, appPath, jobConf);
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)jobConf));
        Path[] filesInClasspath = DistributedCache.getFileClassPaths((Configuration)jobConf);
        for (Path p : new Path[]{new Path(this.getAppPath(), jar), rootJar}) {
            found = false;
            for (Path c : filesInClasspath) {
                if (found || !p.toUri().getPath().equals(c.toUri().getPath())) continue;
                found = true;
            }
            TestJavaActionExecutor.assertTrue((String)("file " + p.toUri().getPath() + " not found in classpath"), (boolean)found);
        }
        for (Path p : new Path[]{new Path(this.getAppPath(), file), rootFile, new Path(this.getAppPath(), so), rootSo, new Path(this.getAppPath(), so1), rootSo1}) {
            found = false;
            for (Path c : filesInClasspath) {
                if (found || !p.toUri().getPath().equals(c.toUri().getPath())) continue;
                found = true;
            }
            TestJavaActionExecutor.assertFalse((String)("file " + p.toUri().getPath() + " found in classpath"), (boolean)found);
        }
        URI[] filesInCache = DistributedCache.getCacheFiles((Configuration)jobConf);
        for (Path p : new Path[]{new Path(this.getAppPath(), jar), rootJar, new Path(this.getAppPath(), file), rootFile, new Path(this.getAppPath(), so), rootSo, new Path(this.getAppPath(), so1), rootSo1}) {
            boolean found2 = false;
            for (URI c : filesInCache) {
                if (found2 || !p.toUri().getPath().equals(c.getPath())) continue;
                found2 = true;
            }
            TestJavaActionExecutor.assertTrue((String)("file " + p.toUri().getPath() + " not found in cache"), (boolean)found2);
        }
        URI[] archivesInCache = DistributedCache.getCacheArchives((Configuration)jobConf);
        for (Path p : new Path[]{new Path(this.getAppPath(), archive), rootArchive}) {
            boolean found3 = false;
            for (URI c : archivesInCache) {
                if (found3 || !p.toUri().getPath().equals(c.getPath())) continue;
                found3 = true;
            }
            TestJavaActionExecutor.assertTrue((String)("archive " + p.toUri().getPath() + " not found in cache"), (boolean)found3);
        }
    }

    public void testPrepare() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path mkdir = new Path(this.getFsTestCaseDir(), "mkdir");
        Path delete = new Path(this.getFsTestCaseDir(), "delete");
        fs.mkdirs(delete);
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><prepare><mkdir path='" + mkdir + "'/><delete path='" + delete + "'/></prepare><configuration><property><name>dfs.umaskmode</name><value>026</value></property><property><name>fs.hdfs.impl.disable.cache</name><value>true</value></property></configuration><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        String runningJob = this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(runningJob);
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((String)"SUCCEEDED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)context.getAction().getStatus());
        TestJavaActionExecutor.assertTrue((boolean)fs.exists(mkdir));
        TestJavaActionExecutor.assertEquals((String)"rwxr-x--x", (String)fs.getFileStatus(mkdir).getPermission().toString());
        TestJavaActionExecutor.assertFalse((boolean)fs.exists(delete));
    }

    public void testCredentialsModule() throws Exception {
        String actionXml = "<workflow-app xmlns='uri:oozie:workflow:0.2.5' name='pig-wf'><credentials><credential name='abcname' type='abc'><property><name>property1</name><value>value1</value></property><property><name>property2</name><value>value2</value></property><property><name>${property3}</name><value>${value3}</value></property></credential></credentials><start to='pig1' /><action name='pig1' cred='abcname'><pig></pig><ok to='end' /><error to='fail' /></action><kill name='fail'><message>Pig failed, error message[${wf:errorMessage(wf:lastErrorNode())}]</message></kill><end name='end' /></workflow-app>";
        JavaActionExecutor ae = new JavaActionExecutor();
        WorkflowJobBean wfBean = this.addRecordToWfJobTable("test1", actionXml);
        WorkflowActionBean action = (WorkflowActionBean)wfBean.getActions().get(0);
        action.setType(ae.getType());
        action.setCred("abcname");
        String actionxml = "<pig><job-tracker>${jobTracker}</job-tracker><name-node>${nameNode}</name-node><prepare><delete path='outputdir' /></prepare><configuration><property><name>mapred.compress.map.output</name><value>true</value></property><property><name>mapred.job.queue.name</name><value>${queueName}</value></property></configuration><script>org/apache/oozie/examples/pig/id.pig</script><param>INPUT=${inputDir}</param><param>OUTPUT=${outputDir}/pig-output</param></pig>";
        action.setConf(actionxml);
        ActionExecutorTestCase.Context context = new ActionExecutorTestCase.Context(this, wfBean, action);
        Element actionXmlconf = XmlUtils.parseXml((String)action.getConf());
        Configuration actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXmlconf);
        Map credProperties = ae.setCredentialPropertyToActionConf((ActionExecutor.Context)context, (WorkflowAction)action, actionConf);
        TestJavaActionExecutor.assertNotNull((Object)credProperties);
        CredentialsProperties prop = (CredentialsProperties)credProperties.get("abcname");
        TestJavaActionExecutor.assertEquals((String)"value1", (String)((String)prop.getProperties().get("property1")));
        TestJavaActionExecutor.assertEquals((String)"value2", (String)((String)prop.getProperties().get("property2")));
        TestJavaActionExecutor.assertEquals((String)"val3", (String)((String)prop.getProperties().get("prop3")));
        CredentialsProviderFactory.destroy();
        JobConf credentialsConf = new JobConf();
        Credentials credentials = new Credentials();
        Configuration launcherConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXmlconf);
        XConfiguration.copy((Configuration)launcherConf, (Configuration)credentialsConf);
        try {
            ae.setCredentialTokens(credentials, (Configuration)credentialsConf, (ActionExecutor.Context)context, (WorkflowAction)action, credProperties);
            TestJavaActionExecutor.fail((String)"Should have gotten an exception but did not");
        }
        catch (ActionExecutorException aee) {
            TestJavaActionExecutor.assertEquals((String)"JA020", (String)aee.getErrorCode());
            TestJavaActionExecutor.assertTrue((boolean)aee.getMessage().contains("type [abc]"));
            TestJavaActionExecutor.assertTrue((boolean)aee.getMessage().contains("name [abcname]"));
        }
        CredentialsProviderFactory.destroy();
        ConfigurationService.set((String)"oozie.credentials.credentialclasses", (String)"abc=org.apache.oozie.action.hadoop.InsertTestToken");
        credentialsConf = new JobConf();
        credentials = new Credentials();
        launcherConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXmlconf);
        XConfiguration.copy((Configuration)launcherConf, (Configuration)credentialsConf);
        ae.setCredentialTokens(credentials, (Configuration)credentialsConf, (ActionExecutor.Context)context, (WorkflowAction)action, credProperties);
        Token tk = credentials.getToken(new Text("ABC Token"));
        TestJavaActionExecutor.assertNotNull((Object)tk);
        byte[] secKey = credentials.getSecretKey(new Text(InsertTestToken.DUMMY_SECRET_KEY));
        TestJavaActionExecutor.assertNotNull((Object)secKey);
        TestJavaActionExecutor.assertEquals((String)InsertTestToken.DUMMY_SECRET_KEY, (String)new String(secKey, "UTF-8"));
    }

    public void testCredentialsInvalid() throws Exception {
        String workflowXml = "<workflow-app xmlns='uri:oozie:workflow:0.2.5' name='pig-wf'><credentials><credential name='abcname' type='abc'><property><name>property1</name><value>value1</value></property><property><name>property2</name><value>value2</value></property><property><name>${property3}</name><value>${value3}</value></property></credential></credentials><start to='pig1' /><action name='pig1' cred='abcname'><pig></pig><ok to='end' /><error to='fail' /></action><kill name='fail'><message>Pig failed, error message[${wf:errorMessage(wf:lastErrorNode())}]</message></kill><end name='end' /></workflow-app>";
        JavaActionExecutor ae = new JavaActionExecutor();
        WorkflowJobBean wfBean = this.addRecordToWfJobTable("test1", workflowXml);
        WorkflowActionBean action = (WorkflowActionBean)wfBean.getActions().get(0);
        action.setType(ae.getType());
        action.setCred("invalidabcname");
        String actionXml = "<pig><job-tracker>${jobTracker}</job-tracker><name-node>${nameNode}</name-node><prepare><delete path='outputdir' /></prepare><configuration><property><name>mapred.compress.map.output</name><value>true</value></property><property><name>mapred.job.queue.name</name><value>${queueName}</value></property></configuration><script>org/apache/oozie/examples/pig/id.pig</script><param>INPUT=${inputDir}</param><param>OUTPUT=${outputDir}/pig-output</param></pig>";
        action.setConf(actionXml);
        ActionExecutorTestCase.Context context = new ActionExecutorTestCase.Context(this, wfBean, action);
        Element actionXmlconf = XmlUtils.parseXml((String)action.getConf());
        Configuration actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXmlconf);
        try {
            ae.setCredentialPropertyToActionConf((ActionExecutor.Context)context, (WorkflowAction)action, actionConf);
        }
        catch (ActionExecutorException e) {
            TestJavaActionExecutor.assertEquals((String)e.getErrorCode(), (String)"JA021");
        }
    }

    public void testCredentialsWithoutCredTag() throws Exception {
        String workflowXml = "<workflow-app xmlns='uri:oozie:workflow:0.2.5' name='pig-wf'><credentials><credential name='abcname' type='abc'><property><name>property1</name><value>value1</value></property><property><name>property2</name><value>value2</value></property><property><name>${property3}</name><value>${value3}</value></property></credential></credentials><start to='pig1' /><action name='pig1'><pig></pig><ok to='end' /><error to='fail' /></action><kill name='fail'><message>Pig failed, error message[${wf:errorMessage(wf:lastErrorNode())}]</message></kill><end name='end' /></workflow-app>";
        JavaActionExecutor ae = new JavaActionExecutor();
        WorkflowJobBean wfBean = this.addRecordToWfJobTable("test1", workflowXml);
        WorkflowActionBean action = (WorkflowActionBean)wfBean.getActions().get(0);
        action.setType(ae.getType());
        String actionXml = "<pig><job-tracker>${jobTracker}</job-tracker><name-node>${nameNode}</name-node><prepare><delete path='outputdir' /></prepare><configuration><property><name>mapred.compress.map.output</name><value>true</value></property><property><name>mapred.job.queue.name</name><value>${queueName}</value></property></configuration><script>org/apache/oozie/examples/pig/id.pig</script><param>INPUT=${inputDir}</param><param>OUTPUT=${outputDir}/pig-output</param></pig>";
        action.setConf(actionXml);
        ActionExecutorTestCase.Context context = new ActionExecutorTestCase.Context(this, wfBean, action);
        Element actionXmlconf = XmlUtils.parseXml((String)action.getConf());
        Configuration actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXmlconf);
        ae.setCredentialPropertyToActionConf((ActionExecutor.Context)context, (WorkflowAction)action, actionConf);
    }

    public void testCredentialsSkip() throws Exception {
        this._testCredentialsSkip(false, null, null, true);
        this._testCredentialsSkip(false, null, "false", true);
        this._testCredentialsSkip(false, null, "true", false);
        this._testCredentialsSkip(false, "false", null, true);
        this._testCredentialsSkip(false, "false", "false", true);
        this._testCredentialsSkip(false, "false", "true", false);
        this._testCredentialsSkip(false, "true", null, false);
        this._testCredentialsSkip(false, "true", "false", true);
        this._testCredentialsSkip(false, "true", "true", false);
        this._testCredentialsSkip(true, null, null, false);
        this._testCredentialsSkip(true, null, "false", true);
        this._testCredentialsSkip(true, null, "true", false);
        this._testCredentialsSkip(true, "false", null, true);
        this._testCredentialsSkip(true, "false", "false", true);
        this._testCredentialsSkip(true, "false", "true", false);
        this._testCredentialsSkip(true, "true", null, false);
        this._testCredentialsSkip(true, "true", "false", true);
        this._testCredentialsSkip(true, "true", "true", false);
    }

    private void _testCredentialsSkip(boolean skipSite, String skipJob, String skipAction, boolean expectingTokens) throws Exception {
        String actionLevelSkipConf = skipAction == null ? "" : "<property><name>oozie.credentials.skip</name><value>" + skipAction + "</value></property>";
        String actionxml = "<pig><job-tracker>${jobTracker}</job-tracker><name-node>${nameNode}</name-node><prepare><delete path='outputdir' /></prepare><configuration><property><name>mapred.compress.map.output</name><value>true</value></property><property><name>mapred.job.queue.name</name><value>${queueName}</value></property>" + actionLevelSkipConf + "</configuration><script>org/apache/oozie/examples/pig/id.pig</script><param>INPUT=${inputDir}</param><param>OUTPUT=${outputDir}/pig-output</param></pig>";
        String workflowXml = "<workflow-app xmlns='uri:oozie:workflow:0.2.5' name='pig-wf'><credentials><credential name='abcname' type='abc'><property><name>property1</name><value>value1</value></property><property><name>property2</name><value>value2</value></property><property><name>${property3}</name><value>${value3}</value></property></credential></credentials><start to='pig1' /><action name='pig1' cred='abcname'>" + actionxml + "<ok to='end' /><error to='fail' /></action><kill name='fail'><message>Pig failed, error message[${wf:errorMessage(wf:lastErrorNode())}]</message></kill><end name='end' /></workflow-app>";
        JavaActionExecutor ae = new JavaActionExecutor();
        WorkflowJobBean wfBean = this.addRecordToWfJobTable("test1", workflowXml, skipJob == null ? null : Collections.singletonMap("oozie.credentials.skip", skipJob));
        WorkflowActionBean action = (WorkflowActionBean)wfBean.getActions().get(0);
        action.setType(ae.getType());
        action.setCred("abcname");
        action.setConf(actionxml);
        ActionExecutorTestCase.Context context = new ActionExecutorTestCase.Context(this, wfBean, action);
        Element actionXmlconf = XmlUtils.parseXml((String)action.getConf());
        Configuration actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXmlconf);
        actionConf = ae.setupActionConf(actionConf, (ActionExecutor.Context)context, actionXmlconf, new Path("/tmp/foo"));
        ConfigurationService.set((String)"oozie.credentials.credentialclasses", (String)"abc=org.apache.oozie.action.hadoop.InsertTestToken");
        ConfigurationService.setBoolean((String)"oozie.credentials.skip", (boolean)skipSite);
        Map credProperties = ae.setCredentialPropertyToActionConf((ActionExecutor.Context)context, (WorkflowAction)action, actionConf);
        JobConf credentialsConf = new JobConf();
        Credentials credentials = new Credentials();
        Configuration launcherConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXmlconf);
        XConfiguration.copy((Configuration)launcherConf, (Configuration)credentialsConf);
        ae.setCredentialTokens(credentials, (Configuration)credentialsConf, (ActionExecutor.Context)context, (WorkflowAction)action, credProperties);
        Token tk = credentials.getToken(new Text("ABC Token"));
        if (expectingTokens) {
            TestJavaActionExecutor.assertNotNull((Object)tk);
        } else {
            TestJavaActionExecutor.assertNull((Object)tk);
        }
    }

    private WorkflowJobBean addRecordToWfJobTable(String wfId, String wfxml) throws Exception {
        return this.addRecordToWfJobTable(wfId, wfxml, null);
    }

    private WorkflowJobBean addRecordToWfJobTable(String wfId, String wfxml, Map<String, String> otherProps) throws Exception {
        LiteWorkflowApp app = new LiteWorkflowApp("testApp", wfxml, new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "start")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        Configuration conf = this.getHadoopAccessorService().createConfiguration(new URI(this.getNameNodeUri()).getAuthority());
        conf.set("oozie.wf.application.path", this.getNameNodeUri() + "/testPath");
        conf.set("oozie.wf.log.token", "testToken");
        conf.set("user.name", TestJavaActionExecutor.getTestUser());
        conf.set("property3", "prop3");
        conf.set("value3", "val3");
        if (otherProps != null) {
            for (Map.Entry<String, String> ent : otherProps.entrySet()) {
                conf.set(ent.getKey(), ent.getValue());
            }
        }
        WorkflowJobBean wfBean = this.createWorkflow((WorkflowApp)app, conf, "auth");
        wfBean.setId(wfId);
        wfBean.setStatus(WorkflowJob.Status.SUCCEEDED);
        WorkflowActionBean action = new WorkflowActionBean();
        action.setName("test");
        action.setId(((UUIDService)Services.get().get(UUIDService.class)).generateChildId(wfBean.getId(), "test"));
        wfBean.getActions().add(action);
        return wfBean;
    }

    private WorkflowJobBean createWorkflow(WorkflowApp app, Configuration conf, String authToken) throws Exception {
        WorkflowAppService wps = (WorkflowAppService)Services.get().get(WorkflowAppService.class);
        XConfiguration protoActionConf = wps.createProtoActionConf(conf, true);
        WorkflowLib workflowLib = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).getWorkflowLibWithNoDB();
        WorkflowInstance wfInstance = workflowLib.createInstance(app, conf);
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setId(wfInstance.getId());
        workflow.setAppName(app.getName());
        workflow.setAppPath(conf.get("oozie.wf.application.path"));
        workflow.setConf(XmlUtils.prettyPrint((Configuration)conf).toString());
        workflow.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoActionConf).toString());
        workflow.setCreatedTime(new Date());
        workflow.setLogToken(conf.get("oozie.wf.log.token", ""));
        workflow.setStatus(WorkflowJob.Status.PREP);
        workflow.setRun(0);
        workflow.setUser(conf.get("user.name"));
        workflow.setGroup(conf.get("group.name"));
        workflow.setWorkflowInstance(wfInstance);
        return workflow;
    }

    public void testActionSharelibResolution() throws Exception {
        JavaActionExecutor ae = new JavaActionExecutor(){

            protected String getDefaultShareLibName(Element actionXml) {
                return "java-action-executor";
            }
        };
        WorkflowJobBean wfBean = new WorkflowJobBean();
        String jobConf = "<configuration/>";
        wfBean.setConf(jobConf);
        WorkflowActionBean action = new WorkflowActionBean();
        ActionExecutorTestCase.Context context = new ActionExecutorTestCase.Context(this, wfBean, action);
        XConfiguration actionConf = new XConfiguration();
        Assert.assertArrayEquals((Object[])new String[]{"java-action-executor"}, (Object[])ae.getShareLibNames((ActionExecutor.Context)context, new Element("java"), (Configuration)actionConf));
        ConfigurationService.set((String)"oozie.action.sharelib.for.java", (String)"java-oozie-conf");
        Assert.assertArrayEquals((Object[])new String[]{"java-oozie-conf"}, (Object[])ae.getShareLibNames((ActionExecutor.Context)context, new Element("java"), (Configuration)actionConf));
        jobConf = "<configuration><property><name>oozie.action.sharelib.for.java</name><value>java-job-conf</value></property></configuration>";
        wfBean.setConf(jobConf);
        ae = new JavaActionExecutor(){

            protected String getDefaultShareLibName(Element actionXml) {
                return "java-action-executor";
            }
        };
        Assert.assertArrayEquals((Object[])new String[]{"java-job-conf"}, (Object[])ae.getShareLibNames((ActionExecutor.Context)context, new Element("java"), (Configuration)actionConf));
        actionConf.set("oozie.action.sharelib.for.java", "java-action-conf");
        Assert.assertArrayEquals((Object[])new String[]{"java-action-conf"}, (Object[])ae.getShareLibNames((ActionExecutor.Context)context, new Element("java"), (Configuration)actionConf));
    }

    public void testJavaOpts() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>oozie.launcher.a</name><value>LA</value></property><property><name>a</name><value>AA</value></property><property><name>b</name><value>BB</value></property></configuration><main-class>MAIN-CLASS</main-class><java-opts>JAVA-OPT1 JAVA-OPT2</java-opts><arg>A1</arg><arg>A2</arg><file>f.jar</file><archive>a.tar</archive></java>";
        JavaActionExecutor ae = new JavaActionExecutor();
        WorkflowJobBean wfBean = this.addRecordToWfJobTable("test1", actionXml);
        WorkflowActionBean action = (WorkflowActionBean)wfBean.getActions().get(0);
        action.setType(ae.getType());
        action.setConf(actionXml);
        ActionExecutorTestCase.Context context = new ActionExecutorTestCase.Context(this, wfBean, action);
        Element actionXmlconf = XmlUtils.parseXml((String)action.getConf());
        Configuration actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXmlconf);
        Configuration conf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, actionXmlconf, actionConf);
        TestJavaActionExecutor.assertEquals((String)"-Xmx200m JAVA-OPT1 JAVA-OPT2", (String)conf.get(MAPRED_CHILD_JAVA_OPTS));
        TestJavaActionExecutor.assertEquals((String)"-Xmx200m JAVA-OPT1 JAVA-OPT2", (String)conf.get(MAPREDUCE_MAP_JAVA_OPTS));
        actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>oozie.launcher.a</name><value>LA</value></property><property><name>a</name><value>AA</value></property><property><name>b</name><value>BB</value></property></configuration><main-class>MAIN-CLASS</main-class><java-opt>JAVA-OPT1</java-opt><java-opt>JAVA-OPT2</java-opt><arg>A1</arg><arg>A2</arg><file>f.jar</file><archive>a.tar</archive></java>";
        wfBean = this.addRecordToWfJobTable("test1", actionXml);
        action = (WorkflowActionBean)wfBean.getActions().get(0);
        action.setType(ae.getType());
        action.setConf(actionXml);
        context = new ActionExecutorTestCase.Context(this, wfBean, action);
        actionXmlconf = XmlUtils.parseXml((String)action.getConf());
        actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXmlconf);
        conf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, actionXmlconf, actionConf);
        TestJavaActionExecutor.assertEquals((String)"-Xmx200m JAVA-OPT1 JAVA-OPT2", (String)conf.get(MAPRED_CHILD_JAVA_OPTS));
        TestJavaActionExecutor.assertEquals((String)"-Xmx200m JAVA-OPT1 JAVA-OPT2", (String)conf.get(MAPREDUCE_MAP_JAVA_OPTS));
        actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>oozie.launcher.a</name><value>LA</value></property><property><name>a</name><value>AA</value></property><property><name>b</name><value>BB</value></property><property><name>oozie.launcher.mapred.child.java.opts</name><value>JAVA-OPT3</value></property></configuration><main-class>MAIN-CLASS</main-class><java-opt>JAVA-OPT1</java-opt><java-opt>JAVA-OPT2</java-opt><arg>A1</arg><arg>A2</arg><file>f.jar</file><archive>a.tar</archive></java>";
        wfBean = this.addRecordToWfJobTable("test1", actionXml);
        action = (WorkflowActionBean)wfBean.getActions().get(0);
        action.setType(ae.getType());
        action.setConf(actionXml);
        context = new ActionExecutorTestCase.Context(this, wfBean, action);
        actionXmlconf = XmlUtils.parseXml((String)action.getConf());
        actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXmlconf);
        conf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, actionXmlconf, actionConf);
        TestJavaActionExecutor.assertEquals((String)"JAVA-OPT3 JAVA-OPT1 JAVA-OPT2", (String)conf.get(MAPRED_CHILD_JAVA_OPTS));
        TestJavaActionExecutor.assertEquals((String)"JAVA-OPT3 JAVA-OPT1 JAVA-OPT2", (String)conf.get(MAPREDUCE_MAP_JAVA_OPTS));
        actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>oozie.launcher.a</name><value>LA</value></property><property><name>a</name><value>AA</value></property><property><name>b</name><value>BB</value></property><property><name>oozie.launcher.mapreduce.map.java.opts</name><value>JAVA-OPT3</value></property></configuration><main-class>MAIN-CLASS</main-class><java-opt>JAVA-OPT1</java-opt><java-opt>JAVA-OPT2</java-opt><arg>A1</arg><arg>A2</arg><file>f.jar</file><archive>a.tar</archive></java>";
        wfBean = this.addRecordToWfJobTable("test1", actionXml);
        action = (WorkflowActionBean)wfBean.getActions().get(0);
        action.setType(ae.getType());
        action.setConf(actionXml);
        context = new ActionExecutorTestCase.Context(this, wfBean, action);
        actionXmlconf = XmlUtils.parseXml((String)action.getConf());
        actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXmlconf);
        conf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, actionXmlconf, actionConf);
        TestJavaActionExecutor.assertEquals((String)"-Xmx200m JAVA-OPT3 JAVA-OPT1 JAVA-OPT2", (String)conf.get(MAPRED_CHILD_JAVA_OPTS));
        TestJavaActionExecutor.assertEquals((String)"-Xmx200m JAVA-OPT3 JAVA-OPT1 JAVA-OPT2", (String)conf.get(MAPREDUCE_MAP_JAVA_OPTS));
        actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>oozie.launcher.a</name><value>LA</value></property><property><name>a</name><value>AA</value></property><property><name>b</name><value>BB</value></property><property><name>oozie.launcher.mapred.child.java.opts</name><value>JAVA-OPT3</value></property><property><name>oozie.launcher.mapreduce.map.java.opts</name><value>JAVA-OPT4</value></property></configuration><main-class>MAIN-CLASS</main-class><java-opt>JAVA-OPT1</java-opt><java-opt>JAVA-OPT2</java-opt><arg>A1</arg><arg>A2</arg><file>f.jar</file><archive>a.tar</archive></java>";
        wfBean = this.addRecordToWfJobTable("test1", actionXml);
        action = (WorkflowActionBean)wfBean.getActions().get(0);
        action.setType(ae.getType());
        action.setConf(actionXml);
        context = new ActionExecutorTestCase.Context(this, wfBean, action);
        actionXmlconf = XmlUtils.parseXml((String)action.getConf());
        actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXmlconf);
        conf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, actionXmlconf, actionConf);
        TestJavaActionExecutor.assertEquals((String)"JAVA-OPT3 JAVA-OPT4 JAVA-OPT1 JAVA-OPT2", (String)conf.get(MAPRED_CHILD_JAVA_OPTS));
        TestJavaActionExecutor.assertEquals((String)"JAVA-OPT3 JAVA-OPT4 JAVA-OPT1 JAVA-OPT2", (String)conf.get(MAPREDUCE_MAP_JAVA_OPTS));
    }

    public void testActionLibsPath() throws Exception {
        Path actionLibPath = new Path(this.getFsTestCaseDir(), "actionlibs");
        this.getFileSystem().mkdirs(actionLibPath);
        Path jar1Path = new Path(actionLibPath, "jar1.jar");
        this.getFileSystem().create(jar1Path).close();
        Path jar2Path = new Path(actionLibPath, "jar2.jar");
        this.getFileSystem().create(jar2Path).close();
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>oozie.launcher.oozie.libpath</name><value>" + actionLibPath + "</value></property></configuration><main-class>MAIN-CLASS</main-class></java>";
        Element eActionXml = XmlUtils.parseXml((String)actionXml);
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        JavaActionExecutor ae = new JavaActionExecutor();
        Configuration jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        ae.setupLauncherConf(jobConf, eActionXml, this.getAppPath(), (ActionExecutor.Context)context);
        ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, this.getAppPath(), jobConf);
        Object[] cacheFiles = DistributedCache.getCacheFiles((Configuration)jobConf);
        String cacheFilesStr = Arrays.toString(cacheFiles);
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar1Path.toString()));
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar2Path.toString()));
        Path jar3Path = new Path(this.getFsTestCaseDir(), "jar3.jar");
        this.getFileSystem().create(jar3Path).close();
        actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>oozie.launcher.oozie.libpath</name><value>" + jar3Path + "</value></property></configuration><main-class>MAIN-CLASS</main-class></java>";
        eActionXml = XmlUtils.parseXml((String)actionXml);
        context = this.createContext(actionXml, null);
        ae = new JavaActionExecutor();
        jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        ae.setupLauncherConf(jobConf, eActionXml, this.getAppPath(), (ActionExecutor.Context)context);
        ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, this.getAppPath(), jobConf);
        cacheFiles = DistributedCache.getCacheFiles((Configuration)jobConf);
        cacheFilesStr = Arrays.toString(cacheFiles);
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar3Path.toString()));
        actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>oozie.launcher.oozie.libpath</name><value>" + actionLibPath + "," + jar3Path + "</value></property></configuration><main-class>MAIN-CLASS</main-class></java>";
        eActionXml = XmlUtils.parseXml((String)actionXml);
        context = this.createContext(actionXml, null);
        ae = new JavaActionExecutor();
        jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        ae.setupLauncherConf(jobConf, eActionXml, this.getAppPath(), (ActionExecutor.Context)context);
        ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, this.getAppPath(), jobConf);
        cacheFiles = DistributedCache.getCacheFiles((Configuration)jobConf);
        cacheFilesStr = Arrays.toString(cacheFiles);
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar1Path.toString()));
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar2Path.toString()));
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar3Path.toString()));
    }

    @Test
    public void testAddActionShareLib() throws Exception {
        WorkflowAppService wps = (WorkflowAppService)Services.get().get(WorkflowAppService.class);
        Path systemLibPath = new Path(wps.getSystemLibPath(), "lib_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()).toString());
        Path javaShareLibPath = new Path(systemLibPath, "java");
        this.getFileSystem().mkdirs(javaShareLibPath);
        Path jar1Path = new Path(javaShareLibPath, "jar1.jar");
        this.getFileSystem().create(jar1Path).close();
        Path jar2Path = new Path(javaShareLibPath, "jar2.jar");
        this.getFileSystem().create(jar2Path).close();
        Path hcatShareLibPath = new Path(systemLibPath, "hcat");
        this.getFileSystem().mkdirs(hcatShareLibPath);
        Path jar3Path = new Path(hcatShareLibPath, "jar3.jar");
        this.getFileSystem().create(jar3Path).close();
        Path jar4Path = new Path(hcatShareLibPath, "jar4.jar");
        this.getFileSystem().create(jar4Path).close();
        Path otherShareLibPath = new Path(systemLibPath, "other");
        this.getFileSystem().mkdirs(otherShareLibPath);
        Path jar5Path = new Path(otherShareLibPath, "jar5.jar");
        this.getFileSystem().create(jar5Path).close();
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>MAIN-CLASS</main-class></java>";
        Element eActionXml = XmlUtils.parseXml((String)actionXml);
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        Services.get().setService(ShareLibService.class);
        WorkflowJobBean workflow = (WorkflowJobBean)context.getWorkflow();
        XConfiguration wfConf = new XConfiguration();
        wfConf.set("user.name", TestJavaActionExecutor.getTestUser());
        wfConf.set("oozie.wf.application.path", new Path(this.getAppPath(), "workflow.xml").toString());
        wfConf.setBoolean("oozie.use.system.libpath", true);
        workflow.setConf(XmlUtils.prettyPrint((Configuration)wfConf).toString());
        ConfigurationService.set((String)"oozie.action.sharelib.for.java", (String)"java,hcat");
        JavaActionExecutor ae = new JavaActionExecutor();
        Configuration jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        ae.setupLauncherConf(jobConf, eActionXml, this.getAppPath(), (ActionExecutor.Context)context);
        try {
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, this.getAppPath(), jobConf);
            TestJavaActionExecutor.fail();
        }
        catch (ActionExecutorException aee) {
            TestJavaActionExecutor.assertEquals((String)"EJ001", (String)aee.getErrorCode());
            TestJavaActionExecutor.assertEquals((String)"Could not locate Oozie sharelib", (String)aee.getMessage());
        }
        Path launcherPath = new Path(systemLibPath, "oozie");
        this.getFileSystem().mkdirs(launcherPath);
        Path jar6Path = new Path(launcherPath, "jar6.jar");
        this.getFileSystem().create(jar6Path).close();
        ((ShareLibService)Services.get().get(ShareLibService.class)).updateShareLib();
        ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, this.getAppPath(), jobConf);
        Object[] cacheFiles = DistributedCache.getCacheFiles((Configuration)jobConf);
        String cacheFilesStr = Arrays.toString(cacheFiles);
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar1Path.toString()));
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar2Path.toString()));
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar3Path.toString()));
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar4Path.toString()));
        TestJavaActionExecutor.assertFalse((boolean)cacheFilesStr.contains(jar5Path.toString()));
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar6Path.toString()));
        workflow = (WorkflowJobBean)context.getWorkflow();
        wfConf = new XConfiguration();
        wfConf.set("user.name", TestJavaActionExecutor.getTestUser());
        wfConf.set("oozie.wf.application.path", new Path(this.getAppPath(), "workflow.xml").toString());
        wfConf.setBoolean("oozie.use.system.libpath", true);
        wfConf.set("oozie.action.sharelib.for.java", "other,hcat");
        workflow.setConf(XmlUtils.prettyPrint((Configuration)wfConf).toString());
        ConfigurationService.set((String)"oozie.action.sharelib.for.java", (String)"java");
        ae = new JavaActionExecutor();
        jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        ae.setupLauncherConf(jobConf, eActionXml, this.getAppPath(), (ActionExecutor.Context)context);
        ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, this.getAppPath(), jobConf);
        cacheFiles = DistributedCache.getCacheFiles((Configuration)jobConf);
        cacheFilesStr = Arrays.toString(cacheFiles);
        TestJavaActionExecutor.assertFalse((boolean)cacheFilesStr.contains(jar1Path.toString()));
        TestJavaActionExecutor.assertFalse((boolean)cacheFilesStr.contains(jar2Path.toString()));
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar3Path.toString()));
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar4Path.toString()));
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar5Path.toString()));
        TestJavaActionExecutor.assertTrue((boolean)cacheFilesStr.contains(jar6Path.toString()));
    }

    public void testAddShareLibSchemeAndAuthority() throws Exception {
        JavaActionExecutor ae = new JavaActionExecutor(){

            public String getDefaultShareLibName(Element actionXml) {
                return "java-action-executor";
            }
        };
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNode2Uri() + "</name-node><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        Element eActionXml = XmlUtils.parseXml((String)actionXml);
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        Services.get().destroy();
        this.setSystemProperty("oozie.service.WorkflowAppService.system.libpath", "/user/" + TestJavaActionExecutor.getTestUser() + "/share/");
        new Services().init();
        WorkflowAppService wps = (WorkflowAppService)Services.get().get(WorkflowAppService.class);
        Path systemLibPath = new Path(wps.getSystemLibPath(), "lib_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()).toString());
        Path javaShareLibPath = new Path(systemLibPath, "java-action-executor");
        this.getFileSystem().mkdirs(javaShareLibPath);
        Services.get().setService(ShareLibService.class);
        Configuration conf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        ae.addShareLib(conf, new String[]{"java-action-executor"});
        Services.get().destroy();
        this.setSystemProperty("oozie.service.WorkflowAppService.system.libpath", this.getNameNodeUri() + "/user/" + TestJavaActionExecutor.getTestUser() + "/share/");
        new Services().init();
        Services.get().setService(ShareLibService.class);
        conf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        ae.addShareLib(conf, new String[]{"java-action-executor"});
    }

    public void testFilesystemScheme() throws Exception {
        try {
            String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
            Element eActionXml = XmlUtils.parseXml((String)actionXml);
            ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
            Path appPath = new Path("localfs://namenode:port/mydir");
            JavaActionExecutor ae = new JavaActionExecutor();
            Configuration conf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            Services.get().destroy();
            this.setSystemProperty("oozie.service.HadoopAccessorService.supported.filesystems", "hdfs,viewfs");
            new Services().init();
            ae.setupActionConf(conf, (ActionExecutor.Context)context, eActionXml, appPath);
            TestJavaActionExecutor.fail((String)"Supposed to throw exception due to unsupported fs scheme - localfs");
        }
        catch (ActionExecutorException ae) {
            TestJavaActionExecutor.assertTrue((boolean)ae.getMessage().contains("E0904"));
            TestJavaActionExecutor.assertTrue((boolean)ae.getMessage().contains("Scheme [localfs] not supported"));
        }
    }

    public void testACLDefaults_launcherACLsSetToDefault() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node> <configuration><property><name>mapreduce.job.acl-view-job</name><value>VIEWER</value></property><property><name>mapreduce.job.acl-modify-job</name><value>MODIFIER</value></property></configuration><main-class>MAIN-CLASS</main-class></java>";
        WorkflowJobBean wfBean = this.addRecordToWfJobTable("test1-acl", actionXml);
        WorkflowActionBean action = (WorkflowActionBean)wfBean.getActions().get(0);
        JavaActionExecutor ae = new JavaActionExecutor();
        action.setType(ae.getType());
        ActionExecutorTestCase.Context context = new ActionExecutorTestCase.Context(this, wfBean, action);
        Element eActionXml = XmlUtils.parseXml((String)actionXml);
        Configuration actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        ae.setupActionConf(actionConf, (ActionExecutor.Context)context, eActionXml, this.getAppPath());
        Configuration conf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, eActionXml, actionConf);
        TestJavaActionExecutor.assertEquals((String)"VIEWER", (String)conf.get("mapreduce.job.acl-view-job"));
        TestJavaActionExecutor.assertEquals((String)"MODIFIER", (String)conf.get("mapreduce.job.acl-modify-job"));
    }

    public void testACLDefaults_noFalseChange() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node> <configuration><property><name>oozie.launcher.mapreduce.job.acl-view-job</name><value>V</value></property><property><name>oozie.launcher.mapreduce.job.acl-modify-job</name><value>M</value></property></configuration><main-class>MAIN-CLASS</main-class></java>";
        WorkflowJobBean wfBean = this.addRecordToWfJobTable("test2-acl", actionXml);
        WorkflowActionBean action = (WorkflowActionBean)wfBean.getActions().get(0);
        JavaActionExecutor ae = new JavaActionExecutor();
        action.setType(ae.getType());
        ActionExecutorTestCase.Context context = new ActionExecutorTestCase.Context(this, wfBean, action);
        Element eActionXml = XmlUtils.parseXml((String)actionXml);
        Configuration actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        ae.setupActionConf(actionConf, (ActionExecutor.Context)context, eActionXml, this.getAppPath());
        Configuration conf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, eActionXml, actionConf);
        TestJavaActionExecutor.assertNotNull((Object)conf.get("mapreduce.job.acl-view-job"));
        TestJavaActionExecutor.assertNotNull((Object)conf.get("mapreduce.job.acl-modify-job"));
    }

    public void testACLDefaults_explicitLauncherAndActionSettings() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node> <configuration><property><name>oozie.launcher.mapreduce.job.acl-view-job</name><value>V</value></property><property><name>oozie.launcher.mapreduce.job.acl-modify-job</name><value>M</value></property><property><name>mapreduce.job.acl-view-job</name><value>VIEWER</value></property><property><name>mapreduce.job.acl-modify-job</name><value>MODIFIER</value></property></configuration><main-class>MAIN-CLASS</main-class></java>";
        WorkflowJobBean wfBean = this.addRecordToWfJobTable("test3-acl", actionXml);
        WorkflowActionBean action = (WorkflowActionBean)wfBean.getActions().get(0);
        JavaActionExecutor ae = new JavaActionExecutor();
        action.setType(ae.getType());
        ActionExecutorTestCase.Context context = new ActionExecutorTestCase.Context(this, wfBean, action);
        Element eActionXml = XmlUtils.parseXml((String)actionXml);
        Configuration actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        ae.setupActionConf(actionConf, (ActionExecutor.Context)context, eActionXml, this.getAppPath());
        Configuration conf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, eActionXml, actionConf);
        TestJavaActionExecutor.assertNotSame((Object)conf.get("mapreduce.job.acl-view-job"), (Object)actionConf.get("mapreduce.job.acl-view-job"));
        TestJavaActionExecutor.assertNotSame((Object)conf.get("mapreduce.job.acl-modify-job"), (Object)actionConf.get("mapreduce.job.acl-modify-job"));
    }

    public void testCannotKillActionWhenACLSpecified() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration>  <property><name>oozie.launcher.modify.acl</name><value>dummyuser</value></property></configuration><main-class>" + LauncherMainTester.class.getName() + "</main-class><arg>sleep</arg><arg>10000</arg></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        String applicationId = this.submitAction(context);
        this.waitUntilYarnAppState(applicationId, EnumSet.of(YarnApplicationState.RUNNING));
        WorkflowJobBean wfBean = (WorkflowJobBean)context.getWorkflow();
        wfBean.setUser(TestJavaActionExecutor.getTestUser2());
        JavaActionExecutor jae = new JavaActionExecutor();
        jae.kill((ActionExecutor.Context)context, context.getAction());
        this.waitUntilYarnAppDoneAndAssertSuccess(applicationId);
    }

    public void testParseJobXmlAndConfiguration() throws Exception {
        String str = "<java><job-xml>job1.xml</job-xml><job-xml>job2.xml</job-xml><configuration><property><name>p1</name><value>v1a</value></property><property><name>p2</name><value>v2</value></property></configuration></java>";
        Element xml = XmlUtils.parseXml((String)str);
        Path appPath = new Path(this.getFsTestCaseDir(), "app");
        this.getFileSystem().mkdirs(appPath);
        XConfiguration jConf = new XConfiguration();
        jConf.set("p1", "v1b");
        jConf.set("p3", "v3a");
        FSDataOutputStream os = this.getFileSystem().create(new Path(appPath, "job1.xml"));
        jConf.writeXml((OutputStream)os);
        os.close();
        jConf = new XConfiguration();
        jConf.set("p4", "v4");
        jConf.set("p3", "v3b");
        os = this.getFileSystem().create(new Path(appPath, "job2.xml"));
        jConf.writeXml((OutputStream)os);
        os.close();
        XConfiguration conf = new XConfiguration();
        TestJavaActionExecutor.assertEquals((int)0, (int)conf.size());
        JavaActionExecutor.parseJobXmlAndConfiguration((ActionExecutor.Context)this.createContext("<java/>", null), (Element)xml, (Path)appPath, (Configuration)conf);
        TestJavaActionExecutor.assertEquals((int)4, (int)conf.size());
        TestJavaActionExecutor.assertEquals((String)"v1a", (String)conf.get("p1"));
        TestJavaActionExecutor.assertEquals((String)"v2", (String)conf.get("p2"));
        TestJavaActionExecutor.assertEquals((String)"v3b", (String)conf.get("p3"));
        TestJavaActionExecutor.assertEquals((String)"v4", (String)conf.get("p4"));
    }

    public void testParseJobXmlAndConfigurationWithELExpression() throws Exception {
        String str = "<java><job-xml>job1.xml</job-xml><job-xml>job2.xml</job-xml><configuration><property><name>p1</name><value>v1a</value></property><property><name>p2</name><value>v2</value></property></configuration></java>";
        Element xml = XmlUtils.parseXml((String)str);
        Path appPath = new Path(this.getFsTestCaseDir(), "app");
        this.getFileSystem().mkdirs(appPath);
        XConfiguration jConf = new XConfiguration();
        jConf.set("p3", "${v3}");
        jConf.set("p4", "${v4}");
        jConf.set("user", "${wf:user()}");
        FSDataOutputStream os = this.getFileSystem().create(new Path(appPath, "job1.xml"));
        jConf.writeXml((OutputStream)os);
        os.close();
        jConf = new XConfiguration();
        jConf.set("p5", "v5");
        jConf.set("p6", "v6");
        os = this.getFileSystem().create(new Path(appPath, "job2.xml"));
        jConf.writeXml((OutputStream)os);
        os.close();
        XConfiguration conf = new XConfiguration();
        TestJavaActionExecutor.assertEquals((int)0, (int)conf.size());
        JavaActionExecutor.parseJobXmlAndConfiguration((ActionExecutor.Context)this.createContext("<configuration><property><name>v3</name><value>v3a</value></property><property><name>v4</name><value>v4a</value></property></configuration>", null), (Element)xml, (Path)appPath, (Configuration)conf);
        TestJavaActionExecutor.assertEquals((int)7, (int)conf.size());
        TestJavaActionExecutor.assertEquals((String)"v1a", (String)conf.get("p1"));
        TestJavaActionExecutor.assertEquals((String)"v2", (String)conf.get("p2"));
        TestJavaActionExecutor.assertEquals((String)"v3a", (String)conf.get("p3"));
        TestJavaActionExecutor.assertEquals((String)"v4a", (String)conf.get("p4"));
        TestJavaActionExecutor.assertEquals((String)"v5", (String)conf.get("p5"));
        TestJavaActionExecutor.assertEquals((String)"v6", (String)conf.get("p6"));
        TestJavaActionExecutor.assertEquals((String)"test", (String)conf.get("user"));
    }

    public void testJobXmlWithOozieLauncher() throws Exception {
        String str = "<java><job-xml>job.xml</job-xml><configuration><property><name>oozie.launcher.p2</name><value>v2b</value></property><property><name>p4</name><value>v4</value></property></configuration></java>";
        Element xml = XmlUtils.parseXml((String)str);
        Path appPath = new Path(this.getFsTestCaseDir(), "app");
        this.getFileSystem().mkdirs(appPath);
        XConfiguration jConf = new XConfiguration();
        jConf.set("oozie.launcher.p1", "v1");
        jConf.set("oozie.launcher.p2", "v2a");
        jConf.set("p3", "v3");
        FSDataOutputStream os = this.getFileSystem().create(new Path(appPath, "job.xml"));
        jConf.writeXml((OutputStream)os);
        os.close();
        XConfiguration conf = new XConfiguration();
        TestJavaActionExecutor.assertEquals((int)0, (int)conf.size());
        JavaActionExecutor jae = new JavaActionExecutor("java");
        jae.setupLauncherConf((Configuration)conf, xml, appPath, (ActionExecutor.Context)this.createContext("<java/>", null));
        TestJavaActionExecutor.assertEquals((int)4, (int)conf.size());
        TestJavaActionExecutor.assertEquals((String)"v1", (String)conf.get("oozie.launcher.p1"));
        TestJavaActionExecutor.assertEquals((String)"v1", (String)conf.get("p1"));
        TestJavaActionExecutor.assertEquals((String)"v2b", (String)conf.get("oozie.launcher.p2"));
        TestJavaActionExecutor.assertEquals((String)"v2b", (String)conf.get("p2"));
    }

    public void testUpdateConfForTimeLineServiceEnabled() throws Exception {
        Element actionXml = XmlUtils.parseXml((String)("<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>MAIN-CLASS</main-class></java>"));
        JavaActionExecutor ae = new JavaActionExecutor();
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestJavaActionExecutor.getTestUser());
        WorkflowJobBean wf = this.createBaseWorkflow(protoConf, "action");
        WorkflowActionBean action = (WorkflowActionBean)wf.getActions().get(0);
        action.setType(ae.getType());
        ActionExecutorTestCase.Context context = new ActionExecutorTestCase.Context(this, wf, action);
        JobConf actionConf = new JobConf();
        Configuration launcherConf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, actionXml, (Configuration)actionConf);
        TestJavaActionExecutor.assertEquals((String)"false", (String)launcherConf.get("yarn.timeline-service.enabled"));
        ConfigurationService.set((String)"oozie.action.launcher.yarn.timeline-service.enabled", (String)"true");
        launcherConf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, actionXml, (Configuration)actionConf);
        TestJavaActionExecutor.assertEquals((String)"false", (String)launcherConf.get("yarn.timeline-service.enabled"));
        Path tezSite = new Path("/tmp/tez-site.xml");
        FSDataOutputStream out = this.getFileSystem().create(tezSite);
        out.close();
        Element actionXmlWithTez = XmlUtils.parseXml((String)("<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>MAIN-CLASS</main-class><file>" + tezSite + "</file></java>"));
        launcherConf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, actionXmlWithTez, (Configuration)actionConf);
        TestJavaActionExecutor.assertTrue((boolean)launcherConf.getBoolean("yarn.timeline-service.enabled", false));
        Element actionXmlATSDisabled = XmlUtils.parseXml((String)("<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>oozie.launcher.yarn.timeline-service.enabled</name><value>false</value></property></configuration><main-class>MAIN-CLASS</main-class><file>" + tezSite + "</file></java>"));
        actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXmlATSDisabled);
        ae.setupActionConf((Configuration)actionConf, (ActionExecutor.Context)context, actionXmlATSDisabled, new Path("hdfs:///tmp/workflow"));
        launcherConf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, actionXmlATSDisabled, (Configuration)actionConf);
        TestJavaActionExecutor.assertFalse((boolean)launcherConf.getBoolean("yarn.timeline-service.enabled", false));
        this.getFileSystem().delete(tezSite, true);
    }

    public void testAddToCache() throws Exception {
        JavaActionExecutor ae = new JavaActionExecutor();
        XConfiguration conf = new XConfiguration();
        Path appPath = new Path(this.getFsTestCaseDir(), "wf");
        URI appUri = appPath.toUri();
        Path archivePath = new Path("test.jar");
        Path archiveFullPath = new Path(appPath, archivePath);
        ae.addToCache((Configuration)conf, appPath, archiveFullPath.toString(), true);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.archives").contains(archiveFullPath.toString()));
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
        Path archiveFragmentPath = new Path("test.jar#a.jar");
        Path archiveFragmentFullPath = new Path(appPath, archiveFragmentPath);
        conf.clear();
        ae.addToCache((Configuration)conf, appPath, archiveFragmentFullPath.toString(), true);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.archives").contains(archiveFragmentFullPath.toString()));
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
        Path appSoPath = new Path("lib/a.so");
        Path appSoFullPath = new Path(appPath, appSoPath);
        conf.clear();
        ae.addToCache((Configuration)conf, appPath, appSoFullPath.toString(), false);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.files").contains(appSoFullPath.toString()));
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
        Path appSoFragmentPath = new Path("lib/a.so#a.so");
        Path appSoFragmentFullPath = new Path(appPath, appSoFragmentPath);
        conf.clear();
        ae.addToCache((Configuration)conf, appPath, appSoFragmentFullPath.toString(), false);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.files").contains(appSoFragmentFullPath.toString()));
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
        Path appJarPath = new Path("lib/a.jar");
        Path appJarFullPath = new Path(appPath, appJarPath);
        conf = new Configuration();
        conf.set("user.name", TestJavaActionExecutor.getTestUser());
        ae.addToCache((Configuration)conf, appPath, appJarFullPath.toString(), false);
        Path jarPath = new Path(appJarFullPath.toUri());
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.files").contains(jarPath.toString()));
        Path[] paths = DistributedCache.getFileClassPaths((Configuration)conf);
        boolean pathFound = false;
        for (Path path : paths) {
            if (!path.equals((Object)jarPath)) continue;
            pathFound = true;
            break;
        }
        TestJavaActionExecutor.assertTrue((boolean)pathFound);
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
        appJarPath = new Path("lib/a.jar");
        appJarFullPath = new Path(appPath, appJarPath);
        Path appDifferentClusterPath = new Path(new URI(appUri.getScheme(), null, appUri.getHost() + "x", appUri.getPort(), appUri.getPath(), appUri.getQuery(), appUri.getFragment()));
        conf.clear();
        conf.set("user.name", TestJavaActionExecutor.getTestUser());
        ae.addToCache((Configuration)conf, appDifferentClusterPath, appJarFullPath.toString(), false);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.files").contains(appJarFullPath.toString()));
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
        Path appJarFragmentPath = new Path("lib/a.jar#a.jar");
        Path appJarFragmentFullPath = new Path(appPath, appJarFragmentPath);
        conf.clear();
        conf.set("user.name", TestJavaActionExecutor.getTestUser());
        ae.addToCache((Configuration)conf, appPath, appJarFragmentFullPath.toString(), false);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.files").contains(appJarFragmentFullPath.toString()));
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
        Path appFilePath = new Path("lib/a.txt");
        Path appFileFullPath = new Path(appPath, appFilePath);
        conf.clear();
        ae.addToCache((Configuration)conf, appPath, appFileFullPath.toString(), false);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.files").contains(appFileFullPath.toString()));
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
        Path appFileFragmentPath = new Path("lib/a.txt#a.txt");
        Path appFileFragmentFullPath = new Path(appPath, appFileFragmentPath);
        conf.clear();
        ae.addToCache((Configuration)conf, appPath, appFileFragmentFullPath.toString(), false);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.files").contains(appFileFragmentFullPath.toString()));
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
        Path testPath = new Path("/tmp/testpath/a.jar#a.jar");
        conf.clear();
        ae.addToCache((Configuration)conf, appPath, testPath.toString(), true);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.archives").contains(testPath.toString()));
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
        conf.clear();
        ae.addToCache((Configuration)conf, appPath, testPath.toString(), false);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.files").contains(testPath.toString()));
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
        Path testAbsolutePath = new Path("hftp://namenode.test.com:8020/tmp/testpath/a.jar#a.jar");
        conf.clear();
        ae.addToCache((Configuration)conf, appPath, testAbsolutePath.toString(), true);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.archives").contains(testAbsolutePath.toString()));
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
        conf.clear();
        ae.addToCache((Configuration)conf, appPath, testAbsolutePath.toString(), false);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.files").contains(testAbsolutePath.toString()));
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
        conf.clear();
        ae.addToCache((Configuration)conf, appPath, "lib/a.jar#a.jar", true);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.archives").contains(appUri.getPath() + "/lib/a.jar#a.jar"));
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
        conf.clear();
        ae.addToCache((Configuration)conf, appPath, "lib/a.jar#a.jar", false);
        TestJavaActionExecutor.assertTrue((boolean)conf.get("mapred.cache.files").contains(appUri.getPath() + "/lib/a.jar#a.jar"));
        TestJavaActionExecutor.assertTrue((boolean)DistributedCache.getSymlink((Configuration)conf));
    }

    public void testJobXmlAndNonDefaultNamenode() throws Exception {
        Path appPath = new Path(this.getFsTestCaseDir(), "app");
        this.getFileSystem().mkdirs(appPath);
        Path jobXmlAbsolutePath = new Path(this.getFsTestCaseDir().toUri().getPath(), "jobxmlpath/job.xml");
        TestJavaActionExecutor.assertTrue((jobXmlAbsolutePath.isAbsolute() && jobXmlAbsolutePath.toUri().getAuthority() == null ? 1 : 0) != 0);
        Path jobXmlAbsolutePath2 = new Path(this.getFsTestCaseDir().toUri().getPath(), "jobxmlpath/job3.xml");
        TestJavaActionExecutor.assertTrue((jobXmlAbsolutePath2.isAbsolute() && jobXmlAbsolutePath2.toUri().getAuthority() == null ? 1 : 0) != 0);
        Path jobXmlQualifiedPath = new Path(this.getFs2TestCaseDir(), "jobxmlpath/job4.xml");
        TestJavaActionExecutor.assertTrue((jobXmlQualifiedPath.toUri().getAuthority() != null ? 1 : 0) != 0);
        String str = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNode2Uri() + "</name-node><job-xml>" + jobXmlAbsolutePath.toString() + "</job-xml><job-xml>job2.xml</job-xml><job-xml>" + jobXmlAbsolutePath2.toString() + "</job-xml><job-xml>" + jobXmlQualifiedPath.toString() + "</job-xml><configuration><property><name>p1</name><value>v1a</value></property><property><name>p2</name><value>v2</value></property></configuration></java>";
        Element xml = XmlUtils.parseXml((String)str);
        XConfiguration jConf = new XConfiguration();
        jConf.set("p1", "v1b");
        jConf.set("p3", "v3a");
        FSDataOutputStream os = this.getFileSystem().create(jobXmlAbsolutePath);
        jConf.writeXml((OutputStream)os);
        os.close();
        jConf = new XConfiguration();
        jConf.set("p4", "v4");
        jConf.set("p3", "v3b");
        os = this.getFileSystem().create(new Path(appPath, "job2.xml"));
        jConf.writeXml((OutputStream)os);
        os.close();
        jConf = new XConfiguration();
        jConf.set("p5", "v5a");
        jConf.set("p6", "v6a");
        os = this.getFileSystem().create(jobXmlAbsolutePath2);
        jConf.writeXml((OutputStream)os);
        os.close();
        jConf = new XConfiguration();
        jConf.set("p5", "v5b");
        jConf.set("p6", "v6b");
        os = this.getFileSystem2().create(new Path(jobXmlAbsolutePath2.toUri().getPath()));
        jConf.writeXml((OutputStream)os);
        os.close();
        jConf = new XConfiguration();
        jConf.set("p7", "v7a");
        jConf.set("p8", "v8a");
        os = this.getFileSystem2().create(jobXmlQualifiedPath);
        jConf.writeXml((OutputStream)os);
        os.close();
        ActionExecutorTestCase.Context context = this.createContext("<java/>", null);
        Configuration conf = new JavaActionExecutor().createBaseHadoopConf((ActionExecutor.Context)context, xml);
        int confSize0 = conf.size();
        JavaActionExecutor.parseJobXmlAndConfiguration((ActionExecutor.Context)context, (Element)xml, (Path)appPath, (Configuration)conf);
        TestJavaActionExecutor.assertEquals((int)(confSize0 + 8), (int)conf.size());
        TestJavaActionExecutor.assertEquals((String)"v1a", (String)conf.get("p1"));
        TestJavaActionExecutor.assertEquals((String)"v2", (String)conf.get("p2"));
        TestJavaActionExecutor.assertEquals((String)"v3b", (String)conf.get("p3"));
        TestJavaActionExecutor.assertEquals((String)"v4", (String)conf.get("p4"));
        TestJavaActionExecutor.assertEquals((String)"v5a", (String)conf.get("p5"));
        TestJavaActionExecutor.assertEquals((String)"v6a", (String)conf.get("p6"));
        TestJavaActionExecutor.assertEquals((String)"v7a", (String)conf.get("p7"));
        TestJavaActionExecutor.assertEquals((String)"v8a", (String)conf.get("p8"));
    }

    public void testActionShareLibWithNonDefaultNamenode() throws Exception {
        WorkflowAppService wps = (WorkflowAppService)Services.get().get(WorkflowAppService.class);
        Path systemLibPath = new Path(wps.getSystemLibPath(), "lib_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()).toString());
        File jarFile = IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)"sourcejar.jar", (Class[])new Class[]{LauncherMainTester.class});
        FileInputStream is = new FileInputStream(jarFile);
        Path javaShareLibPath = new Path(systemLibPath, "java");
        this.getFileSystem().mkdirs(javaShareLibPath);
        Path jar1Path = new Path(javaShareLibPath, "jar1.jar");
        FSDataOutputStream os1 = this.getFileSystem().create(jar1Path);
        IOUtils.copyStream((InputStream)is, (OutputStream)os1);
        Path jar2Path = new Path(javaShareLibPath, "jar2.jar");
        FSDataOutputStream os2 = this.getFileSystem().create(jar2Path);
        is = new FileInputStream(jarFile);
        IOUtils.copyStream((InputStream)is, (OutputStream)os2);
        Path launcherPath = new Path(systemLibPath, "oozie");
        this.getFileSystem().mkdirs(launcherPath);
        Path jar3Path = new Path(launcherPath, "jar3.jar");
        FSDataOutputStream os3 = this.getFileSystem().create(jar3Path);
        is = new FileInputStream(jarFile);
        IOUtils.copyStream((InputStream)is, (OutputStream)os3);
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNode2Uri() + "</name-node><job-xml>job.xml</job-xml><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        XConfiguration jConf = new XConfiguration();
        jConf.set("p", "v");
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getAppPath(), "job.xml"));
        jConf.writeXml((OutputStream)os);
        os.close();
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        Services.get().setService(ShareLibService.class);
        WorkflowJobBean workflow = (WorkflowJobBean)context.getWorkflow();
        XConfiguration wfConf = new XConfiguration();
        wfConf.set("user.name", TestJavaActionExecutor.getTestUser());
        wfConf.set("oozie.wf.application.path", new Path(this.getAppPath(), "workflow.xml").toString());
        wfConf.setBoolean("oozie.use.system.libpath", true);
        workflow.setConf(XmlUtils.prettyPrint((Configuration)wfConf).toString());
        ConfigurationService.set((String)"oozie.action.sharelib.for.java", (String)"java");
        String runningJob = this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(runningJob);
    }

    public void testJobSubmissionWithoutYarnKill() throws Exception {
        Path inputDir = new Path(this.getFsTestCaseDir(), "input");
        Path outputDir = new Path(this.getFsTestCaseDir(), "output");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)this.getFileSystem().create(new Path(inputDir, "data.txt")));
        w.write("dummy\n");
        w.write("dummy\n");
        ((Writer)w).close();
        w = new OutputStreamWriter((OutputStream)this.getFileSystem().create(new Path(inputDir, "id.pig")));
        w.write("A = load '$INPUT' using PigStorage(':');\n");
        w.write("store B into '$OUTPUT' USING PigStorage();\n");
        ((Writer)w).close();
        String actionXml = "<pig><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><prepare><delete path='outputdir' /></prepare><configuration><property><name>mapred.compress.map.output</name><value>true</value></property><property><name>mapred.job.queue.name</name><value>default</value></property></configuration><script>" + inputDir.toString() + "/id.pig</script><param>INPUT=" + inputDir.toUri().getPath() + "</param><param>OUTPUT=" + outputDir.toUri().getPath() + "/pig-output</param></pig>";
        PigActionExecutor ae = new PigActionExecutor();
        WorkflowJobBean wfBean = this.addRecordToWfJobTable("test1", actionXml);
        WorkflowActionBean action = (WorkflowActionBean)wfBean.getActions().get(0);
        action.setType(ae.getType());
        action.setConf(actionXml);
        ActionExecutorTestCase.Context context = new ActionExecutorTestCase.Context(this, wfBean, action);
        ConfigurationService.setBoolean((String)"oozie.action.launcher.am.restart.kill.childjobs", (boolean)false);
        String runningJob = this.submitAction(context, (JavaActionExecutor)ae);
        this.waitUntilYarnAppDoneAndAssertSuccess(runningJob);
    }

    public void testDefaultConfigurationInLauncher() throws Exception {
        JavaActionExecutor ae = new JavaActionExecutor();
        Element actionXmlWithConfiguration = XmlUtils.parseXml((String)("<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>oozie.launcher.a</name><value>AA</value></property><property><name>b</name><value>BB</value></property></configuration><main-class>MAIN-CLASS</main-class></java>"));
        Element actionXmlWithoutConfiguration = XmlUtils.parseXml((String)("<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>MAIN-CLASS</main-class></java>"));
        Configuration conf = new Configuration(false);
        Assert.assertEquals((long)0L, (long)conf.size());
        conf.set(YARN_RESOURCEMANAGER_ADDRESS, this.getJobTrackerUri());
        ae.setupLauncherConf(conf, actionXmlWithConfiguration, null, null);
        TestJavaActionExecutor.assertEquals((String)this.getJobTrackerUri(), (String)conf.get(YARN_RESOURCEMANAGER_ADDRESS));
        TestJavaActionExecutor.assertEquals((String)"AA", (String)conf.get("oozie.launcher.a"));
        TestJavaActionExecutor.assertEquals((String)"AA", (String)conf.get("a"));
        TestJavaActionExecutor.assertEquals((String)"action.barbar", (String)conf.get("oozie.launcher.action.foofoo"));
        TestJavaActionExecutor.assertEquals((String)"action.barbar", (String)conf.get("action.foofoo"));
        TestJavaActionExecutor.assertEquals((String)"max-attempts", (String)"1", (String)conf.get("oozie.launcher.max.attempts"));
        TestJavaActionExecutor.assertEquals((int)6, (int)conf.size());
        conf = new Configuration(false);
        Assert.assertEquals((long)0L, (long)conf.size());
        conf.set(YARN_RESOURCEMANAGER_ADDRESS, this.getJobTrackerUri());
        ae.setupLauncherConf(conf, actionXmlWithoutConfiguration, null, null);
        TestJavaActionExecutor.assertEquals((String)this.getJobTrackerUri(), (String)conf.get(YARN_RESOURCEMANAGER_ADDRESS));
        TestJavaActionExecutor.assertEquals((String)"action.barbar", (String)conf.get("oozie.launcher.action.foofoo"));
        TestJavaActionExecutor.assertEquals((String)"action.barbar", (String)conf.get("action.foofoo"));
        TestJavaActionExecutor.assertEquals((String)"max-attempts", (String)"1", (String)conf.get("oozie.launcher.max.attempts"));
        TestJavaActionExecutor.assertEquals((int)4, (int)conf.size());
    }

    public void testDefaultConfigurationInActionConf() throws Exception {
        JavaActionExecutor ae = new JavaActionExecutor();
        String dummyConfiguration = "<configuration><property><name>action.foo</name><value>AA</value></property></configuration>";
        String xmlStr = this.helper.getJavaActionXml("<configuration><property><name>action.foo</name><value>AA</value></property></configuration>");
        Element actionXml = XmlUtils.parseXml((String)xmlStr);
        ActionExecutorTestCase.Context context = this.createContext(xmlStr, TestJavaActionExecutor.getTestGroup());
        Configuration conf = new Configuration(true);
        conf.set(YARN_RESOURCEMANAGER_ADDRESS, this.getJobTrackerUri());
        TestJavaActionExecutor.assertEquals((String)"MapReduce's default value changed", (String)"4", (String)conf.get("mapreduce.map.maxattempts"));
        ae.setupActionConf(conf, (ActionExecutor.Context)context, actionXml, new Path(context.getWorkflow().getAppPath()));
        TestJavaActionExecutor.assertEquals((String)"failed to inject property >action.foo<", (String)"AA", (String)conf.get("action.foo"));
        TestJavaActionExecutor.assertEquals((String)"failed to inject property >oozie.launcher.action.foofoo<", (String)"action.barbar", (String)conf.get("oozie.launcher.action.foofoo"));
        TestJavaActionExecutor.assertEquals((String)"Maxattempts should've been overwritten by setupActionConf", (String)"1", (String)conf.get("mapreduce.map.maxattempts"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGlobalConfigurationWithActionDefaults() throws Exception {
        try {
            String workflowUri = this.helper.createTestWorkflowXml(this.getWorkflowGlobalXml(), this.helper.getJavaActionXml(""));
            LocalOozie.start();
            final OozieClient wfClient = LocalOozie.getClient();
            Properties conf = wfClient.createConfiguration();
            conf.setProperty("oozie.wf.application.path", workflowUri);
            conf.setProperty("user.name", TestJavaActionExecutor.getTestUser());
            conf.setProperty("appName", "var-app-name");
            final String jobId = wfClient.submit(conf);
            wfClient.start(jobId);
            WorkflowJob workflow = wfClient.getJobInfo(jobId);
            this.waitFor(20000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    WorkflowAction javaAction = TestJavaActionExecutor.this.helper.getJavaAction(wfClient.getJobInfo(jobId));
                    return javaAction != null && !javaAction.getStatus().equals((Object)"PREP");
                }
            });
            WorkflowAction workflowAction = this.helper.getJavaAction(workflow);
            Element eConf = XmlUtils.parseXml((String)workflowAction.getConf());
            Element element = eConf.getChild("configuration", eConf.getNamespace());
            XConfiguration actionConf = new XConfiguration((Reader)new StringReader(XmlUtils.prettyPrint((Element)element).toString()));
            TestJavaActionExecutor.assertEquals((String)"Config value set in <global> section is not propagated correctly", (String)"foo2", (String)actionConf.get("action.foo"));
        }
        finally {
            LocalOozie.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceManagerInGlobalConfigurationCanBeOverridenWithJobTrackerInAction() throws Exception {
        try {
            String global = "<global><resource-manager>RM</resource-manager></global>";
            String workflowUri = this.helper.createTestWorkflowXml("<global><resource-manager>RM</resource-manager></global>", this.helper.getJavaActionXml(""));
            LocalOozie.start();
            final OozieClient wfClient = LocalOozie.getClient();
            Properties conf = wfClient.createConfiguration();
            conf.setProperty("oozie.wf.application.path", workflowUri);
            conf.setProperty("user.name", TestJavaActionExecutor.getTestUser());
            conf.setProperty("appName", "var-app-name");
            final String jobId = wfClient.submit(conf);
            wfClient.start(jobId);
            WorkflowJob workflow = wfClient.getJobInfo(jobId);
            this.waitFor(20000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    WorkflowAction javaAction = TestJavaActionExecutor.this.helper.getJavaAction(wfClient.getJobInfo(jobId));
                    return javaAction != null && !javaAction.getStatus().equals((Object)"PREP");
                }
            });
            WorkflowAction workflowAction = this.helper.getJavaAction(workflow);
            String actualConfig = workflowAction.getConf();
            String actualJobTrackerURI = XmlUtils.parseXml((String)actualConfig).getChildTextNormalize("job-tracker", null);
            TestJavaActionExecutor.assertEquals((String)this.getJobTrackerUri(), (String)actualJobTrackerURI);
        }
        finally {
            LocalOozie.stop();
        }
    }

    public void testSetRootLoggerLevel() throws Exception {
        String oozieActionRootLogger = "oozie.action.rootlogger.log.level";
        String oozieActionHiveRootLogger = "oozie.action.hiverootlogger.log.level";
        JavaActionExecutor jae = new JavaActionExecutor();
        Configuration conf = new Configuration(false);
        jae.setRootLoggerLevel(conf);
        TestJavaActionExecutor.assertEquals((String)"INFO", (String)conf.get(oozieActionRootLogger));
        jae = new JavaActionExecutor();
        conf = new Configuration(false);
        conf.set(oozieActionRootLogger, "DEBUG");
        jae.setRootLoggerLevel(conf);
        TestJavaActionExecutor.assertEquals((String)"DEBUG", (String)conf.get(oozieActionRootLogger));
        HiveActionExecutor hae = new HiveActionExecutor();
        conf = new Configuration(false);
        conf.set(oozieActionHiveRootLogger, "DEBUG");
        hae.setRootLoggerLevel(conf);
        TestJavaActionExecutor.assertEquals((String)"DEBUG", (String)conf.get(oozieActionHiveRootLogger));
    }

    public void testEmptyArgsWithNullArgsNotAllowed() throws Exception {
        this.testEmptyArgs(false, "SUCCEEDED", WorkflowAction.Status.OK);
    }

    public void testEmptyArgsWithNullArgsAllowed() throws Exception {
        this.testEmptyArgs(true, "FAILED/KILLED", WorkflowAction.Status.ERROR);
    }

    private void testEmptyArgs(boolean nullArgsAllowed, String expectedExternalStatus, WorkflowAction.Status expectedStatus) throws Exception {
        ConfigurationService.setBoolean((String)"oozie.action.null.args.allowed", (boolean)nullArgsAllowed);
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + LauncherMainTester.class.getName() + "</main-class><arg></arg></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(context.getAction().getExternalId());
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertTrue((boolean)ae.isCompleted(context.getAction().getExternalStatus()));
        TestJavaActionExecutor.assertEquals((String)expectedExternalStatus, (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)expectedStatus, (Object)context.getAction().getStatus());
    }

    public void testMaxOutputDataSetByUser() {
        Configuration conf = new Configuration(false);
        conf.set("oozie.action.max.output.data", "10000");
        TestJavaActionExecutor.assertEquals((int)10000, (int)JavaActionExecutor.getMaxOutputData((Configuration)conf));
    }

    public void testInvalidMaxOutputDataSetByUser() {
        Configuration conf = new Configuration(false);
        conf.set("oozie.action.max.output.data", "sdasda");
        TestJavaActionExecutor.assertEquals((int)2048, (int)JavaActionExecutor.getMaxOutputData((Configuration)conf));
    }

    public void testFileWithSpaces() throws Exception {
        String actPath = JavaActionExecutor.getTrimmedEncodedPath((String)"/user/map dev/test-case/shell/script/shell 1.sh");
        TestJavaActionExecutor.assertEquals((String)"/user/map%20dev/test-case/shell/script/shell%201.sh", (String)actPath);
    }

    public void testSubmitOKWithVcoresAndMemory() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration>  <property><name>oozie.launcher.vcores</name><value>1</value></property>  <property><name>oozie.launcher.memory.mb</name><value>1024</value></property></configuration><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(context.getAction().getExternalId());
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((String)"SUCCEEDED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)context.getAction().getStatus());
    }

    public void testSubmitOKWithLauncherJavaOpts() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration>  <property><name>oozie.launcher.javaopts</name><value>-DtestJavaOpts=true</value></property></configuration><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(context.getAction().getExternalId());
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((String)"FAILED/KILLED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.ERROR, (Object)context.getAction().getStatus());
    }

    public void testSubmitFailsWithNegativeVcores() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration>  <property><name>oozie.launcher.vcores</name><value>-1</value></property></configuration><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        boolean exception = false;
        try {
            this.submitAction(context);
        }
        catch (ActionExecutorException e) {
            exception = true;
            TestJavaActionExecutor.assertEquals((String)"Illegal exception was thrown", IllegalArgumentException.class, e.getCause().getClass());
        }
        TestJavaActionExecutor.assertTrue((String)"Exception was not caught", (boolean)exception);
    }

    public void testSubmitFailsWithNegativeMemory() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration>  <property><name>oozie.launcher.memory.mb</name><value>-1</value></property></configuration><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        boolean exception = false;
        try {
            this.submitAction(context);
        }
        catch (ActionExecutorException e) {
            exception = true;
            TestJavaActionExecutor.assertEquals((String)"Illegal exception was thrown", IllegalArgumentException.class, e.getCause().getClass());
        }
        TestJavaActionExecutor.assertTrue((String)"Exception was not caught", (boolean)exception);
    }

    public void testSubmitOKWithLauncherEnvVars() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration>  <property><name>oozie.launcher.env</name><value>A=foo1" + File.pathSeparator + "B=foo2</value></property></configuration><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(context.getAction().getExternalId());
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((String)"SUCCEEDED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)context.getAction().getStatus());
    }

    public void testEnvVarsPropagatedFromLauncherConfig() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration>  <property><name>oozie.launcher.env</name><value>LAUNCHER_ENVIRON=foo1" + File.pathSeparator + "B=foo2</value></property></configuration><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        this.submitAction(context);
        this.waitUntilYarnAppDoneAndAssertSuccess(context.getAction().getExternalId());
        JavaActionExecutor ae = new JavaActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((String)"FAILED/KILLED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertNull((Object)context.getAction().getData());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.ERROR, (Object)context.getAction().getStatus());
    }

    public void testSubmitFailsWithInvalidLauncherEnvVars() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration>  <property><name>oozie.launcher.env</name><value>Afoo1" + File.pathSeparator + "B=foo2</value></property></configuration><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        try {
            this.submitAction(context);
            TestJavaActionExecutor.fail();
        }
        catch (ActionExecutorException e) {
            TestJavaActionExecutor.assertTrue((boolean)e.getMessage().contains("Invalid launcher setting for environment variables"));
        }
    }

    public void testSubmitWithLauncherQueue() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration>  <property><name>oozie.launcher.queue</name><value>test</value></property></configuration><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        this.submitAction(context);
        ApplicationId appId = ConverterUtils.toApplicationId((String)context.getAction().getExternalId());
        Configuration conf = this.getHadoopAccessorService().createConfiguration(this.getJobTrackerUri());
        String queue = this.getHadoopAccessorService().createYarnClient(TestJavaActionExecutor.getTestUser(), conf).getApplicationReport(appId).getQueue();
        if (this.isFairSchedulerUsed(conf)) {
            TestJavaActionExecutor.assertEquals((String)"root.test", (String)queue);
        } else {
            TestJavaActionExecutor.assertEquals((String)"test", (String)queue);
        }
    }

    private boolean isFairSchedulerUsed(Configuration conf) {
        return conf.get("yarn.resourcemanager.scheduler.class").contains(FairScheduler.class.getName());
    }

    public void testSubmitLauncherConfigurationOverridesLauncherMapperProperties() throws Exception {
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration>  <property><name>oozie.launcher.queue</name><value>default1</value></property>  <property><name>mapreduce.job.queuename</name><value>default2</value></property></configuration><main-class>" + LauncherMainTester.class.getName() + "</main-class></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        String applicationId = this.submitAction(context);
        ApplicationId appId = ConverterUtils.toApplicationId((String)context.getAction().getExternalId());
        Configuration conf = this.getHadoopAccessorService().createConfiguration(this.getJobTrackerUri());
        String queue = this.getHadoopAccessorService().createYarnClient(TestJavaActionExecutor.getTestUser(), conf).getApplicationReport(appId).getQueue();
        if (this.isFairSchedulerUsed(conf)) {
            TestJavaActionExecutor.assertEquals((String)"queue name", (String)"root.default1", (String)queue);
        }
        this.waitUntilYarnAppDoneAndAssertSuccess(applicationId);
    }

    private HadoopAccessorService getHadoopAccessorService() {
        return (HadoopAccessorService)Services.get().get(HadoopAccessorService.class);
    }

    public void testChildKill() throws Exception {
        JobConf clusterConf = this.createJobConf();
        FileSystem fileSystem = FileSystem.get((Configuration)clusterConf);
        Path confFile = new Path("/tmp/cluster-conf.xml");
        FSDataOutputStream out = fileSystem.create(confFile);
        clusterConf.writeXml((OutputStream)out);
        out.close();
        String confFileName = fileSystem.makeQualified(confFile).toString() + "#core-site.xml";
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class> " + SleepJob.class.getName() + " </main-class><arg>-mt</arg><arg>300000</arg><archive>" + confFileName + "</archive></java>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml, null);
        String runningJob = this.submitAction(context);
        YarnApplicationState state = this.waitUntilYarnAppState(runningJob, EnumSet.of(YarnApplicationState.RUNNING));
        TestJavaActionExecutor.assertEquals((Object)YarnApplicationState.RUNNING, (Object)state);
        WorkflowJob wfJob = context.getWorkflow();
        XConfiguration conf = null;
        if (wfJob.getConf() != null) {
            conf = new XConfiguration((Reader)new StringReader(wfJob.getConf()));
        }
        String launcherTag = LauncherHelper.getActionYarnTag(conf, (String)wfJob.getParentId(), (WorkflowAction)context.getAction());
        JavaActionExecutor ae = new JavaActionExecutor();
        final Configuration jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, XmlUtils.parseXml((String)actionXml));
        jobConf.set("oozie.child.mapreduce.job.tags", LauncherHelper.getTag((String)launcherTag));
        jobConf.setLong("oozie.job.launch.time", context.getAction().getStartTime().getTime());
        UserGroupInformationService ugiService = (UserGroupInformationService)Services.get().get(UserGroupInformationService.class);
        final UserGroupInformation ugi = ugiService.getProxyUser(TestJavaActionExecutor.getTestUser());
        final HashSet childSet = new HashSet();
        this.waitFor(60000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return (Boolean)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws Exception {
                        childSet.clear();
                        childSet.addAll(LauncherMain.getChildYarnJobs((Configuration)jobConf));
                        return childSet.size() > 0;
                    }
                });
            }
        });
        TestJavaActionExecutor.assertEquals((int)1, (int)childSet.size());
        ae.kill((ActionExecutor.Context)context, context.getAction());
        HadoopAccessorService hadoopAccessorService = this.getHadoopAccessorService();
        Configuration config = hadoopAccessorService.createConfiguration(this.getJobTrackerUri());
        YarnClient yarnClient = hadoopAccessorService.createYarnClient(TestJavaActionExecutor.getTestUser(), config);
        ApplicationId jobId = (ApplicationId)childSet.iterator().next();
        TestJavaActionExecutor.assertEquals((Object)YarnApplicationState.KILLED, (Object)yarnClient.getApplicationReport(jobId).getYarnApplicationState());
        TestJavaActionExecutor.assertTrue((boolean)ae.isCompleted(context.getAction().getExternalStatus()));
        TestJavaActionExecutor.assertEquals((Object)WorkflowAction.Status.DONE, (Object)context.getAction().getStatus());
        TestJavaActionExecutor.assertEquals((String)"KILLED", (String)context.getAction().getExternalStatus());
        TestJavaActionExecutor.assertEquals((Object)FinalApplicationStatus.KILLED, (Object)yarnClient.getApplicationReport(ConverterUtils.toApplicationId((String)runningJob)).getFinalApplicationStatus());
    }

    public String getWorkflowGlobalXml() {
        return "<global>   <configuration>        <property>            <name>action.foo</name>            <value>foo2</value>        </property>    </configuration></global>";
    }
}

