/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.LauncherHelper;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.util.XConfiguration;

public class TestLauncher
extends XFsTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        new Services().init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    public void testSetupLauncherInfoWithEmptyPrepareXML() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        Configuration appConf = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createConfiguration(new URI(this.getNameNodeUri()).getAuthority());
        appConf.set("user.name", TestLauncher.getTestUser());
        appConf.set("fs.default.name", this.getNameNodeUri());
        XConfiguration actionConf = new XConfiguration();
        String prepareBlock = "";
        LauncherHelper.setupLauncherInfo((Configuration)appConf, (String)"1", (String)"1@a", (Path)actionDir, (String)"1@a-0", (Configuration)actionConf, (String)prepareBlock);
        TestLauncher.assertTrue((boolean)appConf.get("oozie.action.prepare.xml").equals(""));
    }

    public void testSetupLauncherInfoWithNonEmptyPrepareXML() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        Path newDir = new Path(actionDir, "newDir");
        Configuration appConf = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createConfiguration(new URI(this.getNameNodeUri()).getAuthority());
        appConf.set("user.name", TestLauncher.getTestUser());
        appConf.set("fs.default.name", this.getNameNodeUri());
        XConfiguration actionConf = new XConfiguration();
        String prepareBlock = "<prepare><mkdir path='" + newDir + "'/></prepare>";
        LauncherHelper.setupLauncherInfo((Configuration)appConf, (String)"1", (String)"1@a", (Path)actionDir, (String)"1@a-0", (Configuration)actionConf, (String)prepareBlock);
        TestLauncher.assertTrue((boolean)appConf.get("oozie.action.prepare.xml").equals(prepareBlock));
    }

    public void testSetupMainClass() throws Exception {
        Configuration conf = new Configuration(false);
        LauncherHelper.setupMainClass((Configuration)conf, (String)"");
        TestLauncher.assertNull((Object)conf.get("oozie.launcher.action.main.class"));
        conf = new Configuration(false);
        LauncherHelper.setupMainClass((Configuration)conf, (String)"org.blah.myclass1");
        TestLauncher.assertEquals((String)conf.get("oozie.launcher.action.main.class"), (String)"org.blah.myclass1");
        conf = new Configuration(false);
        conf.set("oozie.launcher.action.main.class", "org.blah.myclass2");
        LauncherHelper.setupMainClass((Configuration)conf, (String)"");
        TestLauncher.assertEquals((String)conf.get("oozie.launcher.action.main.class"), (String)"org.blah.myclass2");
        conf = new Configuration(false);
        conf.set("oozie.launcher.action.main.class", "org.blah.myclass2");
        LauncherHelper.setupMainClass((Configuration)conf, (String)"org.blah.myclass1");
        TestLauncher.assertEquals((String)conf.get("oozie.launcher.action.main.class"), (String)"org.blah.myclass1");
    }

    public void testSetupLauncherInfoHadoop2_0_2_alphaWorkaround() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        Configuration appConf = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createConfiguration(new URI(this.getNameNodeUri()).getAuthority());
        appConf.set("user.name", TestLauncher.getTestUser());
        appConf.set("fs.default.name", this.getNameNodeUri());
        XConfiguration actionConf = new XConfiguration();
        actionConf.set("mapreduce.job.cache.files", "a.jar,aa.jar#aa.jar");
        LauncherHelper.setupLauncherInfo((Configuration)appConf, (String)"1", (String)"1@a", (Path)actionDir, (String)"1@a-0", (Configuration)actionConf, (String)"");
        TestLauncher.assertFalse((boolean)appConf.getBoolean("oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache", false));
        TestLauncher.assertEquals((String)"a.jar,aa.jar#aa.jar", (String)actionConf.get("mapreduce.job.cache.files"));
        Services.get().getConf().setBoolean("oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache", true);
        actionConf = new XConfiguration();
        actionConf.set("mapreduce.job.cache.files", "a.jar,aa.jar#aa.jar");
        LauncherHelper.setupLauncherInfo((Configuration)appConf, (String)"1", (String)"1@a", (Path)actionDir, (String)"1@a-0", (Configuration)actionConf, (String)"");
        TestLauncher.assertTrue((boolean)appConf.getBoolean("oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache", false));
        TestLauncher.assertEquals((String)"aa.jar#aa.jar", (String)actionConf.get("mapreduce.job.cache.files"));
    }

    public void testCopyFileMultiplex() throws Exception {
        File[] dsts;
        String contents = "Hello World!\nThis is Oozie";
        File src = new File(this.getTestCaseDir(), "src.txt");
        FileWriter w = new FileWriter(src);
        w.write(contents);
        ((Writer)w).close();
        for (File dst : dsts = new File[]{new File(this.getTestCaseDir(), "dst1.txt"), new File(this.getTestCaseDir(), "dist2.txt"), new File(this.getTestCaseDir(), "dist3.txt")}) {
            dst.delete();
            TestLauncher.assertFalse((boolean)dst.exists());
        }
        LauncherMain.copyFileMultiplex((File)src, (File[])dsts);
        for (File dst : dsts) {
            TestLauncher.assertTrue((boolean)dst.exists());
            TestLauncher.assertEquals((String)contents, (String)FileUtils.readFileToString((File)dst));
        }
    }
}

