/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.oozie.QueryServlet;
import org.apache.oozie.action.hadoop.LauncherAM;
import org.apache.oozie.action.hadoop.LauncherAMCallbackNotifier;
import org.apache.oozie.command.wf.HangServlet;
import org.apache.oozie.test.EmbeddedServletContainer;
import org.apache.oozie.test.XTestCase;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestLauncherAMCallbackNotifier
extends XTestCase {
    private EmbeddedServletContainer container;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        QueryServlet.lastQueryString = null;
    }

    @Override
    public void tearDown() throws Exception {
        if (this.container != null) {
            this.container.stop();
        }
        super.tearDown();
    }

    public void testConfiguration() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("oozie.launcher.callback.max.attempts", "0");
        conf.set("oozie.launcher.callback.retry.attempts", "10");
        LauncherAMCallbackNotifier cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertEquals((int)0, (int)cn.numTries);
        conf.set("oozie.launcher.callback.max.attempts", "1");
        cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertEquals((int)1, (int)cn.numTries);
        conf.set("oozie.launcher.callback.max.attempts", "20");
        cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertEquals((int)11, (int)cn.numTries);
        conf.set("oozie.launcher.callback.retry.interval", "1000");
        cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertEquals((int)1000, (int)cn.waitInterval);
        conf.set("oozie.launcher.callback.retry.interval", "10000");
        cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertEquals((int)5000, (int)cn.waitInterval);
        conf.set("oozie.launcher.callback.retry.interval", "-10");
        cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertEquals((int)5000, (int)cn.waitInterval);
        conf.set("oozie.launcher.callback.timeout", "1000");
        cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertEquals((int)1000, (int)cn.timeout);
        conf.set("oozie.launcher.callback.proxy", "somehost");
        cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertEquals((Object)((Object)Proxy.Type.DIRECT), (Object)((Object)cn.proxyToUse.type()));
        conf.set("oozie.launcher.callback.proxy", "somehost:someport");
        cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertEquals((Object)((Object)Proxy.Type.DIRECT), (Object)((Object)cn.proxyToUse.type()));
        conf.set("oozie.launcher.callback.proxy", "somehost:1000");
        cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertEquals((String)"HTTP @ somehost:1000", (String)cn.proxyToUse.toString());
        conf.set("oozie.launcher.callback.proxy", "socks@somehost:1000");
        cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertEquals((String)"SOCKS @ somehost:1000", (String)cn.proxyToUse.toString());
        conf.set("oozie.launcher.callback.proxy", "SOCKS@somehost:1000");
        cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertEquals((String)"SOCKS @ somehost:1000", (String)cn.proxyToUse.toString());
        conf.set("oozie.launcher.callback.proxy", "sfafn@somehost:1000");
        cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertEquals((String)"HTTP @ somehost:1000", (String)cn.proxyToUse.toString());
    }

    public void testNotifyRetries() throws InterruptedException {
        Configuration conf = new Configuration(false);
        conf.set("oozie.launcher.callback.retry.attempts", "0");
        conf.set("oozie.launcher.callback.max.attempts", "1");
        conf.set("oozie.launcher.callback.url", "http://nonexistent");
        conf.set("oozie.launcher.callback.retry.interval", "5000");
        LauncherAMCallbackNotifier cnSpy = (LauncherAMCallbackNotifier)Mockito.spy((Object)new LauncherAMCallbackNotifier(conf));
        long start = System.currentTimeMillis();
        cnSpy.notifyURL(LauncherAM.OozieActionResult.SUCCEEDED);
        long end = System.currentTimeMillis();
        ((LauncherAMCallbackNotifier)Mockito.verify((Object)cnSpy, (VerificationMode)Mockito.times((int)1))).notifyURLOnce();
        Assert.assertTrue((String)("Should have taken more than 5 seconds but it only took " + (end - start)), (end - start >= 5000L ? 1 : 0) != 0);
        conf.set("oozie.launcher.callback.max.attempts", "3");
        conf.set("oozie.launcher.callback.retry.attempts", "3");
        conf.set("oozie.launcher.callback.retry.interval", "3000");
        cnSpy = (LauncherAMCallbackNotifier)Mockito.spy((Object)new LauncherAMCallbackNotifier(conf));
        start = System.currentTimeMillis();
        cnSpy.notifyURL(LauncherAM.OozieActionResult.SUCCEEDED);
        end = System.currentTimeMillis();
        ((LauncherAMCallbackNotifier)Mockito.verify((Object)cnSpy, (VerificationMode)Mockito.times((int)3))).notifyURLOnce();
        Assert.assertTrue((String)("Should have taken more than 9 seconds but it only took " + (end - start)), (end - start >= 9000L ? 1 : 0) != 0);
    }

    public void testNotifyTimeout() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sleep_time_ms", "1000000");
        Configuration conf = this.setupEmbeddedContainer(HangServlet.class, "/hang/*", "/hang/*", params);
        LauncherAMCallbackNotifier cnSpy = (LauncherAMCallbackNotifier)Mockito.spy((Object)new LauncherAMCallbackNotifier(conf));
        long start = System.currentTimeMillis();
        cnSpy.notifyURL(LauncherAM.OozieActionResult.SUCCEEDED);
        long end = System.currentTimeMillis();
        ((LauncherAMCallbackNotifier)Mockito.verify((Object)cnSpy, (VerificationMode)Mockito.times((int)1))).notifyURLOnce();
        Assert.assertTrue((String)("Should have taken more than 5 seconds but it only took " + (end - start)), (end - start >= 5000L ? 1 : 0) != 0);
    }

    public void testNotify() throws Exception {
        Configuration conf = this.setupEmbeddedContainer(QueryServlet.class, "/count/*", "/count/?status=$jobStatus", null);
        LauncherAMCallbackNotifier cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertNull((Object)QueryServlet.lastQueryString);
        cn.notifyURL(LauncherAM.OozieActionResult.SUCCEEDED);
        this.waitForCallbackAndCheckResult(FinalApplicationStatus.SUCCEEDED.toString());
    }

    public void testNotifyBackgroundActionWhenSubmitSucceeds() throws Exception {
        Configuration conf = this.setupEmbeddedContainer(QueryServlet.class, "/count/*", "/count/?status=$jobStatus", null);
        LauncherAMCallbackNotifier cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertNull((Object)QueryServlet.lastQueryString);
        cn.notifyURL(LauncherAM.OozieActionResult.RUNNING);
        this.waitForCallbackAndCheckResult(LauncherAM.OozieActionResult.RUNNING.toString());
    }

    public void testNotifyBackgroundActionWhenSubmitFailsWithFailed() throws Exception {
        Configuration conf = this.setupEmbeddedContainer(QueryServlet.class, "/count/*", "/count/?status=$jobStatus", null);
        LauncherAMCallbackNotifier cn = new LauncherAMCallbackNotifier(conf);
        TestLauncherAMCallbackNotifier.assertNull((Object)QueryServlet.lastQueryString);
        cn.notifyURL(LauncherAM.OozieActionResult.FAILED);
        this.waitForCallbackAndCheckResult(FinalApplicationStatus.FAILED.toString());
    }

    private Configuration setupEmbeddedContainer(Class<? extends Servlet> servletClass, String servletEndPoint, String servletUrl, Map<String, String> params) throws Exception {
        this.container = new EmbeddedServletContainer("test");
        if (servletEndPoint != null) {
            if (params != null) {
                this.container.addServletEndpoint(servletEndPoint, servletClass, params);
            } else {
                this.container.addServletEndpoint(servletEndPoint, servletClass);
            }
        }
        this.container.start();
        Configuration conf = new Configuration(false);
        conf.set("oozie.launcher.callback.retry.attempts", "0");
        conf.set("oozie.launcher.callback.max.attempts", "1");
        conf.set("oozie.launcher.callback.url", this.container.getServletURL(servletUrl));
        conf.set("oozie.launcher.callback.retry.interval", "5000");
        return conf;
    }

    private void waitForCallbackAndCheckResult(final String expectedResult) {
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return ("status=" + expectedResult).equals(QueryServlet.lastQueryString);
            }
        });
        TestLauncherAMCallbackNotifier.assertEquals((String)("status=" + expectedResult), (String)QueryServlet.lastQueryString);
    }
}

