/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.LauncherConfigurationInjector;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;

public class TestLauncherConfigurationInjector
extends XTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        new Services().init();
    }

    @Override
    protected void tearDown() throws Exception {
        if (Services.get() != null) {
            Services.get().destroy();
        }
        super.tearDown();
    }

    public void testOverrideSwitchedOffSourceCopiedToTargetWithTwoDifferentKeys() {
        ConfigurationService.setBoolean((String)"oozie.launcher.override", (boolean)false);
        Configuration sourceConf = SourceConfigurationFactory.createOverridingAndLauncherEntries();
        Configuration launcherConf = TestLauncherConfigurationInjector.newConfigurationWithoutDefaults();
        new LauncherConfigurationInjector(sourceConf).inject(launcherConf);
        this.assertLauncherAndDefaultEntries(launcherConf);
    }

    private static Configuration newConfigurationWithoutDefaults() {
        return new Configuration(false);
    }

    private static Configuration newConfigurationWithDefaults() {
        return new Configuration(true);
    }

    private void assertLauncherAndDefaultEntries(Configuration launcherConf) {
        TestLauncherConfigurationInjector.assertEquals((String)"launcher max attempts", (int)1, (int)launcherConf.getInt("oozie.launcher.max.attempts", -1));
        TestLauncherConfigurationInjector.assertEquals((String)"max attempts", (int)1, (int)launcherConf.getInt("max.attempts", -1));
        TestLauncherConfigurationInjector.assertEquals((String)"launcher memory mb", (int)512, (int)launcherConf.getInt("oozie.launcher.memory.mb", -1));
        TestLauncherConfigurationInjector.assertEquals((String)"memory mb", (int)512, (int)launcherConf.getInt("memory.mb", -1));
        TestLauncherConfigurationInjector.assertEquals((String)"launcher vcores", (int)4, (int)launcherConf.getInt("oozie.launcher.vcores", -1));
        TestLauncherConfigurationInjector.assertEquals((String)"vcores", (int)4, (int)launcherConf.getInt("vcores", -1));
        TestLauncherConfigurationInjector.assertEquals((String)"launcher log level", (String)"DEBUG", (String)launcherConf.get("oozie.launcher.log.level"));
        TestLauncherConfigurationInjector.assertEquals((String)"log level", (String)"DEBUG", (String)launcherConf.get("log.level"));
        TestLauncherConfigurationInjector.assertTrue((String)"launcher java opts", (boolean)launcherConf.get("oozie.launcher.javaopts").contains("-XX:MaxPermSize=128m"));
        TestLauncherConfigurationInjector.assertTrue((String)"java opts", (boolean)launcherConf.get("javaopts").contains("-XX:MaxPermSize=128m"));
        TestLauncherConfigurationInjector.assertTrue((String)"launcher env", (boolean)launcherConf.get("oozie.launcher.env").contains("PATH=/path2:$PATH"));
        TestLauncherConfigurationInjector.assertTrue((String)"env", (boolean)launcherConf.get("env").contains("PATH=/path2:$PATH"));
        TestLauncherConfigurationInjector.assertEquals((String)"launcher priority", (int)2, (int)launcherConf.getInt("oozie.launcher.priority", -1));
        TestLauncherConfigurationInjector.assertEquals((String)"priority", (int)2, (int)launcherConf.getInt("priority", -1));
        TestLauncherConfigurationInjector.assertTrue((String)"launcher queue", (boolean)launcherConf.get("oozie.launcher.queue").contains("default2"));
        TestLauncherConfigurationInjector.assertTrue((String)"queue", (boolean)launcherConf.get("queue").contains("default2"));
    }

    public void testLauncherConfigSourceCopiedToTarget() {
        Configuration sourceConf = SourceConfigurationFactory.createLauncherEntries();
        Configuration launcherConf = TestLauncherConfigurationInjector.newConfigurationWithoutDefaults();
        new LauncherConfigurationInjector(sourceConf).inject(launcherConf);
        this.assertLauncherAndDefaultEntries(launcherConf);
    }

    public void testOverridingConfigCopiedToTarget() {
        Configuration sourceConf = SourceConfigurationFactory.createOverridingEntries();
        Configuration launcherConf = TestLauncherConfigurationInjector.newConfigurationWithoutDefaults();
        new LauncherConfigurationInjector(sourceConf).inject(launcherConf);
        this.assertHigherRankingOverridingAndNoDefaultEntries(launcherConf);
    }

    private void assertHigherRankingOverridingAndNoDefaultEntries(Configuration launcherConf) {
        TestLauncherConfigurationInjector.assertEquals((String)"launcher max-attempts", (int)4, (int)launcherConf.getInt("oozie.launcher.max.attempts", -1));
        TestLauncherConfigurationInjector.assertEquals((String)"max-attempts", (int)-1, (int)launcherConf.getInt("max.attempts", -1));
        TestLauncherConfigurationInjector.assertEquals((String)"launcher memory mb", (int)2048, (int)launcherConf.getInt("oozie.launcher.memory.mb", -1));
        TestLauncherConfigurationInjector.assertEquals((String)"memory mb", (int)-1, (int)launcherConf.getInt("memory.mb", -1));
        TestLauncherConfigurationInjector.assertEquals((String)"launcher vcores", (int)16, (int)launcherConf.getInt("oozie.launcher.vcores", -1));
        TestLauncherConfigurationInjector.assertEquals((String)"vcores", (int)-1, (int)launcherConf.getInt("vcores", -1));
        TestLauncherConfigurationInjector.assertEquals((String)"launcher log level", (String)"TRACE", (String)launcherConf.get("oozie.launcher.log.level"));
        TestLauncherConfigurationInjector.assertNull((String)"log level", (Object)launcherConf.get("log.level"));
        TestLauncherConfigurationInjector.assertTrue((String)"launcher java opts", (boolean)launcherConf.get("oozie.launcher.javaopts").contains("-XX:MaxPermSize=256m"));
        TestLauncherConfigurationInjector.assertNull((String)"java opts", (Object)launcherConf.get("javaopts"));
        TestLauncherConfigurationInjector.assertTrue((String)"launcher env", (boolean)launcherConf.get("oozie.launcher.env").contains("PATH=/path1:$PATH"));
        TestLauncherConfigurationInjector.assertNull((String)"env", (Object)launcherConf.get("env"));
        TestLauncherConfigurationInjector.assertEquals((String)"launcher priority", (int)1, (int)launcherConf.getInt("oozie.launcher.priority", -1));
        TestLauncherConfigurationInjector.assertEquals((String)"priority", (int)-1, (int)launcherConf.getInt("priority", -1));
        TestLauncherConfigurationInjector.assertTrue((String)"launcher queue", (boolean)launcherConf.get("oozie.launcher.queue").contains("default1"));
        TestLauncherConfigurationInjector.assertNull((String)"queue", (Object)launcherConf.get("queue"));
        TestLauncherConfigurationInjector.assertEquals((String)"view ACL", (String)"view", (String)launcherConf.get("oozie.launcher.view.acl"));
        TestLauncherConfigurationInjector.assertEquals((String)"modify ACL", (String)"modify", (String)launcherConf.get("oozie.launcher.modify.acl"));
    }

    public void testMultipleOverrideOrder() {
        Configuration sourceConf = SourceConfigurationFactory.createMultipleOverridingEntries();
        Configuration launcherConf = TestLauncherConfigurationInjector.newConfigurationWithoutDefaults();
        new LauncherConfigurationInjector(sourceConf).inject(launcherConf);
        this.assertHigherRankingOverridingAndNoDefaultEntries(launcherConf);
    }

    public void testPrependLauncherConfigSourcePrependedToTarget() {
        Configuration sourceConf = SourceConfigurationFactory.createPrependingAndLauncherEntries();
        Configuration launcherConf = TestLauncherConfigurationInjector.newConfigurationWithoutDefaults();
        new LauncherConfigurationInjector(sourceConf).inject(launcherConf);
        this.assertPrependedLauncherAndDefaultEntries(launcherConf);
    }

    private void assertPrependedLauncherAndDefaultEntries(Configuration launcherConf) {
        TestLauncherConfigurationInjector.assertTrue((String)"launcher java opts", (boolean)launcherConf.get("oozie.launcher.javaopts").contains("-XX:+UseParNewGC -XX:MaxPermSize=128m"));
        TestLauncherConfigurationInjector.assertTrue((String)"java opts", (boolean)launcherConf.get("javaopts").contains("-XX:MaxPermSize=128m"));
        TestLauncherConfigurationInjector.assertFalse((String)"java opts", (boolean)launcherConf.get("javaopts").contains("-XX:+UseParNewGC"));
        TestLauncherConfigurationInjector.assertTrue((String)"launcher env", (boolean)launcherConf.get("oozie.launcher.env").contains("ENV=env:$ENV PATH=/path2:$PATH"));
        TestLauncherConfigurationInjector.assertTrue((String)"env", (boolean)launcherConf.get("env").contains("PATH=/path2:$PATH"));
        TestLauncherConfigurationInjector.assertFalse((String)"env", (boolean)launcherConf.get("env").contains("ENV=env:$ENV"));
    }

    private static class SourceConfigurationFactory {
        private SourceConfigurationFactory() {
        }

        private static Configuration createOverridingAndLauncherEntries() {
            Configuration sourceConf = TestLauncherConfigurationInjector.newConfigurationWithDefaults();
            sourceConf.set("mapreduce.map.maxattempts", "4");
            sourceConf.set("oozie.launcher.max.attempts", "1");
            sourceConf.set("yarn.app.mapreduce.am.resource.mb", "2048");
            sourceConf.set("oozie.launcher.memory.mb", "512");
            sourceConf.set("yarn.app.mapreduce.am.resource.cpu-vcores", "16");
            sourceConf.set("oozie.launcher.vcores", "4");
            sourceConf.set("mapreduce.map.log.level", "TRACE");
            sourceConf.set("oozie.launcher.log.level", "DEBUG");
            sourceConf.set("yarn.app.mapreduce.am.command-opts", "-XX:MaxPermSize=256m");
            sourceConf.set("oozie.launcher.javaopts", "-XX:MaxPermSize=128m");
            sourceConf.set("yarn.app.mapreduce.am.env", "PATH=/path1:$PATH");
            sourceConf.set("oozie.launcher.env", "PATH=/path2:$PATH");
            sourceConf.set("mapreduce.job.priority", "1");
            sourceConf.set("oozie.launcher.priority", "2");
            sourceConf.set("mapreduce.job.queuename", "default1");
            sourceConf.set("oozie.launcher.queue", "default2");
            return sourceConf;
        }

        private static Configuration createLauncherEntries() {
            Configuration sourceConf = TestLauncherConfigurationInjector.newConfigurationWithDefaults();
            sourceConf.set("oozie.launcher.max.attempts", "1");
            sourceConf.set("oozie.launcher.memory.mb", "512");
            sourceConf.set("oozie.launcher.vcores", "4");
            sourceConf.set("oozie.launcher.log.level", "DEBUG");
            sourceConf.set("oozie.launcher.javaopts", "-XX:MaxPermSize=128m");
            sourceConf.set("oozie.launcher.env", "PATH=/path2:$PATH");
            sourceConf.set("oozie.launcher.priority", "2");
            sourceConf.set("oozie.launcher.queue", "default2");
            return sourceConf;
        }

        private static Configuration createOverridingEntries() {
            Configuration sourceConf = TestLauncherConfigurationInjector.newConfigurationWithDefaults();
            sourceConf.set("mapreduce.map.maxattempts", "4");
            sourceConf.set("yarn.app.mapreduce.am.resource.mb", "2048");
            sourceConf.set("yarn.app.mapreduce.am.resource.cpu-vcores", "16");
            sourceConf.set("mapreduce.map.log.level", "TRACE");
            sourceConf.set("yarn.app.mapreduce.am.command-opts", "-XX:MaxPermSize=256m");
            sourceConf.set("yarn.app.mapreduce.am.env", "PATH=/path1:$PATH");
            sourceConf.set("mapreduce.job.priority", "1");
            sourceConf.set("mapreduce.job.queuename", "default1");
            sourceConf.set("mapreduce.job.acl-view-job", "view");
            sourceConf.set("mapreduce.job.acl-modify-job", "modify");
            return sourceConf;
        }

        private static Configuration createMultipleOverridingEntries() {
            Configuration sourceConf = TestLauncherConfigurationInjector.newConfigurationWithDefaults();
            sourceConf.set("mapred.map.max.attempts", "5");
            sourceConf.set("mapreduce.map.maxattempts", "4");
            sourceConf.set("mapred.job.map.memory.mb", "2050");
            sourceConf.set("mapreduce.map.memory.mb", "2049");
            sourceConf.set("yarn.app.mapreduce.am.resource.mb", "2048");
            sourceConf.set("mapreduce.map.cpu.vcores", "17");
            sourceConf.set("yarn.app.mapreduce.am.resource.cpu-vcores", "16");
            sourceConf.set("mapred.map.child.log.level", "DEBUG");
            sourceConf.set("mapreduce.map.log.level", "TRACE");
            sourceConf.set("mapred.child.java.opts", "-XX:MaxPermSize=258m");
            sourceConf.set("mapreduce.map.java.opts", "-XX:MaxPermSize=257m");
            sourceConf.set("yarn.app.mapreduce.am.command-opts", "-XX:MaxPermSize=256m");
            sourceConf.set("mapred.child.env", "PATH=/path3:$PATH");
            sourceConf.set("mapreduce.map.env", "PATH=/path2:$PATH");
            sourceConf.set("yarn.app.mapreduce.am.env", "PATH=/path1:$PATH");
            sourceConf.set("mapred.job.priority", "2");
            sourceConf.set("mapreduce.job.priority", "1");
            sourceConf.set("mapred.job.queue.name", "default2");
            sourceConf.set("mapreduce.job.queuename", "default1");
            sourceConf.set("mapreduce.job.acl-view-job", "view");
            sourceConf.set("mapreduce.job.acl-modify-job", "modify");
            return sourceConf;
        }

        private static Configuration createPrependingAndLauncherEntries() {
            Configuration sourceConf = TestLauncherConfigurationInjector.newConfigurationWithDefaults();
            sourceConf.set("yarn.app.mapreduce.am.admin-command-opts", "-XX:+UseParNewGC");
            sourceConf.set("oozie.launcher.javaopts", "-XX:MaxPermSize=128m");
            sourceConf.set("yarn.app.mapreduce.am.admin.user.env", "ENV=env:$ENV");
            sourceConf.set("oozie.launcher.env", "PATH=/path2:$PATH");
            return sourceConf;
        }
    }
}

