/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.LauncherAMUtils;
import org.apache.oozie.action.hadoop.MainTestCase;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.oozie.util.XConfiguration;

public class TestMapReduceMain
extends MainTestCase {
    @Override
    public Void call() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path inputDir = new Path(this.getFsTestCaseDir(), "input");
        fs.mkdirs(inputDir);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "data.txt")));
        writer.write("hello");
        ((Writer)writer).close();
        Path outputDir = new Path(this.getFsTestCaseDir(), "output");
        XConfiguration jobConf = new XConfiguration();
        XConfiguration.copy((Configuration)this.createJobConf(), (Configuration)jobConf);
        jobConf.setInt("mapred.map.tasks", 1);
        jobConf.setInt("mapred.map.max.attempts", 1);
        jobConf.setInt("mapred.reduce.max.attempts", 1);
        jobConf.set("mapred.input.dir", inputDir.toString());
        jobConf.set("mapred.output.dir", outputDir.toString());
        jobConf.set("user.name", TestMapReduceMain.getTestUser());
        jobConf.set("hadoop.job.ugi", TestMapReduceMain.getTestUser() + "," + TestMapReduceMain.getTestGroup());
        jobConf.set("mapreduce.job.tags", "" + System.currentTimeMillis());
        this.setSystemProperty("oozie.job.launch.time", "" + System.currentTimeMillis());
        File actionXml = new File(this.getTestCaseDir(), "action.xml");
        FileOutputStream os = new FileOutputStream(actionXml);
        jobConf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        File newId = new File(this.getTestCaseDir(), "newId");
        System.setProperty("oozie.action.conf.xml", actionXml.getAbsolutePath());
        System.setProperty("oozie.action.newId", newId.getAbsolutePath());
        MapReduceMain.main((String[])new String[0]);
        TestMapReduceMain.assertTrue((boolean)newId.exists());
        TestMapReduceMain.assertNotNull((Object)LauncherAMUtils.getLocalFileContentStr((File)newId, (String)"", (int)-1));
        return null;
    }
}

