/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.MapReduceActionExecutor;
import org.apache.oozie.action.hadoop.MapperReducerForTest;
import org.apache.oozie.action.hadoop.OozieJobInfo;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.bundle.BundleStartXCommand;
import org.apache.oozie.command.bundle.BundleSubmitXCommand;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionsGetForJobJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsGetFromCoordParentIdJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;

public class TestOozieJobInfo
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testInfoWithBundle() throws Exception {
        Services.get().getConf().setBoolean("oozie.action.jobinfo.enable", true);
        OozieJobInfo.setJobInfo((boolean)true);
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        XConfiguration jobConf = null;
        try {
            jobConf = new XConfiguration((Reader)new StringReader(job.getConf()));
        }
        catch (IOException ioe) {
            this.log.warn((Object)("Configuration parse error. read from DB :" + job.getConf()), (Throwable)ioe);
            throw new CommandException(ErrorCode.E1005, new Object[]{ioe});
        }
        this.setCoordConf((Configuration)jobConf);
        Path appPath = new Path(jobConf.get("oozie.bundle.application.path"), "bundle.xml");
        jobConf.set("oozie.bundle.application.path", appPath.toString());
        BundleSubmitXCommand submitCmd = new BundleSubmitXCommand((Configuration)jobConf);
        submitCmd.call();
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(submitCmd.getJob().getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestOozieJobInfo.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREP);
        new BundleStartXCommand(job.getId()).call();
        this.sleep(2000);
        List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{job.getId()});
        TestOozieJobInfo.assertEquals((int)1, (int)actions.size());
        final String bundleID = job.getId();
        this.waitFor(200000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{bundleID});
                return ((BundleActionBean)actions.get(0)).getStatus().equals((Object)Job.Status.RUNNING);
            }
        });
        actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{job.getId()});
        final String cordID = ((BundleActionBean)actions.get(0)).getCoordId();
        this.waitFor(200000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordJobGetJPAExecutor coordGetCmd2 = new CoordJobGetJPAExecutor(cordID);
                CoordinatorJobBean cc = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd2);
                return cc.getStatus().equals((Object)Job.Status.RUNNING);
            }
        });
        String jobID = (String)((List)jpaService.execute((JPAExecutor)new WorkflowJobsGetFromCoordParentIdJPAExecutor(cordID, 1))).get(0);
        final WorkflowActionsGetForJobJPAExecutor actionsGetExecutor = new WorkflowActionsGetForJobJPAExecutor(jobID);
        this.waitFor(200000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                List actions = (List)jpaService.execute((JPAExecutor)actionsGetExecutor);
                WorkflowActionBean action = null;
                for (WorkflowActionBean bean : actions) {
                    if (!bean.getName().contains("hadoop")) continue;
                    action = bean;
                    break;
                }
                return action.getStatus().toString().equalsIgnoreCase(Job.Status.RUNNING.toString());
            }
        });
        WorkflowJobGetJPAExecutor wfeExc = new WorkflowJobGetJPAExecutor(jobID);
        WorkflowJobBean wfbean = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfeExc);
        List actionList = (List)jpaService.execute((JPAExecutor)actionsGetExecutor);
        ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(wfbean, (WorkflowActionBean)actionList.get(1), false, false);
        MapReduceActionExecutor actionExecutor = new MapReduceActionExecutor();
        Configuration conf = actionExecutor.createBaseHadoopConf((ActionExecutor.Context)context, XmlUtils.parseXml((String)((WorkflowActionBean)actionList.get(1)).getConf()));
        String user = conf.get("user.name");
        FileSystem fs = this.getFileSystem();
        XConfiguration jobXmlConf = new XConfiguration((InputStream)fs.open(this.getPathToWorkflowResource(user, (WorkflowJob)wfbean, this.services, context, "launcher.xml")));
        String jobInfo = jobXmlConf.get("oozie.job.info");
        TestOozieJobInfo.assertEquals((int)jobInfo.split(",").length, (int)13);
        TestOozieJobInfo.assertTrue((boolean)jobInfo.contains(bundleID));
        TestOozieJobInfo.assertTrue((boolean)jobInfo.contains("bundle.name=test_bundle,"));
        TestOozieJobInfo.assertTrue((boolean)jobInfo.contains(cordID));
        TestOozieJobInfo.assertTrue((boolean)jobInfo.contains("action.type=map-reduce"));
        TestOozieJobInfo.assertTrue((boolean)jobInfo.contains("wf.depth=0"));
        TestOozieJobInfo.assertTrue((boolean)jobInfo.contains("wf.superparent.id=" + cordID));
        TestOozieJobInfo.assertTrue((boolean)jobInfo.contains(",testing=test,"));
        TestOozieJobInfo.assertTrue((boolean)jobInfo.contains(",coord.nominal.time="));
        TestOozieJobInfo.assertTrue((boolean)jobInfo.contains("launcher=true"));
    }

    protected void setCoordConf(Configuration jobConf) throws IOException {
        Path wfAppPath = new Path(this.getFsTestCaseDir(), "app");
        FileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path(wfAppPath, "lib"));
        File jarFile = IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)"test.jar", (Class[])new Class[]{MapperReducerForTest.class});
        FileInputStream is = new FileInputStream(jarFile);
        FSDataOutputStream os = fs.create(new Path(wfAppPath, "lib/test.jar"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        Path input = new Path(wfAppPath, "input");
        fs.mkdirs(input);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(input, "test.txt")));
        writer.write("hello");
        ((Writer)writer).close();
        String APP1 = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='app'><start to='hadoop'/><action name=\"hadoop\"><map-reduce><job-tracker>${jobTracker}</job-tracker><name-node>${nameNode}</name-node><configuration><property><name>mapred.map.tasks</name><value>1</value></property><property><name>mapred.reduce.tasks</name><value>0</value></property><property><name>oozie.job.info.testing</name><value>test</value></property></configuration></map-reduce><ok to=\"end\"/><error to=\"k\"/></action><kill name=\"k\"><message>kill</message></kill><end name=\"end\"/></workflow-app>";
        OutputStreamWriter writer2 = new OutputStreamWriter((OutputStream)fs.create(new Path(wfAppPath, "workflow.xml")));
        writer2.write("<workflow-app xmlns='uri:oozie:workflow:0.1' name='app'><start to='hadoop'/><action name=\"hadoop\"><map-reduce><job-tracker>${jobTracker}</job-tracker><name-node>${nameNode}</name-node><configuration><property><name>mapred.map.tasks</name><value>1</value></property><property><name>mapred.reduce.tasks</name><value>0</value></property><property><name>oozie.job.info.testing</name><value>test</value></property></configuration></map-reduce><ok to=\"end\"/><error to=\"k\"/></action><kill name=\"k\"><message>kill</message></kill><end name=\"end\"/></workflow-app>");
        ((Writer)writer2).close();
        jobConf.set("user.name", TestOozieJobInfo.getTestUser());
        jobConf.set("myJobTracker", this.getJobTrackerUri());
        jobConf.set("myNameNode", this.getNameNodeUri());
        jobConf.set("wfAppPath", new Path(wfAppPath, "workflow.xml").toString());
        jobConf.set("mrclass", MapperReducerForTest.class.getName());
    }

    @Override
    protected BundleJobBean createBundleJob(Job.Status jobStatus, boolean pending) throws Exception {
        Path coordPath1 = new Path(this.getFsTestCaseDir(), "coord1");
        String coord = "<coordinator-app name='COORD-TEST' frequency='${coord:days(1)}' start=\"${START_TIME}\" end=\"${END_TIME}\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"><controls><concurrency>2</concurrency><execution>LIFO</execution></controls><action><workflow><app-path>${wfAppPath}</app-path><configuration><property><name>inputA</name><value>aaaa</value></property></configuration></workflow> </action></coordinator-app>";
        this.writeToFile(coord, coordPath1, "coordinator.xml");
        Path bundleAppPath = new Path(this.getFsTestCaseDir(), "bundle");
        String bundleAppXml = "<bundle-app name='test_bundle' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns='uri:oozie:bundle:0.1'> <controls> <kick-off-time>2009-02-02T00:00Z</kick-off-time> </controls> <coordinator name='c12'> <app-path>#app_path1</app-path><configuration> <property> <name>START_TIME</name> <value>2009-02-01T00:00Z</value> </property> </configuration> </coordinator></bundle-app>";
        bundleAppXml = bundleAppXml.replaceAll("#app_path1", Matcher.quoteReplacement(new Path(coordPath1.toString(), "coordinator.xml").toString()));
        this.writeToFile(bundleAppXml, bundleAppPath, "bundle.xml");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.bundle.application.path", bundleAppPath.toString());
        conf.set("user.name", TestOozieJobInfo.getTestUser());
        conf.set("jobTracker", this.getJobTrackerUri());
        conf.set("nameNode", this.getNameNodeUri());
        conf.set("appName", "bundle-app-name");
        conf.set("start", "2009-02-01T00:00Z");
        conf.set("end", "2009-02-01T00:00Z");
        conf.set("START_TIME", "2009-02-01T00:00Z");
        conf.set("END_TIME", "2009-03-01T00:00Z");
        this.setCoordConf((Configuration)conf);
        BundleJobBean bundle = new BundleJobBean();
        bundle.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.BUNDLE));
        bundle.setAppName("BUNDLE-TEST");
        bundle.setAppPath(bundleAppPath.toString());
        bundle.setConf(XmlUtils.prettyPrint((Configuration)conf).toString());
        bundle.setConsoleUrl("consoleUrl");
        bundle.setCreatedTime(new Date());
        bundle.setJobXml(bundleAppXml);
        bundle.setLastModifiedTime(new Date());
        bundle.setOrigJobXml(bundleAppXml);
        if (pending) {
            bundle.setPending();
        } else {
            bundle.resetPending();
        }
        bundle.setStatus(jobStatus);
        bundle.setUser(conf.get("user.name"));
        return bundle;
    }
}

