/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.action.hadoop.LauncherException;
import org.apache.oozie.action.hadoop.LauncherHelper;
import org.apache.oozie.action.hadoop.PrepareActionsDriver;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XFsTestCase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestPrepareActionsDriver
extends XFsTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        new Services().init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    public void testDoOperationsWithValidXML() throws LauncherException, IOException, ParserConfigurationException, SAXException {
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        Path newDir = new Path(actionDir, "newDir");
        String prepareXML = "<prepare><mkdir path='" + newDir + "'/></prepare>";
        if (fs.exists(newDir)) {
            fs.delete(newDir, true);
        }
        JobConf conf = this.createJobConf();
        LauncherHelper.setupLauncherURIHandlerConf((Configuration)conf);
        PrepareActionsDriver.doOperations((String)prepareXML, (Configuration)conf);
        TestPrepareActionsDriver.assertTrue((boolean)fs.exists(actionDir));
    }

    public void testDoOperationsWithInvalidXML() throws LauncherException, IOException {
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        Path newDir = new Path(actionDir, "newDir");
        String prepareXML = "";
        if (fs.exists(newDir)) {
            fs.delete(newDir, true);
        }
        try {
            prepareXML = "prepare><mkdir path='" + newDir + "'/></prepare>";
            JobConf conf = this.createJobConf();
            LauncherHelper.setupLauncherURIHandlerConf((Configuration)conf);
            PrepareActionsDriver.doOperations((String)prepareXML, (Configuration)conf);
            TestPrepareActionsDriver.fail((String)"Expected to catch an exception but did not encounter any");
        }
        catch (Exception ex) {
            TestPrepareActionsDriver.assertEquals(ex.getClass(), SAXParseException.class);
            TestPrepareActionsDriver.assertEquals((String)ex.getMessage(), (String)"Content is not allowed in prolog.");
        }
    }
}

