/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.ScriptLanguageActionExecutor;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.jdom.Element;
import org.jdom.Namespace;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Services.class})
public class TestScriptLanguageActionExecutor {
    @Mock
    private ActionExecutor.Context mockContext;
    @Mock
    private Element mockScript;
    @Mock
    private Element mockElement;
    @Mock
    private Path mockPath;
    @Mock
    private Configuration mockConfiguration;
    @Mock
    private FSDataOutputStream fsDataOutputStream;
    @Mock
    private FileSystem mockFs;
    @Mock
    private Configuration mockActionConfig;
    @Mock
    private Services mockServices;

    @Before
    public void setup() throws ServiceException {
        PowerMockito.mockStatic(Services.class, (Class[])new Class[0]);
        PowerMockito.when((Object)Services.get()).thenReturn((Object)this.mockServices);
        ((Services)Mockito.doReturn((Object)this.mockConfiguration).when((Object)this.mockServices)).getConf();
    }

    @Test
    public void multibyteInputsAreAcceptedInScripts() throws Exception {
        String testInput = "\u6797\u6a8e";
        ((Element)Mockito.doReturn((Object)this.mockScript).when((Object)this.mockElement)).getChild(Matchers.anyString(), (Namespace)Matchers.any(Namespace.class));
        ((Element)Mockito.doReturn((Object)"script").when((Object)this.mockScript)).getTextTrim();
        ((ActionExecutor.Context)Mockito.doReturn((Object)this.mockActionConfig).when((Object)this.mockContext)).getProtoActionConf();
        ((Configuration)Mockito.doReturn((Object)"\u6797\u6a8e").when((Object)this.mockActionConfig)).get(Matchers.anyString());
        ((ActionExecutor.Context)Mockito.doReturn((Object)new Path(".")).when((Object)this.mockContext)).getActionDir();
        ((ActionExecutor.Context)Mockito.doReturn((Object)this.mockFs).when((Object)this.mockContext)).getAppFileSystem();
        ((FileSystem)Mockito.doReturn((Object)this.fsDataOutputStream).when((Object)this.mockFs)).create((Path)Matchers.any(Path.class));
        ScriptLanguageActionExecutor scriptLanguageActionExecutor = (ScriptLanguageActionExecutor)Mockito.spy((Object)new ScriptLanguageActionExecutor("pig"){

            protected String getScriptName() {
                return null;
            }
        });
        scriptLanguageActionExecutor.addScriptToCache(this.mockConfiguration, this.mockElement, this.mockPath, this.mockContext);
        byte[] expectedInput = "\u6797\u6a8e".getBytes(StandardCharsets.UTF_8);
        ((FSDataOutputStream)Mockito.verify((Object)this.fsDataOutputStream)).write(expectedInput);
    }

    @After
    public void cleanUp() {
        Services.get().destroy();
    }
}

