/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import org.apache.oozie.action.hadoop.TestWorkflowHelper;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.test.MiniOozieTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jdom.Element;
import org.junit.Assert;

public class TestSharelibConfigs
extends MiniOozieTestCase {
    private TestWorkflowHelper helper;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.helper = new TestWorkflowHelper(this.getJobTrackerUri(), this.getNameNodeUri(), this.getTestCaseDir());
    }

    public void testActionSharelibConfigPropagation() throws Exception {
        String globalConfigForJavaSharelib = "<global><configuration><property><name>oozie.action.sharelib.for.java</name><value>globalJavaConfigSharelib</value></property></configuration></global>";
        String globalLauncherWithSharelib = "<global><launcher><sharelib>globalLauncherSharelib</sharelib></launcher></global>";
        String globalLauncherAndConfigWithSharelib = "<global><launcher><sharelib>globalLauncherSharelib</sharelib></launcher><configuration><property><name>oozie.action.sharelib.for.java</name><value>globalJavaConfigSharelib</value></property></configuration></global>";
        String localConfigForJavaSharelib = "<configuration><property><name>oozie.action.sharelib.for.java</name><value>localJavaConfigSharelib</value></property></configuration>";
        String localLauncherWithSharelib = "<launcher><sharelib>localLauncherSharelib</sharelib></launcher>";
        this.launchJavaActionAndValidateSharelibValues("", "", null, null);
        this.launchJavaActionAndValidateSharelibValues("<global><configuration><property><name>oozie.action.sharelib.for.java</name><value>globalJavaConfigSharelib</value></property></configuration></global>", "", "globalJavaConfigSharelib", null);
        this.launchJavaActionAndValidateSharelibValues("<global><launcher><sharelib>globalLauncherSharelib</sharelib></launcher></global>", "", null, "globalLauncherSharelib");
        this.launchJavaActionAndValidateSharelibValues("<global><launcher><sharelib>globalLauncherSharelib</sharelib></launcher><configuration><property><name>oozie.action.sharelib.for.java</name><value>globalJavaConfigSharelib</value></property></configuration></global>", "<configuration><property><name>oozie.action.sharelib.for.java</name><value>localJavaConfigSharelib</value></property></configuration>", "localJavaConfigSharelib", "globalLauncherSharelib");
        this.launchJavaActionAndValidateSharelibValues("<global><launcher><sharelib>globalLauncherSharelib</sharelib></launcher><configuration><property><name>oozie.action.sharelib.for.java</name><value>globalJavaConfigSharelib</value></property></configuration></global>", "<launcher><sharelib>localLauncherSharelib</sharelib></launcher>", "globalJavaConfigSharelib", "localLauncherSharelib");
        this.launchJavaActionAndValidateSharelibValues("<global><launcher><sharelib>globalLauncherSharelib</sharelib></launcher><configuration><property><name>oozie.action.sharelib.for.java</name><value>globalJavaConfigSharelib</value></property></configuration></global>", "<launcher><sharelib>localLauncherSharelib</sharelib></launcher><configuration><property><name>oozie.action.sharelib.for.java</name><value>localJavaConfigSharelib</value></property></configuration>", "localJavaConfigSharelib", "localLauncherSharelib");
    }

    private void launchJavaActionAndValidateSharelibValues(String globalConfig, String localConfig, String oozieSharelibForJavaPropertyValue, String oozieSharelibPropertyValue) throws Exception {
        String workflowUri = this.helper.createTestWorkflowXml(globalConfig, this.helper.getJavaActionXml(localConfig));
        final OozieClient wfClient = LocalOozie.getClient();
        Properties conf = wfClient.createConfiguration();
        conf.setProperty("oozie.wf.application.path", workflowUri);
        conf.setProperty("user.name", TestSharelibConfigs.getTestUser());
        conf.setProperty("appName", "var-app-name");
        conf.setProperty("oozie.use.system.libpath", "true");
        final String jobId = wfClient.submit(conf);
        wfClient.start(jobId);
        WorkflowJob workflow = wfClient.getJobInfo(jobId);
        this.waitFor(20000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowAction javaAction = TestSharelibConfigs.this.helper.getJavaAction(wfClient.getJobInfo(jobId));
                return javaAction != null && !javaAction.getStatus().equals((Object)"PREP");
            }
        });
        XConfiguration actionConf = this.getJavaActionConfiguration(workflow);
        Assert.assertThat((String)"Configuration priorities are incorrect! Global/local configs are not overwriting each other.", (Object)actionConf.get("oozie.launcher.sharelib"), (Matcher)Is.is((Object)oozieSharelibPropertyValue));
        Assert.assertThat((String)"Configuration priorities are incorrect! Global/local configs are not overwriting each other.", (Object)actionConf.get("oozie.action.sharelib.for.java"), (Matcher)Is.is((Object)oozieSharelibForJavaPropertyValue));
    }

    private XConfiguration getJavaActionConfiguration(WorkflowJob workflow) throws Exception {
        WorkflowAction workflowAction = this.helper.getJavaAction(workflow);
        Element element = XmlUtils.parseXml((String)workflowAction.getConf());
        String configuration = XmlUtils.prettyPrint((Element)element.getChild("configuration", element.getNamespace())).toString();
        return new XConfiguration((Reader)new StringReader(configuration));
    }
}

