/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.SharelibResolver;
import org.apache.oozie.util.XConfiguration;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class TestSharelibResolver {
    public final String defaultValue = "default";
    private final String serverConfigSharelib = "serverConfigSharelib";
    private final String globalConfigSharelib = "globalConfigSharelib";
    private final String globalLauncherSharelib = "globalLauncherSharelib";
    private final String localConfigSharelib = "localConfigSharelib";
    private final String localLauncherSharelib = "localLauncherSharelib";
    private final String sharelibProperty = "sharelibProperty";

    @Test
    public void testResolvingOrder() {
        Configuration oozieServerConfiguration = new Configuration(false);
        XConfiguration workflowConf = new XConfiguration();
        Configuration actionConf = new Configuration(false);
        SharelibResolver resolver = new SharelibResolver("sharelibProperty", actionConf, workflowConf, oozieServerConfiguration, "default");
        Assert.assertThat((String)"Without setting anything we should've got the default value.", (Object)resolver.resolve(), (Matcher)Is.is((Object)new String[]{"default"}));
        oozieServerConfiguration.set("sharelibProperty", "serverConfigSharelib");
        Assert.assertThat((String)"Server-level sharelib configuration is not processed", (Object)resolver.resolve(), (Matcher)Is.is((Object)new String[]{"serverConfigSharelib"}));
        workflowConf.set("sharelibProperty", "globalConfigSharelib");
        Assert.assertThat((String)"Global workflow-level sharelib configuration is not processed", (Object)resolver.resolve(), (Matcher)Is.is((Object)new String[]{"globalConfigSharelib"}));
        workflowConf.set("oozie.launcher.sharelib", "globalLauncherSharelib");
        Assert.assertThat((String)"Global workflow-level sharelib configuration is not processed", (Object)resolver.resolve(), (Matcher)Is.is((Object)new String[]{"globalLauncherSharelib"}));
        actionConf.set("sharelibProperty", "localConfigSharelib");
        Assert.assertThat((String)"Local action-level sharelib configuration is not processed", (Object)resolver.resolve(), (Matcher)Is.is((Object)new String[]{"localConfigSharelib"}));
        actionConf.set("oozie.launcher.sharelib", "localLauncherSharelib");
        Assert.assertThat((String)"Local action-level sharelib configuration is not processed", (Object)resolver.resolve(), (Matcher)Is.is((Object)new String[]{"localLauncherSharelib"}));
    }
}

