/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import org.apache.oozie.action.hadoop.ShellContentWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestShellContentWriter {
    public static final int MAX_TEST_SCRIPT_SIZE_KB = 128;
    ByteArrayOutputStream outputStream;
    ByteArrayOutputStream errorStream;
    File scriptFile;
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Before
    public void setUp() throws IOException {
        this.outputStream = new ByteArrayOutputStream(128);
        this.errorStream = new ByteArrayOutputStream(128);
        this.scriptFile = this.folder.newFile("shell_script.sh");
    }

    @Test
    public void testPrintShellFile() throws Exception {
        this.writeScript("echo Hello World");
        Assert.assertTrue((boolean)this.outputStream.toString().contains("echo Hello World"));
        Assert.assertTrue((boolean)this.errorStream.toString().isEmpty());
    }

    @Test
    public void testPrintShellNullByte() throws Exception {
        this.writeScript("echo Hello World\u0000");
        Assert.assertFalse((boolean)this.outputStream.toString().contains("Hello World"));
        Assert.assertTrue((boolean)this.errorStream.toString().contains("appears to be a binary file"));
    }

    @Test
    public void testPrintControlCharacter() throws Exception {
        this.writeScript("echo Hello World\t");
        Assert.assertFalse((boolean)this.outputStream.toString().contains("Hello World"));
        Assert.assertTrue((boolean)this.errorStream.toString().contains("appears to be a binary file"));
    }

    @Test
    public void testEmptyFile() throws Exception {
        this.writeScript("");
        Assert.assertTrue((boolean)this.outputStream.toString().contains("---\n\n---"));
        Assert.assertTrue((boolean)this.errorStream.toString().isEmpty());
    }

    @Test
    public void testTooLargeFile() throws Exception {
        byte[] arr = new byte[2048];
        Arrays.fill(arr, (byte)Character.getNumericValue('x'));
        this.writeScript(new String(arr));
        Assert.assertTrue((boolean)this.outputStream.toString().isEmpty());
        Assert.assertTrue((boolean)this.errorStream.toString().contains("content suppressed."));
        Assert.assertTrue((boolean)this.errorStream.toString().contains("File size=2048b; max printable size=1024b"));
    }

    @Test
    public void testNegativeMaxSize() throws Exception {
        this.writeScript("test script", -1);
        Assert.assertTrue((boolean)this.outputStream.toString().isEmpty());
        Assert.assertTrue((boolean)this.errorStream.toString().contains("Not printing script file as configured, content suppressed."));
    }

    @Test
    public void testMissingFile() throws Exception {
        this.scriptFile.delete();
        this.writeScript("");
        Assert.assertTrue((boolean)this.outputStream.toString().isEmpty());
        Assert.assertTrue((boolean)this.errorStream.toString().contains("doesn't appear to exist"));
    }

    private void writeScript(String content) throws IOException {
        this.writeScript(content, 1);
    }

    private void writeScript(String content, int maxLen) throws IOException {
        if (content != null && !content.isEmpty()) {
            Files.write(this.scriptFile.toPath(), content.getBytes(), new OpenOption[0]);
        }
        ShellContentWriter writer = new ShellContentWriter(maxLen, (OutputStream)this.outputStream, (OutputStream)this.errorStream, this.scriptFile.getAbsolutePath());
        writer.print();
    }
}

