/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.ActionUtils;
import org.apache.oozie.action.hadoop.LauncherMainException;
import org.apache.oozie.action.hadoop.ShellMain;
import org.apache.oozie.action.hadoop.ShellTestCase;
import org.apache.oozie.util.XConfiguration;

public class TestShellMain
extends ShellTestCase {
    @Override
    public Void call() throws Exception {
        block3: {
            File script = new File(this.getTestCaseDir(), scriptName);
            FileWriter w = new FileWriter(script);
            w.write(scriptContent);
            ((Writer)w).close();
            script.setExecutable(true);
            XConfiguration jobConf = new XConfiguration();
            jobConf.set("user.name", TestShellMain.getTestUser());
            jobConf.set("group.name", TestShellMain.getTestGroup());
            jobConf.setInt("mapred.map.tasks", 1);
            jobConf.setInt("mapred.map.max.attempts", 1);
            jobConf.setInt("mapred.reduce.max.attempts", 1);
            jobConf.set("mapred.job.tracker", this.getJobTrackerUri());
            jobConf.set("fs.default.name", this.getNameNodeUri());
            jobConf.setLong("oozie.job.launch.time", System.currentTimeMillis());
            jobConf.set("oozie.shell.exec", SHELL_COMMAND_NAME);
            String[] args = new String[]{SHELL_COMMAND_SCRIPTFILE_OPTION, script.toString(), "A", "B"};
            ActionUtils.setStrings((Configuration)jobConf, (String)"oozie.shell.args", (String[])args);
            ActionUtils.setStrings((Configuration)jobConf, (String)"oozie.shell.envs", (String[])new String[]{"var1=value1", "var2=value2"});
            File actionXml = new File(this.getTestCaseDir(), "action.xml");
            FileOutputStream os = new FileOutputStream(actionXml);
            jobConf.writeXml((OutputStream)os);
            os.close();
            this.setSystemProperty("oozie.launcher.job.id", "" + System.currentTimeMillis());
            this.setSystemProperty("oozie.action.conf.xml", actionXml.getAbsolutePath());
            Properties props = jobConf.toProperties();
            TestShellMain.assertEquals((String)props.getProperty("oozie.shell.args.size"), (String)"4");
            TestShellMain.assertEquals((String)props.getProperty("oozie.shell.envs.size"), (String)"2");
            try {
                ShellMain.main(null);
                if (!this.expectedSuccess) {
                    TestShellMain.fail((String)"Expected to fail");
                }
            }
            catch (LauncherMainException le) {
                if (!this.expectedSuccess) break block3;
                TestShellMain.fail((String)"Should be successful");
            }
        }
        return null;
    }
}

