/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.util.IOUtils;

public class TestWorkflowHelper {
    private final String jobTrackerUri;
    private final String nameNodeUri;
    private final String testCaseDir;

    public TestWorkflowHelper(String jobTrackerUri, String nameNodeUri, String testCaseDir) {
        this.jobTrackerUri = jobTrackerUri;
        this.nameNodeUri = nameNodeUri;
        this.testCaseDir = testCaseDir;
    }

    protected String getJavaActionXml(String configToAdd) {
        return "<java><job-tracker>" + this.jobTrackerUri + "</job-tracker><name-node>" + this.nameNodeUri + "</name-node>" + configToAdd + "<main-class>MAIN-CLASS</main-class></java>";
    }

    protected String createTestWorkflowXml(String globalXml, String actionXml) throws IOException {
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = "<workflow-app xmlns=\"uri:oozie:workflow:1.0\" name=\"workflow\">" + globalXml + "<start to=\"java\"/><action name=\"java\">" + actionXml + "     <ok to=\"end\"/>     <error to=\"fail\"/></action><kill name=\"fail\">     <message>Sub workflow failed, error message[${wf:errorMessage(wf:lastErrorNode())}]</message></kill><end name=\"end\"/></workflow-app>";
        File f = new File(URI.create(workflowUri));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(appXml.getBytes("UTF-8"));
        IOUtils.copyStream((InputStream)inputStream, (OutputStream)new FileOutputStream(f));
        return workflowUri;
    }

    protected WorkflowAction getJavaAction(WorkflowJob workflowJob) {
        List actions = workflowJob.getActions();
        for (WorkflowAction wa : actions) {
            if (!wa.getType().equals("java")) continue;
            return wa;
        }
        return null;
    }

    private String getTestCaseFileUri(String relativeUri) {
        String uri = new File(this.testCaseDir).toURI().toString();
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return uri + "/" + relativeUri;
    }
}

