/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.oozie.action.hadoop.YarnACLHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestYarnACLHandler {
    private static final String VIEW_ACL_VALUE = "viewacl";
    private static final String MODIFY_ACL_VALUE = "modifyacl";
    private YarnACLHandler yarnACLSetter;
    private Configuration launcherConfig;
    @Mock
    private ContainerLaunchContext contextMock;
    @Captor
    private ArgumentCaptor<Map<ApplicationAccessType, String>> captor;

    @Test
    public void testViewACLisSet() {
        this.setupYarnACLHandler(true);
        this.setViewACL();
        this.yarnACLSetter.setACLs(this.contextMock);
        this.assertViewACLset();
    }

    @Test
    public void testModifyACLisSet() {
        this.setupYarnACLHandler(true);
        this.setModifyACL();
        this.yarnACLSetter.setACLs(this.contextMock);
        this.assertModifyACLset();
    }

    @Test
    public void testACLisEmptyWhenEnabledAndNoACLsDefined() {
        this.setupYarnACLHandler(true);
        this.yarnACLSetter.setACLs(this.contextMock);
        this.assertNoACLset();
    }

    @Test
    public void testACLisEmptyWhenMRACLsDisabled() {
        this.setupYarnACLHandler(false);
        this.setModifyACL();
        this.setViewACL();
        this.yarnACLSetter.setACLs(this.contextMock);
        this.assertNoACLset();
    }

    private void setupYarnACLHandler(boolean mrACLsEnabled) {
        this.launcherConfig = new Configuration();
        this.launcherConfig.setBoolean("mapreduce.cluster.acls.enabled", mrACLsEnabled);
        this.yarnACLSetter = new YarnACLHandler(this.launcherConfig);
    }

    private void setViewACL() {
        this.launcherConfig.set("oozie.launcher.view.acl", VIEW_ACL_VALUE);
    }

    private void setModifyACL() {
        this.launcherConfig.set("oozie.launcher.modify.acl", MODIFY_ACL_VALUE);
    }

    private void assertModifyACLset() {
        this.verifyACLset("Modify ACL", MODIFY_ACL_VALUE, ApplicationAccessType.MODIFY_APP);
    }

    private void assertViewACLset() {
        this.verifyACLset("View ACL", VIEW_ACL_VALUE, ApplicationAccessType.VIEW_APP);
    }

    private void assertNoACLset() {
        ((ContainerLaunchContext)Mockito.verify((Object)this.contextMock, (VerificationMode)Mockito.never())).setApplicationACLs((Map)Matchers.any(Map.class));
    }

    private void verifyACLset(String aclMessage, String aclValue, ApplicationAccessType aclType) {
        ((ContainerLaunchContext)Mockito.verify((Object)this.contextMock)).setApplicationACLs((Map)this.captor.capture());
        Map aclDefinition = (Map)this.captor.getValue();
        Assert.assertEquals((String)"ACL size", (long)1L, (long)aclDefinition.size());
        Assert.assertEquals((String)aclMessage, (Object)aclValue, aclDefinition.get(aclType));
    }
}

