/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Properties;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.BuildInfo;
import org.apache.oozie.cli.CLIParser;
import org.apache.oozie.cli.OozieCLI;
import org.apache.oozie.client.HeaderTestingVersionServlet;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.MetricsInstrumentationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.ShareLibService;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockCoordinatorEngineService;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.servlet.SLAServlet;
import org.apache.oozie.servlet.V1AdminServlet;
import org.apache.oozie.servlet.V1JobServlet;
import org.apache.oozie.servlet.V1JobsServlet;
import org.apache.oozie.servlet.V2AdminServlet;
import org.apache.oozie.servlet.V2JobServlet;
import org.apache.oozie.servlet.V2ValidateServlet;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;

public class TestOozieCLI
extends DagServletTestCase {
    static final boolean IS_SECURITY_ENABLED = false;
    static final String VERSION = "/v2";
    static final String[] END_POINTS;
    static final Class<?>[] SERVLET_CLASSES;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        MockDagEngineService.reset();
        MockCoordinatorEngineService.reset();
    }

    private String createConfigFile(String appPath) throws Exception {
        String path = this.getTestCaseDir() + "/" + this.getName() + ".xml";
        Configuration conf = new Configuration(false);
        conf.set("oozie.wf.application.path", appPath);
        conf.set("oozie.wf.rerun.skip.nodes", "node");
        FileOutputStream os = new FileOutputStream(path);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        return path;
    }

    private String createCoodrConfigFile(String appPath) throws Exception {
        String path = this.getTestCaseDir() + "/" + this.getName() + ".xml";
        Configuration conf = new Configuration(false);
        conf.set("oozie.coord.application.path", appPath);
        FileOutputStream os = new FileOutputStream(path);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        return path;
    }

    private String createPropertiesFile(String appPath) throws Exception {
        String path = this.getTestCaseDir() + "/" + this.getName() + ".properties";
        Properties props = new Properties();
        props.setProperty("user.name", TestOozieCLI.getTestUser());
        props.setProperty("group.name", TestOozieCLI.getTestGroup());
        props.setProperty("oozie.wf.application.path", appPath);
        props.setProperty("oozie.wf.rerun.skip.nodes", "node");
        props.setProperty("a", "A");
        FileOutputStream os = new FileOutputStream(path);
        props.store(os, "");
        ((OutputStream)os).close();
        return path;
    }

    private String createPropertiesFileWithTrailingSpaces(String appPath) throws Exception {
        String path = this.getTestCaseDir() + "/" + this.getName() + ".properties";
        Properties props = new Properties();
        props.setProperty("user.name", TestOozieCLI.getTestUser());
        props.setProperty("group.name", TestOozieCLI.getTestGroup());
        props.setProperty("oozie.wf.application.path", appPath);
        props.setProperty("oozie.wf.rerun.skip.nodes ", " node ");
        FileOutputStream os = new FileOutputStream(path);
        props.store(os, "");
        ((OutputStream)os).close();
        return path;
    }

    private String createPigPropertiesFile(String appPath) throws Exception {
        String path = this.getTestCaseDir() + "/" + this.getName() + ".properties";
        Properties props = new Properties();
        props.setProperty("user.name", TestOozieCLI.getTestUser());
        props.setProperty("fs.default.name", "localhost:8020");
        props.setProperty("yarn.resourcemanager.address", "localhost:8032");
        props.setProperty("oozie.libpath", appPath);
        props.setProperty("mapred.output.dir", appPath);
        props.setProperty("a", "A");
        FileOutputStream os = new FileOutputStream(path);
        props.store(os, "");
        ((OutputStream)os).close();
        return path;
    }

    private String createMRProperties(String appPath, boolean useNewAPI) throws Exception {
        String path = this.getTestCaseDir() + "/" + this.getName() + ".properties";
        Properties props = new Properties();
        props.setProperty("user.name", TestOozieCLI.getTestUser());
        props.setProperty("group.name", TestOozieCLI.getTestGroup());
        props.setProperty("oozie.wf.application.path", appPath);
        props.setProperty("oozie.wf.rerun.skip.nodes", "node");
        props.setProperty("fs.default.name", "localhost:9000");
        props.setProperty("yarn.resourcemanager.address", "localhost:9001");
        if (useNewAPI) {
            props.setProperty("mapreduce.map.class", "mapper.class");
            props.setProperty("mapreduce.reduce.class", "reducer.class");
        } else {
            props.setProperty("mapred.mapper.class", "mapper.class");
            props.setProperty("mapred.reducer.class", "reducer.class");
        }
        props.setProperty("mapred.input.dir", "input");
        props.setProperty("mapred.output.dir", "output");
        props.setProperty("oozie.libpath", appPath);
        props.setProperty("a", "A");
        FileOutputStream os = new FileOutputStream(path);
        props.store(os, "");
        ((OutputStream)os).close();
        return path;
    }

    private String createPigScript(String appPath) throws Exception {
        String path = this.getTestCaseDir() + "/" + this.getName() + ".properties";
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(path));
        String pigScript = "A = load '/user/data' using PigStorage(:);\nB = foreach A generate $0dumb B;";
        dos.writeBytes(pigScript);
        dos.close();
        return path;
    }

    public void testSubmit() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                int wfCount = 4;
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                String[] args = new String[]{"job", "-submit", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString())};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"submit", (String)MockDagEngineService.did);
                TestCase.assertFalse((boolean)MockDagEngineService.started.get(wfCount));
                args = new String[]{"job", "-submit", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createPropertiesFile(appPath.toString())};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"submit", (String)MockDagEngineService.did);
                TestCase.assertFalse((boolean)MockDagEngineService.started.get(++wfCount));
                MockDagEngineService.reset();
                wfCount = 4;
                args = new String[]{"job", "-submit", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createPropertiesFile(appPath.toString()) + "x"};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                TestCase.assertEquals(null, (String)MockDagEngineService.did);
                try {
                    MockDagEngineService.started.get(wfCount);
                    TestCase.fail();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void testSubmitPig() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                int wfCount = 4;
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                String[] args = new String[]{"pig", "-oozie", oozieUrl, "-file", TestOozieCLI.this.createPigScript(appPath.toString()), "-config", TestOozieCLI.this.createPigPropertiesFile(appPath.toString())};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"submitPig", (String)MockDagEngineService.did);
                TestCase.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testSubmitMapReduce() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                int wfCount = 4;
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                String[] args = new String[]{"mapreduce", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createMRProperties(appPath.toString(), false)};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"submitMR", (String)MockDagEngineService.did);
                TestCase.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testSubmitMapReduce2() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                int wfCount = 4;
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                String[] args = new String[]{"mapreduce", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createMRProperties(appPath.toString(), true)};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"submitMR", (String)MockDagEngineService.did);
                TestCase.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testSubmitDoAs() throws Exception {
        this.setSystemProperty("oozie.authentication.simple.anonymous.allowed", "false");
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                String[] args = new String[]{"job", "-submit", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString()), "-doas", TestOozieCLI.getTestUser2()};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"submit", (String)MockDagEngineService.did);
                TestCase.assertEquals((String)TestOozieCLI.getTestUser2(), (String)MockDagEngineService.user);
                return null;
            }
        });
    }

    public void testSubmitWithPropertyArguments() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                int wfCount = 4;
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                String[] args = new String[]{"job", "-submit", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString()), "-Da=X", "-Db=B"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"submit", (String)MockDagEngineService.did);
                TestCase.assertFalse((boolean)MockDagEngineService.started.get(wfCount));
                TestCase.assertEquals((String)"X", (String)MockDagEngineService.submittedConf.get("a"));
                TestCase.assertEquals((String)"B", (String)MockDagEngineService.submittedConf.get("b"));
                return null;
            }
        });
    }

    public void testRun() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                int wfCount = 4;
                String[] args = new String[]{"job", "-run", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString())};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"submit", (String)MockDagEngineService.did);
                TestCase.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testRunWithDebug() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                int wfCount = 4;
                String[] args = new String[]{"job", "-run", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString()), "-debug"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"submit", (String)MockDagEngineService.did);
                TestCase.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testStart() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-start", "job-1-W"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"start", (String)MockDagEngineService.did);
                TestCase.assertTrue((boolean)MockDagEngineService.started.get(1));
                args = new String[]{"job", "-oozie", oozieUrl, "-start", "job-" + (MockDagEngineService.workflows.size() + 1)};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                return null;
            }
        });
    }

    public void testSuspend() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-suspend", "job-1-W"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"suspend", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-suspend", "job-" + (MockDagEngineService.workflows.size() + 1)};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                return null;
            }
        });
    }

    public void testResume() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-resume", "job-1-W"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"resume", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-resume", "job-" + (MockDagEngineService.workflows.size() + 1)};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                return null;
            }
        });
    }

    public void testKill() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-kill", "job-1-W"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"kill", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-kill", "job-" + (MockDagEngineService.workflows.size() + 1)};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                return null;
            }
        });
    }

    public void testBulkSuspendResumeKill1() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"jobs", "-oozie", oozieUrl, "-suspend", "-filter", "name=workflow-1"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"jobs", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-oozie", oozieUrl, "-resume", "-filter", "name=workflow-1"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"jobs", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-oozie", oozieUrl, "-kill", "-filter", "name=workflow-1"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"jobs", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testBulkSuspendResumeKill2() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"jobs", "-oozie", oozieUrl, "-suspend", "-filter", "name=coordinator", "-jobtype", "coordinator"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"jobs", (String)MockCoordinatorEngineService.did);
                args = new String[]{"jobs", "-oozie", oozieUrl, "-resume", "-filter", "name=coordinator", "-jobtype", "coordinator"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"jobs", (String)MockCoordinatorEngineService.did);
                args = new String[]{"jobs", "-oozie", oozieUrl, "-kill", "-filter", "name=coordinator", "-jobtype", "coordinator"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"jobs", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testBulkCommandWithoutFilterNegative() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"jobs", "-oozie", oozieUrl, "-suspend", "-jobtype", "coordinator"};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                TestCase.assertNull((Object)MockCoordinatorEngineService.did);
                args = new String[]{"jobs", "-oozie", oozieUrl, "-resume", "-jobtype", "coordinator"};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                TestCase.assertNull((Object)MockCoordinatorEngineService.did);
                args = new String[]{"jobs", "-oozie", oozieUrl, "-kill", "-jobtype", "coordinator"};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                TestCase.assertNull((Object)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testCoordActionKill1() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-kill", "coord-job-C-1", "-action", "1"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"kill", (String)MockCoordinatorEngineService.did);
                TestCase.assertFalse((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                return null;
            }
        });
    }

    public void testCoordActionKill2() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-kill", "coord-job-C-1", "-date", "2009-12-15T01:00Z::2009-12-16T01:00Z"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"kill", (String)MockCoordinatorEngineService.did);
                TestCase.assertFalse((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                return null;
            }
        });
    }

    public void testReRun() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString()), "-rerun", "job-1-W"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"rerun", (String)MockDagEngineService.did);
                TestCase.assertTrue((boolean)MockDagEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testCoordReRun1() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-rerun", "coord-job-C-1", "-action", "1"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"coord-rerun", (String)MockCoordinatorEngineService.did);
                TestCase.assertTrue((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                return null;
            }
        });
    }

    public void testCoordReRun2() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-rerun", "coord-job-C-1", "-date", "2009-12-15T01:00Z::2009-12-16T01:00Z"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"coord-rerun", (String)MockCoordinatorEngineService.did);
                TestCase.assertTrue((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                return null;
            }
        });
    }

    public void testCoordReRun3() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-rerun", "coord-job-C-0", "-action", "0", "-refresh"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"coord-rerun", (String)MockCoordinatorEngineService.did);
                TestCase.assertTrue((boolean)MockCoordinatorEngineService.startedCoordJobs.get(0));
                return null;
            }
        });
    }

    public void testCoordReRun4() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-rerun", "coord-job-C-0", "-action", "0", "-nocleanup"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"coord-rerun", (String)MockCoordinatorEngineService.did);
                TestCase.assertTrue((boolean)MockCoordinatorEngineService.startedCoordJobs.get(0));
                return null;
            }
        });
    }

    public void testCoordReRunNeg1() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-rerun", "coord-job-C-1-W", "-date", "2009-12-15T01:00Z", "-action", "1"};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                TestCase.assertNull((Object)MockCoordinatorEngineService.did);
                TestCase.assertFalse((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                return null;
            }
        });
    }

    public void testCoordReRunNeg2() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-rerun", "coord-job-C-1-W"};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                TestCase.assertNull((Object)MockCoordinatorEngineService.did);
                TestCase.assertFalse((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                return null;
            }
        });
    }

    public void testCoordReRunNeg3() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString()), "-rerun", "coord-job-C-0"};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                TestCase.assertNull((Object)MockCoordinatorEngineService.did);
                TestCase.assertFalse((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                return null;
            }
        });
    }

    public void testCoordReRunNeg4() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString()), "-rerun", "coord-job-C-0", "-date", "2009-12-15T01:00Z", "-action", "1"};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                TestCase.assertNull((Object)MockCoordinatorEngineService.did);
                TestCase.assertFalse((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                return null;
            }
        });
    }

    public void testCoordJobIgnore() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-ignore", "coord-job-C-1"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"change", (String)MockCoordinatorEngineService.did);
                TestCase.assertTrue((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                MockCoordinatorEngineService.reset();
                args = new String[]{"job", "-oozie", oozieUrl, "ignore", "job-" + (MockCoordinatorEngineService.coordJobs.size() + 1)};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                TestCase.assertNull((Object)MockCoordinatorEngineService.did);
                TestCase.assertFalse((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                return null;
            }
        });
    }

    public void testCoordActionsIgnore() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-ignore", "coord-job-C-1", "-action", "1"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"ignore", (String)MockCoordinatorEngineService.did);
                TestCase.assertTrue((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                MockCoordinatorEngineService.reset();
                args = new String[]{"job", "-oozie", oozieUrl, "ignore", "job-" + (MockCoordinatorEngineService.coordJobs.size() + 1), "-action", "1"};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                TestCase.assertNull((Object)MockCoordinatorEngineService.did);
                TestCase.assertFalse((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                MockCoordinatorEngineService.reset();
                args = new String[]{"job", "-oozie", oozieUrl, "-ignore", "coord-job-C-", "-action", ""};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                TestCase.assertNull((Object)MockCoordinatorEngineService.did);
                TestCase.assertFalse((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                return null;
            }
        });
    }

    public void testJobStatus() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                MockDagEngineService.reset();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-info", "job-0-W"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-localtime", "-oozie", oozieUrl, "-info", "job-1-W"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-timezone", "PST", "-oozie", oozieUrl, "-info", "job-1-W"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "job-2-W"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "job-" + (MockDagEngineService.workflows.size() + 1)};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                return null;
            }
        });
    }

    public void testJobsStatus() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"jobs", "-len", "3", "-offset", "2", "-oozie", oozieUrl, "-filter", "name=x"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-localtime", "-len", "3", "-offset", "2", "-oozie", oozieUrl, "-filter", "name=x"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-timezone", "PST", "-len", "3", "-offset", "2", "-oozie", oozieUrl, "-filter", "name=x"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-jobtype", "coord", "-filter", "status=FAILED", "-oozie", oozieUrl};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-filter", "startcreatedtime=2014-04-01T00:00Z;endcreatedtime=2014-05-01T00:00Z", "-oozie", oozieUrl};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-filter", "startcreatedtime=-10d;endcreatedtime=-20m", "-oozie", oozieUrl};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-filter", "sortby=lastmodifiedtime", "-oozie", oozieUrl};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-filter", "sortby=lastmodifiedtime", "-jobtype", "coord", "-oozie", oozieUrl};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-filter", "sortby=lastmodifiedtime", "-jobtype", "bundle", "-oozie", oozieUrl};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-filter", "startcreatedtime=-10d;endcreatedtime=-20m", "-jobtype", "coord", "-oozie", oozieUrl};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-filter", "startcreatedtime=-10d;endcreatedtime=-20m", "-jobtype", "bundle", "-oozie", oozieUrl};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"filter", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testHeaderPropagation() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                TestOozieCLI.this.setSystemProperty("header:header", "test");
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-start", "job-1-W"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"start", (String)MockDagEngineService.did);
                TestCase.assertTrue((boolean)HeaderTestingVersionServlet.OOZIE_HEADERS.containsKey("header"));
                TestCase.assertTrue((boolean)HeaderTestingVersionServlet.OOZIE_HEADERS.containsValue("test"));
                return null;
            }
        });
    }

    public void testOozieStatus() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-status", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertEquals((String)("System mode: NORMAL" + SYSTEM_LINE_SEPARATOR), (String)out);
                args = new String[]{"admin", "-oozie", oozieUrl, "-systemmode", "NORMAL"};
                out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertEquals((String)("System mode: NORMAL" + SYSTEM_LINE_SEPARATOR), (String)out);
                return null;
            }
        });
    }

    public void testServerBuildVersion() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-version", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertTrue((String)out, (boolean)out.startsWith("Oozie server build version: {"));
                TestCase.assertTrue((String)out, (boolean)out.endsWith(SYSTEM_LINE_SEPARATOR));
                TestCase.assertTrue((String)out, (boolean)out.contains("build.time"));
                TestCase.assertTrue((String)out, (boolean)out.contains("build.version"));
                TestCase.assertTrue((String)out, (boolean)out.contains("build.user"));
                TestCase.assertTrue((String)out, (boolean)out.contains("vc.url"));
                TestCase.assertTrue((String)out, (boolean)out.contains("vc.revision"));
                return null;
            }
        });
    }

    public void testAdminPurgeCommand() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-purge", "wf=1;coord=2;bundle=3;limit=10;oldCoordAction=true", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertEquals((String)("Purge command executed successfully" + SYSTEM_LINE_SEPARATOR), (String)out);
                return null;
            }
        });
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-purge", "wf=1;coord=0;bundle=0;limit=10;oldCoordAction=true", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertEquals((String)("Purge command executed successfully" + SYSTEM_LINE_SEPARATOR), (String)out);
                return null;
            }
        });
    }

    public void testAdminPurgeCommandNegative() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-purge", "-oozie", oozieUrl};
                String error = TestOozieCLI.this.runOozieCLIAndGetStderr(args);
                TestCase.assertTrue((boolean)error.contains("Missing argument for option: purge"));
                args = new String[]{"admin", "-purge", "invalid=1", "-oozie", oozieUrl};
                error = TestOozieCLI.this.runOozieCLIAndGetStderr(args);
                TestCase.assertTrue((boolean)error.contains("INVALID_INPUT : Invalid purge option [invalid] specified."));
                args = new String[]{"admin", "-purge", "wf=1;coord=", "-oozie", oozieUrl};
                error = TestOozieCLI.this.runOozieCLIAndGetStderr(args);
                TestCase.assertTrue((boolean)error.contains("INVALID_INPUT : Invalid purge option pair [coord=] specified."));
                args = new String[]{"admin", "-purge", "wf=1;coord=-1", "-oozie", oozieUrl};
                error = TestOozieCLI.this.runOozieCLIAndGetStderr(args);
                TestCase.assertTrue((boolean)error.contains("Input value should be a positive integer. Value: -1"));
                args = new String[]{"admin", "-purge", "wf=a", "-oozie", oozieUrl};
                error = TestOozieCLI.this.runOozieCLIAndGetStderr(args);
                TestCase.assertTrue((boolean)error.contains("For input string: \"a\""));
                return null;
            }
        });
    }

    public void testClientBuildVersion() throws Exception {
        String[] args = new String[]{"version"};
        String out = this.runOozieCLIAndGetStdout(args);
        StringBuilder sb = new StringBuilder();
        sb.append("Oozie client build version: ").append(BuildInfo.getBuildInfo().getProperty("build.version")).append("\nSource code repository: ").append(BuildInfo.getBuildInfo().getProperty("vc.url")).append("\nCompiled by ").append(BuildInfo.getBuildInfo().getProperty("build.user")).append(" on ").append(BuildInfo.getBuildInfo().getProperty("build.time")).append("\nFrom source with checksum: ").append(BuildInfo.getBuildInfo().getProperty("vc.revision"));
        TestOozieCLI.assertEquals((String)(sb.toString() + SYSTEM_LINE_SEPARATOR), (String)out);
    }

    public void testJobInfo() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                MockDagEngineService.reset();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-info", "job-0-W"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "job-1-W", "-len", "3", "-offset", "1"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "job-2-W", "-len", "2"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "job-3-W", "-offset", "3"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "coord-job-C-1-C"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                TestCase.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(1));
                TestCase.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(1000));
                MockCoordinatorEngineService.reset();
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "coord-job-C-1-C", "-len", "10", "-offset", "5", "-order", "desc", "-filter", "status=FAILED"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                TestCase.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(5));
                TestCase.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(10));
                TestCase.assertEquals((String)MockCoordinatorEngineService.order, (String)"desc");
                TestCase.assertEquals((String)MockCoordinatorEngineService.filter, (String)"status=FAILED");
                MockCoordinatorEngineService.reset();
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "coord-job-C-1-C", "-len", "10", "-offset", "5", "-order", "desc", "-filter", "status!=FAILED"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                TestCase.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(5));
                TestCase.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(10));
                TestCase.assertEquals((String)MockCoordinatorEngineService.order, (String)"desc");
                TestCase.assertEquals((String)MockCoordinatorEngineService.filter, (String)"status!=FAILED");
                return null;
            }
        });
    }

    public void testJobPoll() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                MockDagEngineService.reset();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-poll", "job-1-W"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"status", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-poll", "job-1-W", "-interval", "10"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"status", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-poll", "job-1-W", "-timeout", "60"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"status", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-poll", "job-1-W", "-interval", "10", "-timeout", "60"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"status", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testJobLog() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                MockDagEngineService.reset();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-log", "job-0-W"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"log", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-log", "coord-job-C-0"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"log", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-log", "coord-job-C-0", "-action", "0", "-date", "2009-12-16T01:00Z"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"log", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testJobDefinition() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                MockDagEngineService.reset();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-definition", "job-0-W"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"definition", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testPropertiesWithTrailingSpaces() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                String[] args = new String[]{"job", "-submit", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createPropertiesFileWithTrailingSpaces(appPath.toString())};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"submit", (String)MockDagEngineService.did);
                String confStr = MockDagEngineService.workflows.get(4).getConf();
                XConfiguration conf = new XConfiguration((Reader)new StringReader(confStr));
                TestCase.assertNotNull((Object)conf.get("oozie.wf.rerun.skip.nodes"));
                TestCase.assertEquals((String)"node", (String)conf.get("oozie.wf.rerun.skip.nodes"));
                return null;
            }
        });
    }

    public void testWfActionRetries() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                MockDagEngineService.reset();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-retries", "job-0-W@a"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"retries", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testAdminQueueDump() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-queuedump", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertTrue((String)"Queue dump", (boolean)out.contains("Server Queue Dump"));
                TestCase.assertTrue((String)"Queue dump empty message", (boolean)out.contains("The queue dump is empty, nothing to display."));
                TestCase.assertTrue((String)"Uniqueness map dump", (boolean)out.contains("Server Uniqueness Map Dump"));
                TestCase.assertTrue((String)"Uniqueness dump empty message", (boolean)out.contains("The uniqueness map dump is empty, nothing to display."));
                return null;
            }
        });
    }

    public void testInfo() throws Exception {
        String[] args = new String[]{"info"};
        TestOozieCLI.assertEquals((int)0, (int)new OozieCLI().run(args));
        args = new String[]{"info", "-timezones"};
        String out = this.runOozieCLIAndGetStdout(args);
        TestOozieCLI.assertTrue((boolean)out.contains("Available Time Zones"));
    }

    public void testValidateWorkFlowCommand() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String validFileName = "test-workflow-app.xml";
                String invalidFileName = "test-invalid-workflow-app.xml";
                String validContent = "<workflow-app xmlns=\"uri:oozie:workflow:0.2\" name=\"no-op-wf\">  <start to=\"end\"/> <end name=\"end\"/> </workflow-app>";
                String invalidContent = "<workflow-app xmlns=\"uri:oozie:workflow:0.2\" name=\"f\">  <tag=\"end\"/> <tag=\"end\"/> </workflow-app>";
                File validfile = new File(TestOozieCLI.this.getTestCaseDir(), validFileName);
                File invalidfile = new File(TestOozieCLI.this.getTestCaseDir(), invalidFileName);
                validfile.delete();
                invalidfile.delete();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                IOUtils.copyCharStream((Reader)new StringReader(validContent), (Writer)new FileWriter(validfile));
                String[] args = new String[]{"validate", "-oozie", oozieUrl, validfile.getAbsolutePath()};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertTrue((boolean)out.contains("Valid"));
                IOUtils.copyCharStream((Reader)new StringReader(invalidContent), (Writer)new FileWriter(invalidfile));
                args = new String[]{"validate", "-oozie", oozieUrl, invalidfile.getAbsolutePath()};
                out = TestOozieCLI.this.runOozieCLIAndGetStderr(args);
                TestCase.assertTrue((boolean)out.contains("XML schema error"));
                return null;
            }
        });
    }

    public void testChangeValue() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-change", "coord-job-C-0", "-value", "concurrency=10"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)"change", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testSlaEvents() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"sla", "-oozie", oozieUrl, "-len", "1"};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertTrue((String)out, (boolean)out.contains("<sla-message>"));
                return null;
            }
        });
    }

    public void testshareLibUpdate() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                Services.get().setService(ShareLibService.class);
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-sharelibupdate", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertTrue((boolean)out.contains("ShareLib update status"));
                return null;
            }
        });
    }

    public void testshareLibUpdate_withSecurity() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, true, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-sharelibupdate", "-oozie", oozieUrl, "-auth", "simple"};
                String out = TestOozieCLI.this.runOozieCLIAndGetStderr(args);
                TestCase.assertEquals((String)"Error: E0503 : E0503: User [test] does not have admin privileges\n", (String)out);
                return null;
            }
        });
    }

    public void testGetShareLib() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                Services.get().setService(ShareLibService.class);
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-shareliblist", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertTrue((boolean)out.contains("Available ShareLib"));
                return null;
            }
        });
    }

    public void testGetShareLib_withKey() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                Services.get().setService(ShareLibService.class);
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-shareliblist", "pig", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertTrue((boolean)out.contains("Available ShareLib"));
                return null;
            }
        });
    }

    public void testJobDryrun() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-dryrun", "-config", TestOozieCLI.this.createCoodrConfigFile(appPath.toString()), "-oozie", oozieUrl, "-Doozie.proxysubmission=true"};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)MockCoordinatorEngineService.did, (String)"dryrun");
                TestCase.assertFalse((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                return null;
            }
        });
    }

    public void testUpdate() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-update", "aaa", "-oozie", oozieUrl};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)MockCoordinatorEngineService.did, (String)"update");
                TestCase.assertFalse((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                return null;
            }
        });
    }

    public void testUpdateWithDryrun() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-update", "aaa", "-dryrun", "-oozie", oozieUrl};
                TestCase.assertEquals((int)-1, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)MockCoordinatorEngineService.did, (String)"update&dryrun");
                TestCase.assertFalse((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                return null;
            }
        });
    }

    public void testFailNoArg() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStderr(args);
                TestCase.assertTrue((boolean)out.contains("Invalid sub-command"));
                return null;
            }
        });
    }

    public void testRetryForTimeout() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = "http://localhost:11/oozie";
                String[] args = new String[]{"job", "-update", "aaa", "-dryrun", "-oozie", oozieUrl, "-debug"};
                OozieCLI cli = new OozieCLI();
                CLIParser parser = cli.getCLIParser();
                try {
                    CLIParser.Command command = parser.parse(args);
                    cli.processCommand(parser, command);
                }
                catch (Exception e) {
                    TestCase.assertTrue((boolean)e.getMessage().contains("Error while connecting Oozie server. No of retries = 4. Exception = Connection refused"));
                }
                return null;
            }
        });
    }

    public void testNoRetryForError() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-info", "aaa", "-oozie", oozieUrl, "-debug"};
                OozieCLI cli = new OozieCLI();
                CLIParser parser = cli.getCLIParser();
                try {
                    CLIParser.Command command = parser.parse(args);
                    cli.processCommand(parser, command);
                }
                catch (Exception e) {
                    TestCase.assertFalse((boolean)e.getMessage().contains("Error while connecting Oozie server"));
                    TestCase.assertTrue((boolean)e.getMessage().contains("invalid job id [aaa]"));
                }
                return null;
            }
        });
    }

    public void testRetryWithRetryCount() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = "http://localhost:11/oozie";
                String[] args = new String[]{"job", "-update", "aaa", "-dryrun", "-oozie", oozieUrl, "-debug"};
                OozieCLI cli = new OozieCLI(){

                    protected void setRetryCount(OozieClient wc) {
                        wc.setRetryCount(2);
                    }

                    public CLIParser getCLIParser() {
                        return super.getCLIParser();
                    }
                };
                CLIParser parser = cli.getCLIParser();
                try {
                    CLIParser.Command command = parser.parse(args);
                    cli.processCommand(parser, command);
                }
                catch (Exception e) {
                    TestCase.assertTrue((boolean)e.getMessage().contains("Error while connecting Oozie server. No of retries = 2. Exception = Connection refused"));
                }
                return null;
            }
        });
    }

    public void testAdminConfiguration() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-configuration", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertTrue((boolean)out.contains("oozie.base.url"));
                return null;
            }
        });
    }

    public void testAdminOsEnv() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-osenv", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertTrue((boolean)out.contains("JAVA_HOME"));
                return null;
            }
        });
    }

    public void testAdminJavaSystemProperties() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-javasysprops", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertTrue((boolean)out.contains("java.vendor"));
                return null;
            }
        });
    }

    public void testAdminInstrumentation() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                Services.get().setService(InstrumentationService.class);
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-instrumentation", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertTrue((boolean)out.contains("webservices.version-GET"));
                args = new String[]{"admin", "-metrics", "-oozie", oozieUrl};
                out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertTrue((boolean)out.contains("Metrics are unavailable"));
                return null;
            }
        });
    }

    public void testAdminMetrics() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                Services.get().setService(MetricsInstrumentationService.class);
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-metrics", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertTrue((boolean)out.contains("webservices.version-GET"));
                args = new String[]{"admin", "-instrumentation", "-oozie", oozieUrl};
                out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                TestCase.assertTrue((boolean)out.contains("Instrumentation is unavailable"));
                return null;
            }
        });
    }

    public void testSlaEnable() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-slaenable", "aaa-C", "-oozie", oozieUrl};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)MockCoordinatorEngineService.did, (String)"sla-enable");
                return null;
            }
        });
    }

    public void testSlaDisable() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-sladisable", "aaa-C", "-oozie", oozieUrl};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)MockCoordinatorEngineService.did, (String)"sla-disable");
                return null;
            }
        });
    }

    public void testSlaChange() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-slachange", "aaa-C", "-oozie", oozieUrl};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)MockCoordinatorEngineService.did, (String)"sla-change");
                return null;
            }
        });
    }

    public void testCoordActionMissingdependencies() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-missingdeps", "aaa-C", "-oozie", oozieUrl};
                TestCase.assertEquals((int)0, (int)new OozieCLI().run(args));
                TestCase.assertEquals((String)MockCoordinatorEngineService.did, (String)"missing-dependencies");
                TestCase.assertFalse((boolean)MockCoordinatorEngineService.startedCoordJobs.get(1));
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runOozieCLIAndGetStdout(String[] args) {
        PrintStream original = System.out;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        String outStr = null;
        System.out.flush();
        try {
            System.setOut(ps);
            TestOozieCLI.assertEquals((int)0, (int)new OozieCLI().run(args));
            System.out.flush();
            outStr = baos.toString();
        }
        catch (Throwable throwable) {
            System.setOut(original);
            if (outStr != null) {
                System.out.print(outStr);
            }
            System.out.flush();
            throw throwable;
        }
        System.setOut(original);
        if (outStr != null) {
            System.out.print(outStr);
        }
        System.out.flush();
        return outStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runOozieCLIAndGetStderr(String[] args) {
        PrintStream original = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        String outStr = null;
        System.err.flush();
        try {
            System.setErr(ps);
            TestOozieCLI.assertEquals((int)-1, (int)new OozieCLI().run(args));
            System.err.flush();
            outStr = baos.toString();
        }
        catch (Throwable throwable) {
            System.setErr(original);
            if (outStr != null) {
                System.err.print(outStr);
            }
            System.err.flush();
            throw throwable;
        }
        System.setErr(original);
        if (outStr != null) {
            System.err.print(outStr);
        }
        System.err.flush();
        return outStr;
    }

    static {
        new HeaderTestingVersionServlet();
        new V1JobServlet();
        new V1JobsServlet();
        new V1AdminServlet();
        new V2AdminServlet();
        new V2JobServlet();
        new V2ValidateServlet();
        new SLAServlet();
        END_POINTS = new String[]{"/versions", "/v2/jobs", "/v2/job/*", "/v2/admin/*", "/v2/validate/*", "/v1/sla"};
        SERVLET_CLASSES = new Class[]{HeaderTestingVersionServlet.class, V1JobsServlet.class, V2JobServlet.class, V2AdminServlet.class, V2ValidateServlet.class, SLAServlet.class};
    }
}

