/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.BuildInfo;
import org.apache.oozie.client.BundleJob;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.HeaderTestingVersionServlet;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockCoordinatorEngineService;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.servlet.SLAServlet;
import org.apache.oozie.servlet.V0JobServlet;
import org.apache.oozie.servlet.V0JobsServlet;
import org.apache.oozie.servlet.V1AdminServlet;
import org.apache.oozie.servlet.V1JobServlet;
import org.apache.oozie.servlet.V1JobsServlet;
import org.apache.oozie.servlet.V2AdminServlet;
import org.apache.oozie.servlet.V2JobServlet;
import org.apache.oozie.servlet.V2SLAServlet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.mockito.Mockito;

public class TestWorkflowClient
extends DagServletTestCase {
    private static final boolean IS_SECURITY_ENABLED = false;
    static final String VERSION_0 = "/v0";
    static final String VERSION_1 = "/v1";
    static final String VERSION_2 = "/v2";
    static final String[] END_POINTS;
    static final Class[] SERVLET_CLASSES;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        MockDagEngineService.reset();
    }

    public void testHeaders() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                wc.setHeader("header", "test");
                TestCase.assertEquals((String)"test", (String)wc.getHeader("header"));
                TestCase.assertEquals((String)"test", (String)((String)wc.getHeaders().get("header")));
                boolean found = false;
                Iterator headers = wc.getHeaderNames();
                while (headers.hasNext()) {
                    if (!"header".equals(headers.next())) continue;
                    found = true;
                }
                TestCase.assertTrue((String)"headers does not contain header!", (boolean)found);
                wc.validateWSVersion();
                TestCase.assertTrue((boolean)HeaderTestingVersionServlet.OOZIE_HEADERS.containsKey("header"));
                TestCase.assertTrue((boolean)HeaderTestingVersionServlet.OOZIE_HEADERS.containsValue("test"));
                wc.removeHeader("header");
                TestCase.assertNull((Object)wc.getHeader("header"));
                return null;
            }
        });
    }

    public void testUrls() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                TestCase.assertEquals((String)oozieUrl, (String)wc.getOozieUrl().substring(0, wc.getOozieUrl().length() - 1));
                TestCase.assertTrue((boolean)wc.getProtocolUrl().startsWith(wc.getOozieUrl() + "v"));
                try {
                    wc = new OozieClientForTest(oozieUrl);
                    wc.getProtocolUrl();
                    TestCase.fail((String)"wrong version should run throw exception");
                }
                catch (OozieClientException e) {
                    TestCase.assertEquals((String)"UNSUPPORTED_VERSION : Supported version [2] or less, Unsupported versions[-11-10]", (String)e.toString());
                }
                return null;
            }
        });
    }

    public void testValidateVersion() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                wc.validateWSVersion();
                return null;
            }
        });
    }

    public void testSubmit() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                int wfCount = 4;
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                Properties conf = wc.createConfiguration();
                Path appPath = new Path(TestWorkflowClient.this.getFsTestCaseDir(), "app");
                TestWorkflowClient.this.getFileSystem().mkdirs(appPath);
                TestWorkflowClient.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                conf.setProperty("oozie.wf.application.path", appPath.toString());
                TestCase.assertEquals((String)("job-" + wfCount + "-W"), (String)wc.submit(conf));
                TestCase.assertFalse((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testRun() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                int wfCount = 4;
                OozieClient wc = new OozieClient(oozieUrl);
                Properties conf = wc.createConfiguration();
                Path appPath = new Path(TestWorkflowClient.this.getFsTestCaseDir(), "app");
                TestWorkflowClient.this.getFileSystem().mkdirs(appPath);
                TestWorkflowClient.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                conf.setProperty("oozie.wf.application.path", appPath.toString());
                TestCase.assertEquals((String)("job-" + wfCount + "-W"), (String)wc.run(conf));
                TestCase.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testStart() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                Properties conf = wc.createConfiguration();
                conf.setProperty("user.name", "x");
                wc.start("job-1-W");
                TestCase.assertEquals((String)"start", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testSuspend() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                Properties conf = wc.createConfiguration();
                conf.setProperty("user.name", "x");
                wc.suspend("job-1-W");
                TestCase.assertEquals((String)"suspend", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testResume() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                Properties conf = wc.createConfiguration();
                conf.setProperty("user.name", "x");
                wc.resume("job-1-W");
                TestCase.assertEquals((String)"resume", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testKill() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                Properties conf = wc.createConfiguration();
                conf.setProperty("user.name", "x");
                wc.kill("job-1-W");
                TestCase.assertEquals((String)"kill", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testReRun() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                Properties conf = wc.createConfiguration();
                conf.setProperty("user.name", TestWorkflowClient.getTestUser());
                Path appPath = new Path(TestWorkflowClient.this.getFsTestCaseDir(), "app");
                TestWorkflowClient.this.getFileSystem().mkdirs(appPath);
                TestWorkflowClient.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                conf.setProperty("oozie.wf.application.path", appPath.toString());
                wc.reRun("job-1-W", conf);
                TestCase.assertEquals((String)"rerun", (String)MockDagEngineService.did);
                TestCase.assertTrue((boolean)MockDagEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testJobStatus() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                WorkflowJob wf = wc.getJobInfo("job-1-W");
                TestCase.assertEquals((String)"info", (String)MockDagEngineService.did);
                TestCase.assertEquals((String)"job-1-W", (String)wf.getId());
                return null;
            }
        });
    }

    public void testJobsStatus() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int i;
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                List list = wc.getJobsInfo(null);
                TestCase.assertEquals((int)4, (int)list.size());
                for (i = 0; i < 4; ++i) {
                    TestCase.assertNotNull((Object)((WorkflowJob)list.get(i)).getAppPath());
                    TestCase.assertEquals((String)("job-" + i + "-W"), (String)((WorkflowJob)list.get(i)).getId());
                }
                MockDagEngineService.reset();
                list = wc.getJobsInfo("name=x", 3, 4);
                TestCase.assertEquals((int)4, (int)list.size());
                for (i = 0; i < 4; ++i) {
                    TestCase.assertNotNull((Object)((WorkflowJob)list.get(i)).getAppPath());
                    TestCase.assertEquals((String)("job-" + i + "-W"), (String)((WorkflowJob)list.get(i)).getId());
                }
                return null;
            }
        });
    }

    public void testExternalId() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                TestCase.assertEquals((String)"id-valid", (String)wc.getJobId("external-valid"));
                TestCase.assertEquals((String)"external-id", (String)MockDagEngineService.did);
                TestCase.assertNull((Object)wc.getJobId("external-invalid"));
                return null;
            }
        });
    }

    public void testJobsStatusFilter() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                wc.getJobsInfo("name=x");
                wc.getJobsInfo("user=x");
                wc.getJobsInfo("group=x");
                wc.getJobsInfo("status=RUNNING");
                wc.getJobsInfo("name=x;name=y");
                try {
                    wc.getJobsInfo("name=");
                    TestCase.fail();
                }
                catch (OozieClientException oozieClientException) {
                    // empty catch block
                }
                try {
                    wc.getJobsInfo("x=x");
                    TestCase.fail();
                }
                catch (OozieClientException oozieClientException) {
                    // empty catch block
                }
                try {
                    wc.getJobsInfo("status=X");
                    TestCase.fail();
                }
                catch (OozieClientException oozieClientException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void testSafeMode() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                OozieClient.SYSTEM_MODE systemMode = wc.getSystemMode();
                TestCase.assertEquals((Object)systemMode, (Object)OozieClient.SYSTEM_MODE.NORMAL);
                wc.setSystemMode(OozieClient.SYSTEM_MODE.SAFEMODE);
                systemMode = wc.getSystemMode();
                TestCase.assertEquals((Object)systemMode, (Object)OozieClient.SYSTEM_MODE.SAFEMODE);
                wc.setSystemMode(OozieClient.SYSTEM_MODE.NOWEBSERVICE);
                systemMode = wc.getSystemMode();
                TestCase.assertEquals((Object)systemMode, (Object)OozieClient.SYSTEM_MODE.NOWEBSERVICE);
                return null;
            }
        });
    }

    public void testWSErrors() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL() + "dummy";
                OozieClient wc = new OozieClient(oozieUrl);
                try {
                    wc.getJobInfo("job-1");
                    TestCase.fail();
                }
                catch (OozieClientException e) {
                    TestCase.assertNotNull((Object)e.getErrorCode());
                    TestCase.assertNotNull((Object)e.getMessage());
                }
                return null;
            }
        });
    }

    public void testServerBuildVersion() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                String buildVersion = wc.getServerBuildVersion();
                JSONObject buildInfo = (JSONObject)JSONValue.parse((String)buildVersion);
                for (String buildInfoKey : BuildInfo.getBuildInfo().stringPropertyNames()) {
                    TestCase.assertEquals((String)("Build value difference in key " + buildInfoKey), (Object)BuildInfo.getBuildInfo().getProperty(buildInfoKey), (Object)buildInfo.get((Object)buildInfoKey));
                }
                return null;
            }
        });
    }

    public void testClientBuildVersion() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                TestCase.assertEquals((String)BuildInfo.getBuildInfo().getProperty("build.version"), (String)wc.getClientBuildVersion());
                return null;
            }
        });
    }

    public void testJobInformation() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                String jobId = "job-1-W";
                TestCase.assertEquals((String)"log", (String)wc.getJobLog(jobId));
                WorkflowAction wfAction = wc.getWorkflowActionInfo(jobId);
                TestCase.assertEquals((String)jobId, (String)wfAction.getId());
                CoordinatorJob job = wc.getCoordJobInfo("coord-job-C-1-C");
                TestCase.assertEquals((String)"group", (String)job.getAcl());
                TestCase.assertEquals((String)"RUNNING", (String)job.getStatus().toString());
                TestCase.assertEquals((String)"user", (String)job.getUser());
                TestCase.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(1));
                TestCase.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(1000));
                BundleJob bundleJob = wc.getBundleJobInfo(jobId);
                TestCase.assertEquals((String)"SUCCEEDED", (String)bundleJob.getStatus().toString());
                TestCase.assertEquals((String)"user", (String)bundleJob.getUser());
                return null;
            }
        });
    }

    public void testSla() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                TestWorkflowClient.this.cleanUpDBTables();
                String oozieUrl = TestWorkflowClient.this.getContextURL();
                OozieClient wc = new OozieClient(oozieUrl);
                PrintStream oldStream = System.out;
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                System.setOut(new PrintStream(data));
                try {
                    wc.getSlaInfo(0, 10, null);
                }
                finally {
                    System.setOut(oldStream);
                }
                TestCase.assertTrue((boolean)data.toString().contains("<sla-message>"));
                TestCase.assertTrue((boolean)data.toString().contains("<last-sequence-id>0</last-sequence-id>"));
                TestCase.assertTrue((boolean)data.toString().contains("</sla-message>"));
                return null;
            }
        });
    }

    static {
        new HeaderTestingVersionServlet();
        new V0JobsServlet();
        new V1JobsServlet();
        new V0JobServlet();
        new V1JobServlet();
        new V2JobServlet();
        new V1AdminServlet();
        new V2AdminServlet();
        new SLAServlet();
        new V2SLAServlet();
        END_POINTS = new String[]{"/versions", "/v0/jobs", "/v1/jobs", "/v2/jobs", "/v0/job/*", "/v1/job/*", "/v2/job/*", "/v1/admin/*", "/v2/admin/*", "/v1/sla/*", "/v2/sla/*"};
        SERVLET_CLASSES = new Class[]{HeaderTestingVersionServlet.class, V0JobsServlet.class, V1JobsServlet.class, V1JobsServlet.class, V0JobServlet.class, V1JobServlet.class, V2JobServlet.class, V1AdminServlet.class, V2AdminServlet.class, SLAServlet.class, V2SLAServlet.class};
    }

    private class OozieClientForTest
    extends OozieClient {
        public OozieClientForTest(String oozieUrl) {
            super(oozieUrl);
        }

        protected HttpURLConnection createConnection(URL url, String method) throws IOException, OozieClientException {
            HttpURLConnection result = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
            Mockito.when((Object)result.getResponseCode()).thenReturn((Object)200);
            JSONArray versions = new JSONArray();
            versions.add((Object)-11);
            versions.add((Object)-10);
            StringWriter writer = new StringWriter();
            versions.writeJSONString((Writer)writer);
            ((Writer)writer).flush();
            Mockito.when((Object)result.getInputStream()).thenReturn((Object)new ByteArrayInputStream(((Object)writer).toString().getBytes()));
            return result;
        }
    }
}

