/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.rest;

import junit.framework.TestCase;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonUtils;

public class TestJsonCoordinatorJob
extends TestCase {
    static String LAST_ACTION_TIME = "Wed, 02 Sep 2009 00:00:00 GMT";
    static String NEXT_MATERIALIZED_TIME = "Thu, 03 Sep 2009 00:00:00 GMT";
    static String START_TIME = "Fri, 04 Sep 2009 00:00:00 GMT";
    static String END_TIME = "Sat, 05 Sep 2009 00:00:00 GMT";

    static CoordinatorJobBean createApplication() {
        CoordinatorJobBean app = new CoordinatorJobBean();
        app.setAppPath("a");
        app.setAppName("b");
        app.setId("c");
        app.setConf("cc");
        app.setStatus(Job.Status.PREP);
        app.setFrequency("100");
        app.setTimeUnit(CoordinatorJob.Timeunit.WEEK);
        app.setTimeZone("timeZone");
        app.setConcurrency(10);
        app.setExecutionOrder(CoordinatorJob.Execution.FIFO);
        app.setTimeout(100);
        app.setLastActionTime(JsonUtils.parseDateRfc822((String)LAST_ACTION_TIME));
        app.setNextMaterializedTime(JsonUtils.parseDateRfc822((String)NEXT_MATERIALIZED_TIME));
        app.setStartTime(JsonUtils.parseDateRfc822((String)START_TIME));
        app.setEndTime(JsonUtils.parseDateRfc822((String)END_TIME));
        app.setUser("d");
        app.setGroup("e");
        app.setConsoleUrl("cu");
        return app;
    }

    public void testProperties() {
        CoordinatorJobBean app = TestJsonCoordinatorJob.createApplication();
        TestJsonCoordinatorJob.assertEquals((String)"a", (String)app.getAppPath());
        TestJsonCoordinatorJob.assertEquals((String)"b", (String)app.getAppName());
        TestJsonCoordinatorJob.assertEquals((String)"c", (String)app.getId());
        TestJsonCoordinatorJob.assertEquals((String)"cc", (String)app.getConf());
        TestJsonCoordinatorJob.assertEquals((Object)Job.Status.PREP, (Object)app.getStatus());
        TestJsonCoordinatorJob.assertEquals((String)"100", (String)app.getFrequency());
        TestJsonCoordinatorJob.assertEquals((Object)CoordinatorJob.Timeunit.WEEK, (Object)app.getTimeUnit());
        TestJsonCoordinatorJob.assertEquals((String)"timeZone", (String)app.getTimeZone());
        TestJsonCoordinatorJob.assertEquals((int)10, (int)app.getConcurrency());
        TestJsonCoordinatorJob.assertEquals((Object)CoordinatorJob.Execution.FIFO, (Object)app.getExecutionOrder());
        TestJsonCoordinatorJob.assertEquals((int)100, (int)app.getTimeout());
        TestJsonCoordinatorJob.assertEquals((Object)JsonUtils.parseDateRfc822((String)LAST_ACTION_TIME), (Object)app.getLastActionTime());
        TestJsonCoordinatorJob.assertEquals((Object)JsonUtils.parseDateRfc822((String)NEXT_MATERIALIZED_TIME), (Object)app.getNextMaterializedTime());
        TestJsonCoordinatorJob.assertEquals((Object)JsonUtils.parseDateRfc822((String)START_TIME), (Object)app.getStartTime());
        TestJsonCoordinatorJob.assertEquals((Object)JsonUtils.parseDateRfc822((String)END_TIME), (Object)app.getEndTime());
        TestJsonCoordinatorJob.assertEquals((String)"d", (String)app.getUser());
        TestJsonCoordinatorJob.assertEquals((String)"e", (String)app.getGroup());
        TestJsonCoordinatorJob.assertEquals((String)"cu", (String)app.getConsoleUrl());
    }
}

