/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.rest;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.rest.JsonUtils;

public class TestJsonWorkflowAction
extends TestCase {
    static String START_TIME = "Thu, 01 Jan 2009 00:00:00 GMT";
    static String END_TIME = "Fri, 02 Jan 2009 00:00:00 GMT";

    static WorkflowActionBean createNode() {
        WorkflowActionBean action = new WorkflowActionBean();
        action.setId("a");
        action.setName("b");
        action.setType("c");
        action.setConf("d");
        action.setRetries(1);
        action.setStatus(WorkflowAction.Status.RUNNING);
        action.setStartTime(JsonUtils.parseDateRfc822((String)START_TIME));
        action.setEndTime(JsonUtils.parseDateRfc822((String)END_TIME));
        action.setTransition("e");
        action.setData("ee");
        action.setStats("stats");
        action.setExternalChildIDs("extChIDs");
        action.setExternalId("f");
        action.setExternalStatus("g");
        action.setTrackerUri("h");
        action.setConsoleUrl("i");
        action.setErrorInfo("j", "k");
        return action;
    }

    public void testProperties() {
        WorkflowActionBean action = TestJsonWorkflowAction.createNode();
        Assert.assertEquals((String)"a", (String)action.getId());
        Assert.assertEquals((String)"b", (String)action.getName());
        Assert.assertEquals((String)"c", (String)action.getType());
        Assert.assertEquals((String)"d", (String)action.getConf());
        Assert.assertEquals((Object)WorkflowAction.Status.RUNNING, (Object)action.getStatus());
        Assert.assertEquals((int)1, (int)action.getRetries());
        Assert.assertEquals((Object)JsonUtils.parseDateRfc822((String)START_TIME), (Object)action.getStartTime());
        Assert.assertEquals((Object)JsonUtils.parseDateRfc822((String)END_TIME), (Object)action.getEndTime());
        Assert.assertEquals((String)"e", (String)action.getTransition());
        Assert.assertEquals((String)"ee", (String)action.getData());
        Assert.assertEquals((String)"stats", (String)action.getStats());
        Assert.assertEquals((String)"extChIDs", (String)action.getExternalChildIDs());
        Assert.assertEquals((String)"f", (String)action.getExternalId());
        Assert.assertEquals((String)"g", (String)action.getExternalStatus());
        Assert.assertEquals((String)"h", (String)action.getTrackerUri());
        Assert.assertEquals((String)"i", (String)action.getConsoleUrl());
        Assert.assertEquals((String)"j", (String)action.getErrorCode());
        Assert.assertEquals((String)"k", (String)action.getErrorMessage());
    }
}

