/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.rest;

import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.oozie.client.rest.TestJsonWorkflowAction;

public class TestJsonWorkflowJob
extends TestCase {
    static String CREATED_TIME = "Thu, 01 Jan 2009 00:00:00 GMT";
    static String START_TIME = "Fri, 02 Jan 2009 00:00:00 GMT";
    static String END_TIME = "Sat, 03 Jan 2009 00:00:00 GMT";

    static WorkflowJobBean createWorkflow() {
        WorkflowJobBean wf = new WorkflowJobBean();
        wf.setAppPath("a");
        wf.setAppName("b");
        wf.setId("c");
        wf.setConf("cc");
        wf.setStatus(WorkflowJob.Status.PREP);
        wf.setCreatedTime(JsonUtils.parseDateRfc822((String)CREATED_TIME));
        wf.setStartTime(JsonUtils.parseDateRfc822((String)START_TIME));
        wf.setEndTime(JsonUtils.parseDateRfc822((String)END_TIME));
        wf.setUser("d");
        wf.setGroup("e");
        wf.setRun(2);
        wf.setConsoleUrl("cu");
        return wf;
    }

    public void testProperties() {
        WorkflowJobBean wf = TestJsonWorkflowJob.createWorkflow();
        TestJsonWorkflowJob.assertEquals((String)"a", (String)wf.getAppPath());
        TestJsonWorkflowJob.assertEquals((String)"b", (String)wf.getAppName());
        TestJsonWorkflowJob.assertEquals((String)"c", (String)wf.getId());
        TestJsonWorkflowJob.assertEquals((String)"cc", (String)wf.getConf());
        TestJsonWorkflowJob.assertEquals((Object)WorkflowJob.Status.PREP, (Object)wf.getStatus());
        TestJsonWorkflowJob.assertEquals((Object)JsonUtils.parseDateRfc822((String)CREATED_TIME), (Object)wf.getCreatedTime());
        TestJsonWorkflowJob.assertEquals((Object)JsonUtils.parseDateRfc822((String)START_TIME), (Object)wf.getStartTime());
        TestJsonWorkflowJob.assertEquals((Object)JsonUtils.parseDateRfc822((String)END_TIME), (Object)wf.getEndTime());
        TestJsonWorkflowJob.assertEquals((String)"d", (String)wf.getUser());
        TestJsonWorkflowJob.assertEquals((String)"e", (String)wf.getGroup());
        TestJsonWorkflowJob.assertEquals((int)2, (int)wf.getRun());
        TestJsonWorkflowJob.assertEquals((String)"cu", (String)wf.getConsoleUrl());
        TestJsonWorkflowJob.assertEquals((int)0, (int)wf.getActions().size());
        wf.setActions(Arrays.asList(TestJsonWorkflowAction.createNode()));
        TestJsonWorkflowJob.assertEquals((int)1, (int)wf.getActions().size());
    }
}

