/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.OperationType;
import org.apache.oozie.command.bundle.BulkBundleXCommand;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestBulkBundleXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testBulkBundleSuspendResumeKillSuccess() throws Exception {
        BundleJobBean job1 = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleJobBean job2 = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("BUNDLE-TEST");
        map.put("name", names);
        new BulkBundleXCommand(map, 1, 50, OperationType.Suspend).call();
        this.verifyJobStatus(job1.getId(), Job.Status.SUSPENDED);
        this.verifyChildrenStatus(job1.getId(), Job.Status.SUSPENDED);
        this.verifyJobStatus(job2.getId(), Job.Status.SUSPENDED);
        this.verifyChildrenStatus(job2.getId(), Job.Status.SUSPENDED);
        new BulkBundleXCommand(map, 1, 50, OperationType.Resume).call();
        this.verifyJobStatus(job1.getId(), Job.Status.RUNNING);
        this.verifyChildrenStatus(job1.getId(), Job.Status.RUNNING);
        this.verifyJobStatus(job2.getId(), Job.Status.RUNNING);
        this.verifyChildrenStatus(job2.getId(), Job.Status.RUNNING);
        new BulkBundleXCommand(map, 1, 50, OperationType.Kill).call();
        this.verifyJobStatus(job1.getId(), Job.Status.KILLED);
        this.verifyChildrenStatus(job1.getId(), Job.Status.KILLED);
        this.verifyJobStatus(job2.getId(), Job.Status.KILLED);
        this.verifyChildrenStatus(job2.getId(), Job.Status.KILLED);
    }

    public void testBulkBundleKillNoOp() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.KILLED, false);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("BUNDLE-TEST");
        map.put("name", names);
        new BulkBundleXCommand(map, 1, 50, OperationType.Kill).call();
        this.verifyJobStatus(job.getId(), Job.Status.KILLED);
        this.verifyChildrenStatus(job.getId(), Job.Status.KILLED);
    }

    public void testBulkBundleKillNegative() throws Exception {
        BundleJobBean job1 = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleJobBean job2 = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("BUNDLE");
        map.put("name", names);
        new BulkBundleXCommand(map, 1, 50, OperationType.Kill).call();
        this.verifyJobStatus(job1.getId(), Job.Status.RUNNING);
        this.verifyChildrenStatus(job1.getId(), Job.Status.RUNNING);
        this.verifyJobStatus(job2.getId(), Job.Status.RUNNING);
        this.verifyChildrenStatus(job2.getId(), Job.Status.RUNNING);
    }

    public void testBulkBundleSuspendNoOp() throws Exception {
        BundleJobBean job1 = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleJobBean job2 = this.addRecordToBundleJobTable(Job.Status.KILLED, false);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("BUNDLE-TEST");
        map.put("name", names);
        new BulkBundleXCommand(map, 1, 10, OperationType.Suspend).call();
        this.verifyJobStatus(job1.getId(), Job.Status.SUSPENDED);
        this.verifyChildrenStatus(job1.getId(), Job.Status.SUSPENDED);
        this.verifyJobStatus(job2.getId(), Job.Status.KILLED);
        this.verifyChildrenStatus(job2.getId(), Job.Status.KILLED);
    }

    public void testBulkBundleSuspendNegative() throws Exception {
        BundleJobBean job1 = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleJobBean job2 = this.addRecordToBundleJobTable(Job.Status.KILLED, false);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("BUNDLE");
        map.put("name", names);
        new BulkBundleXCommand(map, 1, 10, OperationType.Suspend).call();
        this.verifyJobStatus(job1.getId(), Job.Status.RUNNING);
        this.verifyChildrenStatus(job1.getId(), Job.Status.RUNNING);
        this.verifyJobStatus(job2.getId(), Job.Status.KILLED);
        this.verifyChildrenStatus(job2.getId(), Job.Status.KILLED);
    }

    public void testBulkBundleResumeNegative() throws Exception {
        BundleJobBean job1 = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleJobBean job2 = this.addRecordToBundleJobTable(Job.Status.SUSPENDED, false);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("BUNDLE");
        map.put("name", names);
        new BulkBundleXCommand(map, 1, 10, OperationType.Resume).call();
        this.verifyJobStatus(job1.getId(), Job.Status.RUNNING);
        this.verifyChildrenStatus(job1.getId(), Job.Status.RUNNING);
        this.verifyJobStatus(job2.getId(), Job.Status.SUSPENDED);
        this.verifyChildrenStatus(job2.getId(), Job.Status.SUSPENDED);
    }

    public void testBulkBundleResumeNoOp() throws Exception {
        BundleJobBean job1 = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleJobBean job2 = this.addRecordToBundleJobTable(Job.Status.SUSPENDED, false);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("BUNDLE-TEST");
        map.put("name", names);
        new BulkBundleXCommand(map, 1, 10, OperationType.Resume).call();
        this.verifyJobStatus(job1.getId(), Job.Status.RUNNING);
        this.verifyChildrenStatus(job1.getId(), Job.Status.RUNNING);
        this.verifyJobStatus(job2.getId(), Job.Status.RUNNING);
        this.verifyChildrenStatus(job2.getId(), Job.Status.RUNNING);
    }

    private void verifyJobStatus(String jobId, Job.Status status) throws Exception {
        BundleJobBean job = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB, new Object[]{jobId});
        TestBulkBundleXCommand.assertEquals((Object)status, (Object)job.getStatus());
    }

    private void verifyChildrenStatus(String jobId, Job.Status status) throws Exception {
        List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{jobId});
        for (BundleActionBean action : actions) {
            String coordId = action.getCoordId();
            CoordinatorJobBean coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{coordId});
            TestBulkBundleXCommand.assertEquals((Object)status, (Object)coordJob.getStatus());
        }
    }
}

