/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.Date;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.bundle.BundleJobChangeXCommand;
import org.apache.oozie.executor.jpa.BundleActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.PauseTransitService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;

public class TestBundleChangeXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        ((SchedulerService)this.services.get(SchedulerService.class)).destroy();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testBundleChange1() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        String dateStr = "2099-01-01T01:00Z";
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleChangeXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleChangeXCommand.assertEquals((Object)job.getPauseTime(), null);
        new BundleJobChangeXCommand(job.getId(), "pausetime=" + dateStr).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleChangeXCommand.assertEquals((Object)job.getPauseTime(), (Object)DateUtils.parseDateOozieTZ((String)dateStr));
    }

    public void testBundleChange2() throws Exception {
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob.setBundleId(bundleJob.getId());
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleChangeXCommand.assertNotNull((Object)jpaService);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_BUNDLEID, coordJob);
        coordJob.setAppName("COORD-TEST1");
        TestBundleChangeXCommand.assertNotNull((Object)jpaService);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob);
        BundleActionBean bundleAction = new BundleActionBean();
        bundleAction.setBundleActionId(bundleJob.getId() + "_COORD-TEST1");
        bundleAction.setCoordId(coordJob.getId());
        bundleAction.setBundleId(bundleJob.getId());
        bundleAction.setStatus(Job.Status.SUCCEEDED);
        jpaService.execute((JPAExecutor)new BundleActionInsertJPAExecutor(bundleAction));
        String dateStr = "2099-01-01T01:00Z";
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(bundleJob.getId());
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleChangeXCommand.assertEquals((Object)bundleJob.getPauseTime(), null);
        new BundleJobChangeXCommand(bundleJob.getId(), "pausetime=" + dateStr).call();
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleChangeXCommand.assertEquals((Object)DateUtils.parseDateOozieTZ((String)dateStr), (Object)bundleJob.getPauseTime());
        final String coordJobId = coordJob.getId();
        this.waitFor(60000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean coordJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId));
                return coordJob1.getPauseTime() != null;
            }
        });
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJob.getId()));
        TestBundleChangeXCommand.assertEquals((Object)DateUtils.parseDateOozieTZ((String)dateStr), (Object)coordJob.getPauseTime());
    }

    public void testBundleChangeNegative1() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        String dateStr = "2099-01-01Ta1:00Z";
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleChangeXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleChangeXCommand.assertEquals((Object)job.getPauseTime(), null);
        try {
            new BundleJobChangeXCommand(job.getId(), "pausetime=" + dateStr).call();
            TestBundleChangeXCommand.fail((String)"Should not reach here");
        }
        catch (XException e) {
            TestBundleChangeXCommand.assertEquals((Object)ErrorCode.E1317, (Object)e.getErrorCode());
        }
    }

    public void testBundleChangeNegative2() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        String dateStr = "2009-01-01T01:00Z";
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleChangeXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleChangeXCommand.assertEquals((Object)job.getPauseTime(), null);
        try {
            new BundleJobChangeXCommand(job.getId(), "pausetime=" + dateStr).call();
            TestBundleChangeXCommand.fail((String)"Should not reach here");
        }
        catch (XException e) {
            TestBundleChangeXCommand.assertEquals((Object)ErrorCode.E1317, (Object)e.getErrorCode());
        }
    }

    public void testBundleChange3() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        String dateStr = "2099-01-01T01:00Z";
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleChangeXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleChangeXCommand.assertEquals((Object)job.getEndTime(), null);
        new BundleJobChangeXCommand(job.getId(), "endtime=" + dateStr).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleChangeXCommand.assertEquals((Object)job.getEndTime(), (Object)DateUtils.parseDateOozieTZ((String)dateStr));
    }

    public void testBundlePauseExtendMaterializesCoordinator() throws Exception {
        BundleJobBean bundle = this.addRecordToBundleJobTable(Job.Status.PAUSED, false);
        Date startTime = new Date();
        Date endTime = new Date(startTime.getTime() + 1200000L);
        CoordinatorJobBean coord = this.addRecordToCoordJobTable(Job.Status.PAUSED, startTime, endTime, true, false, 1);
        coord.setPauseTime(startTime);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_CHANGE, coord);
        BundleActionBean bundleAction = this.addRecordToBundleActionTable(bundle.getId(), "COORD-TEST", 1, Job.Status.PAUSED);
        coord.setBundleId(bundle.getId());
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_BUNDLEID, coord);
        bundleAction.setCoordId(coord.getId());
        BundleActionQueryExecutor.getInstance().executeUpdate((Enum)BundleActionQueryExecutor.BundleActionQuery.UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME_COORDID, (Object)bundleAction);
        Date later = new Date(System.currentTimeMillis() + 20000L);
        Date evenLater = new Date(later.getTime() + 600000L);
        bundle = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB, new Object[]{bundle.getId()});
        TestBundleChangeXCommand.assertEquals((Object)Job.Status.PAUSED, (Object)bundle.getStatus());
        coord = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{coord.getId()});
        TestBundleChangeXCommand.assertEquals((Object)Job.Status.PAUSED, (Object)coord.getStatus());
        coord.setNextMaterializedTime(new Date(startTime.getTime() + 300000L));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coord);
        Date lastMod = coord.getLastModifiedTime();
        this.addRecordToCoordActionTable(coord.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        new BundleJobChangeXCommand(bundle.getId(), "pausetime=" + DateUtils.formatDateOozieTZ((Date)evenLater)).call();
        this.sleep(1000);
        PauseTransitService.PauseTransitRunnable runnable = new PauseTransitService.PauseTransitRunnable();
        runnable.run();
        Thread.sleep(1000L);
        bundle = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB, new Object[]{bundle.getId()});
        TestBundleChangeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)bundle.getStatus());
        TestBundleChangeXCommand.assertEquals((String)DateUtils.formatDateOozieTZ((Date)evenLater), (String)DateUtils.formatDateOozieTZ((Date)bundle.getPauseTime()));
        coord = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{coord.getId()});
        TestBundleChangeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)coord.getStatus());
        TestBundleChangeXCommand.assertEquals((String)DateUtils.formatDateOozieTZ((Date)evenLater), (String)DateUtils.formatDateOozieTZ((Date)coord.getPauseTime()));
        TestBundleChangeXCommand.assertTrue((boolean)coord.getLastModifiedTime().after(lastMod));
    }

    public void testBundleChangeReport() throws Exception {
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        CoordinatorJobBean coordJob1 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob1.setBundleId(bundleJob.getId());
        coordJob1.setAppName("COORD-TEST1");
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleChangeXCommand.assertNotNull((Object)jpaService);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob1);
        BundleActionBean bundleAction1 = new BundleActionBean();
        bundleAction1.setBundleActionId(bundleJob.getId() + "_COORD-TEST1");
        bundleAction1.setCoordId(coordJob1.getId());
        bundleAction1.setBundleId(bundleJob.getId());
        bundleAction1.setStatus(Job.Status.SUCCEEDED);
        jpaService.execute((JPAExecutor)new BundleActionInsertJPAExecutor(bundleAction1));
        CoordinatorJobBean coordJob2 = this.addRecordToCoordJobTable(Job.Status.KILLED, false, false);
        coordJob2.setBundleId(bundleJob.getId());
        coordJob2.setAppName("COORD-TEST2");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob2);
        BundleActionBean bundleAction2 = new BundleActionBean();
        bundleAction2.setBundleActionId(bundleJob.getId() + "_COORD-TEST2");
        bundleAction2.setCoordId(coordJob2.getId());
        bundleAction2.setBundleId(bundleJob.getId());
        bundleAction2.setStatus(Job.Status.KILLED);
        jpaService.execute((JPAExecutor)new BundleActionInsertJPAExecutor(bundleAction2));
        CoordinatorJobBean coordJob3 = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordActionTable(coordJob3.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(coordJob3.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T02:00Z"));
        this.addRecordToCoordActionTable(coordJob3.getId(), 3, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T03:00Z"));
        this.addRecordToCoordActionTable(coordJob3.getId(), 4, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T04:00Z"));
        coordJob3.setBundleId(bundleJob.getId());
        coordJob3.setAppName("COORD-TEST3");
        coordJob3.setLastActionNumber(4);
        coordJob3.setEndTime(DateUtils.parseDateOozieTZ((String)"2013-08-01T04:00Z"));
        coordJob3.setStartTime(DateUtils.parseDateOozieTZ((String)"2013-08-01T00:00Z"));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob3);
        BundleActionBean bundleAction3 = new BundleActionBean();
        bundleAction3.setBundleActionId(bundleJob.getId() + "_COORD-TEST3");
        bundleAction3.setCoordId(coordJob3.getId());
        bundleAction3.setBundleId(bundleJob.getId());
        bundleAction3.setStatus(Job.Status.RUNNING);
        jpaService.execute((JPAExecutor)new BundleActionInsertJPAExecutor(bundleAction3));
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(bundleJob.getId());
        String dateStr = "2099-01-01T01:00Z";
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleChangeXCommand.assertEquals((Object)bundleJob.getPauseTime(), null);
        String reports = null;
        try {
            new BundleJobChangeXCommand(bundleJob.getId(), "pausetime=" + dateStr).call();
        }
        catch (Exception e) {
            reports = e.getMessage();
        }
        TestBundleChangeXCommand.assertTrue((boolean)reports.contains(coordJob2.getId() + " : Coord is in killed state"));
        bundleJobGetCmd = new BundleJobGetJPAExecutor(bundleJob.getId());
        dateStr = "2013-08-01T03:00Z";
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        try {
            new BundleJobChangeXCommand(bundleJob.getId(), "endtime=" + dateStr).call();
        }
        catch (Exception e) {
            reports = e.getMessage();
        }
        TestBundleChangeXCommand.assertTrue((boolean)reports.contains(coordJob2.getId() + " : Coord is in killed state"));
        TestBundleChangeXCommand.assertTrue((boolean)reports.contains(coordJob3.getId() + " : E1022: Cannot delete running/completed coordinator action"));
    }

    public void testCheckBundleActionStatus() throws Exception {
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        CoordinatorJobBean coordJob1 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob1.setBundleId(bundleJob.getId());
        coordJob1.setAppName("COORD-TEST1");
        coordJob1.setEndTime(DateUtils.parseDateOozieTZ((String)"2013-08-01T02:00Z"));
        coordJob1.setStartTime(DateUtils.parseDateOozieTZ((String)"2013-08-01T00:00Z"));
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleChangeXCommand.assertNotNull((Object)jpaService);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob1);
        BundleActionBean bundleAction1 = new BundleActionBean();
        bundleAction1.setBundleActionId(bundleJob.getId() + "_COORD-TEST1");
        bundleAction1.setCoordId(coordJob1.getId());
        bundleAction1.setBundleId(bundleJob.getId());
        bundleAction1.setStatus(Job.Status.SUCCEEDED);
        jpaService.execute((JPAExecutor)new BundleActionInsertJPAExecutor(bundleAction1));
        CoordinatorJobBean coordJob2 = this.addRecordToCoordJobTable(Job.Status.PREP, false, false);
        coordJob2.setBundleId(bundleJob.getId());
        coordJob2.setAppName("COORD-TEST2");
        coordJob2.setStartTime(DateUtils.parseDateOozieTZ((String)"2099-08-01T02:00Z"));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob2);
        BundleActionBean bundleAction2 = new BundleActionBean();
        bundleAction2.setBundleActionId(bundleJob.getId() + "_COORD-TEST2");
        bundleAction2.setCoordId(coordJob2.getId());
        bundleAction2.setBundleId(bundleJob.getId());
        bundleAction2.setStatus(Job.Status.PREP);
        jpaService.execute((JPAExecutor)new BundleActionInsertJPAExecutor(bundleAction2));
        CoordinatorJobBean coordJob3 = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordActionTable(coordJob3.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(coordJob3.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T02:00Z"));
        this.addRecordToCoordActionTable(coordJob3.getId(), 3, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T03:00Z"));
        this.addRecordToCoordActionTable(coordJob3.getId(), 4, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T04:00Z"));
        coordJob3.setBundleId(bundleJob.getId());
        coordJob3.setAppName("COORD-TEST3");
        coordJob3.setLastActionNumber(4);
        coordJob3.setEndTime(DateUtils.parseDateOozieTZ((String)"2013-08-01T04:00Z"));
        coordJob3.setStartTime(DateUtils.parseDateOozieTZ((String)"2013-08-01T00:00Z"));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob3);
        BundleActionBean bundleAction3 = new BundleActionBean();
        bundleAction3.setBundleActionId(bundleJob.getId() + "_COORD-TEST3");
        bundleAction3.setPending(1);
        bundleAction3.setCoordId(coordJob3.getId());
        bundleAction3.setBundleId(bundleJob.getId());
        bundleAction3.setStatus(Job.Status.RUNNING);
        jpaService.execute((JPAExecutor)new BundleActionInsertJPAExecutor(bundleAction3));
        String dateStr = "2013-08-01T03:00Z";
        try {
            new BundleJobChangeXCommand(bundleJob.getId(), "endtime=" + dateStr).call();
            TestBundleChangeXCommand.fail((String)"should throw exception");
        }
        catch (Exception e) {
            String reports = e.getMessage();
            TestBundleChangeXCommand.assertTrue((boolean)reports.contains(coordJob3.getId() + " : E1022: Cannot delete running/completed coordinator action"));
        }
        BundleActionBean action1 = (BundleActionBean)BundleActionQueryExecutor.getInstance().get((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTION, new Object[]{bundleJob.getId() + "_COORD-TEST1"});
        TestBundleChangeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)action1.getStatus());
        BundleActionBean action2 = (BundleActionBean)BundleActionQueryExecutor.getInstance().get((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTION, new Object[]{bundleJob.getId() + "_COORD-TEST2"});
        TestBundleChangeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)action2.getStatus());
        BundleActionBean action3 = (BundleActionBean)BundleActionQueryExecutor.getInstance().get((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTION, new Object[]{bundleJob.getId() + "_COORD-TEST3"});
        TestBundleChangeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)action3.getStatus());
        TestBundleChangeXCommand.assertEquals((int)action3.getPending(), (int)1);
    }
}

