/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.oozie.BundleJobInfo;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.bundle.BundleJobsXCommand;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestBundleJobsXCommand
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testBundleJobsGet() throws Exception {
        this.addRecordToBundleJobTable(Job.Status.PREP, false);
        this.addRecordToBundleJobTable(Job.Status.PREP, false);
        this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        this._testGetJobsForStatus();
        this._testGetJobsForGroup();
        this.addRecordToBundleJobTable(Job.Status.KILLED, false);
        this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, false);
        this._testGetJobsForAppName();
        this._testGetJobInfoForUser();
        this._testGetJobsForUserAndStatus();
    }

    private void _testGetJobsForStatus() throws Exception {
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("RUNNING");
        list.add("PREP");
        filter.put("status", list);
        BundleJobsXCommand bundlesGetCmd = new BundleJobsXCommand(filter, 1, 20);
        BundleJobInfo ret = (BundleJobInfo)bundlesGetCmd.call();
        TestBundleJobsXCommand.assertNotNull((Object)ret);
        TestBundleJobsXCommand.assertEquals((int)4, (int)ret.getBundleJobs().size());
    }

    private void _testGetJobsForGroup() throws Exception {
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(TestBundleJobsXCommand.getTestGroup());
        filter.put("group", list);
        BundleJobsXCommand bundlesGetCmd = new BundleJobsXCommand(filter, 1, 20);
        BundleJobInfo ret = (BundleJobInfo)bundlesGetCmd.call();
        TestBundleJobsXCommand.assertNotNull((Object)ret);
        TestBundleJobsXCommand.assertEquals((int)4, (int)ret.getBundleJobs().size());
    }

    private void _testGetJobsForAppName() throws Exception {
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("BUNDLE-TEST");
        filter.put("name", list);
        BundleJobsXCommand bundlesGetCmd = new BundleJobsXCommand(filter, 1, 20);
        BundleJobInfo ret = (BundleJobInfo)bundlesGetCmd.call();
        TestBundleJobsXCommand.assertNotNull((Object)ret);
        TestBundleJobsXCommand.assertEquals((int)6, (int)ret.getBundleJobs().size());
    }

    private void _testGetJobInfoForUser() throws Exception {
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(TestBundleJobsXCommand.getTestUser());
        filter.put("user", list);
        BundleJobsXCommand bundlesGetCmd = new BundleJobsXCommand(filter, 1, 20);
        BundleJobInfo ret = (BundleJobInfo)bundlesGetCmd.call();
        TestBundleJobsXCommand.assertNotNull((Object)ret);
        TestBundleJobsXCommand.assertEquals((int)6, (int)ret.getBundleJobs().size());
    }

    private void _testGetJobsForUserAndStatus() throws Exception {
        HashMap filter = new HashMap();
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(TestBundleJobsXCommand.getTestUser());
        filter.put("user", list1);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("KILLED");
        filter.put("status", list2);
        BundleJobsXCommand bundlesGetCmd = new BundleJobsXCommand(filter, 1, 20);
        BundleJobInfo ret = (BundleJobInfo)bundlesGetCmd.call();
        TestBundleJobsXCommand.assertNotNull((Object)ret);
        TestBundleJobsXCommand.assertEquals((int)1, (int)ret.getBundleJobs().size());
    }
}

