/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.bundle.BundleKillXCommand;
import org.apache.oozie.command.bundle.BundleStartXCommand;
import org.apache.oozie.command.bundle.BundleSubmitXCommand;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.StatusTransitService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;

public class TestBundleKillXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testBundleKill1() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleKillXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleKillXCommand.assertEquals((Object)Job.Status.PREP, (Object)job.getStatus());
        new BundleKillXCommand(job.getId()).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleKillXCommand.assertEquals((Object)Job.Status.KILLED, (Object)job.getStatus());
    }

    public void testBundleKill2() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        XConfiguration jobConf = null;
        try {
            jobConf = new XConfiguration((Reader)new StringReader(job.getConf()));
        }
        catch (IOException ioe) {
            this.log.warn((Object)("Configuration parse error. read from DB :" + job.getConf()), (Throwable)ioe);
            throw new CommandException(ErrorCode.E1005, new Object[]{ioe});
        }
        Path appPath = new Path(jobConf.get("oozie.bundle.application.path"), "bundle.xml");
        jobConf.set("oozie.bundle.application.path", appPath.toString());
        new BundleKillXCommand(job.getId()).call();
        BundleSubmitXCommand submitCmd = new BundleSubmitXCommand((Configuration)jobConf);
        submitCmd.call();
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(submitCmd.getJob().getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleKillXCommand.assertEquals((Object)Job.Status.PREP, (Object)job.getStatus());
        new BundleStartXCommand(job.getId()).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleKillXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)job.getStatus());
        this.sleep(2000);
        List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{job.getId()});
        TestBundleKillXCommand.assertEquals((int)2, (int)actions.size());
        TestBundleKillXCommand.assertNotNull((Object)((BundleActionBean)actions.get(0)).getCoordId());
        TestBundleKillXCommand.assertNotNull((Object)((BundleActionBean)actions.get(1)).getCoordId());
        new BundleKillXCommand(job.getId()).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleKillXCommand.assertEquals((Object)Job.Status.KILLED, (Object)job.getStatus());
        actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{job.getId()});
        TestBundleKillXCommand.assertEquals((boolean)true, (boolean)((BundleActionBean)actions.get(0)).isPending());
        TestBundleKillXCommand.assertEquals((boolean)true, (boolean)((BundleActionBean)actions.get(1)).isPending());
        final CoordJobGetJPAExecutor coordGetCmd1 = new CoordJobGetJPAExecutor(((BundleActionBean)actions.get(0)).getCoordId());
        final CoordJobGetJPAExecutor coordGetCmd2 = new CoordJobGetJPAExecutor(((BundleActionBean)actions.get(1)).getCoordId());
        this.waitFor(200000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean job1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd1);
                return job1.getStatus().equals((Object)Job.Status.KILLED);
            }
        });
        CoordinatorJobBean job1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd1);
        TestBundleKillXCommand.assertEquals((Object)Job.Status.KILLED, (Object)job1.getStatus());
        this.waitFor(200000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean job2 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd2);
                return job2.getStatus().equals((Object)Job.Status.KILLED);
            }
        });
        CoordinatorJobBean job2 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd2);
        TestBundleKillXCommand.assertEquals((Object)Job.Status.KILLED, (Object)job2.getStatus());
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(1000);
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleKillXCommand.assertEquals((Object)Job.Status.KILLED, (Object)job.getStatus());
        actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{job.getId()});
        for (BundleActionBean action : actions) {
            TestBundleKillXCommand.assertEquals((int)0, (int)action.getPending());
            TestBundleKillXCommand.assertEquals((Object)Job.Status.KILLED, (Object)action.getStatus());
        }
        job.setPending();
        job.setStatus(Job.Status.RUNNING);
        ((BundleActionBean)actions.get(0)).incrementAndGetPending();
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS_PENDING, (Object)job);
        BundleActionQueryExecutor.getInstance().executeUpdate((Enum)BundleActionQueryExecutor.BundleActionQuery.UPDATE_BUNDLE_ACTION_PENDING_MODTIME, actions.get(0));
        runnable.run();
        this.sleep(1000);
        new BundleKillXCommand(job.getId()).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleKillXCommand.assertEquals((Object)Job.Status.KILLED, (Object)job.getStatus());
        runnable.run();
        this.sleep(1000);
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleKillXCommand.assertEquals((Object)Job.Status.KILLED, (Object)job.getStatus());
        actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{job.getId()});
        for (BundleActionBean action : actions) {
            TestBundleKillXCommand.assertEquals((int)0, (int)action.getPending());
            TestBundleKillXCommand.assertEquals((Object)Job.Status.KILLED, (Object)action.getStatus());
        }
    }

    public void testBundleKill3() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleKillXCommand.assertNotNull((Object)jpaService);
        XConfiguration jobConf = null;
        try {
            jobConf = new XConfiguration((Reader)new StringReader(job.getConf()));
        }
        catch (IOException ioe) {
            this.log.warn((Object)("Configuration parse error. read from DB :" + job.getConf()), (Throwable)ioe);
            throw new CommandException(ErrorCode.E1005, new Object[]{ioe});
        }
        Path appPath = new Path(jobConf.get("oozie.bundle.application.path"), "bundle.xml");
        jobConf.set("oozie.bundle.application.path", appPath.toString());
        BundleSubmitXCommand submitCmd = new BundleSubmitXCommand((Configuration)jobConf);
        submitCmd.call();
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(submitCmd.getJob().getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleKillXCommand.assertEquals((Object)Job.Status.PREP, (Object)job.getStatus());
        new BundleKillXCommand(job.getId()).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundleKillXCommand.assertEquals((Object)Job.Status.KILLED, (Object)job.getStatus());
    }

    public void testBundleKillFailed() throws Exception {
        this.addRecordToBundleJobTable(Job.Status.PREP, false);
        try {
            new BundleKillXCommand("bundle-id").call();
            TestBundleKillXCommand.fail((String)"Job doesn't exist. Should fail.");
        }
        catch (CommandException commandException) {
            // empty catch block
        }
    }
}

