/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.Date;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.bundle.BundleRerunXCommand;
import org.apache.oozie.executor.jpa.BundleActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestBundleRerunXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testBundleRerun1() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, false);
        CoordinatorJobBean coord1 = this.addRecordToCoordJobTable("action1", Job.Status.SUCCEEDED, false, false);
        CoordinatorJobBean coord2 = this.addRecordToCoordJobTable("action2", Job.Status.SUCCEEDED, false, false);
        this.addRecordToBundleActionTable(job.getId(), coord1.getId(), "action1", 0, Job.Status.SUCCEEDED);
        this.addRecordToBundleActionTable(job.getId(), coord2.getId(), "action2", 0, Job.Status.SUCCEEDED);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleRerunXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)job.getStatus());
        new BundleRerunXCommand(job.getId(), null, "2009-02-01T00:00Z", false, true).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)job.getStatus());
    }

    public void testBundleRerun2() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, false);
        CoordinatorJobBean coord1 = this.addRecordToCoordJobTable("action1", Job.Status.SUCCEEDED, false, false);
        CoordinatorJobBean coord2 = this.addRecordToCoordJobTable("action2", Job.Status.SUCCEEDED, false, false);
        this.addRecordToBundleActionTable(job.getId(), coord1.getId(), "action1", 0, Job.Status.SUCCEEDED);
        this.addRecordToBundleActionTable(job.getId(), coord2.getId(), "action2", 0, Job.Status.SUCCEEDED);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleRerunXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)job.getStatus());
        new BundleRerunXCommand(job.getId(), "action1", null, false, true).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)job.getStatus());
    }

    public void testBundleRerunKilledCoordinator() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.DONEWITHERROR, false);
        String bundleId = job.getId();
        this.addRecordToBundleActionTable(bundleId, "action1", 0, Job.Status.KILLED);
        this.addRecordToCoordJobTableWithBundle(bundleId, "action1", Job.Status.KILLED, false, false, 1);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleRerunXCommand.assertNotNull((Object)jpaService);
        new BundleRerunXCommand(bundleId, "action1", null, false, true).call();
        this.sleep(1000);
        BundleActionGetJPAExecutor bundleActionJPA = new BundleActionGetJPAExecutor(bundleId, "action1");
        BundleActionBean ba = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionJPA);
        TestBundleRerunXCommand.assertEquals((int)0, (int)ba.getPending());
    }

    public void testBundleRerunWithError() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.services.init();
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.DONEWITHERROR, false);
        CoordinatorJobBean coord1 = this.addRecordToCoordJobTable("action1", Job.Status.SUCCEEDED, false, false);
        CoordinatorJobBean coord2 = this.addRecordToCoordJobTable("action2", Job.Status.FAILED, false, false);
        this.addRecordToBundleActionTable(job.getId(), coord1.getId(), "action1", 0, Job.Status.SUCCEEDED);
        this.addRecordToBundleActionTable(job.getId(), coord2.getId(), "action2", 0, Job.Status.FAILED);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleRerunXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.DONEWITHERROR, (Object)job.getStatus());
        new BundleRerunXCommand(job.getId(), null, "2009-02-01T00:00Z", false, true).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.RUNNINGWITHERROR, (Object)job.getStatus());
    }

    public void testBundleRerunInPrep() throws Exception {
        Date curr = new Date();
        Date pauseTime = new Date(curr.getTime() - 1000L);
        BundleJobBean job = this.addRecordToBundleJobTableWithPausedTime(Job.Status.PREP, false, pauseTime);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleRerunXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.PREP, (Object)job.getStatus());
        new BundleRerunXCommand(job.getId(), "action2", null, false, true).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.PREP, (Object)job.getStatus());
    }

    public void testBundleRerunInPaused() throws Exception {
        Date curr = new Date();
        Date pauseTime = new Date(curr.getTime() - 1000L);
        BundleJobBean job = this.addRecordToBundleJobTableWithPausedTime(Job.Status.PAUSED, false, pauseTime);
        this.addRecordToBundleActionTable(job.getId(), "action1", 0, Job.Status.SUCCEEDED);
        this.addRecordToBundleActionTable(job.getId(), "action2", 0, Job.Status.PAUSED);
        this.addRecordToCoordJobTable("action1", Job.Status.SUCCEEDED, false, false);
        this.addRecordToCoordJobTable("action2", Job.Status.PAUSED, false, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleRerunXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.PAUSED, (Object)job.getStatus());
        new BundleRerunXCommand(job.getId(), "action2", null, false, true).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.PAUSED, (Object)job.getStatus());
        TestBundleRerunXCommand.assertNotNull((Object)job.getPauseTime());
        TestBundleRerunXCommand.assertFalse((boolean)job.isPending());
    }

    public void testBundleRerunInPausedWithError() throws Exception {
        Date curr = new Date();
        Date pauseTime = new Date(curr.getTime() - 1000L);
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.services.init();
        BundleJobBean job = this.addRecordToBundleJobTableWithPausedTime(Job.Status.PAUSEDWITHERROR, false, pauseTime);
        this.addRecordToBundleActionTable(job.getId(), "action1", 0, Job.Status.FAILED);
        this.addRecordToBundleActionTable(job.getId(), "action2", 0, Job.Status.PAUSED);
        this.addRecordToCoordJobTable("action1", Job.Status.FAILED, false, false);
        this.addRecordToCoordJobTable("action2", Job.Status.PAUSED, false, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleRerunXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.PAUSEDWITHERROR, (Object)job.getStatus());
        new BundleRerunXCommand(job.getId(), "action2", null, false, true).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.PAUSEDWITHERROR, (Object)job.getStatus());
        TestBundleRerunXCommand.assertNotNull((Object)job.getPauseTime());
        TestBundleRerunXCommand.assertFalse((boolean)job.isPending());
    }

    public void testBundleRerunInSuspended() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.SUSPENDED, false);
        CoordinatorJobBean coord1 = this.addRecordToCoordJobTable("action1", Job.Status.SUSPENDED, false, false);
        CoordinatorJobBean coord2 = this.addRecordToCoordJobTable("action2", Job.Status.SUSPENDED, false, false);
        this.addRecordToBundleActionTable(job.getId(), coord1.getId(), "action1", 0, Job.Status.SUSPENDED);
        this.addRecordToBundleActionTable(job.getId(), coord2.getId(), "action2", 0, Job.Status.SUSPENDED);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleRerunXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.SUSPENDED, (Object)job.getStatus());
        new BundleRerunXCommand(job.getId(), "action2", null, false, true).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)job.getStatus());
    }

    public void testBundleRerunInSuspendedWithError() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.services.init();
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.SUSPENDEDWITHERROR, false);
        CoordinatorJobBean coord1 = this.addRecordToCoordJobTable("action1", Job.Status.SUSPENDED, false, false);
        CoordinatorJobBean coord2 = this.addRecordToCoordJobTable("action2", Job.Status.SUSPENDEDWITHERROR, false, false);
        this.addRecordToBundleActionTable(job.getId(), coord1.getId(), "action1", 0, Job.Status.SUSPENDED);
        this.addRecordToBundleActionTable(job.getId(), coord2.getId(), "action2", 0, Job.Status.SUSPENDEDWITHERROR);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleRerunXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.SUSPENDEDWITHERROR, (Object)job.getStatus());
        new BundleRerunXCommand(job.getId(), "action2", null, false, true).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleRerunXCommand.assertEquals((Object)Job.Status.RUNNINGWITHERROR, (Object)job.getStatus());
    }

    protected BundleJobBean addRecordToBundleJobTableWithPausedTime(Job.Status jobStatus, boolean pending, Date pausedTime) throws Exception {
        BundleJobBean bundle = this.createBundleJob(jobStatus, pending);
        bundle.setPauseTime(pausedTime);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestBundleRerunXCommand.assertNotNull((Object)jpaService);
            BundleJobInsertJPAExecutor bundleInsertjpa = new BundleJobInsertJPAExecutor(bundle);
            jpaService.execute((JPAExecutor)bundleInsertjpa);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            TestBundleRerunXCommand.fail((String)"Unable to insert the test bundle job record to table");
            throw ce;
        }
        return bundle;
    }

    protected CoordinatorJobBean addRecordToCoordJobTable(String coordId, Job.Status status, boolean pending, boolean doneMatd) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(status, pending, doneMatd);
        coordJob.setId(coordId);
        coordJob.setAppName(coordId);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestBundleRerunXCommand.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestBundleRerunXCommand.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
        return coordJob;
    }
}

