/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.bundle.BundleCoordSubmitXCommand;
import org.apache.oozie.command.bundle.BundleStartXCommand;
import org.apache.oozie.command.bundle.BundleSubmitXCommand;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;

public class TestBundleSubmitXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testJobXmlCommentRemoved() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleSubmitXCommand.assertNotNull((Object)jpaService);
        XConfiguration jobConf = null;
        try {
            jobConf = new XConfiguration((Reader)new StringReader(job.getConf()));
        }
        catch (IOException ioe) {
            this.log.warn((Object)("Configuration parse error. read from DB :" + job.getConf()), (Throwable)ioe);
            throw new CommandException(ErrorCode.E1005, new Object[]{ioe});
        }
        Path appPath = new Path(jobConf.get("oozie.bundle.application.path"), "bundle.xml");
        jobConf.set("oozie.bundle.application.path", appPath.toString());
        BundleSubmitXCommand command = new BundleSubmitXCommand(true, (Configuration)jobConf);
        BundleJobBean bundleBean = (BundleJobBean)command.getJob();
        bundleBean.setStartTime(new Date());
        bundleBean.setEndTime(new Date());
        command.call();
        String result = command.submit();
        TestBundleSubmitXCommand.assertTrue((String)"submit result should not contain <!-- ", (!result.contains("<!--") ? 1 : 0) != 0);
        TestBundleSubmitXCommand.assertTrue((String)"submit result should not contain --> ", (!result.contains("-->") ? 1 : 0) != 0);
    }

    public void testCoordJobNameParameterization() throws Exception {
        XConfiguration jobConf = this.setUpBundle();
        jobConf.set("coordName1", "coord1");
        jobConf.set("coordName2", "coord2");
        jobConf.set("coord1.starttime", "2009-02-01T00:00Z");
        BundleSubmitXCommand command = new BundleSubmitXCommand((Configuration)jobConf);
        BundleJobBean bundleBean = (BundleJobBean)command.getJob();
        bundleBean.setStartTime(new Date());
        bundleBean.setEndTime(new Date());
        final String jobId = (String)command.call();
        this.sleep(2000);
        new BundleStartXCommand(jobId).call();
        this.waitFor(200000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{jobId});
                return ((BundleActionBean)actions.get(0)).getStatus().equals((Object)Job.Status.RUNNING);
            }
        });
        List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{jobId});
        TestBundleSubmitXCommand.assertEquals((String)((BundleActionBean)actions.get(0)).getCoordName(), (String)"coord1");
        TestBundleSubmitXCommand.assertEquals((String)((BundleActionBean)actions.get(1)).getCoordName(), (String)"coord2");
    }

    public void testDuplicateCoordName() throws Exception {
        XConfiguration jobConf = this.setUpBundle();
        jobConf.set("coordName1", "coord");
        jobConf.set("coordName2", "coord");
        BundleSubmitXCommand command = new BundleSubmitXCommand(true, (Configuration)jobConf);
        BundleJobBean bundleBean = (BundleJobBean)command.getJob();
        bundleBean.setStartTime(new Date());
        bundleBean.setEndTime(new Date());
        try {
            command.call();
        }
        catch (CommandException e) {
            TestBundleSubmitXCommand.assertTrue((boolean)e.getMessage().contains("Bundle Job submission Error"));
            TestBundleSubmitXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E1310);
        }
    }

    public void testMultipleCoordSubmit() throws Exception {
        XConfiguration jobConf = this.setUpBundle();
        jobConf.set("coordName1", "coord1");
        jobConf.set("coordName2", "coord2");
        jobConf.set("coord1.starttime", "2009-02-01T00:00Z");
        BundleSubmitXCommand command = new BundleSubmitXCommand((Configuration)jobConf);
        BundleJobBean bundleBean = (BundleJobBean)command.getJob();
        bundleBean.setStartTime(new Date());
        bundleBean.setEndTime(new Date());
        final String jobId = (String)command.call();
        this.sleep(2000);
        new BundleStartXCommand(jobId).call();
        this.waitFor(2000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{jobId});
                return ((BundleActionBean)actions.get(0)).getStatus().equals((Object)Job.Status.RUNNING);
            }
        });
        List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{jobId});
        TestBundleSubmitXCommand.assertEquals((int)actions.size(), (int)2);
        TestBundleSubmitXCommand.assertEquals((String)((BundleActionBean)actions.get(0)).getCoordName(), (String)"coord1");
        TestBundleSubmitXCommand.assertEquals((String)((BundleActionBean)actions.get(1)).getCoordName(), (String)"coord2");
        try {
            new BundleCoordSubmitXCommand((Configuration)jobConf, jobId, "coord1").call();
            TestBundleSubmitXCommand.fail((String)"Should fail. Coord job is already created");
        }
        catch (CommandException e) {
            TestBundleSubmitXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E1304);
        }
        actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{jobId});
        TestBundleSubmitXCommand.assertEquals((int)actions.size(), (int)2);
        TestBundleSubmitXCommand.assertEquals((String)((BundleActionBean)actions.get(0)).getStatusStr(), (String)"RUNNING");
        TestBundleSubmitXCommand.assertEquals((String)((BundleActionBean)actions.get(1)).getStatusStr(), (String)"RUNNING");
    }

    private XConfiguration setUpBundle() throws UnsupportedEncodingException, IOException {
        XConfiguration jobConf = new XConfiguration();
        Path coordPath1 = new Path(this.getFsTestCaseDir(), "coord1");
        Path coordPath2 = new Path(this.getFsTestCaseDir(), "coord2");
        this.writeCoordXml(coordPath1, "coord-job-bundle.xml");
        this.writeCoordXml(coordPath2, "coord-job-bundle.xml");
        Path bundleAppPath = new Path(this.getFsTestCaseDir(), "bundle");
        String bundleAppXml = this.getBundleXml("bundle-submit-job-with-functions.xml");
        TestBundleSubmitXCommand.assertNotNull((Object)bundleAppXml);
        TestBundleSubmitXCommand.assertTrue((bundleAppXml.length() > 0 ? 1 : 0) != 0);
        bundleAppXml = bundleAppXml.replaceAll("#app_path1", Matcher.quoteReplacement(new Path(coordPath1.toString(), "coordinator.xml").toString()));
        bundleAppXml = bundleAppXml.replaceAll("#app_path2", Matcher.quoteReplacement(new Path(coordPath2.toString(), "coordinator.xml").toString()));
        this.writeToFile(bundleAppXml, bundleAppPath, "bundle.xml");
        Path appPath = new Path(bundleAppPath, "bundle.xml");
        jobConf.set("oozie.bundle.application.path", appPath.toString());
        jobConf.set("appName", "test");
        jobConf.set("user.name", TestBundleSubmitXCommand.getTestUser());
        return jobConf;
    }
}

