/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.service.AbandonedCoordCheckerService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestAbandonedCoordChecker
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        ((SchedulerService)this.services.get(SchedulerService.class)).destroy();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void tesAbandonedFailed() throws Exception {
        Date start = DateUtils.addMonths((Date)new Date(), (int)-1);
        Date end = DateUtils.addHours((Date)new Date(), (int)4);
        Date createdTime = start;
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, createdTime, true, false, 5);
        this.addRecordToCoordActionTable(job1.getId(), 5, CoordinatorAction.Status.FAILED);
        CoordinatorJobBean job2 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, createdTime, true, false, 4);
        this.addRecordToCoordActionTable(job2.getId(), 4, CoordinatorAction.Status.FAILED);
        ExtendedAbandonedCoordCheckerRunnable coordChecked = new ExtendedAbandonedCoordCheckerRunnable(5);
        coordChecked.run();
        String msg = coordChecked.getMessage();
        TestAbandonedCoordChecker.assertTrue((boolean)msg.contains(job1.getId()));
        TestAbandonedCoordChecker.assertFalse((boolean)msg.contains(job2.getId()));
    }

    public void testNoAbandoned() throws Exception {
        Date start = DateUtils.addMonths((Date)new Date(), (int)-1);
        Date end = DateUtils.addHours((Date)new Date(), (int)4);
        Date createdTime = start;
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, createdTime, true, false, 6);
        this.addRecordToCoordActionTable(job1.getId(), 6, CoordinatorAction.Status.SUCCEEDED, CoordinatorAction.Status.FAILED);
        CoordinatorJobBean job2 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, start, end, createdTime, true, false, 6);
        this.addRecordToCoordActionTable(job2.getId(), 6, CoordinatorAction.Status.SUCCEEDED, CoordinatorAction.Status.FAILED);
        ExtendedAbandonedCoordCheckerRunnable coordChecked = new ExtendedAbandonedCoordCheckerRunnable(5);
        coordChecked.run();
        TestAbandonedCoordChecker.assertNull((Object)coordChecked.getMessage());
    }

    public void testMessage_withTimedout() throws Exception {
        Date start = DateUtils.addMonths((Date)new Date(), (int)-1);
        Date end = DateUtils.addHours((Date)new Date(), (int)4);
        Date createdTime = start;
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, createdTime, true, false, 12);
        this.addRecordToCoordActionTable(job1.getId(), 12, CoordinatorAction.Status.TIMEDOUT);
        CoordinatorJobBean job2 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, createdTime, true, false, 4);
        this.addRecordToCoordActionTable(job2.getId(), 4, CoordinatorAction.Status.TIMEDOUT);
        ExtendedAbandonedCoordCheckerRunnable coordChecked = new ExtendedAbandonedCoordCheckerRunnable(10);
        coordChecked.run();
        String msg = coordChecked.getMessage();
        TestAbandonedCoordChecker.assertTrue((boolean)msg.contains(job1.getId()));
        TestAbandonedCoordChecker.assertFalse((boolean)msg.contains(job2.getId()));
    }

    public void testMessage_withMixedStatus() throws Exception {
        Date start = DateUtils.addMonths((Date)new Date(), (int)-1);
        Date end = DateUtils.addHours((Date)new Date(), (int)4);
        Date createdTime = start;
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, createdTime, true, false, 5);
        this.addRecordToCoordActionTable(job1.getId(), 5, CoordinatorAction.Status.FAILED, CoordinatorAction.Status.SUSPENDED, CoordinatorAction.Status.TIMEDOUT);
        CoordinatorJobBean job2 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, createdTime, true, false, 5);
        this.addRecordToCoordActionTable(job2.getId(), 5, CoordinatorAction.Status.FAILED, CoordinatorAction.Status.SUSPENDED, CoordinatorAction.Status.TIMEDOUT);
        CoordinatorJobBean job3 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, start, end, createdTime, true, false, 5);
        this.addRecordToCoordActionTable(job3.getId(), 5, CoordinatorAction.Status.FAILED, CoordinatorAction.Status.SUSPENDED, CoordinatorAction.Status.TIMEDOUT);
        ExtendedAbandonedCoordCheckerRunnable coordChecked = new ExtendedAbandonedCoordCheckerRunnable(5);
        coordChecked.run();
        String msg = coordChecked.getMessage();
        TestAbandonedCoordChecker.assertTrue((boolean)msg.contains(job1.getId()));
        TestAbandonedCoordChecker.assertTrue((boolean)msg.contains(job2.getId()));
        TestAbandonedCoordChecker.assertFalse((boolean)msg.contains(job3.getId()));
    }

    public void testKill() throws Exception {
        Date start = DateUtils.addMonths((Date)new Date(), (int)-1);
        Date end = DateUtils.addHours((Date)new Date(), (int)4);
        Date createdTime = start;
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, createdTime, true, false, 6);
        this.addRecordToCoordActionTable(job1.getId(), 6, CoordinatorAction.Status.FAILED);
        CoordinatorJobBean job2 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, createdTime, true, false, 4);
        this.addRecordToCoordActionTable(job2.getId(), 4, CoordinatorAction.Status.FAILED);
        new AbandonedCoordCheckerService.AbandonedCoordCheckerRunnable(5, true).run();
        TestAbandonedCoordChecker.assertEquals((Object)CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job1.getId()}).getStatus(), (Object)Job.Status.KILLED);
        TestAbandonedCoordChecker.assertEquals((Object)CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job2.getId()}).getStatus(), (Object)Job.Status.RUNNING);
    }

    public void testStartTime() throws Exception {
        Date start = DateUtils.addDays((Date)new Date(), (int)1);
        Date end = DateUtils.addDays((Date)new Date(), (int)6);
        Date createdTime = new Date();
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, createdTime, true, false, 6);
        this.addRecordToCoordActionTable(job1.getId(), 6, CoordinatorAction.Status.FAILED);
        start = DateUtils.addDays((Date)new Date(), (int)-3);
        createdTime = DateUtils.addDays((Date)new Date(), (int)-4);
        CoordinatorJobBean job2 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, createdTime, true, false, 4);
        this.addRecordToCoordActionTable(job2.getId(), 10, CoordinatorAction.Status.FAILED);
        new AbandonedCoordCheckerService.AbandonedCoordCheckerRunnable(5, true).run();
        TestAbandonedCoordChecker.assertEquals((Object)CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job1.getId()}).getStatus(), (Object)Job.Status.RUNNING);
        TestAbandonedCoordChecker.assertEquals((Object)CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job2.getId()}).getStatus(), (Object)Job.Status.KILLED);
    }

    public void testCatchupJob() throws Exception {
        Date start = DateUtils.addMonths((Date)new Date(), (int)-1);
        Date end = DateUtils.addHours((Date)new Date(), (int)4);
        Date createdTime = DateUtils.addDays((Date)new Date(), (int)-1);
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, createdTime, true, false, 6);
        this.addRecordToCoordActionTable(job1.getId(), 6, CoordinatorAction.Status.FAILED);
        createdTime = DateUtils.addDays((Date)new Date(), (int)-3);
        CoordinatorJobBean job2 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, createdTime, true, false, 4);
        this.addRecordToCoordActionTable(job2.getId(), 10, CoordinatorAction.Status.FAILED);
        new AbandonedCoordCheckerService.AbandonedCoordCheckerRunnable(5, true).run();
        TestAbandonedCoordChecker.assertEquals((Object)CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job1.getId()}).getStatus(), (Object)Job.Status.RUNNING);
        TestAbandonedCoordChecker.assertEquals((Object)CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job2.getId()}).getStatus(), (Object)Job.Status.KILLED);
    }

    private void addRecordToCoordActionTable(String jobId, int count, CoordinatorAction.Status ... status) throws Exception {
        for (int i = 1; i <= count; ++i) {
            CoordinatorAction.Status jobStatus = status[status.length - 1];
            if (i <= status.length) {
                jobStatus = status[i - 1];
            }
            this.addRecordToCoordActionTable(jobId, i, jobStatus, "coord-action-get.xml", 0);
        }
    }

    public static class ExtendedAbandonedCoordCheckerRunnable
    extends AbandonedCoordCheckerService.AbandonedCoordCheckerRunnable {
        String message;

        public ExtendedAbandonedCoordCheckerRunnable(int failureLimit) {
            super(failureLimit);
        }

        public void sendMail(String body) throws Exception {
            this.message = body;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

