/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.command.coord.CoordActionInputCheckXCommand;
import org.apache.oozie.command.coord.CoordActionMissingDependenciesXCommand;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.command.coord.CoordMaterializeTransitionXCommand;
import org.apache.oozie.command.coord.CoordPushDependencyCheckXCommand;
import org.apache.oozie.command.coord.CoordSubmitXCommand;
import org.apache.oozie.coord.input.logic.TestCoordInputLogicPush;
import org.apache.oozie.dependency.ActionDependency;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XHCatTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.Pair;
import org.apache.oozie.util.XConfiguration;

public class TestCoordActionMissingDependenciesXCommand
extends XHCatTestCase {
    private Services services;
    final String TABLE = "table1";
    final String DB_A = "db_a";
    final String DB_B = "db_b";
    final String DB_C = "db_c";
    final String DB_D = "db_d";
    final String DB_E = "db_e";
    final String DB_F = "db_f";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = super.setupServicesForHCatalog();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionPullDependencyMissing() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"coord-multiple-output-instance5.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "coordinator.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordActionMissingDependenciesXCommand.getTestUser());
        conf.set("data_set_a", "file://" + this.getTestCaseDir() + "/input-data/a/${YEAR}/${DAY}");
        conf.set("data_set_b", "file://" + this.getTestCaseDir() + "/input-data/b/${YEAR}/${DAY}");
        conf.set("data_set_c", "file://" + this.getTestCaseDir() + "/input-data/c/${YEAR}/${DAY}");
        conf.set("data_set_d", "file://" + this.getTestCaseDir() + "/input-data/d/${YEAR}/${DAY}");
        conf.set("data_set_e", "file://" + this.getTestCaseDir() + "/input-data/e/${YEAR}/${DAY}");
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        List data = (List)new CoordActionMissingDependenciesXCommand(jobId + "@1").call();
        Map dependencyMap = (Map)((Pair)data.get(0)).getSecond();
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)6, (int)dependencyMap.size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)1, (int)((ActionDependency)dependencyMap.get("A")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)6, (int)((ActionDependency)dependencyMap.get("B")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)1, (int)((ActionDependency)dependencyMap.get("C")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)1, (int)((ActionDependency)dependencyMap.get("D")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)6, (int)((ActionDependency)dependencyMap.get("E")).getMissingDependencies().size());
        this.createTestCaseSubDir("input-data/a/2009/01/_SUCCESS".split("/"));
        this.createTestCaseSubDir("input-data/b/2009/01/_SUCCESS".split("/"));
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        data = (List)new CoordActionMissingDependenciesXCommand(jobId + "@1").call();
        dependencyMap = (Map)((Pair)data.get(0)).getSecond();
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)5, (int)dependencyMap.size());
        TestCoordActionMissingDependenciesXCommand.assertNull(dependencyMap.get("A"));
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)5, (int)((ActionDependency)dependencyMap.get("B")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertTrue((boolean)((ActionDependency)dependencyMap.get("B")).getMissingDependencies().contains("file://" + this.getTestCaseDir() + "/input-data/b/2009/31/_SUCCESS"));
        TestCoordActionMissingDependenciesXCommand.assertTrue((boolean)((ActionDependency)dependencyMap.get("B")).getMissingDependencies().contains("file://" + this.getTestCaseDir() + "/input-data/b/2009/30/_SUCCESS"));
        TestCoordActionMissingDependenciesXCommand.assertTrue((boolean)((ActionDependency)dependencyMap.get("B")).getMissingDependencies().contains("file://" + this.getTestCaseDir() + "/input-data/b/2009/29/_SUCCESS"));
        TestCoordActionMissingDependenciesXCommand.assertTrue((boolean)((ActionDependency)dependencyMap.get("B")).getMissingDependencies().contains("file://" + this.getTestCaseDir() + "/input-data/b/2009/28/_SUCCESS"));
        TestCoordActionMissingDependenciesXCommand.assertTrue((boolean)((ActionDependency)dependencyMap.get("B")).getMissingDependencies().contains("file://" + this.getTestCaseDir() + "/input-data/b/2009/27/_SUCCESS"));
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)1, (int)((ActionDependency)dependencyMap.get("C")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)1, (int)((ActionDependency)dependencyMap.get("D")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((String)((String)((ActionDependency)dependencyMap.get("D")).getMissingDependencies().get(0)), (String)("file://" + this.getTestCaseDir() + "/input-data/d/2009/01"));
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)6, (int)((ActionDependency)dependencyMap.get("E")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)2, (int)((ActionDependency)dependencyMap.get("F")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((String)((String)((ActionDependency)dependencyMap.get("F")).getMissingDependencies().get(0)), (String)("file://" + this.getTestCaseDir() + "/input-data/e/2009/01/_SUCCESS"));
        TestCoordActionMissingDependenciesXCommand.assertEquals((String)((String)((ActionDependency)dependencyMap.get("F")).getMissingDependencies().get(1)), (String)("${coord:latest(0)} -> file://" + this.getTestCaseDir() + "/input-data/e/${YEAR}/${DAY}"));
    }

    public void testCoordActionPushDependencyMissing() throws Exception {
        this.createTestTables();
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"coord-multiple-output-instance5.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "coordinator.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordActionMissingDependenciesXCommand.getTestUser());
        String datasetSuffix = "/table1/dt=${YEAR}${DAY};country=usa";
        String datasetPrefix = "hcat://" + this.getMetastoreAuthority() + "/";
        conf.set("data_set_a", datasetPrefix.toString() + "db_a" + datasetSuffix);
        conf.set("data_set_b", datasetPrefix.toString() + "db_b" + datasetSuffix);
        conf.set("data_set_c", datasetPrefix.toString() + "db_c" + datasetSuffix);
        conf.set("data_set_d", datasetPrefix.toString() + "db_d" + datasetSuffix);
        conf.set("data_set_e", datasetPrefix.toString() + "db_e" + datasetSuffix);
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        List data = (List)new CoordActionMissingDependenciesXCommand(jobId + "@1").call();
        TestCoordActionMissingDependenciesXCommand.assertEquals((String)(datasetPrefix + "db_a/table1/dt=200901;country=usa"), (String)CoordCommandUtils.getFirstMissingDependency((CoordinatorActionBean)((CoordinatorActionBean)((Pair)data.get(0)).getFirst())));
        Map dependencyMap = (Map)((Pair)data.get(0)).getSecond();
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)6, (int)dependencyMap.size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)1, (int)((ActionDependency)dependencyMap.get("A")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)6, (int)((ActionDependency)dependencyMap.get("B")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)1, (int)((ActionDependency)dependencyMap.get("C")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((String)("${coord:latestRange(-5,0)} -> " + datasetPrefix.toString() + "db_c" + datasetSuffix), (String)((String)((ActionDependency)dependencyMap.get("C")).getMissingDependencies().get(0)));
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)1, (int)((ActionDependency)dependencyMap.get("D")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)6, (int)((ActionDependency)dependencyMap.get("E")).getMissingDependencies().size());
        this.addPartition("db_a", "table1", "dt=200901;country=usa");
        new CoordPushDependencyCheckXCommand(jobId + "@1").call();
        data = (List)new CoordActionMissingDependenciesXCommand(jobId + "@1").call();
        dependencyMap = (Map)((Pair)data.get(0)).getSecond();
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)5, (int)dependencyMap.size());
        TestCoordActionMissingDependenciesXCommand.assertNull(dependencyMap.get("A"));
        this.addPartition("db_b", "table1", "dt=200901;country=usa");
        this.addPartition("db_b", "table1", "dt=200931;country=usa");
        this.addPartition("db_b", "table1", "dt=200930;country=usa");
        this.addPartition("db_b", "table1", "dt=200929;country=usa");
        this.addPartition("db_b", "table1", "dt=200928;country=usa");
        this.addPartition("db_b", "table1", "dt=200927;country=usa");
        new CoordPushDependencyCheckXCommand(jobId + "@1").call();
        data = (List)new CoordActionMissingDependenciesXCommand(jobId + "@1").call();
        dependencyMap = (Map)((Pair)data.get(0)).getSecond();
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)4, (int)dependencyMap.size());
        TestCoordActionMissingDependenciesXCommand.assertNull(dependencyMap.get("B"));
    }

    public void testCoordActionPullPushDependencyMissing() throws Exception {
        this.createTestTables();
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"coord-multiple-output-instance5.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "coordinator.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordActionMissingDependenciesXCommand.getTestUser());
        String datasetPrefix = "/table1/dt=${YEAR}${DAY};country=usa";
        String datasetSuffix = "hcat://" + this.getMetastoreAuthority() + "/";
        conf.set("data_set_a", datasetSuffix.toString() + "db_a" + datasetPrefix);
        conf.set("data_set_b", datasetSuffix.toString() + "db_b" + datasetPrefix);
        conf.set("data_set_c", datasetSuffix.toString() + "db_c" + datasetPrefix);
        conf.set("data_set_d", "file://" + this.getTestCaseDir() + "/input-data/d/${YEAR}/${DAY}");
        conf.set("data_set_e", "file://" + this.getTestCaseDir() + "/input-data/e/${YEAR}/${DAY}");
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        List data = (List)new CoordActionMissingDependenciesXCommand(jobId + "@1").call();
        TestCoordActionMissingDependenciesXCommand.assertEquals((String)("file://" + this.getTestCaseDir() + "/input-data/d/2009/01"), (String)CoordCommandUtils.getFirstMissingDependency((CoordinatorActionBean)((CoordinatorActionBean)((Pair)data.get(0)).getFirst())));
        Map dependencyMap = (Map)((Pair)data.get(0)).getSecond();
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)6, (int)dependencyMap.size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)1, (int)((ActionDependency)dependencyMap.get("A")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)6, (int)((ActionDependency)dependencyMap.get("B")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)1, (int)((ActionDependency)dependencyMap.get("C")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)1, (int)((ActionDependency)dependencyMap.get("D")).getMissingDependencies().size());
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)6, (int)((ActionDependency)dependencyMap.get("E")).getMissingDependencies().size());
        this.addPartition("db_a", "table1", "dt=200901;country=usa");
        this.addPartition("db_b", "table1", "dt=200901;country=usa");
        this.addPartition("db_b", "table1", "dt=200931;country=usa");
        this.addPartition("db_b", "table1", "dt=200930;country=usa");
        this.addPartition("db_b", "table1", "dt=200929;country=usa");
        this.addPartition("db_b", "table1", "dt=200928;country=usa");
        this.addPartition("db_b", "table1", "dt=200927;country=usa");
        this.createTestCaseSubDir("input-data/d/2009/01".split("/"));
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        new CoordPushDependencyCheckXCommand(jobId + "@1").call();
        data = (List)new CoordActionMissingDependenciesXCommand(jobId + "@1").call();
        dependencyMap = (Map)((Pair)data.get(0)).getSecond();
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)3, (int)dependencyMap.size());
        TestCoordActionMissingDependenciesXCommand.assertNull(dependencyMap.get("B"));
        TestCoordActionMissingDependenciesXCommand.assertNull(dependencyMap.get("D"));
    }

    public void testCoordActionInputLogicMissing() throws Exception {
        this.createTestTables();
        Configuration conf = TestCoordInputLogicPush.getConfForCombine("file://" + this.getTestCaseDir(), "hcat://" + this.getMetastoreAuthority());
        conf.set("initial_instance_a", "2014-10-07T00:00Z");
        conf.set("initial_instance_b", "2014-10-07T00:00Z");
        String inputLogic = "<and name=\"test\"><data-in dataset=\"A\" /><data-in dataset=\"B\" /></and>";
        String jobId = TestCoordInputLogicPush.submitCoord(this.getTestCaseDir(), "coord-inputlogic-combine.xml", conf, inputLogic, TestCoordInputLogicPush.TEST_TYPE.CURRENT_SINGLE, TestCoordInputLogicPush.TEST_TYPE.CURRENT_SINGLE, TestCoordInputLogicPush.TEST_TYPE.CURRENT_RANGE, TestCoordInputLogicPush.TEST_TYPE.LATEST_RANGE);
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        List data = (List)new CoordActionMissingDependenciesXCommand(jobId + "@1").call();
        Map dependencyMap = (Map)((Pair)data.get(0)).getSecond();
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)6, (int)dependencyMap.size());
        TestCoordActionMissingDependenciesXCommand.assertNull((Object)CoordCommandUtils.getFirstMissingDependency((CoordinatorActionBean)((CoordinatorActionBean)((Pair)data.get(0)).getFirst())));
        this.createTestCaseSubDir("input-data/b/2014/10/08/_SUCCESS".split("/"));
        this.addPartition("db_a", "table1", "dt=20141008;country=usa");
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        new CoordPushDependencyCheckXCommand(jobId + "@1").call();
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        data = (List)new CoordActionMissingDependenciesXCommand(jobId + "@1").call();
        dependencyMap = (Map)((Pair)data.get(0)).getSecond();
        TestCoordActionMissingDependenciesXCommand.assertEquals((int)4, (int)dependencyMap.size());
        TestCoordActionMissingDependenciesXCommand.assertNull(dependencyMap.get("A"));
        TestCoordActionMissingDependenciesXCommand.assertNull(dependencyMap.get("B"));
    }

    private void createSingleTestDB(String db) throws Exception {
        this.dropTable(db, "table1", true);
        this.dropDatabase(db, true);
        this.createDatabase(db);
        this.createTable(db, "table1", "dt,country");
    }

    private void createTestTables() throws Exception {
        this.createSingleTestDB("db_a");
        this.createSingleTestDB("db_b");
        this.createSingleTestDB("db_c");
        this.createSingleTestDB("db_d");
        this.createSingleTestDB("db_e");
        this.createSingleTestDB("db_f");
    }
}

