/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.command.coord.CoordActionNotificationXCommand;
import org.apache.oozie.command.wf.HangServlet;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.EmbeddedServletContainer;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;
import org.junit.Assert;
import org.mockito.Mockito;

public class TestCoordActionNotificationXCommand
extends XTestCase {
    private EmbeddedServletContainer container;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.notification.url.connection.timeout", "50");
        Services services = new Services();
        services.init();
        this.container = new EmbeddedServletContainer("blah");
        this.container.addServletEndpoint("/hang/*", HangServlet.class);
        this.container.start();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.container.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Services.get().destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }

    public void testCoordNotificationTimeout() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.coord.action.notification.url", this.container.getServletURL("/hang/*"));
        String runConf = conf.toXmlString(false);
        CoordinatorActionBean coord = (CoordinatorActionBean)Mockito.mock(CoordinatorActionBean.class);
        Mockito.when((Object)coord.getId()).thenReturn((Object)"1");
        Mockito.when((Object)coord.getStatus()).thenReturn((Object)CoordinatorAction.Status.SUCCEEDED);
        Mockito.when((Object)coord.getRunConf()).thenReturn((Object)runConf);
        CoordActionNotificationXCommand command = new CoordActionNotificationXCommand(coord);
        command.retries = 3;
        long start = System.currentTimeMillis();
        command.call();
        long end = System.currentTimeMillis();
        Assert.assertTrue((end - start >= 50L ? 1 : 0) != 0);
        Assert.assertTrue((end - start <= 10000L ? 1 : 0) != 0);
    }
}

