/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionSkipXCommand;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordActionSkipXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testVerifyPrecondition() throws Exception {
        Date startTime = new Date();
        Date endTime = new Date(startTime.getTime() + 60000L);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, false, true, 0);
        int actionNum = 1;
        for (CoordinatorAction.Status actionStatus : CoordinatorAction.Status.values()) {
            CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), actionNum, actionStatus, "coord-action-get.xml", 0);
            try {
                new CoordActionSkipXCommand(action, TestCoordActionSkipXCommand.getTestUser(), "my-app-name").verifyPrecondition();
                if (!actionStatus.equals((Object)CoordinatorAction.Status.WAITING) && !actionStatus.equals((Object)CoordinatorAction.Status.READY)) {
                    TestCoordActionSkipXCommand.fail();
                }
            }
            catch (PreconditionException pe) {
                TestCoordActionSkipXCommand.assertEquals((Object)ErrorCode.E1100, (Object)pe.getErrorCode());
                TestCoordActionSkipXCommand.assertTrue((boolean)pe.getMessage().endsWith("[" + actionStatus + "]]"));
            }
            ++actionNum;
        }
    }

    public void testWaitingToSkipped() throws Exception {
        this._testToSkipped(CoordinatorAction.Status.WAITING);
    }

    public void testReadyToSkipped() throws Exception {
        this._testToSkipped(CoordinatorAction.Status.READY);
    }

    public void _testToSkipped(CoordinatorAction.Status actionStatus) throws Exception {
        Date startTime = new Date();
        Date endTime = new Date(startTime.getTime() + 60000L);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, false, true, 0);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), 1, actionStatus, "coord-action-get.xml", 0);
        TestCoordActionSkipXCommand.assertEquals((Object)actionStatus, (Object)action.getStatus());
        new CoordActionSkipXCommand(action, TestCoordActionSkipXCommand.getTestUser(), "my-app-name").call();
        action = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{action.getId()});
        TestCoordActionSkipXCommand.assertEquals((Object)CoordinatorAction.Status.SKIPPED, (Object)action.getStatus());
    }
}

