/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.oozie.CoordinatorJobInfo;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.coord.CoordJobsXCommand;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordJobsXCommand
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordJobsGet() throws Exception {
        this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordJobTable(Job.Status.KILLED, false, false);
        this._testGetJobsForStatus();
        this._testGetJobsForGroup();
        this.addRecordToCoordJobTable(Job.Status.KILLED, false, false);
        this._testGetJobsForAppName();
        this._testGetJobInfoForUser();
        this._testGetJobsForUserAndStatus();
        this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this._testGetJobCount();
    }

    private void _testGetJobsForStatus() throws Exception {
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("RUNNING");
        list.add("KILLED");
        filter.put("status", list);
        CoordJobsXCommand coordsGetCmd = new CoordJobsXCommand(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)coordsGetCmd.call();
        TestCoordJobsXCommand.assertNotNull((Object)ret);
        TestCoordJobsXCommand.assertEquals((int)ret.getCoordJobs().size(), (int)2);
    }

    private void _testGetJobsForGroup() throws Exception {
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(TestCoordJobsXCommand.getTestGroup());
        filter.put("group", list);
        CoordJobsXCommand coordsGetCmd = new CoordJobsXCommand(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)coordsGetCmd.call();
        TestCoordJobsXCommand.assertNotNull((Object)ret);
        TestCoordJobsXCommand.assertEquals((int)ret.getCoordJobs().size(), (int)2);
    }

    private void _testGetJobsForAppName() throws Exception {
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("COORD-TEST");
        filter.put("name", list);
        CoordJobsXCommand coordsGetCmd = new CoordJobsXCommand(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)coordsGetCmd.call();
        TestCoordJobsXCommand.assertNotNull((Object)ret);
        TestCoordJobsXCommand.assertEquals((int)ret.getCoordJobs().size(), (int)3);
    }

    private void _testGetJobInfoForUser() throws Exception {
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(TestCoordJobsXCommand.getTestUser());
        filter.put("user", list);
        CoordJobsXCommand coordsGetCmd = new CoordJobsXCommand(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)coordsGetCmd.call();
        TestCoordJobsXCommand.assertNotNull((Object)ret);
        TestCoordJobsXCommand.assertEquals((int)ret.getCoordJobs().size(), (int)3);
    }

    private void _testGetJobsForUserAndStatus() throws Exception {
        HashMap filter = new HashMap();
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(TestCoordJobsXCommand.getTestUser());
        filter.put("user", list1);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("KILLED");
        filter.put("status", list2);
        CoordJobsXCommand coordsGetCmd = new CoordJobsXCommand(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)coordsGetCmd.call();
        TestCoordJobsXCommand.assertNotNull((Object)ret);
        TestCoordJobsXCommand.assertEquals((int)ret.getCoordJobs().size(), (int)2);
    }

    private void _testGetJobCount() throws Exception {
        HashMap filter = new HashMap();
        CoordJobsXCommand coordsGetCmd = new CoordJobsXCommand(filter, 1, 1);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)coordsGetCmd.call();
        TestCoordJobsXCommand.assertNotNull((Object)ret);
        TestCoordJobsXCommand.assertEquals((int)ret.getTotal(), (int)6);
        coordsGetCmd = new CoordJobsXCommand(filter, 3, 6);
        ret = (CoordinatorJobInfo)coordsGetCmd.call();
        TestCoordJobsXCommand.assertNotNull((Object)ret);
        TestCoordJobsXCommand.assertEquals((int)ret.getTotal(), (int)6);
        coordsGetCmd = new CoordJobsXCommand(filter, 5, 20);
        ret = (CoordinatorJobInfo)coordsGetCmd.call();
        TestCoordJobsXCommand.assertNotNull((Object)ret);
        TestCoordJobsXCommand.assertEquals((int)ret.getTotal(), (int)6);
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(TestCoordJobsXCommand.getTestUser());
        filter.put("user", list1);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("RUNNING");
        filter.put("status", list2);
        coordsGetCmd = new CoordJobsXCommand(filter, 1, 20);
        ret = (CoordinatorJobInfo)coordsGetCmd.call();
        TestCoordJobsXCommand.assertNotNull((Object)ret);
        TestCoordJobsXCommand.assertEquals((int)ret.getTotal(), (int)4);
        coordsGetCmd = new CoordJobsXCommand(filter, 2, 1);
        ret = (CoordinatorJobInfo)coordsGetCmd.call();
        TestCoordJobsXCommand.assertNotNull((Object)ret);
        TestCoordJobsXCommand.assertEquals((int)ret.getTotal(), (int)4);
    }
}

