/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.File;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordMaterializeTransitionXCommand;
import org.apache.oozie.command.coord.CoordSubmitXCommand;
import org.apache.oozie.command.coord.DaylightOffsetCalculator;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionsJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionsSubsetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetRunningActionsCountJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.SLAEventsGetForSeqIdJPAExecutor;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class TestCoordMaterializeTransitionXCommand
extends XDataTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        super.tearDown();
    }

    public void testActionMater() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T010:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2009-03-11T10:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, false, false, 0);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        this.checkCoordAction(job.getId() + "@1");
    }

    private int hoursToSeconds(int hours) {
        return new Long(java.util.concurrent.TimeUnit.HOURS.toSeconds(hours)).intValue();
    }

    public void testActionMaterForHcatalog() throws Exception {
        Services.get().destroy();
        Services services = super.setupServicesForHCatalog();
        services.init();
        Date startTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T010:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2009-03-11T10:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-matd-hcat.xml", Job.Status.RUNNING, startTime, endTime, false, false, 0);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        CoordinatorActionBean actionBean = this.getCoordAction(job.getId() + "@1");
        TestCoordMaterializeTransitionXCommand.assertEquals((String)"file://dummyhdfs/2009/05/_SUCCESS!!${coord:latestRange(-1,0)}", (String)actionBean.getMissingDependencies());
        TestCoordMaterializeTransitionXCommand.assertEquals((String)"hcat://dummyhcat:1000/db1/table1/ds=2009-12#hcat://dummyhcat:1000/db3/table3/ds=2009-05#hcat://dummyhcat:1000/db3/table3/ds=2009-26", (String)actionBean.getPushMissingDependencies());
    }

    public void testActionMaterForHcatalogIncorrectURI() throws Exception {
        Services.get().destroy();
        Services services = super.setupServicesForHCatalog();
        services.init();
        Date startTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T010:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2009-03-11T10:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-matd-neg-hcat.xml", Job.Status.RUNNING, startTime, endTime, false, false, 0);
        try {
            new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
            TestCoordMaterializeTransitionXCommand.fail((String)"Expected Command exception but didn't catch any");
        }
        catch (CommandException e) {
            e.printStackTrace();
            job = (CoordinatorJobBean)((JPAService)services.get(JPAService.class)).execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
            TestCoordMaterializeTransitionXCommand.assertEquals((Object)Job.Status.FAILED, (Object)job.getStatus());
            TestCoordMaterializeTransitionXCommand.assertEquals((Object)ErrorCode.E1012, (Object)e.getErrorCode());
        }
        catch (Exception e) {
            TestCoordMaterializeTransitionXCommand.fail((String)("Unexpected exception " + e.getMessage()));
        }
    }

    public void testActionMaterForHcatalogRelativePath() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T010:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2009-03-11T10:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-matd-relative.xml", Job.Status.RUNNING, startTime, endTime, false, false, 0);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
    }

    public void testActionMaterWithCronFrequency1() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T01:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, null, "10,20 * * * *");
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        Date[] nominalTimes = new Date[]{DateUtils.parseDateOozieTZ((String)"2013-07-18T00:10Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:20Z")};
        int expectedNominalTimeCount = 2;
        this.checkCoordActionsNominalTime(job.getId(), 2, nominalTimes);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
            TestCoordMaterializeTransitionXCommand.assertTrue((boolean)job.isDoneMaterialization());
            TestCoordMaterializeTransitionXCommand.assertEquals((int)job.getLastActionNumber(), (int)2);
            TestCoordMaterializeTransitionXCommand.assertEquals((Object)job.getNextMaterializedTime(), (Object)DateUtils.parseDateOozieTZ((String)"2013-07-18T01:10Z"));
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + job.getId() + " was not stored properly in db"));
        }
    }

    public void testActionMaterWithCronFrequency2() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T01:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, null, "10-20 * * * *");
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        Date[] nominalTimes = new Date[]{DateUtils.parseDateOozieTZ((String)"2013-07-18T00:10Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:11Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:12Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:13Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:14Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:15Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:16Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:17Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:18Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:19Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:20Z")};
        int expectedNominalTimeCount = 11;
        this.checkCoordActionsNominalTime(job.getId(), 11, nominalTimes);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
            TestCoordMaterializeTransitionXCommand.assertTrue((boolean)job.isDoneMaterialization());
            TestCoordMaterializeTransitionXCommand.assertEquals((int)job.getLastActionNumber(), (int)11);
            TestCoordMaterializeTransitionXCommand.assertEquals((Object)job.getNextMaterializedTime(), (Object)DateUtils.parseDateOozieTZ((String)"2013-07-18T01:10Z"));
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + job.getId() + " was not stored properly in db"));
        }
    }

    public void testActionMaterWithCronFrequency3() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T01:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, null, "0/15 2 * 5-7 4,5");
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        boolean expectedNominalTimeCount = false;
        this.checkCoordActionsNominalTime(job.getId(), 0, new Date[0]);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
            TestCoordMaterializeTransitionXCommand.assertTrue((boolean)job.isDoneMaterialization());
            TestCoordMaterializeTransitionXCommand.assertEquals((int)job.getLastActionNumber(), (int)0);
            TestCoordMaterializeTransitionXCommand.assertEquals((Object)job.getNextMaterializedTime(), (Object)DateUtils.parseDateOozieTZ((String)"2013-07-18T02:00Z"));
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + job.getId() + " was not stored properly in db"));
        }
    }

    public void testActionMaterWithCronFrequency4() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T01:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, null, "0/15 * * 5-7 4,5");
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        Date[] nominalTimes = new Date[]{DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:15Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:30Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:45Z")};
        int expectedNominalTimeCount = 4;
        this.checkCoordActionsNominalTime(job.getId(), 4, nominalTimes);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
            TestCoordMaterializeTransitionXCommand.assertTrue((boolean)job.isDoneMaterialization());
            TestCoordMaterializeTransitionXCommand.assertEquals((int)job.getLastActionNumber(), (int)4);
            TestCoordMaterializeTransitionXCommand.assertEquals((Object)job.getNextMaterializedTime(), (Object)DateUtils.parseDateOozieTZ((String)"2013-07-18T01:00Z"));
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + job.getId() + " was not stored properly in db"));
        }
    }

    public void testActionMaterWithCronFrequency5() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T01:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, null, "20/15 * * 5-7 4,5");
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        Date[] nominalTimes = new Date[]{DateUtils.parseDateOozieTZ((String)"2013-07-18T00:20Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:35Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:50Z")};
        int expectedNominalTimeCount = 3;
        this.checkCoordActionsNominalTime(job.getId(), 3, nominalTimes);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
            TestCoordMaterializeTransitionXCommand.assertTrue((boolean)job.isDoneMaterialization());
            TestCoordMaterializeTransitionXCommand.assertEquals((int)job.getLastActionNumber(), (int)3);
            TestCoordMaterializeTransitionXCommand.assertEquals((Object)job.getNextMaterializedTime(), (Object)DateUtils.parseDateOozieTZ((String)"2013-07-18T01:20Z"));
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + job.getId() + " was not stored properly in db"));
        }
    }

    public void testActionMaterWithCronFrequency6() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T01:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, null, "20");
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        Date[] nominalTimes = new Date[]{DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:20Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:40Z")};
        int expectedNominalTimeCount = 3;
        this.checkCoordActionsNominalTime(job.getId(), 3, nominalTimes);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
            TestCoordMaterializeTransitionXCommand.assertTrue((boolean)job.isDoneMaterialization());
            TestCoordMaterializeTransitionXCommand.assertEquals((int)job.getLastActionNumber(), (int)3);
            TestCoordMaterializeTransitionXCommand.assertEquals((Object)job.getNextMaterializedTime(), (Object)DateUtils.parseDateOozieTZ((String)"2013-07-18T01:00Z"));
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + job.getId() + " was not stored properly in db"));
        }
    }

    public void testActionMaterWithCronFrequency7() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T01:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, null, "20/15 * * 7,10 THU");
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        Date[] nominalTimes = new Date[]{DateUtils.parseDateOozieTZ((String)"2013-07-18T00:20Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:35Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:50Z")};
        int expectedNominalTimeCount = 3;
        this.checkCoordActionsNominalTime(job.getId(), 3, nominalTimes);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
            TestCoordMaterializeTransitionXCommand.assertTrue((boolean)job.isDoneMaterialization());
            TestCoordMaterializeTransitionXCommand.assertEquals((int)3, (int)job.getLastActionNumber());
            TestCoordMaterializeTransitionXCommand.assertEquals((Object)job.getNextMaterializedTime(), (Object)DateUtils.parseDateOozieTZ((String)"2013-07-18T01:20Z"));
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + job.getId() + " was not stored properly in db"));
        }
    }

    public void testActionMaterwithCronFrequencyWithThrottle() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T01:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, null, "0/10 * * * *");
        job.setMatThrottling(3);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        Date[] nominalTimes = new Date[]{DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:10Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:20Z")};
        int expectedNominalTimeCount = 3;
        this.checkCoordActionsNominalTime(job.getId(), 3, nominalTimes);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
            TestCoordMaterializeTransitionXCommand.assertFalse((boolean)job.isDoneMaterialization());
            TestCoordMaterializeTransitionXCommand.assertEquals((int)3, (int)job.getLastActionNumber());
            TestCoordMaterializeTransitionXCommand.assertEquals((Object)DateUtils.parseDateOozieTZ((String)"2013-07-18T00:30Z"), (Object)job.getNextMaterializedTime());
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + job.getId() + " was not stored properly in db"));
        }
    }

    public void testCronFrequencyCatchupThrottleLessThanDuration() throws Exception {
        String startInThePast = "2013-03-10T08:00Z";
        String startPlusOneDay = "2013-03-11T08:00Z";
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-03-10T08:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-03-11T08:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        job.setNextMaterializedTime(startTime);
        job.setMatThrottling(3);
        String everyHour = "0 * * * *";
        job.setFrequency("0 * * * *");
        job.setTimeUnit(CoordinatorJob.Timeunit.CRON);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        String startPlusOneHour = "2013-03-10T09:00Z";
        String startPlusTwoHours = "2013-03-10T10:00Z";
        Date[] nominalTimes = new Date[]{DateUtils.parseDateOozieTZ((String)"2013-03-10T08:00Z"), DateUtils.parseDateOozieTZ((String)"2013-03-10T09:00Z"), DateUtils.parseDateOozieTZ((String)"2013-03-10T10:00Z")};
        int expectedNominalTimeCount = 3;
        this.checkCoordActionsNominalTime(job.getId(), 3, nominalTimes);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
            TestCoordMaterializeTransitionXCommand.assertFalse((String)"coordinator job shouldn't have yet been materialized", (boolean)job.isDoneMaterialization());
            TestCoordMaterializeTransitionXCommand.assertEquals((String)"coordinator action count mismatch", (int)3, (int)job.getLastActionNumber());
            String startPlusThreeHours = "2013-03-10T11:00Z";
            TestCoordMaterializeTransitionXCommand.assertEquals((String)"coordinator next materialization time mismatch", (Object)DateUtils.parseDateOozieTZ((String)"2013-03-10T11:00Z"), (Object)job.getNextMaterializedTime());
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + job.getId() + " was not stored properly in db"));
        }
    }

    public void testCronFrequencyCatchupThrottleEqualsDurationDSTChange() throws Exception {
        String startInThePast = "2013-03-10T08:00Z";
        Date startTimeBeforeDSTChange = DateUtils.parseDateOozieTZ((String)"2013-03-10T08:00Z");
        String startPlusTwoHoursAndSome = "2013-03-10T10:01Z";
        Date endTimeAfterDSTChange = DateUtils.parseDateOozieTZ((String)"2013-03-10T10:01Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PREP, startTimeBeforeDSTChange, endTimeAfterDSTChange, false, false, 0);
        job.setNextMaterializedTime(startTimeBeforeDSTChange);
        job.setMatThrottling(3);
        String everyHour = "0 * * * *";
        job.setFrequency("0 * * * *");
        job.setTimeUnit(CoordinatorJob.Timeunit.CRON);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        String startPlusOneHour = "2013-03-10T09:00Z";
        Date[] nominalTimesWithDSTChange = new Date[]{DateUtils.parseDateOozieTZ((String)"2013-03-10T08:00Z"), DateUtils.parseDateOozieTZ((String)"2013-03-10T09:00Z")};
        this.checkCoordActionsNominalTime(job.getId(), 2, nominalTimesWithDSTChange);
        this.checkTwoActionsAfterCatchup(job);
    }

    private void checkTwoActionsAfterCatchup(CoordinatorJobBean job) throws ParseException {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
            TestCoordMaterializeTransitionXCommand.assertTrue((String)"coordinator job should have already been materialized", (boolean)job.isDoneMaterialization());
            TestCoordMaterializeTransitionXCommand.assertEquals((String)"coordinator action count mismatch", (int)2, (int)job.getLastActionNumber());
            String startPlusThreeHours = "2013-03-10T10:00Z";
            TestCoordMaterializeTransitionXCommand.assertEquals((String)"coordinator next materialization time mismatch", (Object)DateUtils.parseDateOozieTZ((String)"2013-03-10T10:00Z"), (Object)job.getNextMaterializedTime());
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + job.getId() + " was not stored properly in db"));
        }
    }

    public void testCronFrequencyCatchupThrottleMoreThanDurationNoDSTChange() throws Exception {
        String startInThePast = "2013-03-10T08:00Z";
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-03-10T08:00Z");
        String startPlusOneHourAndSome = "2013-03-10T09:01Z";
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-03-10T09:01Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        job.setNextMaterializedTime(startTime);
        job.setMatThrottling(5);
        String everyHour = "0 * * * *";
        job.setFrequency("0 * * * *");
        job.setTimeUnit(CoordinatorJob.Timeunit.CRON);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        String startPlusOneHour = "2013-03-10T09:00Z";
        Date[] nominalTimesWithoutDSTChange = new Date[]{DateUtils.parseDateOozieTZ((String)"2013-03-10T08:00Z"), DateUtils.parseDateOozieTZ((String)"2013-03-10T09:00Z")};
        this.checkCoordActionsNominalTime(job.getId(), 2, nominalTimesWithoutDSTChange);
        this.checkTwoActionsAfterCatchup(job);
    }

    public void testActionMaterWithDST1() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-03-10T08:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-03-10T12:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, null, "0 * * * *");
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(4)).call();
        Date[] nominalTimes = new Date[]{DateUtils.parseDateOozieTZ((String)"2013-03-10T08:00Z"), DateUtils.parseDateOozieTZ((String)"2013-03-10T09:00Z"), DateUtils.parseDateOozieTZ((String)"2013-03-10T10:00Z")};
        int expectedNominalTimeCount = 3;
        this.checkCoordActionsNominalTime(job.getId(), 3, nominalTimes);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
            TestCoordMaterializeTransitionXCommand.assertTrue((boolean)job.isDoneMaterialization());
            TestCoordMaterializeTransitionXCommand.assertEquals((int)3, (int)job.getLastActionNumber());
            TestCoordMaterializeTransitionXCommand.assertEquals((Object)DateUtils.parseDateOozieTZ((String)"2013-03-10T11:00Z"), (Object)job.getNextMaterializedTime());
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + job.getId() + " was not stored properly in db"));
        }
    }

    public void testActionMaterWithDST2() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2012-11-04T07:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2012-11-04T11:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, null, "0 * * * *");
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(4)).call();
        Date[] nominalTimes = new Date[]{DateUtils.parseDateOozieTZ((String)"2012-11-04T07:00Z"), DateUtils.parseDateOozieTZ((String)"2012-11-04T08:00Z"), DateUtils.parseDateOozieTZ((String)"2012-11-04T09:00Z"), DateUtils.parseDateOozieTZ((String)"2012-11-04T10:00Z"), DateUtils.parseDateOozieTZ((String)"2012-11-04T11:00Z")};
        int expectedNominalTimeCount = 5;
        this.checkCoordActionsNominalTime(job.getId(), 5, nominalTimes);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
            TestCoordMaterializeTransitionXCommand.assertTrue((boolean)job.isDoneMaterialization());
            TestCoordMaterializeTransitionXCommand.assertEquals((int)job.getLastActionNumber(), (int)5);
            TestCoordMaterializeTransitionXCommand.assertEquals((Object)job.getNextMaterializedTime(), (Object)DateUtils.parseDateOozieTZ((String)"2012-11-04T12:00Z"));
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + job.getId() + " was not stored properly in db"));
        }
    }

    public void testActionMaterWithPauseTime1() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T10:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T10:14Z");
        Date pauseTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T10:04Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, pauseTime, "5");
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        Date[] nominalTimes = new Date[]{DateUtils.parseDateOozieTZ((String)"2009-03-06T10:00Z")};
        this.checkCoordActionsNominalTime(job.getId(), 1, nominalTimes);
    }

    public void testActionMaterWithPauseTime2() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T10:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T10:14Z");
        Date pauseTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T10:08Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, pauseTime, "5");
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        Date[] nominalTimes = new Date[]{DateUtils.parseDateOozieTZ((String)"2009-03-06T10:00Z"), DateUtils.parseDateOozieTZ((String)"2009-03-06T10:05Z")};
        this.checkCoordActionsNominalTime(job.getId(), 2, nominalTimes);
    }

    public void testActionMaterWithPauseTime3() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T10:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T10:14Z");
        Date pauseTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T09:58Z");
        final CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, pauseTime, "5");
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        this.waitFor(60000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return TestCoordMaterializeTransitionXCommand.this.getStatus(job.getId()) == Job.Status.PAUSED;
            }
        });
        this.checkCoordActions(job.getId(), 0, Job.Status.PAUSED);
    }

    public void testGetDryrun() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T10:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T10:14Z");
        CoordinatorJobBean job = this.createCoordJob(Job.Status.RUNNING, startTime, endTime, false, false, 0);
        job.setFrequency("5");
        job.setTimeUnit(CoordinatorJob.Timeunit.MINUTE);
        job.setMatThrottling(20);
        String dryRunOutput = new CoordMaterializeTransitionXCommand(job, this.hoursToSeconds(1), startTime, endTime).materializeActions(true);
        String[] actions = dryRunOutput.split("action for new instance");
        TestCoordMaterializeTransitionXCommand.assertEquals((int)3, (int)(actions.length - 1));
        for (int i = 1; i < actions.length; ++i) {
            TestCoordMaterializeTransitionXCommand.assertTrue((boolean)actions[i].contains("action-nominal-time"));
        }
    }

    public void testTimeout() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T10:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2009-03-06T10:14Z");
        Date pauseTime = null;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, pauseTime, 300, "5");
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        this.checkCoordActionsTimeout(job.getId() + "@1", 300);
    }

    public void testMatLookupCommand1() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2009-02-03T23:59Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        this.checkCoordJobs(job.getId(), Job.Status.RUNNING);
    }

    public void testMatThrottle() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2009-02-03T23:59Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        this.checkCoordWaiting(job.getId(), job.getMatThrottling());
    }

    public void testMatLookupCommand2() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2099-02-01T01:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2099-02-03T23:59Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        this.checkCoordJobs(job.getId(), Job.Status.PREP);
    }

    public void testMatLookupCommand3() throws Exception {
        Date startTime = DateUtils.toDate((Timestamp)new Timestamp(System.currentTimeMillis() + 180000L));
        Date endTime = DateUtils.parseDateOozieTZ((String)"2099-02-03T23:59Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        this.checkCoordJobs(job.getId(), Job.Status.RUNNING);
    }

    public void testFailedJobNotMaterializeActions() throws Exception {
        String coordXml = "<coordinator-app xmlns=\"uri:oozie:coordinator:0.4\" name=\"NAME\" frequency=\"5\" start=\"#start\" end=\"#end\" timezone=\"America/Los_Angeles\" freq_timeunit=\"DAY\" end_of_duration=\"NONE\"><input-events><data-in name=\"a\" dataset=\"a\"><dataset name=\"a\" frequency=\"7\" initial-instance=\"2010-01-01T00:00Z\" timezone=\"UTC\" freq_timeunit=\"MINUTE\" end_of_duration=\"NONE\"><uri-template>${hcatNode}/${db}/${table}/ds=${YEAR}-${MONTH}-${DAY};region=${region}</uri-template></dataset><start-instance>${coord:current(0)}</start-instance><end-instance>${coord:latest(0)}</end-instance></data-in></input-events><action><workflow><app-path>hdfs:///tmp/workflows/</app-path></workflow></action></coordinator-app>";
        CoordinatorJobBean job = this.addRecordToCoordJobTable(coordXml);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
        TestCoordMaterializeTransitionXCommand.assertEquals((Object)Job.Status.FAILED, (Object)job.getStatus());
        int actions = (Integer)jpaService.execute((JPAExecutor)new CoordJobGetActionsJPAExecutor(job.getId()));
        TestCoordMaterializeTransitionXCommand.assertEquals((int)0, (int)actions);
    }

    public void testMatLookupCommand4() throws Exception {
        Date startTime = DateUtils.toDate((Timestamp)new Timestamp(System.currentTimeMillis() + 360000L));
        Date endTime = DateUtils.parseDateOozieTZ((String)"2099-02-03T23:59Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        this.checkCoordJobs(job.getId(), Job.Status.PREP);
    }

    public void testMaterizationLookup() throws Exception {
        long TIME_IN_MIN = 60000L;
        long TIME_IN_HOURS = TIME_IN_MIN * 60L;
        long TIME_IN_DAY = TIME_IN_HOURS * 24L;
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        Date startTime = DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2009-05-03T23:59Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        job.setNextMaterializedTime(startTime);
        job.setMatThrottling(3);
        job.setFrequency("1");
        job.setTimeUnitStr("DAY");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
        TestCoordMaterializeTransitionXCommand.assertEquals((Object)new Date(startTime.getTime() + TIME_IN_DAY * 3L), (Object)job.getNextMaterializedTime());
        startTime = DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z");
        endTime = DateUtils.parseDateOozieTZ((String)"2009-05-03T23:59Z");
        job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        job.setNextMaterializedTime(startTime);
        job.setMatThrottling(10);
        job.setFrequency("1");
        job.setTimeUnitStr("HOUR");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
        TestCoordMaterializeTransitionXCommand.assertEquals((Object)new Date(startTime.getTime() + TIME_IN_HOURS * 10L), (Object)job.getNextMaterializedTime());
        startTime = new Date(new Date().getTime() - TIME_IN_DAY * 3L);
        endTime = new Date(startTime.getTime() + TIME_IN_DAY * 3L);
        job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        job.setNextMaterializedTime(startTime);
        job.setMatThrottling(10);
        job.setFrequency("1");
        job.setTimeUnitStr("DAY");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
        Date next = new Date(startTime.getTime() + TIME_IN_DAY * 3L);
        TimeZone tz = TimeZone.getTimeZone(job.getTimeZone());
        next.setTime(next.getTime() + DaylightOffsetCalculator.getDSTOffset((TimeZone)tz, (Date)startTime, (Date)next));
        TestCoordMaterializeTransitionXCommand.assertEquals((Object)next, (Object)job.getNextMaterializedTime());
        startTime = new Date(new Date().getTime());
        endTime = new Date(startTime.getTime() + TIME_IN_DAY * 3L);
        job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        job.setNextMaterializedTime(startTime);
        job.setMatThrottling(10);
        job.setFrequency("1");
        job.setTimeUnitStr("DAY");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
        next = new Date(startTime.getTime() + TIME_IN_DAY);
        tz = TimeZone.getTimeZone(job.getTimeZone());
        next.setTime(next.getTime() + DaylightOffsetCalculator.getDSTOffset((TimeZone)tz, (Date)startTime, (Date)next));
        TestCoordMaterializeTransitionXCommand.assertEquals((Object)next, (Object)job.getNextMaterializedTime());
        startTime = new Date(new Date().getTime());
        endTime = new Date(startTime.getTime() + TIME_IN_HOURS * 24L);
        job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        job.setMatThrottling(20);
        job.setFrequency("5");
        job.setTimeUnitStr("MINUTE");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
        next = new Date(startTime.getTime() + TIME_IN_HOURS);
        tz = TimeZone.getTimeZone(job.getTimeZone());
        next.setTime(next.getTime() + DaylightOffsetCalculator.getDSTOffset((TimeZone)tz, (Date)startTime, (Date)next));
        TestCoordMaterializeTransitionXCommand.assertEquals((Object)next, (Object)job.getNextMaterializedTime());
        startTime = new Date(new Date().getTime());
        endTime = new Date(startTime.getTime() + TIME_IN_DAY * 24L);
        job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        job.setMatThrottling(20);
        job.setFrequency("1");
        job.setTimeUnitStr("DAY");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
        next = new Date(startTime.getTime() + TIME_IN_DAY);
        tz = TimeZone.getTimeZone(job.getTimeZone());
        next.setTime(next.getTime() + DaylightOffsetCalculator.getDSTOffset((TimeZone)tz, (Date)startTime, (Date)next));
        TestCoordMaterializeTransitionXCommand.assertEquals((Object)next, (Object)job.getNextMaterializedTime());
        startTime = this.getDaylightCalendar().getTime();
        endTime = new Date(startTime.getTime() + TIME_IN_DAY * 3L);
        job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        job.setNextMaterializedTime(startTime);
        job.setMatThrottling(10);
        job.setFrequency("1");
        job.setTimeUnitStr("DAY");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
        next = new Date(startTime.getTime() + TIME_IN_DAY * 3L);
        tz = TimeZone.getTimeZone(job.getTimeZone());
        next.setTime(next.getTime() + DaylightOffsetCalculator.getDSTOffset((TimeZone)tz, (Date)startTime, (Date)next));
        TestCoordMaterializeTransitionXCommand.assertEquals((Object)next, (Object)job.getNextMaterializedTime());
        Calendar c = this.getStandardCalendar();
        startTime = c.getTime();
        endTime = new Date(startTime.getTime() + TIME_IN_DAY * 3L);
        job = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, false, 0);
        job.setNextMaterializedTime(startTime);
        job.setMatThrottling(10);
        job.setFrequency("1");
        job.setTimeUnitStr("DAY");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(job, this.hoursToSeconds(1), startTime, endTime).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
        next = new Date(startTime.getTime() + TIME_IN_DAY * 3L);
        tz = TimeZone.getTimeZone(job.getTimeZone());
        next.setTime(next.getTime() + DaylightOffsetCalculator.getDSTOffset((TimeZone)tz, (Date)startTime, (Date)next));
        TestCoordMaterializeTransitionXCommand.assertEquals((Object)next, (Object)job.getNextMaterializedTime());
    }

    Calendar getDaylightCalendar() {
        Calendar daylight = Calendar.getInstance();
        daylight.set(2012, 10, 2, 15, 28, 0);
        return daylight;
    }

    Calendar getStandardCalendar() {
        Calendar standard = Calendar.getInstance();
        standard.set(2013, 2, 9, 15, 28, 0);
        return standard;
    }

    public void testLastOnlyMaterialization() throws Exception {
        long now = System.currentTimeMillis();
        Date startTime = DateUtils.toDate((Timestamp)new Timestamp(now - 10800000L));
        Date endTime = DateUtils.toDate((Timestamp)new Timestamp(now + 10800000L));
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, null, -1, "10", CoordinatorJob.Execution.LAST_ONLY);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        this.checkCoordJobs(job.getId(), Job.Status.RUNNING);
        Object[] expectedStatuses = new CoordinatorAction.Status[19];
        Arrays.fill(expectedStatuses, CoordinatorAction.Status.WAITING);
        this.checkCoordActionsStatus(job.getId(), (CoordinatorAction.Status[])expectedStatuses);
        startTime = DateUtils.toDate((Timestamp)new Timestamp(now));
        job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, null, -1, "10", CoordinatorJob.Execution.LAST_ONLY);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        this.checkCoordJobs(job.getId(), Job.Status.RUNNING);
        expectedStatuses = new CoordinatorAction.Status[6];
        Arrays.fill(expectedStatuses, CoordinatorAction.Status.WAITING);
        this.checkCoordActionsStatus(job.getId(), (CoordinatorAction.Status[])expectedStatuses);
    }

    public void testCurrentTimeCheck() throws Exception {
        long now = System.currentTimeMillis();
        Date startTime = DateUtils.toDate((Timestamp)new Timestamp(now));
        Date endTime = DateUtils.toDate((Timestamp)new Timestamp(now + 10800000L));
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, null, "5", 20);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        this.checkCoordJobs(job.getId(), Job.Status.RUNNING);
        job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job.getId()});
        TestCoordMaterializeTransitionXCommand.assertEquals((int)job.getLastActionNumber(), (int)12);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job.getId()});
        TestCoordMaterializeTransitionXCommand.assertEquals((int)job.getLastActionNumber(), (int)12);
    }

    public void testMaterizationEndOfMonths() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"test\" frequency=\"${coord:endOfMonths(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordMaterializeTransitionXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        Calendar cal = Calendar.getInstance(DateUtils.getOozieProcessingTimeZone());
        cal.add(2, -3);
        Date startTime = cal.getTime();
        cal = Calendar.getInstance(DateUtils.getOozieProcessingTimeZone());
        cal.add(2, 3);
        Date endTime = cal.getTime();
        CoordinatorJobBean job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{jobId});
        TestCoordMaterializeTransitionXCommand.assertEquals((int)job.getLastActionNumber(), (int)0);
        job.setStartTime(startTime);
        job.setEndTime(endTime);
        job.setMatThrottling(10);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job.getId()});
        TestCoordMaterializeTransitionXCommand.assertEquals((int)job.getLastActionNumber(), (int)3);
        String jobXml = job.getJobXml();
        Element eJob = XmlUtils.parseXml((String)jobXml);
        TimeZone appTz = DateUtils.getTimeZone((String)job.getTimeZone());
        TimeUnit endOfFlag = TimeUnit.valueOf((String)eJob.getAttributeValue("end_of_duration"));
        TimeUnit freqTU = TimeUnit.valueOf((String)job.getTimeUnitStr());
        Calendar origStart = Calendar.getInstance(appTz);
        origStart.setTime(job.getStartTimestamp());
        DateUtils.moveToEnd((Calendar)origStart, (TimeUnit)endOfFlag);
        origStart.add(freqTU.getCalendarUnit(), 3 * Integer.parseInt(job.getFrequency()));
        TestCoordMaterializeTransitionXCommand.assertEquals((Object)job.getNextMaterializedTime(), (Object)origStart.getTime());
    }

    public void testActionMaterEndOfWeeks() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"test\" frequency=\"${coord:endOfWeeks(1)}\" start=\"2016-02-03T01:00Z\" end=\"2016-03-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:endOfWeeks(1)}\" initial-instance=\"2016-01-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"${coord:endOfWeeks(1)}\" initial-instance=\"2016-01-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordMaterializeTransitionXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        CoordinatorJobBean job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{jobId});
        TestCoordMaterializeTransitionXCommand.assertEquals((int)job.getLastActionNumber(), (int)0);
        job.setMatThrottling(10);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(job.getId(), this.hoursToSeconds(1)).call();
        job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job.getId()});
        TestCoordMaterializeTransitionXCommand.assertEquals((int)4, (int)job.getLastActionNumber());
        String jobXml = job.getJobXml();
        Element eJob = XmlUtils.parseXml((String)jobXml);
        TimeZone appTz = DateUtils.getTimeZone((String)job.getTimeZone());
        TimeUnit endOfFlag = TimeUnit.valueOf((String)eJob.getAttributeValue("end_of_duration"));
        TimeUnit freqTU = TimeUnit.valueOf((String)job.getTimeUnitStr());
        Calendar origStart = Calendar.getInstance(appTz);
        origStart.setTime(job.getStartTimestamp());
        DateUtils.moveToEnd((Calendar)origStart, (TimeUnit)endOfFlag);
        origStart.add(freqTU.getCalendarUnit(), 4 * Integer.parseInt(job.getFrequency()));
        TestCoordMaterializeTransitionXCommand.assertEquals((Object)origStart.getTime(), (Object)job.getNextMaterializedTime());
    }

    protected CoordinatorJobBean addRecordToCoordJobTable(Job.Status status, Date startTime, Date endTime, Date pauseTime, String freq) throws Exception {
        return this.addRecordToCoordJobTable(status, startTime, endTime, pauseTime, -1, freq);
    }

    protected CoordinatorJobBean addRecordToCoordJobTable(Job.Status status, Date startTime, Date endTime, Date pauseTime, String freq, int matThrottling) throws Exception {
        return this.addRecordToCoordJobTable(status, startTime, endTime, pauseTime, -1, freq, CoordinatorJob.Execution.FIFO, matThrottling);
    }

    protected CoordinatorJobBean addRecordToCoordJobTable(Job.Status status, Date startTime, Date endTime, Date pauseTime, int timeout, String freq) throws Exception {
        return this.addRecordToCoordJobTable(status, startTime, endTime, pauseTime, timeout, freq, CoordinatorJob.Execution.FIFO, 20);
    }

    protected CoordinatorJobBean addRecordToCoordJobTable(Job.Status status, Date startTime, Date endTime, Date pauseTime, int timeout, String freq, CoordinatorJob.Execution execution) throws Exception {
        return this.addRecordToCoordJobTable(status, startTime, endTime, pauseTime, timeout, freq, execution, 20);
    }

    protected CoordinatorJobBean addRecordToCoordJobTable(Job.Status status, Date startTime, Date endTime, Date pauseTime, int timeout, String freq, CoordinatorJob.Execution execution, int matThrottling) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(status, startTime, endTime, false, false, 0);
        coordJob.setStartTime(startTime);
        coordJob.setEndTime(endTime);
        coordJob.setPauseTime(pauseTime);
        coordJob.setFrequency(freq);
        coordJob.setTimeUnit(CoordinatorJob.Timeunit.MINUTE);
        coordJob.setTimeout(timeout);
        coordJob.setConcurrency(3);
        coordJob.setMatThrottling(matThrottling);
        coordJob.setExecutionOrder(execution);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordMaterializeTransitionXCommand.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException ex) {
            ex.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)"Unable to insert the test coord job record to table");
            throw ex;
        }
        return coordJob;
    }

    private void checkCoordJobs(String jobId, Job.Status expectedStatus) {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            CoordinatorJobBean job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId));
            if (job.getStatus() != expectedStatus) {
                TestCoordMaterializeTransitionXCommand.fail((String)("CoordJobMatLookupCommand didn't work because the status for job id" + jobId + " is : " + job.getStatusStr() + "; however expected status is : " + expectedStatus.toString()));
            }
        }
        catch (JPAExecutorException se) {
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + jobId + " was not stored properly in db"));
        }
    }

    private void checkCoordWaiting(String jobId, int expectedValue) {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            int numWaitingActions = (Integer)jpaService.execute((JPAExecutor)new CoordJobGetRunningActionsCountJPAExecutor(jobId));
            assert (numWaitingActions <= expectedValue);
        }
        catch (JPAExecutorException se) {
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + jobId + " was not stored properly in db"));
        }
    }

    private CoordinatorActionBean checkCoordAction(String actionId) throws JPAExecutorException {
        long[] lastSeqId = new long[1];
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        List slaEventList = (List)jpaService.execute((JPAExecutor)new SLAEventsGetForSeqIdJPAExecutor(-1L, 10, lastSeqId));
        if (slaEventList.size() == 0) {
            TestCoordMaterializeTransitionXCommand.fail((String)"Unable to GET any record of sequence id greater than 0");
        }
        CoordinatorActionBean actionBean = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
        return actionBean;
    }

    private CoordinatorActionBean getCoordAction(String actionId) throws JPAExecutorException {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
        return actionBean;
    }

    private Job.Status getStatus(String jobId) {
        CoordinatorJob job = null;
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            job = (CoordinatorJob)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId));
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
        }
        return job.getStatus();
    }

    private void checkCoordActions(String jobId, int number, Job.Status status) {
        try {
            CoordinatorJob job;
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            Integer actionsSize = (Integer)jpaService.execute((JPAExecutor)new CoordJobGetActionsJPAExecutor(jobId));
            if (actionsSize != number) {
                TestCoordMaterializeTransitionXCommand.fail((String)("Should have " + number + " actions created for job " + jobId + ", but has " + actionsSize + " actions."));
            }
            if (status != null && (job = (CoordinatorJob)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId))).getStatus() != status) {
                TestCoordMaterializeTransitionXCommand.fail((String)("Job status " + job.getStatus() + " should be " + status));
            }
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + jobId + " was not stored properly in db"));
        }
    }

    private void checkCoordActionsNominalTime(String jobId, int number, Date[] nominalTimes) {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            List actions = (List)jpaService.execute((JPAExecutor)new CoordJobGetActionsSubsetJPAExecutor(jobId, null, 1, 1000, false));
            if (actions.size() != number) {
                TestCoordMaterializeTransitionXCommand.fail((String)("Should have " + number + " actions created for job " + jobId + ", but has " + actions.size() + " actions."));
            }
            for (int i = 0; i < nominalTimes.length; ++i) {
                TestCoordMaterializeTransitionXCommand.assertEquals((Object)nominalTimes[i], (Object)((CoordinatorActionBean)actions.get(i)).getNominalTime());
            }
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + jobId + " was not stored properly in db"));
        }
    }

    private void checkCoordActionsStatus(String jobId, CoordinatorAction.Status[] statuses) {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            List actions = (List)jpaService.execute((JPAExecutor)new CoordJobGetActionsSubsetJPAExecutor(jobId, null, 1, 1000, false));
            if (actions.size() != statuses.length) {
                TestCoordMaterializeTransitionXCommand.fail((String)("Should have " + statuses.length + " actions created for job " + jobId + ", but has " + actions.size() + " actions."));
            }
            for (int i = 0; i < statuses.length; ++i) {
                TestCoordMaterializeTransitionXCommand.assertEquals((Object)statuses[i], (Object)((CoordinatorActionBean)actions.get(i)).getStatus());
            }
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Job ID " + jobId + " was not stored properly in db"));
        }
    }

    private void checkCoordActionsTimeout(String actionId, int expected) {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
            TestCoordMaterializeTransitionXCommand.assertEquals((int)action.getTimeOut(), (int)expected);
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordMaterializeTransitionXCommand.fail((String)("Action ID " + actionId + " was not stored properly in db"));
        }
    }

    public void testSuccessedJobSlaParseElFunctionVariableInMaterializeActions() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String coordXml = "<coordinator-app name=\"NAME\" frequency=\"0 * * * *\" start=\"2017-06-12T01:00Z\" end=\"2017-06-12T02:00Z\" timezone=\"Asia/Shanghai\" xmlns=\"uri:oozie:coordinator:0.4\" xmlns:sla=\"uri:oozie:sla:0.2\"><controls> <execution>FIFO</execution> </controls><action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> </workflow>  <sla:info>  <sla:nominal-time>${NOMINAL_TIME}</sla:nominal-time>  <sla:should-start>${SHOULD_START}</sla:should-start>  <sla:should-end>${SHOULD_END}</sla:should-end> </sla:info></action></coordinator-app>";
        this.writeToFile(coordXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordMaterializeTransitionXCommand.getTestUser());
        conf.set("NOMINAL_TIME", "${coord:nominalTime()}");
        conf.set("SHOULD_START", "${5 * MINUTES}");
        conf.set("SHOULD_END", "${ SLA_OFFSET * HOURS}");
        conf.set("SLA_OFFSET", "10");
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        new CoordMaterializeTransitionXCommand(jobId, 60).call();
    }
}

