/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.CoordinatorWfActionBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorWfAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordWfActionInfoXCommand;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestCoordWfActionInfoXCommand
extends XDataTestCase {
    Services services;
    private CoordinatorJobBean coordJob;
    private List<WorkflowJobBean> wfJobs;
    private List<CoordinatorActionBean> coordActions;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.createTestData();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    private void createTestData() throws Exception {
        int i;
        int i2;
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordWfActionInfoXCommand.assertNotNull((String)"Missing jpa service", (Object)jpaService);
        this.coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        this.wfJobs = new ArrayList<WorkflowJobBean>();
        this.coordActions = new ArrayList<CoordinatorActionBean>();
        for (i2 = 0; i2 < 4; ++i2) {
            WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
            this.wfJobs.add(wfJob);
        }
        for (i2 = 0; i2 < 4; ++i2) {
            CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(this.coordJob.getId(), i2 + 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", this.wfJobs.get(i2).getId(), "SUCCEEDED", 0);
            this.coordActions.add(coordAction);
        }
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(this.coordJob.getId(), 5, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", null, null, 0);
        this.coordActions.add(coordAction);
        for (i = 0; i < 5; ++i) {
            this.setCoordActionNominalTime(this.coordActions.get(i).getId(), (i + 1) * 1000);
        }
        for (i = 0; i < 4; ++i) {
            String name = i == 3 ? "bb" : "aa";
            this.addRecordToWfActionTable(this.wfJobs.get(i).getId(), name, WorkflowAction.Status.DONE);
        }
    }

    public void testNormalCase() throws Exception {
        int offset = 2;
        int len = 2;
        List coordWfActions = (List)new CoordWfActionInfoXCommand(this.coordJob.getId(), "aa", offset, len).call();
        TestCoordWfActionInfoXCommand.assertEquals((int)2, (int)coordWfActions.size());
        List<String> wfIds = Arrays.asList(this.wfJobs.get(1).getId(), this.wfJobs.get(2).getId());
        for (int i = 0; i < coordWfActions.size(); ++i) {
            CoordinatorWfActionBean coordWfAction = (CoordinatorWfActionBean)coordWfActions.get(i);
            WorkflowActionBean wfAction = coordWfAction.getAction();
            TestCoordWfActionInfoXCommand.assertEquals((int)(i + offset), (int)((CoordinatorWfActionBean)coordWfActions.get(i)).getActionNumber());
            TestCoordWfActionInfoXCommand.assertEquals((String)wfIds.get(i), (String)wfAction.getWfId());
            TestCoordWfActionInfoXCommand.assertEquals(null, (String)coordWfAction.getNullReason());
        }
    }

    public void testActionMissing() throws CommandException {
        List coordWfActions = (List)new CoordWfActionInfoXCommand(this.coordJob.getId(), "aa", 2, 3).call();
        TestCoordWfActionInfoXCommand.assertEquals((int)3, (int)coordWfActions.size());
        TestCoordWfActionInfoXCommand.assertEquals((String)this.wfJobs.get(1).getId(), (String)((CoordinatorWfActionBean)coordWfActions.get(0)).getAction().getWfId());
        TestCoordWfActionInfoXCommand.assertEquals((String)this.wfJobs.get(2).getId(), (String)((CoordinatorWfActionBean)coordWfActions.get(1)).getAction().getWfId());
        CoordinatorWfActionBean coordWfAction = (CoordinatorWfActionBean)coordWfActions.get(2);
        TestCoordWfActionInfoXCommand.assertEquals((int)4, (int)coordWfAction.getActionNumber());
        TestCoordWfActionInfoXCommand.assertEquals(null, (Object)coordWfAction.getAction());
        String expectNullReason = CoordinatorWfAction.NullReason.ACTION_NULL.getNullReason(new Object[]{"aa", this.wfJobs.get(3).getId()});
        TestCoordWfActionInfoXCommand.assertEquals((String)expectNullReason, (String)coordWfAction.getNullReason());
    }

    public void testWorkflowInstanceMissing() throws CommandException {
        List coordWfActions = (List)new CoordWfActionInfoXCommand(this.coordJob.getId(), "aa", 2, 4).call();
        TestCoordWfActionInfoXCommand.assertEquals((int)4, (int)coordWfActions.size());
        CoordinatorWfActionBean coordWfAction = (CoordinatorWfActionBean)coordWfActions.get(3);
        TestCoordWfActionInfoXCommand.assertEquals((int)5, (int)coordWfAction.getActionNumber());
        TestCoordWfActionInfoXCommand.assertEquals(null, (Object)coordWfAction.getAction());
        String expectNullReason = CoordinatorWfAction.NullReason.PARENT_NULL.getNullReason(new Object[0]);
        TestCoordWfActionInfoXCommand.assertEquals((String)expectNullReason, (String)coordWfAction.getNullReason());
    }

    public void testOffsetOutOfRange() throws CommandException {
        List coordWfActions = (List)new CoordWfActionInfoXCommand(this.coordJob.getId(), "aa", 6, 4).call();
        TestCoordWfActionInfoXCommand.assertEquals((int)0, (int)coordWfActions.size());
    }

    public void testLenOutOfRange() throws CommandException {
        int offset = 2;
        List coordWfActions = (List)new CoordWfActionInfoXCommand(this.coordJob.getId(), "aa", 2, 19).call();
        TestCoordWfActionInfoXCommand.assertEquals((int)4, (int)coordWfActions.size());
        for (int i = 0; i < coordWfActions.size(); ++i) {
            TestCoordWfActionInfoXCommand.assertEquals((int)(i + offset), (int)((CoordinatorWfActionBean)coordWfActions.get(i)).getActionNumber());
        }
    }

    private void _testDefaultOffsetAndLen() throws CommandException {
        List coordWfActions = (List)new CoordWfActionInfoXCommand(this.coordJob.getId(), "aa").call();
        TestCoordWfActionInfoXCommand.assertEquals((int)5, (int)coordWfActions.size());
        for (int i = 0; i < coordWfActions.size(); ++i) {
            TestCoordWfActionInfoXCommand.assertEquals((int)(i + 1), (int)((CoordinatorWfActionBean)coordWfActions.get(i)).getActionNumber());
        }
    }
}

