/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.oozie.command.coord.DaylightOffsetCalculator;
import org.apache.oozie.util.DateUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestDaylightOffsetCalculator {
    private static final TimeZone TZ_DST = TimeZone.getTimeZone("America/Los_Angeles");
    private static final TimeZone TZ_STANDARD = TimeZone.getTimeZone("Asia/Kolkata");

    @Test
    public void testCalculateBetweenNonDSTStartAndEndGivesZeroOffset() throws ParseException {
        DaylightOffsetCalculator nonDSTStartAndEndCalculator = new DaylightOffsetCalculator(DateUtils.parseDateOozieTZ((String)"2013-01-18T00:00Z"), DateUtils.parseDateOozieTZ((String)"2014-01-18T00:00Z"));
        Calendar target = Calendar.getInstance();
        target.setTime(DateUtils.parseDateOozieTZ((String)"2014-01-18T00:00Z"));
        Assert.assertEquals((Object)nonDSTStartAndEndCalculator.calculate(TZ_DST, target), (Object)target);
    }

    @Test
    public void testCalculateBetweenDSTStartAndStandardEndGivesPositiveOffset() throws ParseException {
        DaylightOffsetCalculator dstStartAndStandardEndCalculator = new DaylightOffsetCalculator(DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z"), DateUtils.parseDateOozieTZ((String)"2014-01-18T00:00Z"));
        Calendar standardEnd = Calendar.getInstance();
        standardEnd.setTime(DateUtils.parseDateOozieTZ((String)"2014-01-18T00:00Z"));
        Calendar standardEndPlusOneHour = (Calendar)standardEnd.clone();
        standardEndPlusOneHour.add(10, 1);
        Assert.assertEquals((Object)dstStartAndStandardEndCalculator.calculate(TZ_DST, standardEnd), (Object)standardEndPlusOneHour);
    }

    @Test
    public void testCalculateBetweenStandardStartAndDSTEndGivesNegativeOffset() throws ParseException {
        DaylightOffsetCalculator standardStartAndDSTEndCalculator = new DaylightOffsetCalculator(DateUtils.parseDateOozieTZ((String)"2013-01-18T00:00Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z"));
        Calendar standardEnd = Calendar.getInstance();
        standardEnd.setTime(DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z"));
        Calendar standardEndMinusOneHour = (Calendar)standardEnd.clone();
        standardEndMinusOneHour.add(10, -1);
        Assert.assertEquals((Object)standardStartAndDSTEndCalculator.calculate(TZ_DST, standardEnd), (Object)standardEndMinusOneHour);
    }

    @Test
    public void testCalculateGivenStandardTZGivesZeroOffset() throws ParseException {
        DaylightOffsetCalculator standardStartAndDSTEndCalculator = new DaylightOffsetCalculator(DateUtils.parseDateOozieTZ((String)"2013-01-18T00:00Z"), DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z"));
        Calendar dstStart = Calendar.getInstance();
        dstStart.setTime(DateUtils.parseDateOozieTZ((String)"2013-01-18T00:00Z"));
        Calendar standardEnd = Calendar.getInstance();
        standardEnd.setTime(DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z"));
        Assert.assertEquals((Object)standardStartAndDSTEndCalculator.calculate(TZ_STANDARD, standardEnd), (Object)standardEnd);
    }

    @Test
    public void testGetDSTOffsetOfNonDaylightChangeGivesZeroOffset() throws ParseException {
        long dstOffset = DaylightOffsetCalculator.getDSTOffset((TimeZone)TZ_DST, (Date)DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z"), (Date)DateUtils.parseDateOozieTZ((String)"2013-07-19T00:00Z"));
        Assert.assertEquals((String)"non-daylight change should give zero DST offset", (long)0L, (long)dstOffset);
    }

    @Test
    public void testGetDSTOffsetOfDaylightChangeFromDSTToStandardGivesPositiveOffset() throws ParseException {
        long dstOffset = DaylightOffsetCalculator.getDSTOffset((TimeZone)TZ_DST, (Date)DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z"), (Date)DateUtils.parseDateOozieTZ((String)"2014-01-19T00:00Z"));
        Assert.assertEquals((String)"daylight change from DST to standard should give positive DST offset", (long)3600000L, (long)dstOffset);
    }

    @Test
    public void testGetDSTOffsetOfDaylightChangeFromStandardToDSTGivesNegativeOffset() throws ParseException {
        long dstOffset = DaylightOffsetCalculator.getDSTOffset((TimeZone)TZ_DST, (Date)DateUtils.parseDateOozieTZ((String)"2013-01-18T00:00Z"), (Date)DateUtils.parseDateOozieTZ((String)"2013-07-19T00:00Z"));
        Assert.assertEquals((String)"daylight change from standard to DST should give negative DST offset", (long)-3600000L, (long)dstOffset);
    }

    @Test
    public void testGetDSTOffsetGivenStandardTZGivesZeroOffset() throws ParseException {
        long dstOffset = DaylightOffsetCalculator.getDSTOffset((TimeZone)TZ_STANDARD, (Date)DateUtils.parseDateOozieTZ((String)"2013-01-18T00:00Z"), (Date)DateUtils.parseDateOozieTZ((String)"2013-07-19T00:00Z"));
        Assert.assertEquals((String)"daylight change from standard to DST should give negative DST offset", (long)0L, (long)dstOffset);
    }
}

