/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.LauncherHelper;
import org.apache.oozie.action.hadoop.MapReduceActionExecutor;
import org.apache.oozie.action.hadoop.MapperReducerForTest;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.wf.ActionCheckXCommand;
import org.apache.oozie.command.wf.ActionStartXCommand;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.command.wf.ResumeXCommand;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestActionCheckXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testActionCheckPreCondition1() throws Exception {
        long counterVal;
        Instrumentation inst = ((InstrumentationService)Services.get().get(InstrumentationService.class)).get();
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP);
        ActionCheckXCommand checkCmd = new ActionCheckXCommand(action.getId(), 10);
        try {
            counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(checkCmd.getName() + ".preconditionfailed")).getValue();
        }
        catch (NullPointerException e) {
            counterVal = 0L;
        }
        TestActionCheckXCommand.assertEquals((long)0L, (long)counterVal);
        checkCmd.call();
        counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(checkCmd.getName() + ".preconditionfailed")).getValue();
        TestActionCheckXCommand.assertEquals((long)1L, (long)counterVal);
    }

    public void testActionCheckPreCondition2() throws Exception {
        long counterVal;
        Instrumentation inst = ((InstrumentationService)Services.get().get(InstrumentationService.class)).get();
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = super.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.RUNNING);
        ActionCheckXCommand checkCmd = new ActionCheckXCommand(action.getId());
        try {
            counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(checkCmd.getName() + ".preconditionfailed")).getValue();
        }
        catch (NullPointerException e) {
            counterVal = 0L;
        }
        TestActionCheckXCommand.assertEquals((long)0L, (long)counterVal);
        checkCmd.call();
        counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(checkCmd.getName() + ".preconditionfailed")).getValue();
        TestActionCheckXCommand.assertEquals((long)1L, (long)counterVal);
    }

    public void testActionCheckPreCondition3() throws Exception {
        long counterVal;
        Instrumentation inst = ((InstrumentationService)Services.get().get(InstrumentationService.class)).get();
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP);
        ActionCheckXCommand checkCmd = new ActionCheckXCommand(action.getId());
        try {
            counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(checkCmd.getName() + ".preconditionfailed")).getValue();
        }
        catch (NullPointerException e) {
            counterVal = 0L;
        }
        TestActionCheckXCommand.assertEquals((long)0L, (long)counterVal);
        checkCmd.call();
        counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(checkCmd.getName() + ".preconditionfailed")).getValue();
        TestActionCheckXCommand.assertEquals((long)1L, (long)counterVal);
    }

    public void testActionCheckPreCondition4() throws Exception {
        long counterVal;
        Instrumentation inst = ((InstrumentationService)Services.get().get(InstrumentationService.class)).get();
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.FAILED, WorkflowInstance.Status.FAILED);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.RUNNING);
        ActionCheckXCommand checkCmd = new ActionCheckXCommand(action.getId());
        try {
            counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(checkCmd.getName() + ".preconditionfailed")).getValue();
        }
        catch (NullPointerException e) {
            counterVal = 0L;
        }
        TestActionCheckXCommand.assertEquals((long)0L, (long)counterVal);
        checkCmd.call();
        counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(checkCmd.getName() + ".preconditionfailed")).getValue();
        TestActionCheckXCommand.assertEquals((long)1L, (long)counterVal);
        job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.RUNNING);
        checkCmd = new ActionCheckXCommand(action.getId());
        checkCmd.call();
        counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(checkCmd.getName() + ".preconditionfailed")).getValue();
        TestActionCheckXCommand.assertEquals((long)1L, (long)counterVal);
        job = this.addRecordToWfJobTable(WorkflowJob.Status.SUSPENDED, WorkflowInstance.Status.SUSPENDED);
        action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.RUNNING);
        checkCmd = new ActionCheckXCommand(action.getId());
        checkCmd.call();
        counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(checkCmd.getName() + ".preconditionfailed")).getValue();
        TestActionCheckXCommand.assertEquals((long)1L, (long)counterVal);
        job = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.RUNNING);
        checkCmd = new ActionCheckXCommand(action.getId());
        checkCmd.call();
        counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(checkCmd.getName() + ".preconditionfailed")).getValue();
        TestActionCheckXCommand.assertEquals((long)2L, (long)counterVal);
        job = this.addRecordToWfJobTable(WorkflowJob.Status.KILLED, WorkflowInstance.Status.KILLED);
        action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.RUNNING);
        checkCmd = new ActionCheckXCommand(action.getId());
        checkCmd.call();
        counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(checkCmd.getName() + ".preconditionfailed")).getValue();
        TestActionCheckXCommand.assertEquals((long)3L, (long)counterVal);
    }

    public void testActionCheck() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP);
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        new ActionStartXCommand(action.getId(), "map-reduce").call();
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(job, action, false, false);
        MapReduceActionExecutor actionExecutor = new MapReduceActionExecutor();
        Configuration conf = actionExecutor.createBaseHadoopConf((ActionExecutor.Context)context, XmlUtils.parseXml((String)action.getConf()));
        String user = conf.get("user.name");
        JobClient jobClient = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobClient(user, conf);
        String launcherId = action.getExternalId();
        this.waitUntilYarnAppDoneAndAssertSuccess(launcherId);
        Map actionData = LauncherHelper.getActionData((FileSystem)this.getFileSystem(), (Path)context.getActionDir(), (Configuration)conf);
        TestActionCheckXCommand.assertTrue((boolean)LauncherHelper.hasIdSwap((Map)actionData));
        new ActionCheckXCommand(action.getId()).call();
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        String externalId = action.getExternalId();
        String childId = action.getExternalChildIDs();
        TestActionCheckXCommand.assertEquals((String)"LauncherId", (String)launcherId, (String)externalId);
        TestActionCheckXCommand.assertNotNull((Object)childId);
        this.waitUntilYarnAppDoneAndAssertSuccess(childId);
        new ActionCheckXCommand(action.getId()).call();
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestActionCheckXCommand.assertEquals((String)"SUCCEEDED", (String)action.getExternalStatus());
    }

    public void testActionCheckErrorNoUserRetry() throws Exception {
        WorkflowActionBean action = this._testActionCheckError();
        TestActionCheckXCommand.assertEquals((Object)WorkflowAction.Status.FAILED, (Object)action.getStatus());
    }

    public void testActionCheckErrorUserRetry() throws Exception {
        ConfigurationService.set((String)"oozie.service.LiteWorkflowStoreService.user.retry.error.code.ext", (String)"some_error");
        WorkflowActionBean action = this._testActionCheckError();
        TestActionCheckXCommand.assertEquals((Object)WorkflowAction.Status.USER_RETRY, (Object)action.getStatus());
    }

    private WorkflowActionBean _testActionCheckError() throws Exception {
        ((ActionService)this.services.get(ActionService.class)).registerAndInitExecutor(ErrorCheckActionExecutor.class);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.RUNNING);
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        new ActionCheckXCommand(action.getId()).call();
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        return action;
    }

    public void testActionCheckTransientDuringLauncher() throws Exception {
        if (this.createJobConf().get("yarn.resourcemanager.address") != null) {
            return;
        }
        this.services.destroy();
        int maxRetries = 2;
        this.setSystemProperty("oozie.action.retries.max", Integer.toString(2));
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), new String[]{"org.apache.oozie.service.ActionCheckerService"});
        this.services.init();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        WorkflowJobBean job0 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        final String jobId = job0.getId();
        WorkflowActionBean action0 = this.addRecordToWfActionTable(jobId, "1", WorkflowAction.Status.PREP);
        final String actionId = action0.getId();
        final WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(actionId);
        new ActionStartXCommand(actionId, "map-reduce").call();
        final WorkflowActionBean action1 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        String originalLauncherId = action1.getExternalId();
        this.executeWhileJobTrackerIsShutdown(new XTestCase.ShutdownJobTrackerExecutable(){

            @Override
            public void execute() throws Exception {
                TestCase.assertEquals((int)0, (int)action1.getRetries());
                new ActionCheckXCommand(actionId).call();
                TestActionCheckXCommand.this.waitFor(30000, new XTestCase.Predicate(){

                    @Override
                    public boolean evaluate() throws Exception {
                        WorkflowActionBean action1a = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
                        return action1a.getRetries() > 0;
                    }
                });
                TestActionCheckXCommand.this.waitFor(180000, new XTestCase.Predicate(){

                    @Override
                    public boolean evaluate() throws Exception {
                        WorkflowActionBean action1a = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
                        return action1a.getRetries() == 0;
                    }
                });
                WorkflowActionBean action1b = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
                TestCase.assertEquals((int)0, (int)action1b.getRetries());
                TestCase.assertEquals((String)"START_MANUAL", (String)action1b.getStatusStr());
                WorkflowJobBean job1 = (WorkflowJobBean)jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(jobId));
                TestCase.assertEquals((String)"SUSPENDED", (String)job1.getStatusStr());
            }
        });
        new ResumeXCommand(jobId).call();
        WorkflowJobBean job2 = (WorkflowJobBean)jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(jobId));
        TestActionCheckXCommand.assertEquals((String)"RUNNING", (String)job2.getStatusStr());
        ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(job2, action1, false, false);
        WorkflowActionBean action2 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        MapReduceActionExecutor actionExecutor = new MapReduceActionExecutor();
        Configuration conf = actionExecutor.createBaseHadoopConf((ActionExecutor.Context)context, XmlUtils.parseXml((String)action2.getConf()));
        String user = conf.get("user.name");
        JobClient jobClient = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobClient(user, conf);
        new ActionCheckXCommand(actionId).call();
        WorkflowActionBean action3 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        String launcherId = action3.getExternalId();
        TestActionCheckXCommand.assertFalse((boolean)originalLauncherId.equals(launcherId));
        final RunningJob launcherJob = jobClient.getJob(JobID.forName((String)launcherId));
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return launcherJob.isComplete();
            }
        });
        TestActionCheckXCommand.assertTrue((boolean)launcherJob.isSuccessful());
        Map actionData = LauncherHelper.getActionData((FileSystem)this.getFileSystem(), (Path)context.getActionDir(), (Configuration)conf);
        TestActionCheckXCommand.assertTrue((boolean)LauncherHelper.hasIdSwap((Map)actionData));
        new ActionCheckXCommand(actionId).call();
        WorkflowActionBean action4 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        String mapperId = action4.getExternalId();
        String childId = action4.getExternalChildIDs();
        TestActionCheckXCommand.assertTrue((boolean)launcherId.equals(mapperId));
        final RunningJob mrJob = jobClient.getJob(JobID.forName((String)childId));
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return mrJob.isComplete();
            }
        });
        TestActionCheckXCommand.assertTrue((boolean)mrJob.isSuccessful());
        new ActionCheckXCommand(actionId).call();
        WorkflowActionBean action5 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestActionCheckXCommand.assertEquals((String)"SUCCEEDED", (String)action5.getExternalStatus());
    }

    public void testActionCheckTransientDuringMRAction() throws Exception {
        if (this.createJobConf().get("yarn.resourcemanager.address") != null) {
            return;
        }
        this.services.destroy();
        int maxRetries = 2;
        this.setSystemProperty("oozie.action.retries.max", Integer.toString(2));
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), new String[]{"org.apache.oozie.service.ActionCheckerService"});
        this.services.init();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        WorkflowJobBean job0 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        final String jobId = job0.getId();
        WorkflowActionBean action0 = this.addRecordToWfActionTable(jobId, "1", WorkflowAction.Status.PREP);
        final String actionId = action0.getId();
        final WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(actionId);
        new ActionStartXCommand(actionId, "map-reduce").call();
        final WorkflowActionBean action1 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        String originalLauncherId = action1.getExternalId();
        ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(job0, action1, false, false);
        MapReduceActionExecutor actionExecutor = new MapReduceActionExecutor();
        Configuration conf = actionExecutor.createBaseHadoopConf((ActionExecutor.Context)context, XmlUtils.parseXml((String)action1.getConf()));
        String user = conf.get("user.name");
        JobClient jobClient = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobClient(user, conf);
        final RunningJob launcherJob = jobClient.getJob(JobID.forName((String)originalLauncherId));
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return launcherJob.isComplete();
            }
        });
        TestActionCheckXCommand.assertTrue((boolean)launcherJob.isSuccessful());
        Map actionData = LauncherHelper.getActionData((FileSystem)this.getFileSystem(), (Path)context.getActionDir(), (Configuration)conf);
        TestActionCheckXCommand.assertTrue((boolean)LauncherHelper.hasIdSwap((Map)actionData));
        new ActionCheckXCommand(action1.getId()).call();
        WorkflowActionBean action2 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        String originalMapperId = action2.getExternalChildIDs();
        TestActionCheckXCommand.assertFalse((boolean)originalLauncherId.equals(originalMapperId));
        this.executeWhileJobTrackerIsShutdown(new XTestCase.ShutdownJobTrackerExecutable(){

            @Override
            public void execute() throws Exception {
                TestCase.assertEquals((int)0, (int)action1.getRetries());
                new ActionCheckXCommand(actionId).call();
                TestActionCheckXCommand.this.waitFor(30000, new XTestCase.Predicate(){

                    @Override
                    public boolean evaluate() throws Exception {
                        WorkflowActionBean action1a = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
                        return action1a.getRetries() > 0;
                    }
                });
                TestActionCheckXCommand.this.waitFor(180000, new XTestCase.Predicate(){

                    @Override
                    public boolean evaluate() throws Exception {
                        WorkflowActionBean action1a = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
                        return action1a.getRetries() == 0;
                    }
                });
                WorkflowActionBean action1b = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
                TestCase.assertEquals((int)0, (int)action1b.getRetries());
                TestCase.assertEquals((String)"START_MANUAL", (String)action1b.getStatusStr());
                WorkflowJobBean job1 = (WorkflowJobBean)jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(jobId));
                TestCase.assertEquals((String)"SUSPENDED", (String)job1.getStatusStr());
            }
        });
        new ResumeXCommand(jobId).call();
        WorkflowJobBean job2 = (WorkflowJobBean)jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(jobId));
        TestActionCheckXCommand.assertEquals((String)"RUNNING", (String)job2.getStatusStr());
        this.sleep(500);
        new ActionCheckXCommand(actionId).call();
        WorkflowActionBean action3 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        String launcherId = action3.getExternalId();
        TestActionCheckXCommand.assertFalse((boolean)originalLauncherId.equals(launcherId));
        final RunningJob launcherJob2 = jobClient.getJob(JobID.forName((String)launcherId));
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return launcherJob2.isComplete();
            }
        });
        TestActionCheckXCommand.assertTrue((boolean)launcherJob2.isSuccessful());
        actionData = LauncherHelper.getActionData((FileSystem)this.getFileSystem(), (Path)context.getActionDir(), (Configuration)conf);
        TestActionCheckXCommand.assertTrue((boolean)LauncherHelper.hasIdSwap((Map)actionData));
        new ActionCheckXCommand(actionId).call();
        WorkflowActionBean action4 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        String mapperId = action4.getExternalChildIDs();
        TestActionCheckXCommand.assertFalse((boolean)originalMapperId.equals(mapperId));
        final RunningJob mrJob = jobClient.getJob(JobID.forName((String)mapperId));
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return mrJob.isComplete();
            }
        });
        TestActionCheckXCommand.assertTrue((boolean)mrJob.isSuccessful());
        new ActionCheckXCommand(actionId).call();
        WorkflowActionBean action5 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestActionCheckXCommand.assertEquals((String)"SUCCEEDED", (String)action5.getExternalStatus());
    }

    public void testCheckInterval() throws Exception {
        long testedValue = 10L;
        WorkflowJobBean job0 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        String jobId = job0.getId();
        WorkflowActionBean action0 = this.addRecordToWfActionTable(jobId, "1", WorkflowAction.Status.RUNNING);
        String actionId = action0.getId();
        ActionCheckXCommand checkCommand = new ActionCheckXCommand(actionId);
        checkCommand.call();
        long effectiveValue = checkCommand.getRetryInterval();
        TestActionCheckXCommand.assertEquals((long)testedValue, (long)effectiveValue);
    }

    @Override
    protected WorkflowActionBean addRecordToWfActionTable(String wfId, String actionName, WorkflowAction.Status status) throws Exception {
        WorkflowActionBean action = this.createWorkflowActionSetPending(wfId, status);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestActionCheckXCommand.assertNotNull((Object)jpaService);
            WorkflowActionInsertJPAExecutor actionInsertCmd = new WorkflowActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)actionInsertCmd);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            TestActionCheckXCommand.fail((String)"Unable to insert the test wf action record to table");
            throw ce;
        }
        return action;
    }

    protected WorkflowActionBean createWorkflowActionSetPending(String wfId, WorkflowAction.Status status) throws Exception {
        WorkflowActionBean action = new WorkflowActionBean();
        String actionname = "testAction";
        action.setName(actionname);
        action.setId(((UUIDService)Services.get().get(UUIDService.class)).generateChildId(wfId, actionname));
        action.setJobId(wfId);
        action.setType("map-reduce");
        action.setTransition("transition");
        action.setStatus(status);
        action.setStartTime(new Date());
        action.setEndTime(new Date());
        action.setLastCheckTime(new Date());
        action.setPending();
        action.setExecutionPath("/");
        action.setUserRetryMax(2);
        Path inputDir = new Path(this.getFsTestCaseDir(), "input");
        Path outputDir = new Path(this.getFsTestCaseDir(), "output");
        FileSystem fs = this.getFileSystem();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "data.txt")));
        w.write("dummy\n");
        w.write("dummy\n");
        ((Writer)w).close();
        String actionXml = "<map-reduce><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><prepare><delete path=\"" + outputDir.toString() + "\"/></prepare><configuration><property><name>mapred.mapper.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.reducer.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.input.dir</name><value>" + inputDir.toString() + "</value></property><property><name>mapred.output.dir</name><value>" + outputDir.toString() + "</value></property></configuration></map-reduce>";
        action.setConf(actionXml);
        return action;
    }

    private static class ErrorCheckActionExecutor
    extends ActionExecutor {
        public static final String ERROR_CODE = "some_error";

        protected ErrorCheckActionExecutor() {
            super("map-reduce");
        }

        public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        }

        public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        }

        public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, ERROR_CODE, "check");
        }

        public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        }

        public boolean isCompleted(String externalStatus) {
            return false;
        }
    }
}

