/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.OperationType;
import org.apache.oozie.command.wf.BulkWorkflowXCommand;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestBulkWorkflowXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testbulkWfKillSuspendResumeSuccess() throws Exception {
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action1 = this.addRecordToWfActionTable(job1.getId(), "1", WorkflowAction.Status.PREP);
        WorkflowJobBean job2 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action2 = this.addRecordToWfActionTable(job2.getId(), "1", WorkflowAction.Status.PREP);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("testApp");
        map.put("name", names);
        new BulkWorkflowXCommand(map, 1, 10, OperationType.Suspend).call();
        this.verifyJobStatus(job1.getId(), WorkflowJob.Status.SUSPENDED);
        this.verifyJobStatus(job2.getId(), WorkflowJob.Status.SUSPENDED);
        new BulkWorkflowXCommand(map, 1, 10, OperationType.Resume).call();
        this.verifyJobStatus(job1.getId(), WorkflowJob.Status.RUNNING);
        this.verifyJobStatus(job2.getId(), WorkflowJob.Status.RUNNING);
        new BulkWorkflowXCommand(map, 1, 10, OperationType.Kill).call();
        this.verifyJobStatus(job1.getId(), WorkflowJob.Status.KILLED);
        this.verifyJobStatus(job2.getId(), WorkflowJob.Status.KILLED);
        this.verifyActionStatus(action1.getId(), WorkflowAction.Status.KILLED);
        this.verifyActionStatus(action2.getId(), WorkflowAction.Status.KILLED);
    }

    public void testbulkWfKillSuccess() throws Exception {
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUSPENDED, WorkflowInstance.Status.SUSPENDED);
        WorkflowActionBean action1 = this.addRecordToWfActionTable(job1.getId(), "1", WorkflowAction.Status.RUNNING);
        WorkflowJobBean job2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUSPENDED, WorkflowInstance.Status.SUSPENDED);
        WorkflowActionBean action2 = this.addRecordToWfActionTable(job2.getId(), "1", WorkflowAction.Status.RUNNING);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("testApp");
        map.put("name", names);
        new BulkWorkflowXCommand(map, 1, 50, OperationType.Kill).call();
        this.verifyJobStatus(job1.getId(), WorkflowJob.Status.KILLED);
        this.verifyJobStatus(job2.getId(), WorkflowJob.Status.KILLED);
        this.verifyActionStatus(action1.getId(), WorkflowAction.Status.KILLED);
        this.verifyActionStatus(action2.getId(), WorkflowAction.Status.KILLED);
    }

    public void testbulkWfKillNoOp() throws Exception {
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action1 = this.addRecordToWfActionTable(job1.getId(), "1", WorkflowAction.Status.RUNNING);
        WorkflowJobBean job2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean action2 = this.addRecordToWfActionTable(job2.getId(), "1", WorkflowAction.Status.DONE);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("testApp");
        map.put("name", names);
        new BulkWorkflowXCommand(map, 1, 50, OperationType.Kill).call();
        this.verifyJobStatus(job1.getId(), WorkflowJob.Status.KILLED);
        this.verifyJobStatus(job2.getId(), WorkflowJob.Status.SUCCEEDED);
        this.verifyActionStatus(action1.getId(), WorkflowAction.Status.KILLED);
        this.verifyActionStatus(action2.getId(), WorkflowAction.Status.DONE);
    }

    public void testbulkWfKillNegative() throws Exception {
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action1 = this.addRecordToWfActionTable(job1.getId(), "1", WorkflowAction.Status.RUNNING);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("testApp-new");
        map.put("name", names);
        new BulkWorkflowXCommand(map, 1, 50, OperationType.Kill).call();
        this.verifyJobStatus(job1.getId(), WorkflowJob.Status.RUNNING);
        this.verifyActionStatus(action1.getId(), WorkflowAction.Status.RUNNING);
    }

    public void testBulkSuspendNoOp() throws Exception {
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action1 = this.addRecordToWfActionTable(job1.getId(), "1", WorkflowAction.Status.RUNNING);
        WorkflowJobBean job2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean action2 = this.addRecordToWfActionTable(job2.getId(), "1", WorkflowAction.Status.DONE);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("testApp");
        map.put("name", names);
        new BulkWorkflowXCommand(map, 1, 50, OperationType.Suspend).call();
        this.verifyJobStatus(job1.getId(), WorkflowJob.Status.SUSPENDED);
        this.verifyActionStatus(action1.getId(), WorkflowAction.Status.RUNNING);
        this.verifyJobStatus(job2.getId(), WorkflowJob.Status.SUCCEEDED);
        this.verifyActionStatus(action2.getId(), WorkflowAction.Status.DONE);
    }

    public void testBulkSuspendNegative() throws Exception {
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action1 = this.addRecordToWfActionTable(job1.getId(), "1", WorkflowAction.Status.RUNNING);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("testApp-new");
        map.put("name", names);
        new BulkWorkflowXCommand(map, 1, 50, OperationType.Suspend).call();
        this.verifyJobStatus(job1.getId(), WorkflowJob.Status.RUNNING);
        this.verifyActionStatus(action1.getId(), WorkflowAction.Status.RUNNING);
    }

    public void testBulkResumeNegative() throws Exception {
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUSPENDED, WorkflowInstance.Status.SUSPENDED);
        WorkflowActionBean action1 = this.addRecordToWfActionTable(job1.getId(), "1", WorkflowAction.Status.RUNNING);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("testApp-new");
        map.put("name", names);
        new BulkWorkflowXCommand(map, 1, 50, OperationType.Resume).call();
        this.verifyJobStatus(job1.getId(), WorkflowJob.Status.SUSPENDED);
        this.verifyActionStatus(action1.getId(), WorkflowAction.Status.RUNNING);
    }

    public void testBulkResumeNoOp() throws Exception {
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action1 = this.addRecordToWfActionTable(job1.getId(), "1", WorkflowAction.Status.RUNNING);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("testApp");
        map.put("name", names);
        new BulkWorkflowXCommand(map, 1, 50, OperationType.Resume).call();
        this.verifyJobStatus(job1.getId(), WorkflowJob.Status.RUNNING);
        this.verifyActionStatus(action1.getId(), WorkflowAction.Status.RUNNING);
    }

    private void verifyJobStatus(String jobId, WorkflowJob.Status status) throws Exception {
        WorkflowJobBean job = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{jobId});
        TestBulkWorkflowXCommand.assertEquals((Object)status, (Object)job.getStatus());
    }

    private void verifyActionStatus(String actionId, WorkflowAction.Status status) throws Exception {
        WorkflowActionBean action = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, new Object[]{actionId});
        TestBulkWorkflowXCommand.assertEquals((Object)status, (Object)action.getStatus());
    }
}

