/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.ActionUtils;
import org.apache.oozie.command.wf.SubmitHiveXCommand;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class TestSubmitHiveXCommand
extends XFsTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.log4j.file", "oozie-log4j.properties");
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        super.tearDown();
    }

    public void testWFXmlGeneration() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.address", "jobtracker");
        conf.set("fs.default.name", "namenode");
        conf.set("oozie.libpath", "libpath");
        conf.set("oozie.files", "/user/oozie/input1.txt,/user/oozie/input2.txt#my.txt");
        conf.set("oozie.archives", "/user/oozie/udf1.jar,/user/oozie/udf2.jar#my.jar");
        String hiveArgsStr = "-a aaa -b bbb -c ccc -M -Da=aaa -Db=bbb -param input=abc";
        String[] args = hiveArgsStr.split(" ");
        ActionUtils.setStrings((Configuration)conf, (String)"oozie.hive.options", (String[])args);
        String[] params = new String[]{"INPUT=/some/path", "OUTPUT=/some/other/path", "abc=xyz"};
        ActionUtils.setStrings((Configuration)conf, (String)"oozie.hive.script.params", (String[])params);
        SubmitHiveXCommand submitHiveCmd = new SubmitHiveXCommand(conf);
        String xml = submitHiveCmd.getWorkflowXml(conf);
        XLog.getLog(((Object)((Object)this)).getClass()).info((Object)("xml = " + xml));
        StringBuilder sb = new StringBuilder();
        sb.append("<workflow-app xmlns=\"uri:oozie:workflow:0.2\" name=\"oozie-hive\">");
        sb.append("<start to=\"hive1\" />");
        sb.append("<action name=\"hive1\">");
        sb.append("<hive xmlns=\"uri:oozie:hive-action:0.5\">");
        sb.append("<job-tracker>jobtracker</job-tracker>");
        sb.append("<name-node>namenode</name-node>");
        sb.append("<configuration>");
        sb.append("<property>");
        sb.append("<name>a</name>");
        sb.append("<value>aaa</value>");
        sb.append("</property>");
        sb.append("<property>");
        sb.append("<name>b</name>");
        sb.append("<value>bbb</value>");
        sb.append("</property>");
        sb.append("</configuration>");
        sb.append("<script>dummy.hive</script>");
        sb.append("<param>INPUT=/some/path</param>");
        sb.append("<param>OUTPUT=/some/other/path</param>");
        sb.append("<param>abc=xyz</param>");
        sb.append("<argument>-a</argument>");
        sb.append("<argument>aaa</argument>");
        sb.append("<argument>-b</argument>");
        sb.append("<argument>bbb</argument>");
        sb.append("<argument>-c</argument>");
        sb.append("<argument>ccc</argument>");
        sb.append("<argument>-M</argument>");
        sb.append("<argument>-param</argument>");
        sb.append("<argument>input=abc</argument>");
        sb.append("<file>/user/oozie/input1.txt#input1.txt</file>");
        sb.append("<file>/user/oozie/input2.txt#my.txt</file>");
        sb.append("<archive>/user/oozie/udf1.jar#udf1.jar</archive>");
        sb.append("<archive>/user/oozie/udf2.jar#my.jar</archive>");
        sb.append("</hive>");
        sb.append("<ok to=\"end\" />");
        sb.append("<error to=\"fail\" />");
        sb.append("</action>");
        sb.append("<kill name=\"fail\">");
        sb.append("<message>hive failed, error message[${wf:errorMessage(wf:lastErrorNode())}]</message>");
        sb.append("</kill>");
        sb.append("<end name=\"end\" />");
        sb.append("</workflow-app>");
        Element root = XmlUtils.parseXml((String)sb.toString());
        String reference = XmlUtils.prettyPrint((Element)root).toString();
        XLog.getLog(((Object)((Object)this)).getClass()).info((Object)("reference xml = " + reference));
        TestSubmitHiveXCommand.assertTrue((boolean)xml.equals(reference));
    }
}

