/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.net.URI;
import java.util.Date;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.MapperReducerForTest;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.wf.ActionKillXCommand;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionInsertJPAExecutor;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestWorkflowActionKillXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testWfActionKillSuccess() throws Exception {
        String externalJobID = this.launchSleepJob(1000);
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.KILLED, WorkflowInstance.Status.KILLED);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), externalJobID, "1", WorkflowAction.Status.KILLED, null);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowActionKillXCommand.assertNotNull((Object)jpaService);
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestWorkflowActionKillXCommand.assertEquals((Object)WorkflowAction.Status.KILLED, (Object)action.getStatus());
        TestWorkflowActionKillXCommand.assertEquals((String)"RUNNING", (String)action.getExternalStatus());
        new ActionKillXCommand(action.getId()).call();
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestWorkflowActionKillXCommand.assertEquals((Object)WorkflowAction.Status.KILLED, (Object)action.getStatus());
        TestWorkflowActionKillXCommand.assertEquals((String)"KILLED", (String)action.getExternalStatus());
    }

    public void testWfActionKillFailed() throws Exception {
        String externalJobID = this.launchSleepJob(1000);
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), externalJobID, "1", WorkflowAction.Status.RUNNING, null);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowActionKillXCommand.assertNotNull((Object)jpaService);
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestWorkflowActionKillXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.RUNNING);
        TestWorkflowActionKillXCommand.assertEquals((String)action.getExternalStatus(), (String)"RUNNING");
        new ActionKillXCommand(action.getId()).call();
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestWorkflowActionKillXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.RUNNING);
        TestWorkflowActionKillXCommand.assertEquals((String)action.getExternalStatus(), (String)"RUNNING");
    }

    protected WorkflowActionBean addRecordToWfActionTable(String wfId, String externalJobID, String actionName, WorkflowAction.Status status, String childID) throws Exception {
        WorkflowActionBean action = new WorkflowActionBean();
        action.setId(((UUIDService)Services.get().get(UUIDService.class)).generateChildId(wfId, actionName));
        action.setJobId(wfId);
        action.setName(actionName);
        action.setType("map-reduce");
        action.setStatus(status);
        action.setStartTime(new Date());
        action.setEndTime(new Date());
        action.setLastCheckTime(new Date());
        action.setPending();
        action.setExternalId(externalJobID);
        action.setExternalStatus("RUNNING");
        action.setExternalChildIDs(childID);
        String actionXml = "<map-reduce><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>mapred.mapper.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.reducer.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.input.dir</name><value>inputDir</value></property><property><name>mapred.output.dir</name><value>outputDir</value></property></configuration></map-reduce>";
        action.setConf(actionXml);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestWorkflowActionKillXCommand.assertNotNull((Object)jpaService);
            WorkflowActionInsertJPAExecutor actionInsertExe = new WorkflowActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)actionInsertExe);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestWorkflowActionKillXCommand.fail((String)"Unable to insert the test wf action record to table");
            throw je;
        }
        return action;
    }

    public void testWfActionKillChildJob() throws Exception {
        String externalJobID = this.launchSleepJob(1000);
        String childId = this.launchSleepJob(1000000);
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.KILLED, WorkflowInstance.Status.KILLED);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), externalJobID, "1", WorkflowAction.Status.KILLED, childId);
        new ActionKillXCommand(action.getId()).call();
        this.waitUntilYarnAppKilledAndAssertSuccess(childId);
    }

    private String launchSleepJob(int sleep) throws Exception {
        Configuration jobConf = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createConfiguration(new URI(this.getNameNodeUri()).getAuthority());
        JobClient jobClient = this.createJobClient();
        SleepJob sleepjob = new SleepJob();
        sleepjob.setConf(jobConf);
        jobConf = sleepjob.setupJobConf(1, 1, sleep, 1, sleep, 1);
        jobConf.set("oozie.child.mapreduce.job.tags", "sleepjob");
        jobConf.set("mapreduce.job.tags", "sleepjob");
        jobConf.set("oozie.job.launch.time", String.valueOf(System.currentTimeMillis()));
        jobClient.submitJob(new JobConf(jobConf));
        Set apps = LauncherMain.getChildYarnJobs((Configuration)jobConf, (ApplicationsRequestScope)ApplicationsRequestScope.ALL);
        TestWorkflowActionKillXCommand.assertEquals((String)"Number of YARN apps", (int)apps.size(), (int)1);
        sleepjob.close();
        return ((ApplicationId)apps.iterator().next()).toString();
    }
}

