/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ForTestingActionExecutor;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.oozie.command.wf.StartXCommand;
import org.apache.oozie.command.wf.SubmitXCommand;
import org.apache.oozie.command.wf.WorkflowActionRetryInfoXCommand;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionsGetForJobJPAExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.ExtendedCallableQueueService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;
import org.joda.time.Interval;

public class TestWorkflowActionRetryInfoXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.service.SchemaService.wf.ext.schemas", "wf-ext-schema.xsd");
        this.setSystemProperty("oozie.service.LiteWorkflowStoreService.user.retry.error.code.ext", "TEST_ERROR");
        this.setSystemProperty("oozie.services.ext", ExtendedCallableQueueService.class.getName());
        this.services = new Services();
        this.services.init();
        ((ActionService)this.services.get(ActionService.class)).registerAndInitExecutor(ForTestingActionExecutor.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testRetryConsoleUrl() throws Exception {
        String wfXml = "<workflow-app xmlns=\"uri:oozie:workflow:0.3\" name=\"wf-fork\"><start to=\"action1\"/><action name=\"action1\" retry-max=\"2\" retry-interval=\"0\"><test xmlns=\"uri:test\"><signal-value>${wf:conf('signal-value')}</signal-value><external-status>${wf:conf('external-status')}</external-status> <external-childIds>${wf:conf('external-status')}</external-childIds> <error>${wf:conf('error')}</error><avoid-set-execution-data>${wf:conf('avoid-set-execution-data')}</avoid-set-execution-data><avoid-set-end-data>${wf:conf('avoid-set-end-data')}</avoid-set-end-data><running-mode>async-error</running-mode></test><ok to=\"end\"/><error to=\"kill\"/></action><kill name=\"kill\"><message>killed</message></kill><end name=\"end\"/></workflow-app>";
        this.validateRetryConsoleUrl(wfXml);
    }

    public void testRetryConsoleUrlForked() throws Exception {
        String wfXml = "<workflow-app xmlns=\"uri:oozie:workflow:0.3\" name=\"wf-fork\"><start to=\"fork1\"/><fork name=\"fork1\"><path start=\"action1\"/><path start=\"action2\"/></fork><action name=\"action1\" retry-max=\"2\" retry-interval=\"0\"><test xmlns=\"uri:test\"><signal-value>${wf:conf('signal-value')}</signal-value><external-status>${wf:conf('external-status')}</external-status> <external-childIds>${wf:conf('external-status')}</external-childIds> <error>${wf:conf('error')}</error><avoid-set-execution-data>${wf:conf('avoid-set-execution-data')}</avoid-set-execution-data><avoid-set-end-data>${wf:conf('avoid-set-end-data')}</avoid-set-end-data><running-mode>async-error</running-mode></test><ok to=\"join\"/><error to=\"kill\"/></action><action name=\"action2\" retry-max=\"2\" retry-interval=\"0\"><test xmlns=\"uri:test\"><signal-value>${wf:conf('signal-value')}</signal-value><external-status>${wf:conf('external-status')}</external-status> <external-childIds>${wf:conf('external-status')}</external-childIds> <error>${wf:conf('error')}</error><avoid-set-execution-data>${wf:conf('avoid-set-execution-data')}</avoid-set-execution-data><avoid-set-end-data>${wf:conf('avoid-set-end-data')}</avoid-set-end-data><running-mode>async-error</running-mode></test><ok to=\"join\"/><error to=\"kill\"/></action><join name=\"join\" to=\"end\"/><kill name=\"kill\"><message>killed</message></kill><end name=\"end\"/></workflow-app>";
        this.validateRetryConsoleUrl(wfXml);
    }

    public void validateRetryConsoleUrl(String wfXml) throws Exception {
        XConfiguration conf = new XConfiguration();
        File workflowUri = new File(this.getTestCaseDir(), "workflow.xml");
        this.writeToFile(wfXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri.toURI().toString());
        conf.set("user.name", TestWorkflowActionRetryInfoXCommand.getTestUser());
        conf.set("external-status", "error");
        conf.set("signal-value", "based_on_action_status");
        conf.set("external-childIds", "1");
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        new StartXCommand(jobId).call();
        final WorkflowActionsGetForJobJPAExecutor actionsGetExecutor = new WorkflowActionsGetForJobJPAExecutor(jobId);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        this.waitFor(20000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                List actions = (List)jpaService.execute((JPAExecutor)actionsGetExecutor);
                WorkflowActionBean action = null;
                for (WorkflowActionBean bean : actions) {
                    if (!bean.getType().equals("test")) continue;
                    action = bean;
                    break;
                }
                return action != null && action.getUserRetryCount() == 2;
            }
        });
        List actions = (List)jpaService.execute((JPAExecutor)actionsGetExecutor);
        WorkflowActionBean action1 = null;
        WorkflowActionBean action2 = null;
        for (WorkflowActionBean bean : actions) {
            if (bean.getType().equals("test") && bean.getName().equals("action1")) {
                action1 = bean;
                continue;
            }
            if (!bean.getType().equals("test") || !bean.getName().equals("action2")) continue;
            action2 = bean;
        }
        WorkflowActionRetryInfoXCommand command = new WorkflowActionRetryInfoXCommand(action1.getId());
        List retriesList = (List)command.call();
        TestWorkflowActionRetryInfoXCommand.assertEquals((int)2, (int)retriesList.size());
        TestWorkflowActionRetryInfoXCommand.assertEquals((int)2, (int)action1.getUserRetryCount());
        TestWorkflowActionRetryInfoXCommand.assertEquals((String)((String)((Map)retriesList.get(0)).get("attempt")), (String)"1");
        TestWorkflowActionRetryInfoXCommand.assertEquals((String)((String)((Map)retriesList.get(0)).get("startTime")), (String)JsonUtils.formatDateRfc822((Date)action1.getStartTime()));
        TestWorkflowActionRetryInfoXCommand.assertNotNull(((Map)retriesList.get(0)).get("consoleUrl"));
        TestWorkflowActionRetryInfoXCommand.assertNotNull(((Map)retriesList.get(0)).get("externalChildIDs"));
        TestWorkflowActionRetryInfoXCommand.assertNotNull(((Map)retriesList.get(1)).get("consoleUrl"));
        TestWorkflowActionRetryInfoXCommand.assertNotNull(((Map)retriesList.get(1)).get("externalChildIDs"));
        Date actionEndTime = action2 == null ? action1.getEndTime() : action2.getEndTime();
        Date secondRetryEndTime = JsonUtils.parseDateRfc822((String)((String)((Map)retriesList.get(1)).get("endTime")));
        TestWorkflowActionRetryInfoXCommand.assertTrue((String)"action end time should be within ten seconds of second retry end time", (boolean)new Interval(secondRetryEndTime.getTime(), secondRetryEndTime.getTime() + 10000L).contains(actionEndTime.getTime()));
    }
}

