/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.Date;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.KillXCommand;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestWorkflowKillXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testWfKillSuccess1() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowKillXCommand.assertNotNull((Object)jpaService);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(job.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestWorkflowKillXCommand.assertEquals((Object)job.getStatus(), (Object)WorkflowJob.Status.RUNNING);
        TestWorkflowKillXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.PREP);
        WorkflowInstance wfInstance = job.getWorkflowInstance();
        TestWorkflowKillXCommand.assertEquals((Object)wfInstance.getStatus(), (Object)WorkflowInstance.Status.RUNNING);
        new KillXCommand(job.getId()).call();
        job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestWorkflowKillXCommand.assertEquals((Object)job.getStatus(), (Object)WorkflowJob.Status.KILLED);
        TestWorkflowKillXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.KILLED);
        wfInstance = job.getWorkflowInstance();
        TestWorkflowKillXCommand.assertEquals((Object)wfInstance.getStatus(), (Object)WorkflowInstance.Status.KILLED);
    }

    public void testWfKillSuccess2() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.RUNNING);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowKillXCommand.assertNotNull((Object)jpaService);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(job.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestWorkflowKillXCommand.assertEquals((Object)job.getStatus(), (Object)WorkflowJob.Status.RUNNING);
        TestWorkflowKillXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.RUNNING);
        WorkflowInstance wfInstance = job.getWorkflowInstance();
        TestWorkflowKillXCommand.assertEquals((Object)wfInstance.getStatus(), (Object)WorkflowInstance.Status.RUNNING);
        new KillXCommand(job.getId()).call();
        job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestWorkflowKillXCommand.assertEquals((Object)job.getStatus(), (Object)WorkflowJob.Status.KILLED);
        TestWorkflowKillXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.KILLED);
        wfInstance = job.getWorkflowInstance();
        TestWorkflowKillXCommand.assertEquals((Object)wfInstance.getStatus(), (Object)WorkflowInstance.Status.KILLED);
    }

    public void testWfKillSuccessAfterNodeDefUpgrade() throws Exception {
        this.services.destroy();
        this.setSystemProperty("oozie.service.LiteWorkflowStoreService.node.def.version", "_oozie_inst_v_0");
        this.services = new Services();
        this.services.init();
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowKillXCommand.assertNotNull((Object)jpaService);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(job.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestWorkflowKillXCommand.assertEquals((Object)job.getStatus(), (Object)WorkflowJob.Status.RUNNING);
        TestWorkflowKillXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.PREP);
        WorkflowInstance wfInstance = job.getWorkflowInstance();
        TestWorkflowKillXCommand.assertEquals((Object)wfInstance.getStatus(), (Object)WorkflowInstance.Status.RUNNING);
        this.services.destroy();
        this.sleep(5000);
        this.setSystemProperty("oozie.service.LiteWorkflowStoreService.node.def.version", "_oozie_inst_v_1");
        this.services = new Services();
        this.services.init();
        this.sleep(5000);
        new KillXCommand(job.getId()).call();
        jpaService = (JPAService)Services.get().get(JPAService.class);
        job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestWorkflowKillXCommand.assertEquals((Object)job.getStatus(), (Object)WorkflowJob.Status.KILLED);
        TestWorkflowKillXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.KILLED);
        wfInstance = job.getWorkflowInstance();
        TestWorkflowKillXCommand.assertEquals((Object)wfInstance.getStatus(), (Object)WorkflowInstance.Status.KILLED);
        this.services.destroy();
        this.sleep(5000);
        this.setSystemProperty("oozie.service.LiteWorkflowStoreService.node.def.version", "_oozie_inst_v_2");
        this.services = new Services();
        this.services.init();
        this.sleep(5000);
        jpaService = (JPAService)Services.get().get(JPAService.class);
        job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestWorkflowKillXCommand.assertEquals((Object)job.getStatus(), (Object)WorkflowJob.Status.KILLED);
        TestWorkflowKillXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.KILLED);
        wfInstance = job.getWorkflowInstance();
        TestWorkflowKillXCommand.assertEquals((Object)wfInstance.getStatus(), (Object)WorkflowInstance.Status.KILLED);
    }

    public void testChildId() throws Exception {
        this.services.destroy();
        this.setSystemProperty("oozie.service.UUIDService.generator", "counter");
        this.services = new Services();
        this.services.init();
        UUIDService uuid = (UUIDService)this.services.get(UUIDService.class);
        String id = uuid.generateId(UUIDService.ApplicationType.WORKFLOW);
        String childId = uuid.generateChildId(id, "a");
        TestWorkflowKillXCommand.assertEquals((String)id, (String)uuid.getId(childId));
        TestWorkflowKillXCommand.assertEquals((String)"a", (String)uuid.getChildName(childId));
        this.services.destroy();
        this.setSystemProperty("oozie.service.UUIDService.generator", "random");
        this.services = new Services();
        this.services.init();
        uuid = (UUIDService)this.services.get(UUIDService.class);
        id = uuid.generateId(UUIDService.ApplicationType.WORKFLOW);
        childId = uuid.generateChildId(id, "a");
        TestWorkflowKillXCommand.assertEquals((String)id, (String)uuid.getId(childId));
        TestWorkflowKillXCommand.assertEquals((String)"a", (String)uuid.getChildName(childId));
    }

    public void testWfKillFailed() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.OK);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowKillXCommand.assertNotNull((Object)jpaService);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(job.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestWorkflowKillXCommand.assertEquals((Object)job.getStatus(), (Object)WorkflowJob.Status.RUNNING);
        TestWorkflowKillXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.OK);
        WorkflowInstance wfInstance = job.getWorkflowInstance();
        TestWorkflowKillXCommand.assertEquals((Object)wfInstance.getStatus(), (Object)WorkflowInstance.Status.RUNNING);
        new KillXCommand(job.getId()).call();
        job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestWorkflowKillXCommand.assertEquals((Object)job.getStatus(), (Object)WorkflowJob.Status.KILLED);
        TestWorkflowKillXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.OK);
        wfInstance = job.getWorkflowInstance();
        TestWorkflowKillXCommand.assertEquals((Object)wfInstance.getStatus(), (Object)WorkflowInstance.Status.KILLED);
    }

    public void testWfKillFailedToLoadJob() throws Exception {
        String testWfId = "0000001-" + new Date().getTime() + "-testWfKill-W";
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.OK);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowKillXCommand.assertNotNull((Object)jpaService);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(job.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestWorkflowKillXCommand.assertEquals((Object)job.getStatus(), (Object)WorkflowJob.Status.RUNNING);
        TestWorkflowKillXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.OK);
        WorkflowInstance wfInstance = job.getWorkflowInstance();
        TestWorkflowKillXCommand.assertEquals((Object)wfInstance.getStatus(), (Object)WorkflowInstance.Status.RUNNING);
        try {
            new KillXCommand(testWfId).call();
            TestWorkflowKillXCommand.fail((String)"Job doesn't exist. Should fail.");
        }
        catch (CommandException commandException) {
            // empty catch block
        }
    }
}

