/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.wf.HangServlet;
import org.apache.oozie.command.wf.WorkflowNotificationXCommand;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.EmbeddedServletContainer;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.workflow.WorkflowInstance;
import org.junit.Assert;
import org.mockito.Mockito;

public class TestWorkflowNotificationXCommand
extends XTestCase {
    private EmbeddedServletContainer container;
    private CallbackServlet callbackServlet;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.notification.url.connection.timeout", "50");
        Services services = new Services();
        services.init();
        this.container = new EmbeddedServletContainer("blah");
        this.container.addServletEndpoint("/hang/*", HangServlet.class);
        this.callbackServlet = new CallbackServlet();
        this.container.addServletEndpoint("/callback/*", (Servlet)this.callbackServlet);
        this.container.start();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.container.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Services.get().destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }

    public void testWFNotificationTimeout() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.workflow.notification.url", this.container.getServletURL("/hang/*"));
        WorkflowInstance wfi = (WorkflowInstance)Mockito.mock(WorkflowInstance.class);
        Mockito.when((Object)wfi.getConf()).thenReturn((Object)conf);
        WorkflowJobBean workflow = (WorkflowJobBean)Mockito.mock(WorkflowJobBean.class);
        Mockito.when((Object)workflow.getId()).thenReturn((Object)"1");
        Mockito.when((Object)workflow.getStatus()).thenReturn((Object)WorkflowJob.Status.SUCCEEDED);
        Mockito.when((Object)workflow.getWorkflowInstance()).thenReturn((Object)wfi);
        WorkflowNotificationXCommand command = new WorkflowNotificationXCommand(workflow);
        command.setRetry(3);
        long start = System.currentTimeMillis();
        command.call();
        long end = System.currentTimeMillis();
        Assert.assertTrue((end - start >= 50L ? 1 : 0) != 0);
        Assert.assertTrue((end - start < 10000L ? 1 : 0) != 0);
    }

    public void testWFNotification() throws Exception {
        String notificationUrl = "/callback/wf?jobId=$jobId&parentId=$parentId";
        this._testNotificationParentId(notificationUrl, "1", null, "");
        notificationUrl = "/callback/wf?jobId=$jobId";
        this._testNotificationParentId(notificationUrl, "1", null, null);
        notificationUrl = "/callback/wf?jobId=$jobId&parentId=$parentId";
        this._testNotificationParentId(notificationUrl, "1", "0000000-111111-oozie-XXX-C@1", "0000000-111111-oozie-XXX-C@1");
        notificationUrl = "/callback/wf?jobId=$jobId";
        this._testNotificationParentId(notificationUrl, "1", "0000000-111111-oozie-XXX-C@1", null);
    }

    private void _testNotificationParentId(String notificationUrl, String jobId, String parentId, String expectedParentId) throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.workflow.notification.url", this.container.getServletURL(notificationUrl));
        WorkflowInstance wfi = (WorkflowInstance)Mockito.mock(WorkflowInstance.class);
        Mockito.when((Object)wfi.getConf()).thenReturn((Object)conf);
        WorkflowJobBean workflow = (WorkflowJobBean)Mockito.mock(WorkflowJobBean.class);
        Mockito.when((Object)workflow.getId()).thenReturn((Object)jobId);
        Mockito.when((Object)workflow.getStatus()).thenReturn((Object)WorkflowJob.Status.SUCCEEDED);
        Mockito.when((Object)workflow.getParentId()).thenReturn((Object)parentId);
        Mockito.when((Object)workflow.getWorkflowInstance()).thenReturn((Object)wfi);
        WorkflowNotificationXCommand command = new WorkflowNotificationXCommand(workflow);
        command.setRetry(3);
        command.call();
        this.callbackServlet.waitUntilRequestProcessed();
        Assert.assertEquals((Object)jobId, (Object)this.callbackServlet.jobID);
        Assert.assertEquals((Object)expectedParentId, (Object)this.callbackServlet.parentID);
    }

    public static class CallbackServlet
    extends HttpServlet {
        String jobID = null;
        String nodeName = null;
        String status = null;
        String parentID = null;
        final ReentrantLock lock = new ReentrantLock();
        final Condition updated = this.lock.newCondition();
        boolean requestProcessed = false;

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            this.jobID = req.getParameter("jobId");
            this.nodeName = req.getParameter("nodeName");
            this.status = req.getParameter("status");
            this.parentID = req.getParameter("parentId");
            resp.setStatus(200);
            this.lock.lock();
            try {
                this.requestProcessed = true;
                this.updated.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void waitUntilRequestProcessed() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.requestProcessed) {
                    this.updated.await(10L, TimeUnit.SECONDS);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

