/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.compression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.compression.CodecFactory;
import org.apache.oozie.compression.GzipCompressionCodec;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestCodecFactory
extends XTestCase {
    private Services services;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.getConf().set("oozie.output.compression.codec", "gz");
        this.services.init();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test
    public void testCompressionCodecs() throws IOException {
        TestCodecFactory.assertTrue((boolean)CodecFactory.isCompressionEnabled());
        TestCodecFactory.assertEquals(GzipCompressionCodec.class, CodecFactory.getCompressionCodec().getClass());
        byte[] bytes = CodecFactory.getHeaderBytes();
        DataInputStream dais = new DataInputStream(new ByteArrayInputStream(bytes));
        TestCodecFactory.assertEquals(GzipCompressionCodec.class, CodecFactory.getDeCompressionCodec((DataInputStream)dais).getClass());
        dais.close();
    }

    @Test
    public void testCompression() throws IOException {
        byte[] headerBytes = CodecFactory.getHeaderBytes();
        byte[] compressedBytes = CodecFactory.getCompressionCodec().compressString(headerBytes, "dummmmyyyy");
        DataInputStream dais = new DataInputStream(new ByteArrayInputStream(compressedBytes));
        String uncompressed = CodecFactory.getDeCompressionCodec((DataInputStream)dais).decompressToString(dais);
        TestCodecFactory.assertEquals((String)"dummmmyyyy", (String)uncompressed);
        dais.close();
    }

    @Test
    public void testCodecFactoryConf() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream daos = new DataOutputStream(baos);
        daos.write("OBJ".getBytes("UTF-8"));
        daos.writeInt(1);
        daos.writeInt(1);
        daos.writeUTF("codec");
        daos.writeUTF("gz");
        daos.close();
        TestCodecFactory.assertEquals((String)new String(baos.toByteArray()), (String)new String(CodecFactory.getHeaderBytes()));
        Configuration conf = this.services.getConf();
        conf.set("oozie.output.compression.codec", "none");
        CodecFactory.initialize((Configuration)conf);
        TestCodecFactory.assertTrue((!CodecFactory.isCompressionEnabled() ? 1 : 0) != 0);
        conf.set("oozie.output.compression.codec", "");
        CodecFactory.initialize((Configuration)conf);
        TestCodecFactory.assertTrue((!CodecFactory.isCompressionEnabled() ? 1 : 0) != 0);
        conf.set("oozie.compression.codecs", "gz=" + GzipCompressionCodec.class.getName());
        CodecFactory.initialize((Configuration)conf);
        conf.set("oozie.output.compression.codec", "abcd");
        try {
            CodecFactory.initialize((Configuration)conf);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

