/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.dependency;

import java.net.URI;
import org.apache.oozie.dependency.FSURIHandler;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.test.XTestCase;
import org.junit.Test;

public class TestURIHandlerService
extends XTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test
    public void testGetAuthorityWithScheme() throws Exception {
        URIHandlerService uriService = new URIHandlerService();
        URI uri = uriService.getAuthorityWithScheme("hdfs://nn1:8020/dataset/${YEAR}/${MONTH}");
        TestURIHandlerService.assertEquals((String)"hdfs://nn1:8020", (String)uri.toString());
        uri = uriService.getAuthorityWithScheme("hdfs://nn1:8020");
        TestURIHandlerService.assertEquals((String)"hdfs://nn1:8020", (String)uri.toString());
        uri = uriService.getAuthorityWithScheme("hdfs://nn1:8020/");
        TestURIHandlerService.assertEquals((String)"hdfs://nn1:8020", (String)uri.toString());
        uri = uriService.getAuthorityWithScheme("hdfs://///tmp/file");
        TestURIHandlerService.assertEquals((String)"hdfs:///", (String)uri.toString());
        uri = uriService.getAuthorityWithScheme("hdfs:///tmp/file");
        TestURIHandlerService.assertEquals((String)"hdfs:///", (String)uri.toString());
        uri = uriService.getAuthorityWithScheme("/tmp/file");
        TestURIHandlerService.assertEquals((String)"/", (String)uri.toString());
    }

    @Test
    public void testGetURIHandler() throws Exception {
        URIHandlerService uriService = (URIHandlerService)this.services.get(URIHandlerService.class);
        URI uri = uriService.getAuthorityWithScheme("/tmp/file");
        URIHandler uriHandler = uriService.getURIHandler(uri);
        TestURIHandlerService.assertTrue((boolean)(uriHandler instanceof FSURIHandler));
    }
}

