/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.event;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.event.EventQueue;
import org.apache.oozie.event.MemoryEventQueue;
import org.apache.oozie.event.WorkflowJobEvent;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JMSAccessorService;
import org.apache.oozie.service.JMSTopicService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.test.XDataTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestEventQueue
extends XDataTestCase {
    private Services services;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        Configuration conf = this.services.getConf();
        conf.set("oozie.services.ext", JMSAccessorService.class.getName() + "," + JMSTopicService.class.getName() + "," + EventHandlerService.class.getName() + "," + SLAService.class.getName());
        conf.setInt("oozie.service.EventHandlerService.batch.size", 3);
        conf.set("oozie.service.EventHandlerService.event.listeners", "");
        this.services.init();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test
    public void testMemoryEventQueueBasic() throws Exception {
        EventHandlerService ehs = (EventHandlerService)Services.get().get(EventHandlerService.class);
        TestEventQueue.assertNotNull((Object)ehs);
        EventQueue eventQ = ehs.getEventQueue();
        TestEventQueue.assertNotNull((Object)eventQ);
        TestEventQueue.assertTrue((boolean)(eventQ instanceof MemoryEventQueue));
    }

    @Test
    public void testQueueOperations() throws Exception {
        int i;
        EventHandlerService ehs = (EventHandlerService)Services.get().get(EventHandlerService.class);
        EventQueue eventQ = ehs.getEventQueue();
        TestEventQueue.assertEquals((int)eventQ.size(), (int)0);
        TestEventQueue.assertEquals((int)eventQ.getBatchSize(), (int)3);
        WorkflowJobEvent wfEvent = new WorkflowJobEvent("1234-W", "1234-C", WorkflowJob.Status.RUNNING, TestEventQueue.getTestUser(), "myapp", null, null);
        for (int i2 = 0; i2 < 10; ++i2) {
            ehs.queueEvent((Event)wfEvent);
        }
        TestEventQueue.assertEquals((int)eventQ.size(), (int)10);
        int numThreads = 1;
        Thread[] thread = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            thread[i] = new Thread((Runnable)new EventHandlerService.EventWorker(ehs));
            thread[i].run();
        }
        TestEventQueue.assertEquals((int)eventQ.size(), (int)7);
        for (i = 0; i < 3; ++i) {
            ehs.queueEvent((Event)wfEvent);
        }
        TestEventQueue.assertEquals((int)eventQ.size(), (int)10);
        numThreads = 2;
        thread = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            thread[i] = new Thread((Runnable)new EventHandlerService.EventWorker(ehs));
            thread[i].run();
        }
        TestEventQueue.assertEquals((int)eventQ.size(), (int)4);
        for (i = 0; i < 6; ++i) {
            ehs.queueEvent((Event)wfEvent);
        }
        TestEventQueue.assertEquals((int)eventQ.size(), (int)10);
        int repetition = 3;
        for (int r = 0; r < repetition && !eventQ.isEmpty(); ++r) {
            for (int i3 = 0; i3 < numThreads; ++i3) {
                thread[i3].run();
            }
        }
        TestEventQueue.assertEquals((int)eventQ.size(), (int)0);
    }
}

