/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestBatchQueryExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testExecuteBatchUpdateInsertDelete() throws Exception {
        BatchQueryExecutor executor = BatchQueryExecutor.getInstance();
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.PREP, true, true);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.PREP);
        CoordinatorActionBean coordAction = new CoordinatorActionBean();
        coordAction.setId("testCoordAction1");
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        coordJob.setStatus(Job.Status.RUNNING);
        wfJob.setStatus(WorkflowJob.Status.SUCCEEDED);
        ArrayList<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
        updateList.add(new BatchQueryExecutor.UpdateEntry((Enum)CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS_MODTIME, (JsonBean)coordJob));
        updateList.add(new BatchQueryExecutor.UpdateEntry((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (JsonBean)wfJob));
        ArrayList<CoordinatorActionBean> insertList = new ArrayList<CoordinatorActionBean>();
        insertList.add(coordAction);
        ArrayList<WorkflowActionBean> deleteList = new ArrayList<WorkflowActionBean>();
        deleteList.add(wfAction);
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, updateList, deleteList);
        coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{coordJob.getId()});
        TestBatchQueryExecutor.assertEquals((String)"RUNNING", (String)coordJob.getStatusStr());
        wfJob = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{wfJob.getId()});
        TestBatchQueryExecutor.assertEquals((String)"SUCCEEDED", (String)wfJob.getStatusStr());
        coordAction = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{coordAction.getId()});
        TestBatchQueryExecutor.assertEquals((String)"testCoordAction1", (String)coordAction.getId());
        try {
            wfAction = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, new Object[]{wfJob.getId()});
            TestBatchQueryExecutor.fail();
        }
        catch (JPAExecutorException ex) {
            TestBatchQueryExecutor.assertEquals((String)ex.getErrorCode().toString(), (String)"E0605");
        }
    }

    public void testExecuteBatchUpdateInsertDeleteRollBack() throws Exception {
        WorkflowActionBean waBean;
        BatchQueryExecutor executor = BatchQueryExecutor.getInstance();
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        WorkflowActionBean action1 = this.createWorkflowAction(job.getId(), "1", WorkflowAction.Status.PREP);
        WorkflowActionBean action2 = this.createWorkflowAction(job.getId(), "2", WorkflowAction.Status.PREP);
        job.setStatus(WorkflowJob.Status.RUNNING);
        ArrayList<WorkflowActionBean> insertList = new ArrayList<WorkflowActionBean>();
        insertList.add(action1);
        insertList.add(action2);
        ArrayList<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
        updateList.add(new BatchQueryExecutor.UpdateEntry((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (JsonBean)job));
        this.setSystemProperty("oozie.fault.injection", "true");
        this.setSystemProperty("oozie.fault.injection.action.failover", "true");
        FaultInjection.activate((String)"org.apache.oozie.command.SkipCommitFaultInjection");
        try {
            executor.executeBatchInsertUpdateDelete(insertList, updateList, null);
            TestBatchQueryExecutor.fail((String)"Expected exception due to commit failure but didn't get any");
        }
        catch (Exception exception) {
            // empty catch block
        }
        FaultInjection.deactivate((String)"org.apache.oozie.command.SkipCommitFaultInjection");
        WorkflowJobBean wfBean = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{job.getId()});
        TestBatchQueryExecutor.assertEquals((String)"PREP", (String)wfBean.getStatusStr());
        try {
            waBean = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, new Object[]{action1.getId()});
            TestBatchQueryExecutor.fail((String)"Expected exception but didnt get any");
        }
        catch (JPAExecutorException jpaee) {
            TestBatchQueryExecutor.assertEquals((Object)ErrorCode.E0605, (Object)jpaee.getErrorCode());
        }
        try {
            waBean = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, new Object[]{action2.getId()});
            TestBatchQueryExecutor.fail((String)"Expected exception but didnt get any");
        }
        catch (JPAExecutorException jpaee) {
            TestBatchQueryExecutor.assertEquals((Object)ErrorCode.E0605, (Object)jpaee.getErrorCode());
        }
    }
}

